/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.ActionDispatcher;
import com.vaadin.collaborationengine.ActivationHandler;
import com.vaadin.collaborationengine.AsyncRegistration;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.ExecutionQueue;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.ServiceDestroyListener;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class SystemConnectionContext
implements ConnectionContext {
    private final SerializableSupplier<CollaborationEngine> ceSupplier;
    private final Set<ActivationHandler> activeHandlers = new HashSet<ActivationHandler>();
    private Registration serviceDestroyRegistration;

    @Deprecated(since="6.2", forRemoval=true)
    public SystemConnectionContext(CollaborationEngine ce) {
        this((SerializableSupplier<CollaborationEngine>)(SerializableSupplier & Serializable)() -> ce);
    }

    public SystemConnectionContext(SerializableSupplier<CollaborationEngine> ceSupplier) {
        this.ceSupplier = Objects.requireNonNull(ceSupplier);
    }

    public static SystemConnectionContext getInstance() {
        CollaborationEngine ce = CollaborationEngine.getInstance();
        if (ce == null) {
            throw new IllegalStateException("This method cannot be used when CollaborationEngine has not been configured for the current VaadinService.");
        }
        return ce.getSystemContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration init(ActivationHandler activationHandler, Executor executor) {
        Objects.requireNonNull(activationHandler);
        Objects.requireNonNull(executor);
        Set<ActivationHandler> set = this.activeHandlers;
        synchronized (set) {
            if (this.activeHandlers.isEmpty()) {
                this.serviceDestroyRegistration = ((CollaborationEngine)this.ceSupplier.get()).getVaadinService().addServiceDestroyListener((ServiceDestroyListener & Serializable)e -> {
                    Set<ActivationHandler> set = this.activeHandlers;
                    synchronized (set) {
                        this.activeHandlers.forEach(handler -> handler.accept(null));
                        this.activeHandlers.clear();
                    }
                });
            }
            if (!this.activeHandlers.add(activationHandler)) {
                throw new IllegalStateException("The provided activation handler was already active");
            }
            ActionDispatcherImplementation actionDispatcher = new ActionDispatcherImplementation(executor);
            activationHandler.accept(actionDispatcher);
            return new AsyncRegistration(actionDispatcher.shutdownFuture, (Registration & Serializable)() -> {
                Set<ActivationHandler> set = this.activeHandlers;
                synchronized (set) {
                    if (this.activeHandlers.remove(activationHandler)) {
                        activationHandler.accept(null);
                        actionDispatcher.shutdown();
                        if (this.activeHandlers.isEmpty()) {
                            this.serviceDestroyRegistration.remove();
                            this.serviceDestroyRegistration = null;
                        }
                    }
                }
            });
        }
    }

    CollaborationEngine getCollaborationEngine() {
        return (CollaborationEngine)this.ceSupplier.get();
    }

    private final class ActionDispatcherImplementation
    implements ActionDispatcher {
        private final Executor executor;
        private final ExecutionQueue inbox = new ExecutionQueue();
        private final CompletableFuture<Void> shutdownFuture = new CompletableFuture();
        private boolean shuttingDown;

        private ActionDispatcherImplementation(Executor executor) {
            this.executor = executor;
        }

        @Override
        public void dispatchAction(Command action) {
            this.inbox.add((Command & Serializable)() -> {
                Map oldInstances = CurrentInstance.getInstances();
                try {
                    VaadinService.setCurrent((VaadinService)SystemConnectionContext.this.getCollaborationEngine().getVaadinService());
                    action.execute();
                }
                finally {
                    CurrentInstance.restoreInstances((Map)oldInstances);
                }
            });
            this.executor.execute(() -> {
                ActionDispatcherImplementation actionDispatcherImplementation = this;
                synchronized (actionDispatcherImplementation) {
                    this.inbox.runPendingCommands();
                    if (this.shuttingDown) {
                        this.shutdownFuture.complete(null);
                        this.shuttingDown = false;
                    }
                }
            });
        }

        @Override
        public <T> CompletableFuture<T> createCompletableFuture() {
            return new CompletableFuture();
        }

        private synchronized void shutdown() {
            if (this.inbox.isEmpty()) {
                this.shutdownFuture.complete(null);
            } else {
                this.shuttingDown = true;
            }
        }
    }
}

