/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.ComponentConnectionContext;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.FieldHighlighter;
import com.vaadin.collaborationengine.FormManager;
import com.vaadin.collaborationengine.HasExpirationTimeout;
import com.vaadin.collaborationengine.HighlightHandler;
import com.vaadin.collaborationengine.JsonUtil;
import com.vaadin.collaborationengine.PropertyChangeHandler;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BindingValidationStatusHandler;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollaborationBinder<BEAN>
extends Binder<BEAN>
implements HasExpirationTimeout {
    private static final List<Class<?>> SUPPORTED_CLASS_TYPES = Arrays.asList(String.class, Boolean.class, Integer.class, Double.class, BigDecimal.class, LocalDate.class, LocalTime.class, LocalDateTime.class, Enum.class);
    private static final List<Class<?>> SUPPORTED_COLLECTION_TYPES = Arrays.asList(List.class, Set.class);
    private final UserInfo localUser;
    private final SerializableSupplier<CollaborationEngine> ceSupplier;
    private final FieldHighlighter fieldHighlighter;
    private ComponentConnectionContext connectionContext;
    private FormManager formManager;
    private Duration expirationTimeout;
    private final Map<Binder.Binding<?, ?>, Registration> bindingRegistrations = new HashMap();
    private final Map<HasValue<?, ?>, String> fieldToPropertyName = new HashMap();
    private final Map<String, JsonHandler<?>> propertyJsonHandlers = new HashMap();
    private final Map<Class<?>, JsonHandler<?>> typeConfigurations = new HashMap();

    public CollaborationBinder(Class<BEAN> beanType, UserInfo localUser) {
        this(beanType, localUser, (SerializableSupplier<CollaborationEngine>)((SerializableSupplier & Serializable)CollaborationEngine::getInstance));
    }

    CollaborationBinder(Class<BEAN> beanType, UserInfo localUser, SerializableSupplier<CollaborationEngine> ceSupplier) {
        super(beanType);
        this.localUser = Objects.requireNonNull(localUser, "User cannot be null");
        this.ceSupplier = ceSupplier;
        this.fieldHighlighter = new FieldHighlighter((SerializableFunction<UserInfo, Integer>)(SerializableFunction & Serializable)user -> this.getCollaborationEngine().getUserColorIndex((UserInfo)user));
    }

    private CollaborationEngine getCollaborationEngine() {
        return (CollaborationEngine)this.ceSupplier.get();
    }

    protected Binder.BindingBuilder<BEAN, ?> configureBinding(Binder.BindingBuilder<BEAN, ?> baseBinding, PropertyDefinition<BEAN, ?> definition) {
        CollaborationBindingBuilderImpl binding = (CollaborationBindingBuilderImpl)baseBinding;
        JsonHandler<BEAN> handler = this.findJsonHandler(binding, definition);
        this.propertyJsonHandlers.put(definition.getName(), handler);
        return super.configureBinding(baseBinding, definition);
    }

    private static boolean isSupportedType(Type type) {
        ParameterizedType parameterizedType;
        Objects.requireNonNull(type, "Type cannot be null");
        if (type instanceof Class) {
            return CollaborationBinder.isAssignableFromAny(SUPPORTED_CLASS_TYPES, (Class)type);
        }
        if (type instanceof ParameterizedType && CollaborationBinder.isAssignableFromAny(SUPPORTED_COLLECTION_TYPES, (Class)(parameterizedType = (ParameterizedType)type).getRawType())) {
            for (Type typeArgument : parameterizedType.getActualTypeArguments()) {
                if (CollaborationBinder.isSupportedType(typeArgument)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String createTypeNotSupportedMessage(Type type) {
        return "The type " + type.getTypeName() + " is not supported. You must use setSerializer to define conversion logic for custom value types. Supported types are: " + Stream.concat(SUPPORTED_CLASS_TYPES.stream(), SUPPORTED_COLLECTION_TYPES.stream()).map(Class::getName).collect(Collectors.joining(", ")) + ". For collections, the element type must be among the supported types.";
    }

    private static boolean isAssignableFromAny(List<Class<?>> types, Class<?> type) {
        return types.stream().anyMatch(candidate -> candidate.isAssignableFrom(type));
    }

    private JsonHandler<?> findJsonHandler(CollaborationBindingBuilderImpl<?, ?, ?> builder, PropertyDefinition<?, ?> propertyDefinition) {
        if (builder.explicitJsonHandler != null) {
            return builder.explicitJsonHandler;
        }
        if (!builder.typeIsConverted) {
            Class propertyType = propertyDefinition.getType();
            if (CollaborationBinder.isAssignableFromAny(SUPPORTED_COLLECTION_TYPES, propertyType)) {
                throw new IllegalStateException("Cannot configure JSON serializer for '" + builder.propertyName + "' with type '" + propertyType.getName() + "'. For collection types, you have to specify the type of the collection and the type of the elements in the collection. Use CollaborationBinder::forField(field, collectionType, elementType) to specify these. For example, if you are binding a List of String, you should call forField(field, List.class, String.class).");
            }
            return this.getTypeConfiguration(propertyType).orElseThrow(() -> new IllegalStateException("Cannot configure JSON serializer for " + builder.propertyName + ". " + CollaborationBinder.createTypeNotSupportedMessage(propertyType)));
        }
        throw new IllegalStateException("Could not infer field type for property '" + builder.propertyName + "'. Configure the property using an overload of forField or forMemberField that allows explicitly defining the field type.");
    }

    private void handlePropertyChange(PropertyChangeHandler.PropertyChangeEvent event) {
        this.getBinding(event.getPropertyName()).map(Binder.Binding::getField).ifPresent(field -> {
            String propertyName = event.getPropertyName();
            JsonNode value = JsonUtil.toJsonNode(event.getValue());
            this.setFieldValueFromFieldState((HasValue)field, propertyName, (JsonNode)(value == null ? NullNode.getInstance() : value));
        });
    }

    private Registration handleHighlight(HighlightHandler.HighlightContext context) {
        if (!context.getUser().equals(this.localUser)) {
            this.getBinding(context.getPropertyName()).map(Binder.Binding::getField).ifPresent(field -> this.fieldHighlighter.addEditor((HasValue<?, ?>)field, context.getUser(), context.getFieldIndex()));
            return (Registration & Serializable)() -> this.getBinding(context.getPropertyName()).map(Binder.Binding::getField).ifPresent(field -> this.fieldHighlighter.removeEditor((HasValue<?, ?>)field, context.getUser(), context.getFieldIndex()));
        }
        return null;
    }

    private void setFieldValueFromFieldState(HasValue field, String propertyName, JsonNode stateValue) {
        if (stateValue instanceof NullNode) {
            field.clear();
        } else {
            JsonHandler<?> handler = this.propertyJsonHandlers.get(propertyName);
            field.setValue(handler.deserialize(stateValue));
        }
    }

    private void setMapValueFromField(String propertyName, HasValue field) {
        if (this.formManager != null) {
            JsonNode value;
            if (field.isEmpty()) {
                value = null;
            } else {
                JsonHandler<?> handler = this.propertyJsonHandlers.get(propertyName);
                value = handler.serialize(field.getValue());
            }
            this.formManager.setValue(propertyName, value);
        }
    }

    void addEditor(String propertyName, int fieldIndex) {
        if (this.formManager != null) {
            this.formManager.highlight(propertyName, true, fieldIndex);
        }
    }

    void removeEditor(String propertyName) {
        if (this.formManager != null) {
            this.formManager.highlight(propertyName, false);
        }
    }

    protected void removeBindingInternal(Binder.Binding<BEAN, ?> binding) {
        Registration registration = this.bindingRegistrations.remove(binding);
        if (registration != null) {
            registration.remove();
        }
        String propertyName = this.fieldToPropertyName.remove(binding.getField());
        this.propertyJsonHandlers.remove(propertyName);
        if (this.connectionContext != null) {
            this.connectionContext.removeComponent((Component)binding.getField());
        }
        super.removeBindingInternal(binding);
    }

    protected <FIELDVALUE, TARGET> Binder.BindingBuilder<BEAN, TARGET> doCreateBinding(HasValue<?, FIELDVALUE> field, Converter<FIELDVALUE, TARGET> converter, BindingValidationStatusHandler handler) {
        return new CollaborationBindingBuilderImpl(this, field, converter, handler);
    }

    @Deprecated
    public <FIELDVALUE> Binder.Binding<BEAN, FIELDVALUE> bind(HasValue<?, FIELDVALUE> field, ValueProvider<BEAN, FIELDVALUE> getter, Setter<BEAN, FIELDVALUE> setter) {
        return super.bind(field, getter, setter);
    }

    public <FIELDVALUE> Binder.Binding<BEAN, FIELDVALUE> bind(HasValue<?, FIELDVALUE> field, String propertyName) {
        return super.bind(field, propertyName);
    }

    public void bindInstanceFields(Object objectWithMemberFields) {
        super.bindInstanceFields(objectWithMemberFields);
    }

    @Deprecated
    public void setBean(BEAN bean) {
        throw new UnsupportedOperationException("This operation is not supported by the collaboration binder. You can instead provide the bean for populating the fields with the setTopic method, and write the values back to the bean with the writeBean method.");
    }

    @Deprecated
    public BEAN getBean() {
        return (BEAN)super.getBean();
    }

    @Deprecated
    public void readBean(BEAN bean) {
        throw new UnsupportedOperationException("This operation is not supported by the collaboration binder. You can instead provide the bean for populating the fields with the setTopic method to avoid overriding currently edited values. If you explicitly want to reset the field values for every user currently editing the fields, you can use the reset method.");
    }

    public void reset(BEAN bean) {
        super.readBean(bean);
    }

    UserInfo getLocalUser() {
        return this.localUser;
    }

    public void setTopic(String topicId, SerializableSupplier<BEAN> initialBeanSupplier) {
        if (this.formManager != null) {
            this.formManager.close();
            this.formManager = null;
            this.fieldToPropertyName.keySet().forEach(this.fieldHighlighter::removeEditors);
            this.connectionContext = null;
        }
        if (topicId == null) {
            super.readBean(initialBeanSupplier.get());
        } else {
            super.readBean(null);
            this.connectionContext = new ComponentConnectionContext();
            this.fieldToPropertyName.keySet().forEach(field -> this.connectionContext.addComponent((Component)field));
            this.formManager = new FormManager((ConnectionContext)this.connectionContext, this.localUser, topicId, this.ceSupplier);
            this.formManager.setActivationHandler(() -> {
                this.initializeBindingsWithoutFieldState(initialBeanSupplier);
                return null;
            });
            this.formManager.onConnectionFailed(e -> super.readBean(initialBeanSupplier.get()));
            this.formManager.setPropertyChangeHandler(this::handlePropertyChange);
            this.formManager.setHighlightHandler(this::handleHighlight);
            if (this.expirationTimeout != null) {
                this.formManager.setExpirationTimeout(this.expirationTimeout);
            }
        }
    }

    private void initializeBindingsWithoutFieldState(SerializableSupplier<BEAN> initialBeanSupplier) {
        List propertiesWithoutFieldState = this.fieldToPropertyName.values().stream().filter(propertyName -> this.formManager.getValue((String)propertyName, JsonNode.class) == null).collect(Collectors.toList());
        if (propertiesWithoutFieldState.isEmpty()) {
            return;
        }
        Object initialBean = initialBeanSupplier.get();
        propertiesWithoutFieldState.stream().map(arg_0 -> ((CollaborationBinder)this).getBinding(arg_0)).filter(Optional::isPresent).map(Optional::get).forEach(binding -> {
            if (initialBean == null) {
                binding.getField().clear();
            } else {
                binding.read(initialBean);
            }
        });
    }

    public <FIELDVALUE> Binder.BindingBuilder<BEAN, FIELDVALUE> forField(HasValue<?, FIELDVALUE> field) {
        return super.forField(field);
    }

    public <FIELDVALUE> Binder.BindingBuilder<BEAN, FIELDVALUE> forField(HasValue<?, FIELDVALUE> field, Class<FIELDVALUE> fieldType) {
        this.getTypeConfigurationOrThrow(fieldType).store(field);
        return this.forField(field);
    }

    public <FIELDVALUE extends Collection<ELEMENT>, ELEMENT> Binder.BindingBuilder<BEAN, FIELDVALUE> forField(HasValue<?, FIELDVALUE> field, Class<? super FIELDVALUE> collectionType, Class<ELEMENT> elementType) {
        this.getTypeConfiguration(collectionType, elementType).store(field);
        return this.forField(field);
    }

    public <FIELDVALUE> Binder.BindingBuilder<BEAN, FIELDVALUE> forMemberField(HasValue<?, FIELDVALUE> field) {
        return super.forMemberField(field);
    }

    public <FIELDVALUE> Binder.BindingBuilder<BEAN, FIELDVALUE> forMemberField(HasValue<?, FIELDVALUE> field, Class<FIELDVALUE> fieldType) {
        this.getTypeConfigurationOrThrow(fieldType).store(field);
        return this.forMemberField(field);
    }

    public <FIELDVALUE extends Collection<ELEMENT>, ELEMENT> Binder.BindingBuilder<BEAN, FIELDVALUE> forMemberField(HasValue<?, FIELDVALUE> field, Class<? super FIELDVALUE> collectionType, Class<ELEMENT> elementType) {
        this.getTypeConfiguration(collectionType, elementType).store(field);
        return this.forMemberField(field);
    }

    public <T> void setSerializer(Class<T> type, SerializableFunction<T, String> serializer, SerializableFunction<String, T> deserializer) {
        Objects.requireNonNull(type, "Type cannot be null");
        Objects.requireNonNull(serializer, "Serializer cannot be null");
        Objects.requireNonNull(deserializer, "Deserializer cannot be null");
        if (CollaborationBinder.isAssignableFromAny(SUPPORTED_CLASS_TYPES, type) || CollaborationBinder.isAssignableFromAny(SUPPORTED_COLLECTION_TYPES, type)) {
            throw new IllegalArgumentException("Cannot set a custom serializer for a type that has built-in support.");
        }
        if (this.typeConfigurations.containsKey(type)) {
            throw new IllegalStateException("Serializer has already been set for the type " + type.getName() + ".");
        }
        this.typeConfigurations.put(type, new JsonHandler((SerializableFunction & Serializable)value -> new TextNode((String)serializer.apply(value)), (SerializableFunction & Serializable)jsonNode -> deserializer.apply((Object)jsonNode.asText())));
    }

    private <T> Optional<JsonHandler<T>> getTypeConfiguration(Class<T> fieldType) {
        JsonHandler<?> configuration = this.typeConfigurations.get(fieldType);
        if (configuration != null) {
            return Optional.of(configuration);
        }
        if (CollaborationBinder.isSupportedType(fieldType)) {
            return Optional.of(JsonHandler.forBasicType(fieldType));
        }
        return Optional.empty();
    }

    private <ELEMENT> JsonHandler<ELEMENT> getTypeConfigurationOrThrow(Class<ELEMENT> fieldType) {
        return this.getTypeConfiguration(fieldType).orElseThrow(() -> new IllegalStateException(CollaborationBinder.createTypeNotSupportedMessage(fieldType)));
    }

    private <ELEMENT, FIELDVALUE extends Collection<ELEMENT>> JsonHandler<FIELDVALUE> getTypeConfiguration(Class<? super FIELDVALUE> collectionType, Class<ELEMENT> elementType) {
        if (!CollaborationBinder.isAssignableFromAny(SUPPORTED_COLLECTION_TYPES, collectionType)) {
            throw new IllegalArgumentException(collectionType + " is not supported as a collection. Must use a type assignable to one of " + SUPPORTED_COLLECTION_TYPES);
        }
        JsonHandler elementConfiguration = this.getTypeConfigurationOrThrow(elementType);
        return new JsonHandler((SerializableFunction & Serializable)collection -> {
            ArrayNode arrayNode = JsonUtil.getObjectMapper().createArrayNode();
            collection.forEach(element -> arrayNode.add(elementConfiguration.serialize(element)));
            return arrayNode;
        }, (SerializableFunction & Serializable)json -> {
            Collection collection = (Collection)JsonUtil.toInstance((JsonNode)JsonUtil.getObjectMapper().createArrayNode(), collectionType);
            ((ArrayNode)json).forEach(elementJson -> collection.add(elementConfiguration.deserialize((JsonNode)elementJson)));
            return collection;
        });
    }

    @Override
    public Optional<Duration> getExpirationTimeout() {
        return Optional.ofNullable(this.expirationTimeout);
    }

    @Override
    public void setExpirationTimeout(Duration expirationTimeout) {
        this.expirationTimeout = expirationTimeout;
        if (this.formManager != null) {
            this.formManager.setExpirationTimeout(expirationTimeout);
        }
    }

    static {
        UsageStatistics.markAsUsed((String)"vaadin-collaboration-engine/CollaborationBinder", (String)"6.5");
    }

    protected static class CollaborationBindingBuilderImpl<BEAN, FIELDVALUE, TARGET>
    extends Binder.BindingBuilderImpl<BEAN, FIELDVALUE, TARGET> {
        private String propertyName = null;
        private boolean typeIsConverted = false;
        private JsonHandler<?> explicitJsonHandler;

        protected CollaborationBindingBuilderImpl(CollaborationBinder<BEAN> binder, HasValue<?, FIELDVALUE> field, Converter<FIELDVALUE, TARGET> converterValidatorChain, BindingValidationStatusHandler statusHandler) {
            super(binder, field, converterValidatorChain, statusHandler);
            this.explicitJsonHandler = JsonHandler.getAndClear(field);
        }

        public Binder.Binding<BEAN, TARGET> bind(ValueProvider<BEAN, TARGET> getter, Setter<BEAN, TARGET> setter) {
            String propertyName = this.propertyName;
            if (propertyName == null) {
                throw new UnsupportedOperationException("A property name must always be provided when binding with the collaboration binder. Use bind(String propertyName) instead.");
            }
            Binder.Binding binding = super.bind(getter, setter);
            HasValue field = binding.getField();
            Binder binder = this.getBinder();
            ComponentConnectionContext connectionContext = binder.connectionContext;
            if (connectionContext != null) {
                connectionContext.addComponent((Component)field);
            }
            ArrayList<Registration> registrations = new ArrayList<Registration>();
            registrations.add(field.addValueChangeListener(arg_0 -> CollaborationBindingBuilderImpl.lambda$bind$2abd9c08$1((CollaborationBinder)binder, propertyName, field, arg_0)));
            registrations.add(FieldHighlighter.setupForField(field, propertyName, binder));
            binder.bindingRegistrations.put(binding, (Registration & Serializable)() -> registrations.forEach(Registration::remove));
            binder.fieldToPropertyName.put(field, propertyName);
            return binding;
        }

        public Binder.Binding<BEAN, TARGET> bind(String propertyName) {
            try {
                this.propertyName = propertyName;
                Binder.Binding binding = super.bind(propertyName);
                return binding;
            }
            finally {
                this.propertyName = null;
            }
        }

        protected CollaborationBinder<BEAN> getBinder() {
            return (CollaborationBinder)super.getBinder();
        }

        protected <NEWTARGET> Binder.BindingBuilder<BEAN, NEWTARGET> withConverter(Converter<TARGET, NEWTARGET> converter, boolean resetNullRepresentation) {
            if (resetNullRepresentation) {
                this.typeIsConverted = true;
            }
            return super.withConverter(converter, resetNullRepresentation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Binder.BindingBuilder<BEAN, TARGET> withNullRepresentation(TARGET nullRepresentation) {
            boolean typeWasConverted = this.typeIsConverted;
            try {
                Binder.BindingBuilder bindingBuilder = super.withNullRepresentation(nullRepresentation);
                return bindingBuilder;
            }
            finally {
                this.typeIsConverted = typeWasConverted;
            }
        }

        private static /* synthetic */ void lambda$bind$2abd9c08$1(CollaborationBinder binder, String propertyName, HasValue field, HasValue.ValueChangeEvent event) {
            binder.setMapValueFromField(propertyName, field);
        }
    }

    static class JsonHandler<T>
    implements Serializable {
        private final SerializableFunction<T, JsonNode> serializer;
        private final SerializableFunction<JsonNode, T> deserializer;

        private JsonHandler(SerializableFunction<T, JsonNode> serializer, SerializableFunction<JsonNode, T> deserializer) {
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        private static <T> JsonHandler<T> forBasicType(Class<T> fieldType) {
            return new JsonHandler<T>(JsonUtil::toJsonNode, (SerializableFunction & Serializable)jsonNode -> JsonUtil.toInstance(jsonNode, fieldType));
        }

        private void store(HasValue<?, ?> field) {
            if (!(field instanceof Component)) {
                throw new IllegalArgumentException("CollaborationBinder can only be used with component fields. The provided field is of type " + field.getClass().getName());
            }
            Component fieldAsComponent = (Component)field;
            ComponentUtil.setData((Component)fieldAsComponent, JsonHandler.class, (Object)this);
        }

        private static JsonHandler<?> getAndClear(HasValue<?, ?> field) {
            if (field instanceof Component) {
                Component fieldAsComponent = (Component)field;
                JsonHandler config = (JsonHandler)ComponentUtil.getData((Component)fieldAsComponent, JsonHandler.class);
                ComponentUtil.setData((Component)fieldAsComponent, JsonHandler.class, null);
                return config;
            }
            return null;
        }

        private JsonNode serialize(T value) {
            return (JsonNode)this.serializer.apply(value);
        }

        private T deserialize(JsonNode jsonNode) {
            return (T)this.deserializer.apply((Object)jsonNode);
        }
    }
}

