/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueThread {
    protected final Logger log = LoggerFactory.getLogger(QueueThread.class);
    protected String name;
    protected int threadId;
    protected boolean usingThreading;

    public QueueThread(String queue) {
        if (queue != null) {
            int index = queue.indexOf("!");
            if (index != -1 && queue.length() >= index + 1) {
                this.name = queue.substring(0, index);
                try {
                    this.threadId = Integer.parseInt(queue.substring(index + 1));
                    this.usingThreading = true;
                }
                catch (NumberFormatException e) {
                    this.log.warn("Invalid thread ID from queue {}", (Object)queue);
                }
            } else {
                this.name = queue;
            }
        }
    }

    public static String getQueueName(String queue) {
        int index;
        int n = index = queue == null ? -1 : queue.indexOf("!");
        if (index != -1) {
            return queue.substring(0, index);
        }
        return queue;
    }

    public String getQueueName() {
        return this.name;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public boolean isUsingThreading() {
        return this.usingThreading;
    }
}

