/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.ProtocolException;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.util.LinkedCaseInsensitiveMap;

public final class DataUtils {
    private static final String OLD_ = "OLD_";

    public static Map<String, String> getDataMap(DataMetaData dataMetaData) {
        Table table;
        LinkedCaseInsensitiveMap data = null;
        DataEventType dml = dataMetaData.getData().getDataEventType();
        data = DataEventType.UPDATE.equals((Object)dml) || DataEventType.INSERT.equals((Object)dml) || DataEventType.DELETE.equals((Object)dml) ? ((table = dataMetaData.getTable()) != null ? new LinkedCaseInsensitiveMap(dataMetaData.getTable().getColumnCount() * 4) : new LinkedCaseInsensitiveMap()) : new LinkedCaseInsensitiveMap(1);
        switch (dml) {
            case UPDATE: {
                data.putAll(DataUtils.getNewDataAsString(null, dataMetaData));
                data.putAll(DataUtils.getOldDataAsString(OLD_, dataMetaData));
                break;
            }
            case INSERT: {
                data.putAll(DataUtils.getNewDataAsString(null, dataMetaData));
                Map map = DataUtils.getNullData(OLD_, dataMetaData);
                data.putAll(map);
                break;
            }
            case DELETE: {
                data.putAll(DataUtils.getOldDataAsString(null, dataMetaData));
                data.putAll(DataUtils.getOldDataAsString(OLD_, dataMetaData));
                break;
            }
        }
        if (data != null) {
            if (data.size() == 0) {
                data.putAll(DataUtils.getPkDataAsString(dataMetaData));
            }
            data.put("EXTERNAL_DATA", dataMetaData.getData().getExternalData());
        }
        return data;
    }

    public static Map<String, String> getNewDataAsString(String prefix, DataMetaData dataMetaData) {
        String[] rowData = dataMetaData.getData().toParsedRowData();
        return DataUtils.getDataAsString(prefix, dataMetaData, rowData);
    }

    public static Map<String, String> getOldDataAsString(String prefix, DataMetaData dataMetaData) {
        String[] rowData = dataMetaData.getData().toParsedOldData();
        return DataUtils.getDataAsString(prefix, dataMetaData, rowData);
    }

    public static Map<String, String> getDataAsString(String prefix, DataMetaData dataMetaData, String[] rowData) {
        String[] columns = dataMetaData.getTriggerHistory().getParsedColumnNames();
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap(columns.length * 2);
        if (rowData != null) {
            DataUtils.testColumnNamesMatchValues(dataMetaData, columns, rowData);
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i];
                columnName = prefix != null ? prefix + columnName : columnName;
                map.put(columnName, rowData[i]);
                map.put(columnName.toUpperCase(), rowData[i]);
            }
        }
        return map;
    }

    public static Map<String, String> getPkDataAsString(DataMetaData dataMetaData) {
        String[] columns = dataMetaData.getTriggerHistory().getParsedPkColumnNames();
        Object[] rowData = dataMetaData.getData().toParsedPkData();
        LinkedCaseInsensitiveMap map = new LinkedCaseInsensitiveMap(columns.length);
        if (rowData != null) {
            DataUtils.testColumnNamesMatchValues(dataMetaData, columns, rowData);
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i].toUpperCase();
                map.put(columnName, rowData[i]);
            }
        }
        return map;
    }

    public static Map<String, Object> getDataObjectMap(DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, boolean upperCase) {
        LinkedCaseInsensitiveMap data = null;
        DataEventType dml = dataMetaData.getData().getDataEventType();
        switch (dml) {
            case UPDATE: {
                data = new LinkedCaseInsensitiveMap(dataMetaData.getTable().getColumnCount() * 2);
                data.putAll(DataUtils.getNewDataAsObject(null, dataMetaData, symmetricDialect, upperCase));
                data.putAll(DataUtils.getOldDataAsObject(OLD_, dataMetaData, symmetricDialect, upperCase));
                break;
            }
            case INSERT: {
                data = new LinkedCaseInsensitiveMap(dataMetaData.getTable().getColumnCount() * 2);
                data.putAll(DataUtils.getNewDataAsObject(null, dataMetaData, symmetricDialect, upperCase));
                Map map = DataUtils.getNullData(OLD_, dataMetaData);
                data.putAll(map);
                break;
            }
            case DELETE: {
                data = new LinkedCaseInsensitiveMap(dataMetaData.getTable().getColumnCount() * 2);
                data.putAll(DataUtils.getOldDataAsObject(null, dataMetaData, symmetricDialect, upperCase));
                data.putAll(DataUtils.getOldDataAsObject(OLD_, dataMetaData, symmetricDialect, upperCase));
                if (data.size() != 0) break;
                data.putAll(DataUtils.getPkDataAsObject(dataMetaData, symmetricDialect));
                break;
            }
            default: {
                data = new LinkedCaseInsensitiveMap(1);
            }
        }
        if (data.size() == 0) {
            data.putAll(DataUtils.getPkDataAsString(dataMetaData));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMetaData.getData().getExternalData())) {
            data.put("EXTERNAL_DATA", dataMetaData.getData().getExternalData());
        } else {
            data.put("EXTERNAL_DATA", null);
        }
        return data;
    }

    public static Map<String, Object> getNewDataAsObject(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, boolean upperCase) {
        return DataUtils.getDataAsObject(prefix, dataMetaData, symmetricDialect, dataMetaData.getData().toParsedRowData(), upperCase);
    }

    public static Map<String, Object> getOldDataAsObject(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, boolean upperCase) {
        return DataUtils.getDataAsObject(prefix, dataMetaData, symmetricDialect, dataMetaData.getData().toParsedOldData(), upperCase);
    }

    public static <T> Map<String, T> getNullData(String prefix, DataMetaData dataMetaData) {
        String[] columnNames = dataMetaData.getTriggerHistory().getParsedColumnNames();
        LinkedCaseInsensitiveMap data = new LinkedCaseInsensitiveMap(columnNames.length * 2);
        for (String columnName : columnNames) {
            columnName = prefix != null ? prefix + columnName : columnName;
            data.put(columnName, null);
            data.put(columnName.toUpperCase(), null);
        }
        return data;
    }

    public static Map<String, Object> getDataAsObject(String prefix, DataMetaData dataMetaData, ISymmetricDialect symmetricDialect, String[] rowData, boolean upperCase) {
        if (rowData != null) {
            LinkedCaseInsensitiveMap data = new LinkedCaseInsensitiveMap(rowData.length);
            String[] columnNames = dataMetaData.getTriggerHistory().getParsedColumnNames();
            Object[] objects = symmetricDialect.getPlatform().getObjectValues(symmetricDialect.getBinaryEncoding(), dataMetaData.getTable(), columnNames, rowData);
            DataUtils.testColumnNamesMatchValues(dataMetaData, columnNames, objects);
            for (int i = 0; i < columnNames.length; ++i) {
                String colName = upperCase ? columnNames[i].toUpperCase() : columnNames[i];
                data.put(prefix != null ? prefix + colName : colName, objects[i]);
            }
            return data;
        }
        return Collections.emptyMap();
    }

    public static void testColumnNamesMatchValues(DataMetaData dataMetaData, String[] columnNames, Object[] values) {
        if (columnNames.length != values.length) {
            String message = String.format("The router row for table %s had %d columns but expected %d.", dataMetaData.getData().getTableName(), values.length, columnNames.length);
            throw new ProtocolException(message, new Object[0]);
        }
    }

    public static Map<String, Object> getPkDataAsObject(DataMetaData dataMetaData, ISymmetricDialect symmetricDialect) {
        String[] rowData = dataMetaData.getData().toParsedPkData();
        if (rowData != null) {
            LinkedCaseInsensitiveMap data = new LinkedCaseInsensitiveMap(rowData.length);
            String[] columnNames = dataMetaData.getTriggerHistory().getParsedPkColumnNames();
            Object[] objects = symmetricDialect.getPlatform().getObjectValues(symmetricDialect.getBinaryEncoding(), dataMetaData.getTable(), columnNames, rowData);
            DataUtils.testColumnNamesMatchValues(dataMetaData, columnNames, objects);
            for (int i = 0; i < columnNames.length; ++i) {
                data.put(columnNames[i].toUpperCase(), objects[i]);
            }
            return data;
        }
        return Collections.emptyMap();
    }
}

