/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.internal;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.transport.IOutgoingTransport;

public class InternalOutgoingTransport
implements IOutgoingTransport {
    BufferedWriter writer = null;
    OutputStream os = null;
    ChannelMap map = null;
    boolean open = true;

    public InternalOutgoingTransport(OutputStream os, String encoding) throws UnsupportedEncodingException {
        this(os, new ChannelMap(), encoding);
    }

    public InternalOutgoingTransport(OutputStream os, ChannelMap map, String encoding) throws UnsupportedEncodingException {
        this.os = os;
        this.writer = new BufferedWriter(new OutputStreamWriter(os, encoding == null ? Charset.defaultCharset().name() : encoding));
        this.map = map;
    }

    public InternalOutgoingTransport(BufferedWriter writer) {
        this.writer = writer;
        this.map = new ChannelMap();
    }

    @Override
    public void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public OutputStream openStream() {
        return this.os;
    }

    @Override
    public BufferedWriter openWriter() {
        return this.writer;
    }

    @Override
    public BufferedWriter getWriter() {
        return this.writer;
    }

    @Override
    public ChannelMap getSuspendIgnoreChannelLists(IConfigurationService configurationService, String queue, Node targetNode) {
        return this.map;
    }
}

