/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.http;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfSignedX509TrustManager
implements X509TrustManager {
    private X509TrustManager standardTrustManager = null;
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public SelfSignedX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        this.standardTrustManager.checkClientTrusted(certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        if (certificates != null && this.log.isDebugEnabled()) {
            this.log.debug("Server certificate chain:");
            for (int i = 0; i < certificates.length; ++i) {
                this.log.debug("X509Certificate[" + i + "]=" + String.valueOf(certificates[i]));
            }
        }
        if (certificates != null) {
            if (certificates.length == 1 && certificates[0] != null) {
                certificates[0].checkValidity();
                return;
            }
            if (certificates.length > 1 && certificates[0] != null) {
                boolean certificatesAreEqual = true;
                for (int i = 1; i < certificates.length; ++i) {
                    certificatesAreEqual &= certificates[0].equals(certificates[i]);
                }
                if (certificatesAreEqual) {
                    certificates[0].checkValidity();
                    return;
                }
            }
        }
        this.standardTrustManager.checkServerTrusted(certificates, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }
}

