/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport.file;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.transport.IIncomingTransport;

public class FileIncomingTransport
implements IIncomingTransport {
    Node remoteNode;
    String incomingDir;
    String archiveDir;
    String errorDir;
    File incomingFile;
    BufferedReader reader;
    InputStream in;
    boolean open = true;

    public FileIncomingTransport(Node remoteNode, Node localNode, String incomingDir, String archiveDir, String errorDir) {
        this.remoteNode = remoteNode;
        this.incomingDir = incomingDir;
        this.archiveDir = archiveDir;
        this.errorDir = errorDir;
    }

    @Override
    public BufferedReader openReader() throws IOException {
        this.incomingFile = this.getIncomingFile("csv");
        this.reader = this.incomingFile != null ? new BufferedReader(new FileReader(this.incomingFile)) : new BufferedReader(new StringReader(""));
        return this.reader;
    }

    @Override
    public InputStream openStream() throws IOException {
        this.incomingFile = this.getIncomingFile("zip");
        this.in = this.incomingFile != null ? new FileInputStream(this.incomingFile) : new ByteArrayInputStream(new byte[0]);
        return this.in;
    }

    protected File getIncomingFile(String fileExtension) {
        File file = null;
        Object[] files = new File(this.incomingDir).list(new FileIncomingFilter(this.remoteNode, fileExtension));
        if (files != null && files.length > 0) {
            Arrays.sort(files);
            File firstFile = new File(this.incomingDir + File.separator + (String)files[0]);
            long lastModified = firstFile.lastModified();
            if (lastModified > 0L && System.currentTimeMillis() - lastModified > 3000L) {
                file = firstFile;
            }
        }
        return file;
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public String getRedirectionUrl() {
        return null;
    }

    @Override
    public String getUrl() {
        return "";
    }

    public void complete(boolean success) {
        if (this.incomingFile != null) {
            if (success) {
                if (StringUtils.isNotBlank((CharSequence)this.archiveDir)) {
                    this.incomingFile.renameTo(new File(this.archiveDir + File.separator + this.incomingFile.getName()));
                } else {
                    this.incomingFile.delete();
                }
            } else if (StringUtils.isNotBlank((CharSequence)this.errorDir)) {
                this.incomingFile.renameTo(new File(this.errorDir + File.separator + this.incomingFile.getName()));
            }
        }
    }

    @Override
    public Map<String, String> getHeaders() {
        return null;
    }

    public static class FileIncomingFilter
    implements FilenameFilter {
        String startFilter;
        String endFilter;

        public FileIncomingFilter(Node remoteNode, String fileExtension) {
            this.startFilter = remoteNode.getNodeGroupId() + "-" + remoteNode.getNodeId();
            this.endFilter = "." + fileExtension;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.startFilter) && name.endsWith(this.endFilter);
        }
    }
}

