/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.BatchAck;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.transport.ISyncUrlExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransportManager {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final int FORM_KEYS_PER_BATCH = 24;
    protected IExtensionService extensionService;

    public AbstractTransportManager() {
    }

    public AbstractTransportManager(IExtensionService extensionService) {
        this.extensionService = extensionService;
    }

    public String resolveURL(String syncUrl, String registrationUrl) {
        if (StringUtils.isBlank((CharSequence)syncUrl) || syncUrl.startsWith("nop")) {
            this.log.debug("Using the registration URL to contact the remote node because the syncURL for the node is blank");
            return registrationUrl;
        }
        try {
            URI uri = new URI(syncUrl);
            for (ISyncUrlExtension handler : this.extensionService.getExtensionPointList(ISyncUrlExtension.class)) {
                syncUrl = handler.resolveUrl(uri);
                uri = new URI(syncUrl);
            }
        }
        catch (URISyntaxException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return syncUrl;
    }

    protected List<String> getAcknowledgementData(boolean requires13Format, String nodeId, List<IncomingBatch> list, int maxFormKeys, int maxByteSize) throws IOException {
        ArrayList<String> ackDataList = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int keyCount = 0;
        if (maxFormKeys > 0) {
            maxFormKeys = Math.max(maxFormKeys, 24);
        }
        for (IncomingBatch batch : list) {
            int localKeyCount;
            String value = batch.getStatus() == AbstractBatch.Status.OK ? "ok" : Long.valueOf(batch.getFailedRowNumber());
            StringBuilder localBuilder = new StringBuilder();
            if (!requires13Format) {
                localKeyCount = this.appendAcknowledgementData(batch, nodeId, value, localBuilder);
            } else {
                if (batch.getStatus() == AbstractBatch.Status.IG) {
                    value = "ok";
                }
                AbstractTransportManager.append(localBuilder, "batch-" + batch.getBatchId(), value);
                localKeyCount = 1;
            }
            if (maxByteSize > 0 && builder.length() + localBuilder.length() > maxByteSize || maxFormKeys > 0 && keyCount + localKeyCount > maxFormKeys) {
                ackDataList.add(builder.toString());
                builder = new StringBuilder();
                keyCount = 0;
            } else if (keyCount > 0) {
                builder.append("&");
            }
            builder.append((CharSequence)localBuilder);
            keyCount += localKeyCount;
        }
        ackDataList.add(builder.toString());
        return ackDataList;
    }

    protected int appendAcknowledgementData(IncomingBatch batch, String nodeId, Object value, StringBuilder builder) {
        if (batch.getStatus() == AbstractBatch.Status.RS) {
            value = "resend";
        }
        long batchId = batch.getBatchId();
        AbstractTransportManager.append(builder, "batch-" + batchId, value);
        AbstractTransportManager.append(builder, "nodeId-" + batchId, nodeId);
        AbstractTransportManager.append(builder, "network-" + batchId, batch.getNetworkMillis());
        AbstractTransportManager.append(builder, "filter-" + batchId, batch.getFilterMillis());
        AbstractTransportManager.append(builder, "database-" + batchId, batch.getLoadMillis());
        AbstractTransportManager.append(builder, "startTime-" + batchId, batch.getStartTime());
        AbstractTransportManager.append(builder, "byteCount-" + batchId, batch.getByteCount());
        AbstractTransportManager.append(builder, "loadRowCount-" + batchId, batch.getLoadRowCount());
        AbstractTransportManager.append(builder, "transformTime-" + batchId, batch.getTransformLoadMillis());
        AbstractTransportManager.append(builder, "loadInsertRowCount-" + batchId, batch.getLoadInsertRowCount());
        AbstractTransportManager.append(builder, "loadUpdateRowCount-" + batchId, batch.getLoadUpdateRowCount());
        AbstractTransportManager.append(builder, "loadDeleteRowCount-" + batchId, batch.getLoadDeleteRowCount());
        AbstractTransportManager.append(builder, "fallbackInsertCount-" + batchId, batch.getFallbackInsertCount());
        AbstractTransportManager.append(builder, "fallbackUpdateCount-" + batchId, batch.getFallbackUpdateCount());
        AbstractTransportManager.append(builder, "conflictWinCount-" + batchId, batch.getConflictWinCount());
        AbstractTransportManager.append(builder, "conflictLoseCount-" + batchId, batch.getConflictLoseCount());
        AbstractTransportManager.append(builder, "ignoreRowCount-" + batchId, batch.getIgnoreRowCount());
        AbstractTransportManager.append(builder, "missingDeleteCount-" + batchId, batch.getMissingDeleteCount());
        AbstractTransportManager.append(builder, "skipCount-" + batchId, batch.getSkipCount());
        AbstractTransportManager.append(builder, "bulkLoader-" + batchId, batch.isBulkLoaderFlag());
        int keyCount = 20;
        if (batch.getIgnoreCount() > 0L) {
            AbstractTransportManager.append(builder, "ignoreCount-" + batchId, batch.getIgnoreCount());
            ++keyCount;
        }
        if (batch.getStatus() == AbstractBatch.Status.ER || batch.getStatus() == AbstractBatch.Status.LD) {
            String sqlState = batch.getSqlState();
            if (sqlState != null && sqlState.length() > 10 && (sqlState = sqlState.replace("JDBC-", "")).length() > 10) {
                sqlState = sqlState.substring(0, 10);
            }
            AbstractTransportManager.append(builder, "sqlState-" + batchId, sqlState);
            AbstractTransportManager.append(builder, "sqlCode-" + batchId, batch.getSqlCode());
            AbstractTransportManager.append(builder, "sqlMessage-" + batchId, batch.getSqlMessage());
            keyCount += 3;
        }
        return keyCount;
    }

    protected static void append(StringBuilder builder, String name, Object value) {
        try {
            int len = builder.length();
            if (len > 0 && builder.charAt(len - 1) != '?') {
                builder.append("&");
            }
            if (value == null) {
                value = "";
            }
            builder.append(name).append("=").append(URLEncoder.encode(value.toString(), StandardCharsets.UTF_8.name()));
        }
        catch (IOException ex) {
            throw new IoException((Exception)ex);
        }
    }

    public List<BatchAck> readAcknowledgement(String parameterString1, String parameterString2) throws IOException {
        return this.readAcknowledgement(parameterString1 + "&" + parameterString2);
    }

    public List<BatchAck> readAcknowledgement(String parameterString) throws IOException {
        Map<String, String> parameters = this.getParametersFromQueryUrl(parameterString.replace("\n", ""));
        return AbstractTransportManager.readAcknowledgement(parameters);
    }

    public static List<BatchAck> readAcknowledgement(Map<String, ? extends Object> parameters) {
        ArrayList<BatchAck> batches = new ArrayList<BatchAck>();
        for (String parameterName : parameters.keySet()) {
            if (!parameterName.startsWith("batch-")) continue;
            long batchId = NumberUtils.toLong((String)parameterName.substring("batch-".length()));
            BatchAck batchInfo = AbstractTransportManager.getBatchInfo(parameters, batchId);
            batches.add(batchInfo);
        }
        return batches;
    }

    public void writeRequestProperties(Map<String, String> requestProperties, OutputStream os) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> requestProperty : requestProperties.entrySet()) {
            if (sb.length() != 0) {
                sb.append("&");
            }
            sb.append(requestProperty.getKey()).append("=");
            if (requestProperty.getValue() == null || requestProperty.getValue().equals("")) continue;
            sb.append(URLEncoder.encode(requestProperty.getValue(), StandardCharsets.UTF_8.name()));
        }
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(os, StandardCharsets.UTF_8), true);
        pw.println(sb.toString());
        pw.flush();
    }

    public Map<String, String> readRequestProperties(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String parameterString = reader.readLine();
        return this.getParametersFromQueryUrl(parameterString);
    }

    private static BatchAck getBatchInfo(Map<String, ? extends Object> parameters, long batchId) {
        BatchAck batchInfo = new BatchAck(batchId);
        String nodeId = AbstractTransportManager.getParam(parameters, "nodeId-" + batchId);
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            nodeId = AbstractTransportManager.getParam(parameters, "nodeId");
        }
        batchInfo.setNodeId(nodeId);
        batchInfo.setNetworkMillis(AbstractTransportManager.getParamAsNum(parameters, "network-" + batchId));
        batchInfo.setFilterMillis(AbstractTransportManager.getParamAsNum(parameters, "filter-" + batchId));
        batchInfo.setLoadMillis(AbstractTransportManager.getParamAsNum(parameters, "database-" + batchId));
        batchInfo.setByteCount(AbstractTransportManager.getParamAsNum(parameters, "byteCount-" + batchId));
        batchInfo.setLoadRowCount(AbstractTransportManager.getParamAsNum(parameters, "loadRowCount-" + batchId));
        batchInfo.setTransformLoadMillis(AbstractTransportManager.getParamAsNum(parameters, "transformTime-" + batchId));
        batchInfo.setLoadInsertRowCount(AbstractTransportManager.getParamAsNum(parameters, "loadInsertRowCount-" + batchId));
        batchInfo.setLoadUpdateRowCount(AbstractTransportManager.getParamAsNum(parameters, "loadUpdateRowCount-" + batchId));
        batchInfo.setLoadDeleteRowCount(AbstractTransportManager.getParamAsNum(parameters, "loadDeleteRowCount-" + batchId));
        batchInfo.setFallbackInsertCount(AbstractTransportManager.getParamAsNum(parameters, "fallbackInsertCount-" + batchId));
        batchInfo.setFallbackUpdateCount(AbstractTransportManager.getParamAsNum(parameters, "fallbackUpdateCount-" + batchId));
        batchInfo.setConflictWinCount(AbstractTransportManager.getParamAsNum(parameters, "conflictWinCount-" + batchId));
        batchInfo.setConflictLoseCount(AbstractTransportManager.getParamAsNum(parameters, "conflictLoseCount-" + batchId));
        batchInfo.setIgnoreRowCount(AbstractTransportManager.getParamAsNum(parameters, "ignoreRowCount-" + batchId));
        batchInfo.setMissingDeleteCount(AbstractTransportManager.getParamAsNum(parameters, "missingDeleteCount-" + batchId));
        batchInfo.setSkipCount(AbstractTransportManager.getParamAsNum(parameters, "skipCount-" + batchId));
        batchInfo.setIgnored(AbstractTransportManager.getParamAsBoolean(parameters, "ignoreCount-" + batchId));
        batchInfo.setBulkLoaderFlag(Boolean.parseBoolean(AbstractTransportManager.getParam(parameters, "bulkLoader-" + batchId)));
        String status = AbstractTransportManager.getParam(parameters, "batch-" + batchId, "").trim();
        batchInfo.setOk(status.equalsIgnoreCase("ok") || status.equalsIgnoreCase("resend"));
        batchInfo.setResend(status.equalsIgnoreCase("resend"));
        batchInfo.setStartTime(AbstractTransportManager.getParamAsNum(parameters, "startTime-" + batchId));
        if (!batchInfo.isOk()) {
            batchInfo.setErrorLine(NumberUtils.toLong((String)status));
            batchInfo.setSqlState(AbstractTransportManager.getParam(parameters, "sqlState-" + batchId));
            batchInfo.setSqlCode((int)AbstractTransportManager.getParamAsNum(parameters, "sqlCode-" + batchId));
            batchInfo.setSqlMessage(AbstractTransportManager.getParam(parameters, "sqlMessage-" + batchId));
        }
        return batchInfo;
    }

    protected Map<String, String> getParametersFromQueryUrl(String parameterString) throws IOException {
        String[] tokens;
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String param : tokens = parameterString.split("&")) {
            String[] nameValuePair = param.split("=");
            if (nameValuePair.length != 2) continue;
            parameters.put(nameValuePair[0], URLDecoder.decode(nameValuePair[1], StandardCharsets.UTF_8.name()));
        }
        return parameters;
    }

    private static long getParamAsNum(Map<String, ? extends Object> parameters, String parameterName) {
        return NumberUtils.toLong((String)AbstractTransportManager.getParam(parameters, parameterName));
    }

    private static boolean getParamAsBoolean(Map<String, ? extends Object> parameters, String parameterName) {
        return AbstractTransportManager.getParamAsNum(parameters, parameterName) > 0L;
    }

    private static String getParam(Map<String, ? extends Object> parameters, String parameterName, String defaultValue) {
        String value = AbstractTransportManager.getParam(parameters, parameterName);
        return value == null ? defaultValue : value;
    }

    private static String getParam(Map<String, ? extends Object> parameters, String parameterName) {
        String[] arrayValue;
        Object value = parameters.get(parameterName);
        if (value instanceof String[] && (arrayValue = (String[])value).length > 0) {
            value = StringUtils.trim((String)arrayValue[0]);
        }
        return (String)value;
    }
}

