/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeHost;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.service.IUpdateService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.UpdateServiceSqlMap;
import org.jumpmind.util.AppUtils;
import org.slf4j.MDC;

public class UpdateService
extends AbstractService
implements IUpdateService {
    protected final long MILLIS_BETWEEN_CHECKS = 86400000L;
    protected final long MILLIS_AFTER_NODE_OFFLINE = 86400000L;
    protected ISymmetricEngine engine;
    protected boolean sendUsage;
    protected boolean checkUpdates;
    protected String latestVersion;
    protected String downloadUrl;
    protected Thread sleepThread;
    protected boolean stopped = false;

    public UpdateService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.engine = engine;
        this.setSqlMap(new UpdateServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    @Override
    public void init() {
        this.sendUsage = this.parameterService.is("send.usage.stats", true);
        this.checkUpdates = this.parameterService.is("check.software.updates", true);
        if (this.sendUsage || this.checkUpdates) {
            this.sleepThread = new Thread(){

                @Override
                public void run() {
                    MDC.put((String)"engineName", (String)UpdateService.this.engine.getEngineName());
                    UpdateService.this.log.debug("Starting thread to check for updates, running every {} millis", (Object)86400000L);
                    while (!UpdateService.this.stopped) {
                        try {
                            Thread.sleep(86400000L);
                            UpdateService.this.checkForUpdates();
                        }
                        catch (InterruptedException e) {
                            UpdateService.this.log.debug("Stopping check update thread");
                        }
                        catch (Exception e) {
                            UpdateService.this.log.debug("Failed to check updates", (Throwable)e);
                        }
                    }
                }
            };
            this.sleepThread.setDaemon(true);
            this.sleepThread.start();
        }
    }

    @Override
    public void checkForUpdates() {
        try {
            this.log.debug("Starting check for updates");
            Map<String, Object> prop = this.getProperties();
            if (this.sendUsage) {
                this.addUsageProperties(prop);
            }
            byte[] postData = this.getPostData(prop);
            this.postDataForVersion(this.getUpdateUrl(), postData);
            if (this.checkUpdates && this.latestVersion != null && Version.isOlderThanVersion(Version.version(), this.latestVersion)) {
                this.log.warn("New version of SymmetricDS (" + this.latestVersion + ") is available for download from " + this.downloadUrl);
            }
        }
        catch (MalformedURLException e) {
            this.log.debug("Failed to obtain URL for checking updates", (Throwable)e);
        }
        catch (Exception e) {
            this.log.debug("Failed to communicate for checking updates", (Throwable)e);
        }
        finally {
            this.log.debug("Ending check for updates");
        }
    }

    protected byte[] getPostData(Map<String, Object> prop) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (String key : prop.keySet()) {
            Object value = prop.get(key);
            sb.append(URLEncoder.encode(key.toString(), StandardCharsets.UTF_8.name())).append("=");
            sb.append(URLEncoder.encode(value == null ? "" : value.toString(), StandardCharsets.UTF_8.name())).append("&");
        }
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    protected void postDataForVersion(URL url, byte[] postData) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setFixedLengthStreamingMode(postData.length);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        conn.connect();
        try (OutputStream os = conn.getOutputStream();){
            os.write(postData);
        }
        this.parseHeaders(conn);
        this.parseResponse(conn);
        conn.disconnect();
    }

    protected void parseHeaders(HttpURLConnection conn) {
    }

    protected void parseResponse(HttpURLConnection conn) throws IOException {
        Gson gson = new Gson();
        JsonReader reader = gson.newJsonReader((Reader)new InputStreamReader(conn.getInputStream()));
        String fieldName = "";
        while (reader.hasNext()) {
            JsonToken jsonToken = reader.peek();
            if (jsonToken == JsonToken.BEGIN_OBJECT) {
                reader.beginObject();
                continue;
            }
            if (jsonToken == JsonToken.NAME) {
                fieldName = reader.nextName();
                continue;
            }
            if (jsonToken == JsonToken.STRING) {
                String value = reader.nextString();
                if ("version".equals(fieldName)) {
                    this.latestVersion = value;
                    continue;
                }
                if (!"link".equals(fieldName)) continue;
                this.downloadUrl = value;
                continue;
            }
            if (jsonToken != JsonToken.NUMBER) continue;
            reader.nextLong();
        }
        reader.close();
    }

    protected Map<String, Object> getProperties() {
        HashMap<String, Object> prop = new HashMap<String, Object>();
        IContextService contextService = this.engine.getContextService();
        String guid = contextService.getString("guid");
        if (guid == null) {
            guid = UUID.randomUUID().toString();
            contextService.save("guid", guid);
        }
        prop.put("guid", guid.replace("-", ""));
        prop.put("time_zone", AppUtils.getTimezoneOffset());
        prop.put("version", Version.version());
        return prop;
    }

    protected void addUsageProperties(Map<String, Object> prop) {
        Node node = this.engine.getNodeService().findIdentity();
        prop.put("node_id", node.getNodeId());
        prop.put("node_group_id", node.getNodeGroupId());
        prop.put("hostname", AppUtils.getHostName());
        prop.put("ip_address", AppUtils.getIpAddress());
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        prop.put("os_processors", String.valueOf(osBean.getAvailableProcessors()));
        prop.put("os_name", System.getProperty("os.name"));
        prop.put("os_arch", System.getProperty("os.arch"));
        prop.put("os_version", System.getProperty("os.version"));
        prop.put("jvm_title", Runtime.class.getPackage().getImplementationTitle());
        prop.put("jvm_vendor", Runtime.class.getPackage().getImplementationVendor());
        prop.put("jvm_version", Runtime.class.getPackage().getImplementationVersion());
        prop.put("jvm_memory", String.valueOf(Runtime.getRuntime().maxMemory()));
        prop.put("nodes", this.engine.getNodeService().findAllNodeSecurity(true).size());
        int clusterNodeCount = 0;
        Date nodeCreateDate = null;
        boolean isClustered = this.engine.getParameterService().is("cluster.lock.enabled");
        long offlineTime = System.currentTimeMillis() - 86400000L;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        for (NodeHost host : this.engine.getNodeService().findNodeHosts(node.getNodeId())) {
            if (isClustered && host.getHeartbeatTime() != null && host.getHeartbeatTime().getTime() >= offlineTime) {
                ++clusterNodeCount;
            }
            if (host.getCreateTime() == null || nodeCreateDate != null && !host.getCreateTime().before(nodeCreateDate)) continue;
            nodeCreateDate = host.getCreateTime();
        }
        prop.put("cluster.nodes", clusterNodeCount);
        prop.put("node_create_date", nodeCreateDate == null ? "" : dateFormat.format(nodeCreateDate));
        prop.put("node_groups", this.engine.getConfigurationService().getNodeGroups().size());
        Map<String, Channel> channels = this.engine.getConfigurationService().getChannels(false);
        int channelCount = 0;
        int advChannelCount = 0;
        for (String name : channels.keySet()) {
            Object channel;
            if (!(name.equals("config") || name.equals("dynamic") || name.equals("filesync") || name.equals("filesync_reload") || name.equals("heartbeat") || name.equals("reload"))) {
                ++channelCount;
            }
            if (((Channel)(channel = channels.get(name))).getDataLoaderType().equals("default")) continue;
            ++advChannelCount;
        }
        prop.put("channels", channelCount);
        prop.put("channels_advanced", advChannelCount);
        this.engine.getConfigurationService().getNodeGroupLinks(false).size();
        List<Router> routers = this.engine.getTriggerRouterService().getRouters(false);
        int advRouterCount = 0;
        for (Router router : routers) {
            if (router.getRouterType().equals("default")) continue;
            ++advRouterCount;
        }
        prop.put("routers", routers.size());
        prop.put("routers_advanced", advRouterCount);
        prop.put("triggers", this.engine.getTriggerRouterService().getTriggers().size());
        prop.put("trigger_routers", this.engine.getTriggerRouterService().getTriggerRouters(false).size());
        int tableCount = 0;
        int columnCount = 0;
        for (TriggerHistory hist : this.engine.getTriggerRouterService().getActiveTriggerHistoriesFromCache()) {
            if (hist.getSourceTableName().startsWith(this.parameterService.getTablePrefix())) continue;
            ++tableCount;
            columnCount += hist.getParsedColumnNames().length;
        }
        prop.put("tables", tableCount);
        prop.put("table_columns", columnCount);
        prop.put("file_triggers", this.engine.getFileSyncService().getFileTriggers().size());
        prop.put("conflicts", this.engine.getDataLoaderService().getConflictSettingsNodeGroupLinks().size());
        prop.put("transforms", this.engine.getTransformService().getTransformTables(false).size());
        prop.put("load_filters", this.engine.getLoadFilterService().getLoadFilterNodeGroupLinks().size());
        prop.put("extensions", this.engine.getExtensionService().getExtensions().size());
        prop.put("db_type", this.symmetricDialect.getName());
        prop.put("db_version", this.symmetricDialect.getVersion());
        long mobileNodeCount = 0L;
        HashSet<CallSite> databaseTypes = new HashSet<CallSite>();
        for (Node clientNode : this.engine.getNodeService().findAllNodes()) {
            String deployType;
            String databaseType = clientNode.getDatabaseType() + " " + clientNode.getDatabaseVersion();
            if (databaseTypes.add((CallSite)((Object)databaseType))) {
                prop.put("db_type_" + databaseTypes.size(), clientNode.getDatabaseType());
                prop.put("db_version_" + databaseTypes.size(), clientNode.getDatabaseVersion());
                if (databaseTypes.size() == 10) break;
            }
            if (!(deployType = clientNode.getDeploymentType()).equals("android") && !deployType.equals("cclient")) continue;
            ++mobileNodeCount;
        }
        prop.put("mobile_nodes", mobileNodeCount);
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        Map outMap = this.sqlTemplateDirty.queryForMap(this.getSql("countOutgoing"), new Object[]{cal.getTime()});
        prop.put("out_batches", outMap.get("batch_count"));
        prop.put("out_bytes", outMap.get("byte_count") == null ? Long.valueOf(0L) : outMap.get("byte_count"));
        prop.put("out_rows", outMap.get("rows_count") == null ? Long.valueOf(0L) : outMap.get("rows_count"));
        Map inMap = this.sqlTemplateDirty.queryForMap(this.getSql("countIncoming"), new Object[]{cal.getTime()});
        prop.put("in_batches", outMap.get("batch_count"));
        prop.put("in_bytes", inMap.get("byte_count") == null ? Long.valueOf(0L) : inMap.get("byte_count"));
        prop.put("in_rows", inMap.get("rows_count") == null ? Long.valueOf(0L) : inMap.get("rows_count"));
    }

    protected URL getUpdateUrl() throws MalformedURLException {
        return new URL("https://status.symmetricds.org/api/getlatest.php");
    }

    @Override
    public boolean isNewVersionAvailable() {
        return this.latestVersion != null && Version.isOlderThanVersion(Version.version(), this.latestVersion);
    }

    @Override
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    @Override
    public void stop() {
        this.stopped = true;
        if (this.sleepThread != null) {
            this.sleepThread.interrupt();
        }
    }
}

