/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.DataTruncation;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.text.StringEscapeUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.InvalidSqlException;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.UniqueKeyException;
import org.jumpmind.db.sql.mapper.NumberMapper;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.db.util.TableRow;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.AbstractSymmetricEngine;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.ext.IHeartbeatListener;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.TransformPoint;
import org.jumpmind.symmetric.job.PushHeartbeatListener;
import org.jumpmind.symmetric.load.IReloadGenerator;
import org.jumpmind.symmetric.load.IReloadListener;
import org.jumpmind.symmetric.load.IReloadVariableFilter;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataEvent;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.model.ExtractRequest;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeGroupLinkAction;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TableReloadRequest;
import org.jumpmind.symmetric.model.TableReloadRequestKey;
import org.jumpmind.symmetric.model.TableReloadStatus;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerReBuildReason;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IFileSyncService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.DataServiceSqlMap;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.jumpmind.util.ExceptionUtils;
import org.jumpmind.util.FormatUtils;

public class DataService
extends AbstractService
implements IDataService {
    private ISymmetricEngine engine;
    private IExtensionService extensionService;
    public static final int RECAPTURE_DATA_COMMIT_LIMIT = 1000;
    public static final int PROGRESS_LOG_UPDATE_DELAY_MS = 30000;
    public static final transient String TIMESTAMP_ISO_JSON_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final transient DateTimeFormatter isoJsonDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.from(ZoneOffset.UTC));
    protected Map<IHeartbeatListener, Long> lastHeartbeatTimestamps = new HashMap<IHeartbeatListener, Long>();

    public DataService(ISymmetricEngine engine, IExtensionService extensionService) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.engine = engine;
        this.extensionService = extensionService;
        extensionService.addExtensionPoint(new PushHeartbeatListener(engine));
        this.setSqlMap(new DataServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    public boolean insertReloadEvent(TableReloadRequest request, boolean deleteAtClient) {
        boolean successful = false;
        if (request != null) {
            ITriggerRouterService triggerRouterService = this.engine.getTriggerRouterService();
            INodeService nodeService = this.engine.getNodeService();
            Node targetNode = nodeService.findNode(request.getTargetNodeId());
            if (targetNode != null) {
                TriggerRouter triggerRouter = triggerRouterService.getTriggerRouterForCurrentNode(request.getTriggerId(), request.getRouterId(), false);
                if (triggerRouter != null) {
                    Trigger trigger = triggerRouter.getTrigger();
                    Router router = triggerRouter.getRouter();
                    NodeGroupLink link = router.getNodeGroupLink();
                    Node me = nodeService.findIdentity();
                    if (link.getSourceNodeGroupId().equals(me.getNodeGroupId())) {
                        if (link.getTargetNodeGroupId().equals(targetNode.getNodeGroupId())) {
                            TriggerHistory triggerHistory = this.lookupTriggerHistory(trigger);
                            ISqlTransaction transaction = null;
                            try {
                                transaction = this.sqlTemplate.startSqlTransaction();
                                if (this.parameterService.is("initial.load.delete.first")) {
                                    String overrideDeleteStatement = StringUtils.isNotBlank((CharSequence)request.getBeforeCustomSql()) ? request.getBeforeCustomSql() : null;
                                    this.insertPurgeEvent(transaction, targetNode, triggerRouter, triggerHistory, false, overrideDeleteStatement, -1L, null);
                                }
                                this.insertReloadEvent(transaction, targetNode, triggerRouter, triggerHistory, request.getReloadSelect(), false, -1L, null, AbstractBatch.Status.NE, -1L);
                                if (!targetNode.requires13Compatiblity() && deleteAtClient) {
                                    this.insertSqlEvent(transaction, triggerHistory, trigger.getChannelId(), targetNode, String.format("delete from %s where target_node_id='%s' and source_node_id='%s' and trigger_id='%s' and router_id='%s'", TableConstants.getTableName(this.tablePrefix, "table_reload_request"), request.getTargetNodeId(), request.getSourceNodeId(), request.getTriggerId(), request.getRouterId()), false, -1L, null);
                                }
                                this.deleteTableReloadRequest(transaction, request);
                                transaction.commit();
                            }
                            catch (Error ex) {
                                if (transaction != null) {
                                    transaction.rollback();
                                }
                                throw ex;
                            }
                            catch (RuntimeException ex) {
                                if (transaction != null) {
                                    transaction.rollback();
                                }
                                throw ex;
                            }
                            finally {
                                this.close(transaction);
                            }
                        } else {
                            this.log.error("Could not reload table {} for node {} because the router {} target node group id {} did not match", new Object[]{trigger.getSourceTableName(), request.getTargetNodeId(), request.getRouterId(), link.getTargetNodeGroupId()});
                        }
                    } else {
                        this.log.error("Could not reload table {}  for node {} because the router {} source node group id {} did not match", new Object[]{trigger.getSourceTableName(), request.getTargetNodeId(), request.getRouterId(), link.getSourceNodeGroupId()});
                    }
                } else {
                    this.log.error("Could not reload table for node {} because the trigger router ({}, {}) could not be found", new Object[]{request.getTargetNodeId(), request.getTriggerId(), request.getRouterId()});
                }
            } else {
                this.log.error("Could not reload table for node {} because the target node could not be found", (Object)request.getTargetNodeId());
            }
        }
        return successful;
    }

    public String generateTransactionIdFromTimestamp(String prefix, Instant instant) {
        return prefix + isoJsonDateTimeFormatter.format(instant);
    }

    @Override
    public int cancelTableReloadRequest(TableReloadRequest request) {
        return this.sqlTemplate.update(this.getSql("cancelTableReloadRequest"), new Object[]{new Date(), request.getSourceNodeId(), request.getTargetNodeId(), request.getTriggerId(), request.getRouterId(), request.getCreateTime()}, new int[]{93, 12, 12, 12, 12, 93});
    }

    protected void deleteTableReloadRequest(ISqlTransaction sqlTransaction, TableReloadRequest request) {
        sqlTransaction.prepareAndExecute(this.getSql("deleteTableReloadRequest"), new Object[]{request.getSourceNodeId(), request.getTargetNodeId(), request.getTriggerId(), request.getRouterId()}, new int[]{12, 12, 12, 12});
    }

    @Override
    public void insertTableReloadRequest(TableReloadRequest request) {
        try (ISqlTransaction transaction = null;){
            transaction = this.engine.getDatabasePlatform().getSqlTemplate().startSqlTransaction();
            this.insertTableReloadRequest(transaction, request);
            transaction.commit();
        }
    }

    @Override
    public void insertTableReloadRequest(ISqlTransaction transaction, TableReloadRequest request) {
        Date time = new Date();
        request.setLastUpdateTime(time);
        if (request.getCreateTime() == null) {
            request.setCreateTime(time);
        }
        request.setCreateTime(new Date(request.getCreateTime().getTime() / 10L * 10L));
        transaction.prepareAndExecute(this.getSql("insertTableReloadRequest"), new Object[]{request.getReloadSelect(), request.getBeforeCustomSql(), request.getCreateTime(), request.getLastUpdateBy(), request.getLastUpdateTime(), request.getSourceNodeId(), request.getTargetNodeId(), request.getTriggerId(), request.getRouterId(), request.isCreateTable() ? 1 : 0, request.isDeleteFirst() ? 1 : 0, request.getChannelId()});
    }

    @Override
    public TableReloadRequest getTableReloadRequest(final TableReloadRequestKey key) {
        return (TableReloadRequest)this.sqlTemplate.queryForObject(this.getSql("selectTableReloadRequest"), (ISqlRowMapper)new ISqlRowMapper<TableReloadRequest>(){

            public TableReloadRequest mapRow(Row rs) {
                TableReloadRequest request = new TableReloadRequest(key);
                request.setReloadSelect(rs.getString("reload_select"));
                request.setReloadTime(rs.getDateTime("reload_time"));
                request.setBeforeCustomSql(rs.getString("before_custom_sql"));
                request.setCreateTime(rs.getDateTime("create_time"));
                request.setLastUpdateBy(rs.getString("last_update_by"));
                request.setLastUpdateTime(rs.getDateTime("last_update_time"));
                request.setLoadId(rs.getInt("load_id"));
                return request;
            }
        }, new Object[]{key.getSourceNodeId(), key.getTargetNodeId(), key.getTriggerId(), key.getRouterId(), key.getCreateTime()});
    }

    @Override
    public TableReloadRequest getTableReloadRequest(long loadId) {
        List<TableReloadRequest> collapsedRequests = this.getTableReloadRequests(loadId);
        return collapsedRequests == null || collapsedRequests.size() == 0 ? null : collapsedRequests.get(0);
    }

    @Override
    public List<TableReloadRequest> getTableReloadRequests(long loadId) {
        List requests = this.sqlTemplate.query(this.getSql("selectTableReloadRequestsByLoadId"), (ISqlRowMapper)new TableReloadRequestMapper(), new Object[]{loadId});
        List<TableReloadRequest> collapsedRequests = this.collapseTableReloadRequestsByLoadId(requests);
        return collapsedRequests;
    }

    @Override
    public TableReloadRequest getTableReloadRequest(long loadId, String triggerId, String routerId) {
        List requests = this.sqlTemplate.query(this.getSql("selectTableReloadRequestsByLoadIdTriggerRouter"), (ISqlRowMapper)new TableReloadRequestMapper(), new Object[]{loadId, triggerId, routerId});
        if (requests == null || requests.size() == 0) {
            requests = this.sqlTemplate.query(this.getSql("selectTableReloadRequestsByLoadIdTriggerRouter"), (ISqlRowMapper)new TableReloadRequestMapper(), new Object[]{loadId, "ALL", "ALL"});
        }
        return requests == null || requests.size() == 0 ? null : (TableReloadRequest)requests.get(0);
    }

    @Override
    public List<TableReloadRequest> getTableReloadRequestToProcess(final String sourceNodeId) {
        return this.sqlTemplate.query(this.getSql("selectTableReloadRequestToProcess"), (ISqlRowMapper)new ISqlRowMapper<TableReloadRequest>(){

            public TableReloadRequest mapRow(Row rs) {
                TableReloadRequest request = new TableReloadRequest();
                request.setSourceNodeId(sourceNodeId);
                request.setTargetNodeId(rs.getString("target_node_id"));
                request.setCreateTable(rs.getBoolean("create_table"));
                request.setDeleteFirst(rs.getBoolean("delete_first"));
                request.setReloadSelect(rs.getString("reload_select"));
                request.setReloadTime(rs.getDateTime("reload_time"));
                request.setBeforeCustomSql(rs.getString("before_custom_sql"));
                request.setChannelId(rs.getString("channel_id"));
                request.setTriggerId(rs.getString("trigger_id"));
                request.setRouterId(rs.getString("router_id"));
                request.setLoadId(rs.getLong("load_id"));
                request.setCreateTime(rs.getDateTime("create_time"));
                request.setLastUpdateBy(rs.getString("last_update_by"));
                request.setLastUpdateTime(rs.getDateTime("last_update_time"));
                return request;
            }
        }, new Object[]{sourceNodeId});
    }

    @Override
    public List<TableReloadRequest> getTableReloadRequestToProcessByTarget(final String targetNodeId) {
        return this.sqlTemplate.query(this.getSql("selectTableReloadRequestToProcessByTarget"), (ISqlRowMapper)new ISqlRowMapper<TableReloadRequest>(){

            public TableReloadRequest mapRow(Row rs) {
                TableReloadRequest request = new TableReloadRequest();
                request.setSourceNodeId(rs.getString("source_node_id"));
                request.setTargetNodeId(targetNodeId);
                request.setCreateTable(rs.getBoolean("create_table"));
                request.setDeleteFirst(rs.getBoolean("delete_first"));
                request.setReloadSelect(rs.getString("reload_select"));
                request.setReloadTime(rs.getDateTime("reload_time"));
                request.setBeforeCustomSql(rs.getString("before_custom_sql"));
                request.setChannelId(rs.getString("channel_id"));
                request.setTriggerId(rs.getString("trigger_id"));
                request.setRouterId(rs.getString("router_id"));
                request.setLoadId(rs.getLong("load_id"));
                request.setCreateTime(rs.getDateTime("create_time"));
                request.setLastUpdateBy(rs.getString("last_update_by"));
                request.setLastUpdateTime(rs.getDateTime("last_update_time"));
                return request;
            }
        }, new Object[]{targetNodeId});
    }

    public List<TableReloadRequest> getTableReloadRequests() {
        return this.sqlTemplateDirty.query(this.getSql("selectTableReloadRequests"), (ISqlRowMapper)new TableReloadRequestMapper(), new Object[0]);
    }

    @Override
    public List<TableReloadStatus> getTableReloadStatus() {
        return this.sqlTemplateDirty.query(this.getSql("selectTableReloadStatus", "orderTableReloadStatus"), (ISqlRowMapper)new TableReloadStatusMapper(), new Object[0]);
    }

    @Override
    public List<TableReloadStatus> getOutgoingTableReloadStatus() {
        return this.sqlTemplateDirty.query(this.getSql("selectTableReloadStatus", "whereSourceNodeId", "orderTableReloadStatus"), (ISqlRowMapper)new TableReloadStatusMapper(), new Object[]{this.engine.getNodeId()});
    }

    @Override
    public List<TableReloadStatus> getIncomingTableReloadStatus() {
        return this.sqlTemplateDirty.query(this.getSql("selectTableReloadStatus", "whereTargetNodeId", "orderTableReloadStatus"), (ISqlRowMapper)new TableReloadStatusMapper(), new Object[]{this.engine.getNodeId()});
    }

    @Override
    public List<TableReloadStatus> getActiveTableReloadStatus() {
        return this.sqlTemplateDirty.query(this.getSql("selectActiveTableReloadStatus", "orderTableReloadStatus"), (ISqlRowMapper)new TableReloadStatusMapper(), new Object[0]);
    }

    @Override
    public List<TableReloadStatus> getActiveOutgoingTableReloadStatus() {
        return this.sqlTemplateDirty.query(this.getSql("selectActiveTableReloadStatus", "andSourceNodeId", "orderTableReloadStatus"), (ISqlRowMapper)new TableReloadStatusMapper(), new Object[]{this.engine.getNodeId()});
    }

    @Override
    public List<TableReloadStatus> getActiveIncomingTableReloadStatus() {
        return this.sqlTemplateDirty.query(this.getSql("selectActiveTableReloadStatus", "andTargetNodeId", "orderTableReloadStatus"), (ISqlRowMapper)new TableReloadStatusMapper(), new Object[]{this.engine.getNodeId()});
    }

    @Override
    public TableReloadStatus getTableReloadStatusByLoadIdAndSourceNodeId(long loadId, String sourceNodeId) {
        return (TableReloadStatus)this.sqlTemplateDirty.queryForObject(this.getSql("selectTableReloadStatusByLoadIdSourceNodeId"), (ISqlRowMapper)new TableReloadStatusMapper(), new Object[]{loadId, sourceNodeId});
    }

    @Override
    public List<TableReloadStatus> getTableReloadStatusByTarget(String targetNodeId) {
        return this.sqlTemplateDirty.query(this.getSql("selectTableReloadStatusByTargetNodeId"), (ISqlRowMapper)new TableReloadStatusMapper(), new Object[]{targetNodeId});
    }

    public List<TableReloadRequest> getTableReloadRequestByLoadId() {
        return this.collapseTableReloadRequestsByLoadId(this.getTableReloadRequests());
    }

    public List<TableReloadRequest> collapseTableReloadRequestsByLoadId(List<TableReloadRequest> requests) {
        ArrayList<TableReloadRequest> collapsedRequests = new ArrayList<TableReloadRequest>();
        long previousLoadId = -1L;
        TableReloadRequest summary = null;
        for (TableReloadRequest request : requests) {
            if (request.getLoadId() != previousLoadId) {
                if (summary != null) {
                    collapsedRequests.add(summary);
                }
                summary = new TableReloadRequest();
                summary.setTargetNodeId(request.getTargetNodeId());
                summary.setSourceNodeId(request.getSourceNodeId());
                summary.setCreateTable(request.isCreateTable());
                summary.setDeleteFirst(request.isDeleteFirst());
                summary.setBeforeCustomSql(request.getBeforeCustomSql());
                summary.setCreateTime(request.getCreateTime());
                summary.setLastUpdateTime(request.getLastUpdateTime());
                summary.setLastUpdateBy(request.getLastUpdateBy());
                summary.setProcessed(request.isProcessed());
                summary.setLoadId(request.getLoadId());
                summary.setProcessed(request.isProcessed());
                summary.setChannelId(request.getChannelId());
                summary.setTriggerId(request.getTriggerId());
                summary.setRouterId(request.getRouterId());
                summary.setReloadSelect(request.getReloadSelect());
            }
            previousLoadId = request.getLoadId();
        }
        if (summary != null) {
            collapsedRequests.add(summary);
        }
        return collapsedRequests;
    }

    @Override
    public Map<Long, List<TableReloadRequest>> getTableReloadRequestByLoadIdMap() {
        HashMap<Long, List<TableReloadRequest>> requestMap = new HashMap<Long, List<TableReloadRequest>>();
        for (TableReloadRequest request : this.getTableReloadRequests()) {
            ArrayList<TableReloadRequest> requestList = (ArrayList<TableReloadRequest>)requestMap.get(request.getLoadId());
            if (requestList == null) {
                requestList = new ArrayList<TableReloadRequest>();
                requestMap.put(request.getLoadId(), requestList);
            }
            requestList.add(request);
        }
        return requestMap;
    }

    @Override
    public TableReloadStatus updateTableReloadStatusDataLoaded(ISqlTransaction transaction, long loadId, String sourceNodeId, long batchId, int batchCount, boolean isBulkLoaded) {
        int count;
        int idType = this.symmetricDialect.getSqlTypeForIds();
        if (this.platform.supportsParametersInSelect()) {
            count = transaction.prepareAndExecute(this.getSql("updateTableReloadStatusDataLoaded"), new Object[]{batchId, batchCount, batchId, batchCount, batchId, batchCount, batchId, batchCount, batchId, batchCount, batchId, batchCount, new Date(), batchId, batchCount, batchId, batchCount, batchId, batchCount, loadId, sourceNodeId, new Date(), batchId, isBulkLoaded, batchId, batchId, loadId, sourceNodeId, loadId, sourceNodeId}, new int[]{idType, 2, idType, 2, idType, 2, idType, 2, idType, 2, idType, 2, 93, idType, 2, idType, 2, idType, 2, idType, 12, 93, idType, 2, idType, idType, idType, 12, idType, 12});
        } else {
            String sql = this.getSql("updateTableReloadStatusDataLoadedNoParams");
            sql = FormatUtils.replace((String)"batchId", (String)String.valueOf(batchId), (String)sql);
            sql = FormatUtils.replace((String)"batchCount", (String)String.valueOf(batchCount), (String)sql);
            sql = FormatUtils.replace((String)"loadId", (String)String.valueOf(loadId), (String)sql);
            sql = FormatUtils.replace((String)"nodeId", (String)sourceNodeId, (String)sql);
            sql = FormatUtils.replace((String)"isBulkLoaded", (String)(isBulkLoaded ? "1" : "0"), (String)sql);
            count = transaction.prepareAndExecute(sql, new Object[0]);
        }
        TableReloadStatus status = null;
        List statuses = transaction.query(this.getSql("selectTableReloadStatusByLoadIdSourceNodeId"), (ISqlRowMapper)new TableReloadStatusMapper(), new Object[]{loadId, sourceNodeId}, new int[]{idType, 12});
        if (statuses != null && statuses.size() > 0) {
            status = (TableReloadStatus)statuses.get(0);
        }
        if (count == 0) {
            if (status != null && !status.isCompleted()) {
                this.log.warn("No load status updated for source node {} load ID {} batch ID {}", new Object[]{sourceNodeId, loadId, batchId});
            } else if (status == null) {
                this.log.warn("No load status found for source node {} load ID {} batch ID {}", new Object[]{sourceNodeId, loadId, batchId});
            }
            status = null;
        }
        return status;
    }

    @Override
    public void updateTableReloadStatusFailed(long loadId, String sourceNodeId, long batchId) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            this.updateTableReloadStatusFailed(transaction, loadId, sourceNodeId, batchId);
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public void updateTableReloadStatusFailed(ISqlTransaction transaction, long loadId, String sourceNodeId, long batchId) {
        int idType = this.symmetricDialect.getSqlTypeForIds();
        if (this.platform.supportsParametersInSelect()) {
            transaction.prepareAndExecute(this.getSql("updateTableReloadStatusFailed"), new Object[]{batchId, batchId, batchId, loadId, sourceNodeId}, new int[]{idType, idType, idType, idType, 12});
        } else {
            String sql = this.getSql("updateTableReloadStatusFailedNoParams");
            sql = FormatUtils.replace((String)"batchId", (String)String.valueOf(batchId), (String)sql);
            sql = FormatUtils.replace((String)"loadId", (String)String.valueOf(loadId), (String)sql);
            sql = FormatUtils.replace((String)"nodeId", (String)sourceNodeId, (String)sql);
            transaction.prepareAndExecute(sql, new Object[0]);
        }
    }

    public void updateTableReloadStatusDataCounts(ISqlTransaction transaction, long loadId, String sourceNodeId, long startBatchId, long endBatchId, long dataBatchCount, long rowsCount) {
        int[] types;
        Object[] args;
        String sql;
        int idType = this.symmetricDialect.getSqlTypeForIds();
        if (this.platform.supportsParametersInSelect()) {
            sql = this.getSql("updateTableReloadStatusDataCounts");
            args = new Object[]{startBatchId, endBatchId, dataBatchCount, rowsCount, new Date(), loadId, sourceNodeId};
            types = new int[]{idType, idType, 2, 2, 93, idType, 12};
        } else {
            sql = this.getSql("updateTableReloadStatusDataCountsNoParamsInSelect");
            sql = FormatUtils.replace((String)"batchCount", (String)String.valueOf(dataBatchCount), (String)sql);
            sql = FormatUtils.replace((String)"rowCount", (String)String.valueOf(rowsCount), (String)sql);
            args = new Object[]{startBatchId, endBatchId, new Date(), loadId, sourceNodeId};
            types = new int[]{idType, idType, 93, idType, 12};
        }
        if (transaction == null) {
            try {
                transaction = this.sqlTemplate.startSqlTransaction();
                transaction.prepareAndExecute(sql, args, types);
                transaction.commit();
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                this.close(transaction);
            }
        } else {
            transaction.prepareAndExecute(sql, args, types);
        }
    }

    public void updateTableReloadRequestsLoadId(ISqlTransaction transaction, long loadId, TableReloadRequest request) {
        Object[] args = new Object[]{loadId, new Date(), request.getTargetNodeId(), request.getSourceNodeId(), request.getTriggerId(), request.getRouterId(), request.getCreateTime()};
        String sql = this.getSql("updateTableReloadRequestLoadId");
        int[] types = new int[]{this.symmetricDialect.getSqlTypeForIds(), 93, 12, 12, 12, 12, 93};
        if (transaction == null) {
            try {
                transaction = this.sqlTemplate.startSqlTransaction();
                transaction.prepareAndExecute(sql, args, types);
                transaction.commit();
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                this.close(transaction);
            }
        } else {
            transaction.prepareAndExecute(sql, args, types);
        }
    }

    public void updateTableReloadStatusTableCount(ISqlTransaction transaction, long loadId, String sourceNodeId, int tableCount) {
        Object[] args = new Object[]{tableCount, new Date(), loadId, sourceNodeId};
        String sql = this.getSql("updateTableReloadStatusTableCount");
        int[] types = new int[]{2, 93, this.symmetricDialect.getSqlTypeForIds(), 12};
        if (transaction == null) {
            try {
                transaction = this.sqlTemplate.startSqlTransaction();
                transaction.prepareAndExecute(sql, args, types);
                transaction.commit();
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                this.close(transaction);
            }
        } else {
            transaction.prepareAndExecute(sql, args, types);
        }
    }

    private void updateTableReloadStatusFinalizeCount(ISqlTransaction transaction, long loadId, String sourceNodeId, int finalizeBatchCount) {
        Object[] args = new Object[]{finalizeBatchCount, new Date(), loadId, sourceNodeId};
        String sql = this.getSql("updateTableReloadStatusFinalizeCount");
        int[] types = new int[]{2, 93, this.symmetricDialect.getSqlTypeForIds(), 12};
        if (transaction == null) {
            try {
                transaction = this.sqlTemplate.startSqlTransaction();
                transaction.prepareAndExecute(sql, args, types);
                transaction.commit();
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                this.close(transaction);
            }
        } else {
            transaction.prepareAndExecute(sql, new Object[]{finalizeBatchCount, new Date(), loadId, sourceNodeId});
        }
    }

    public void createTableReloadStatus(ISqlTransaction transaction, long loadId, boolean isFullLoad, String sourceNodeId, String targetNodeId) {
        Date now = new Date();
        Object[] argsDelete = new Object[]{loadId, sourceNodeId};
        String sqlDelete = this.getSql("deleteTableReloadStatus");
        int[] typesDelete = new int[]{2, 12};
        Object[] args = new Object[]{loadId, targetNodeId, sourceNodeId, isFullLoad ? 1 : 0, now, now, -1, -1, -1};
        String sql = this.getSql("insertTableReloadStatus");
        int[] types = new int[]{this.symmetricDialect.getSqlTypeForIds(), 12, 12, 4, 93, 93, 2, 2, 2};
        if (transaction == null) {
            try {
                transaction = this.sqlTemplate.startSqlTransaction();
                transaction.prepareAndExecute(sqlDelete, argsDelete, typesDelete);
                transaction.prepareAndExecute(sql, args, types);
                transaction.commit();
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                this.close(transaction);
            }
        } else {
            transaction.prepareAndExecute(sqlDelete, argsDelete, typesDelete);
            transaction.prepareAndExecute(sql, args, types);
        }
    }

    public void updateTableReloadStatusSetupCount(ISqlTransaction transaction, long loadId, String sourceNodeId, int setupBatchCount) {
        Object[] args = new Object[]{setupBatchCount, new Date(), loadId, sourceNodeId};
        String sql = this.getSql("updateTableReloadStatusSetupCount");
        int[] types = new int[]{2, 93, this.symmetricDialect.getSqlTypeForIds(), 12};
        if (transaction == null) {
            try {
                transaction = this.sqlTemplate.startSqlTransaction();
                transaction.prepareAndExecute(sql, args, types);
                transaction.commit();
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                this.close(transaction);
            }
        } else {
            transaction.prepareAndExecute(sql, args, types);
        }
    }

    @Override
    public int updateTableReloadRequestsCancelled(long loadId, String sourceNodeId) {
        ISqlTransaction transaction = null;
        int count = 0;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            Date now = new Date();
            count = transaction.prepareAndExecute(this.getSql("updateTableReloadStatusCancelled"), new Object[]{now, now, loadId, sourceNodeId}, new int[]{93, 93, this.symmetricDialect.getSqlTypeForIds(), 12});
            transaction.prepareAndExecute(this.getSql("updateProcessedTableReloadRequest"), new Object[]{now, loadId});
            transaction.commit();
            int n = count;
            return n;
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    protected int updateTableReloadRequestsError(long loadId, String sourceNodeId, int errorCode, String sqlState, String message) {
        return this.sqlTemplate.update(this.getSql("updateTableReloadStatusError"), new Object[]{errorCode, StringUtils.left((String)sqlState, (int)10), message, loadId, sourceNodeId});
    }

    protected long insertRequestedOutgoingBatches(ISqlTransaction transaction, Node targetNode, TriggerRouter triggerRouter, TriggerHistory triggerHistory, String overrideInitialLoadSelect, long loadId, String createBy, String channelId, long totalRows, long maxRowsPerBatch, long batchCount) {
        long startBatchId = 0L;
        startBatchId = this.platform.supportsMultiThreadedTransactions() ? this.engine.getSequenceService().nextRange("outgoing_batch", batchCount) : this.engine.getSequenceService().nextRange(transaction, "outgoing_batch", batchCount);
        String tableName = triggerHistory.getSourceTableName().toLowerCase();
        int i = 0;
        while ((long)i < batchCount) {
            long batchId = startBatchId + (long)i;
            long rowCount = totalRows;
            if (rowCount > maxRowsPerBatch) {
                rowCount = maxRowsPerBatch;
            }
            OutgoingBatch batch = new OutgoingBatch(targetNode.getNodeId(), channelId, AbstractBatch.Status.RQ);
            batch.setBatchId(batchId);
            batch.setLoadId(loadId);
            batch.setCreateBy(createBy);
            batch.setLoadFlag(true);
            batch.incrementRowCount(DataEventType.RELOAD);
            batch.setDataRowCount(rowCount);
            batch.incrementTableCount(tableName);
            batch.setExtractJobFlag(true);
            this.engine.getOutgoingBatchService().insertOutgoingBatch(transaction, batch);
            if (i == 0) {
                Data data = new Data(triggerHistory.getSourceTableName(), DataEventType.RELOAD, overrideInitialLoadSelect != null ? overrideInitialLoadSelect : triggerRouter.getInitialLoadSelect(), null, triggerHistory, channelId, null, null);
                data.setNodeList(targetNode.getNodeId());
                data.setPreRouted(true);
                long dataId = this.insertData(transaction, data);
                this.insertDataEvent(transaction, new DataEvent(dataId, batchId));
            }
            totalRows -= rowCount;
            ++i;
        }
        return startBatchId;
    }

    @Override
    public long insertReloadEvent(ISqlTransaction transaction, Node targetNode, TriggerRouter triggerRouter, TriggerHistory triggerHistory, String overrideInitialLoadSelect, boolean isLoad, long loadId, String createBy, AbstractBatch.Status status, long estimatedBatchRowCount) {
        String channelId = this.getReloadChannelIdForTrigger(triggerRouter.getTrigger(), this.engine.getConfigurationService().getChannels(false));
        return this.insertReloadEvent(transaction, targetNode, triggerRouter, triggerHistory, overrideInitialLoadSelect, isLoad, loadId, createBy, status, channelId, estimatedBatchRowCount);
    }

    public long insertReloadEvent(ISqlTransaction transaction, Node targetNode, TriggerRouter triggerRouter, TriggerHistory triggerHistory, String overrideInitialLoadSelect, boolean isLoad, long loadId, String createBy, AbstractBatch.Status status, String channelId, long estimatedBatchRowCount) {
        return this.insertReloadEvent(transaction, targetNode, triggerRouter, triggerHistory, overrideInitialLoadSelect, isLoad, loadId, createBy, status, channelId, estimatedBatchRowCount, isLoad);
    }

    public long insertReloadEventImmediate(ISqlTransaction transaction, Node targetNode, TriggerRouter triggerRouter, TriggerHistory triggerHistory, String overrideInitialLoadSelect, boolean isLoad, long loadId, String createBy, AbstractBatch.Status status, String channelId, long estimatedBatchRowCount) {
        if (triggerHistory == null) {
            triggerHistory = this.lookupTriggerHistory(triggerRouter.getTrigger());
        }
        Data data = new Data(triggerHistory.getSourceTableName(), DataEventType.RELOAD, overrideInitialLoadSelect != null ? overrideInitialLoadSelect : triggerRouter.getInitialLoadSelect(), null, triggerHistory, channelId, null, null);
        data.setNodeList(targetNode.getNodeId());
        return this.insertDataAndDataEventAndOutgoingBatch(transaction, data, targetNode.getNodeId(), isLoad, loadId, createBy, status, channelId, estimatedBatchRowCount);
    }

    protected long insertReloadEvent(ISqlTransaction transaction, Node targetNode, TriggerRouter triggerRouter, TriggerHistory triggerHistory, String overrideInitialLoadSelect, boolean isLoad, long loadId, String createBy, AbstractBatch.Status status, String channelId, long estimatedBatchRowCount, boolean isImmediate) {
        if (triggerHistory == null) {
            triggerHistory = this.lookupTriggerHistory(triggerRouter.getTrigger());
        }
        Data data = new Data(triggerHistory.getSourceTableName(), DataEventType.RELOAD, overrideInitialLoadSelect != null ? overrideInitialLoadSelect : triggerRouter.getInitialLoadSelect(), null, triggerHistory, channelId, null, null);
        data.setNodeList(targetNode.getNodeId());
        if (isImmediate) {
            return this.insertDataAndDataEventAndOutgoingBatch(transaction, data, targetNode.getNodeId(), isLoad, loadId, createBy, status, null, estimatedBatchRowCount);
        }
        return this.insertData(transaction, data);
    }

    protected String getReloadChannelIdForTrigger(Trigger trigger, Map<String, Channel> channels) {
        String channelId;
        String string = channelId = trigger != null ? trigger.getChannelId() : "default";
        if (this.parameterService.is("initial.load.use.reload.channel")) {
            Channel normalChannel = channels.get(channelId);
            Channel reloadChannel = channels.get(trigger != null ? trigger.getReloadChannelId() : "reload");
            if (normalChannel != null && normalChannel.isFileSyncFlag()) {
                if (reloadChannel != null && reloadChannel.isFileSyncFlag()) {
                    channelId = reloadChannel.getChannelId();
                }
            } else {
                channelId = reloadChannel != null && reloadChannel.isReloadFlag() ? reloadChannel.getChannelId() : "reload";
            }
        }
        return channelId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, ExtractRequest> insertReloadEvents(Node targetNode, boolean reverse, List<TableReloadRequest> reloadRequests, ProcessInfo processInfo, List<TriggerRouter> triggerRouters, Map<Integer, ExtractRequest> extractRequests, IReloadGenerator reloadGenerator) {
        block52: {
            if (this.engine.getClusterService().lock("SyncTriggers")) {
                try {
                    ITriggerRouterService triggerRouterService;
                    INodeService nodeService = this.engine.getNodeService();
                    ITriggerRouterService iTriggerRouterService = triggerRouterService = this.engine.getTriggerRouterService();
                    synchronized (iTriggerRouterService) {
                        boolean transactional = this.parameterService.is("datareload.batch.insert.transactional");
                        long loadId = 0L;
                        if (reloadRequests != null && reloadRequests.size() > 0) {
                            loadId = reloadRequests.get(0).getLoadId();
                        }
                        if (loadId != 0L) {
                            TableReloadStatus status = new TableReloadStatus();
                            status.setSourceNodeId(this.engine.getNodeId());
                            status.setTargetNodeId(targetNode.getNodeId());
                            status.setLoadId((int)loadId);
                            status.setFullLoad(reloadRequests.get(0).isFullLoadRequest());
                            this.engine.getInitialLoadService().cancelLoad(status);
                            TableReloadRequest tableReloadRequest = reloadRequests.get(0);
                            tableReloadRequest.setLoadId(0L);
                            tableReloadRequest.setProcessed(false);
                            tableReloadRequest.setCreateTime(null);
                            this.insertTableReloadRequest(tableReloadRequest);
                            loadId = 0L;
                        }
                        List<TriggerHistory> activeHistories = null;
                        activeHistories = reloadGenerator == null ? triggerRouterService.getActiveTriggerHistories() : reloadGenerator.getActiveTriggerHistories(targetNode);
                        boolean isFullLoad = reloadRequests == null || reloadRequests.size() == 1 && reloadRequests.get(0).isFullLoadRequest();
                        boolean isChannelLoad = false;
                        String channelId = null;
                        if (reloadRequests != null && reloadRequests.size() == 1 && reloadRequests.get(0).isChannelRequest()) {
                            isChannelLoad = true;
                            channelId = reloadRequests.get(0).getChannelId();
                        }
                        if (!reverse) {
                            this.log.info("Queueing up " + (isFullLoad ? "an initial" : "a") + " load to node " + targetNode.getNodeId() + (String)(isChannelLoad ? " for channel " + channelId : ""));
                        } else {
                            this.log.info("Queueing up a reverse " + (isFullLoad ? "initial " : "partial ") + "load to node " + targetNode.getNodeId());
                        }
                        if (isFullLoad && StringUtils.isBlank((CharSequence)reloadRequests.get(0).getReloadSelect())) {
                            this.engine.getOutgoingBatchService().markAllAsSentForNode(targetNode.getNodeId(), false);
                        }
                        Node sourceNode = nodeService.findIdentity();
                        String nodeIdRecord = reverse ? nodeService.findIdentityNodeId() : targetNode.getNodeId();
                        NodeSecurity nodeSecurity = nodeService.findNodeSecurity(nodeIdRecord);
                        ISqlTransaction transaction = null;
                        try {
                            String createBy;
                            transaction = this.platform.getSqlTemplate().startSqlTransaction();
                            if (loadId == 0L) {
                                loadId = this.platform.supportsMultiThreadedTransactions() ? this.engine.getSequenceService().nextVal("outgoing_batch_load_id") : this.engine.getSequenceService().nextVal(transaction, "outgoing_batch_load_id");
                            }
                            processInfo.setCurrentLoadId(loadId);
                            String string = createBy = reverse ? nodeSecurity.getRevInitialLoadCreateBy() : nodeSecurity.getInitialLoadCreateBy();
                            if (reloadRequests != null && reloadRequests.size() > 0) {
                                createBy = reloadRequests.get(0).getLastUpdateBy();
                                this.createTableReloadStatus(this.platform.supportsMultiThreadedTransactions() ? null : transaction, loadId, isFullLoad, reloadRequests.get(0).getSourceNodeId(), reloadRequests.get(0).getTargetNodeId());
                                for (TableReloadRequest request : reloadRequests) {
                                    this.updateTableReloadRequestsLoadId(this.platform.supportsMultiThreadedTransactions() ? null : transaction, loadId, request);
                                }
                                if (!isFullLoad && !reverse) {
                                    nodeService.setPartialLoadStarted(transaction, nodeIdRecord, loadId, createBy);
                                }
                                this.close(transaction);
                                transaction = this.platform.getSqlTemplate().startSqlTransaction();
                            }
                            Object triggerHistories = new ArrayList<TriggerHistory>();
                            if (isFullLoad || isChannelLoad) {
                                triggerHistories.addAll(activeHistories);
                                if (reloadRequests != null && reloadRequests.size() == 1 && channelId != null) {
                                    ArrayList channelTriggerHistories = new ArrayList();
                                    Iterator iterator = triggerHistories.iterator();
                                    while (iterator.hasNext()) {
                                        TriggerHistory history = (TriggerHistory)iterator.next();
                                        Trigger trigger = this.findTriggerFor(history, triggerRouters);
                                        if (trigger == null || !channelId.equals(trigger.getChannelId()) && !channelId.equals(trigger.getReloadChannelId())) continue;
                                        channelTriggerHistories.add(history);
                                    }
                                    triggerHistories = channelTriggerHistories;
                                }
                            } else {
                                for (TableReloadRequest reloadRequest : reloadRequests) {
                                    triggerHistories.addAll(this.engine.getTriggerRouterService().getActiveTriggerHistories(new Trigger(reloadRequest.getTriggerId(), null)));
                                }
                            }
                            boolean sortByFk = !isFullLoad || !this.parameterService.is("initial.load.defer.create.constraints", false) || reloadRequests == null || reloadRequests.size() <= 0 || !reloadRequests.get(0).isCreateTable();
                            Map<Integer, List<TriggerRouter>> triggerRoutersByHistoryId = triggerRouterService.fillTriggerRoutersByHistIdAndSortHist(sourceNode.getNodeGroupId(), targetNode.getNodeGroupId(), targetNode.getExternalId(), (List<TriggerHistory>)triggerHistories, triggerRouters, sortByFk);
                            if (isFullLoad) {
                                if (!reverse) {
                                    nodeService.setInitialLoadEnabled(transaction, nodeIdRecord, false, true, loadId, createBy);
                                } else {
                                    nodeService.setReverseInitialLoadEnabled(transaction, nodeIdRecord, false, true, loadId, createBy);
                                }
                                this.callReloadListeners(true, targetNode, transactional, transaction, loadId);
                                if (reloadRequests == null || reloadRequests.size() == 0) {
                                    this.insertCreateSchemaScriptPriorToReload(targetNode, nodeIdRecord, loadId, createBy, transactional, transaction);
                                }
                            }
                            Map<String, TableReloadRequest> mapReloadRequests = this.convertReloadListToMap(reloadRequests, triggerRouters, isFullLoad, isChannelLoad);
                            String symNodeSecurityReloadChannel = null;
                            int totalTableCount = 0;
                            try {
                                for (List<TriggerRouter> triggerRouterList : triggerRoutersByHistoryId.values()) {
                                    if (triggerRouterList.size() > 0) {
                                        TriggerRouter tr = triggerRouterList.get(0);
                                        symNodeSecurityReloadChannel = tr.getTrigger().getReloadChannelId();
                                    }
                                    totalTableCount += triggerRouterList.size();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            processInfo.setTotalDataCount(totalTableCount);
                            if (reloadRequests != null && reloadRequests.size() > 0) {
                                this.updateTableReloadStatusTableCount(this.platform.supportsMultiThreadedTransactions() ? null : transaction, loadId, sourceNode.getNodeId(), totalTableCount);
                            }
                            int setupBatchCount = 0;
                            int finalizeBatchCount = 0;
                            setupBatchCount += this.insertSqlEventsPriorToReload(targetNode, nodeIdRecord, loadId, createBy, transactional, transaction, reverse, (List<TriggerHistory>)triggerHistories, triggerRoutersByHistoryId, mapReloadRequests, isFullLoad, symNodeSecurityReloadChannel);
                            int createTableBatchCount = this.insertCreateBatchesForReload(targetNode, loadId, createBy, (List<TriggerHistory>)triggerHistories, triggerRoutersByHistoryId, transactional, transaction, mapReloadRequests);
                            setupBatchCount += createTableBatchCount;
                            if (this.parameterService.is("initial.load.defer.create.constraints", false)) {
                                finalizeBatchCount += createTableBatchCount;
                            }
                            setupBatchCount += this.insertDeleteBatchesForReload(targetNode, loadId, createBy, (List<TriggerHistory>)triggerHistories, triggerRoutersByHistoryId, transactional, transaction, mapReloadRequests);
                            setupBatchCount += this.insertSQLBatchesForReload(targetNode, loadId, createBy, (List<TriggerHistory>)triggerHistories, triggerRoutersByHistoryId, transactional, transaction, mapReloadRequests);
                            if (reloadRequests != null && reloadRequests.size() > 0) {
                                this.updateTableReloadStatusSetupCount(this.platform.supportsMultiThreadedTransactions() ? null : transaction, loadId, sourceNode.getNodeId(), setupBatchCount);
                            }
                            extractRequests = this.insertLoadBatchesForReload(targetNode, loadId, createBy, (List<TriggerHistory>)triggerHistories, triggerRoutersByHistoryId, transactional, transaction, mapReloadRequests, processInfo, null, extractRequests, isFullLoad);
                            finalizeBatchCount += this.insertSqlEventsAfterReload(targetNode, nodeIdRecord, loadId, createBy, transactional, transaction, reverse, (List<TriggerHistory>)triggerHistories, triggerRoutersByHistoryId, mapReloadRequests, isFullLoad, symNodeSecurityReloadChannel);
                            int fileSyncBatches = this.insertFileSyncBatchForReload(targetNode, loadId, createBy, transactional, transaction, mapReloadRequests, isFullLoad, processInfo);
                            if (reloadRequests != null && reloadRequests.size() > 0) {
                                this.updateTableReloadStatusTableCount(this.platform.supportsMultiThreadedTransactions() ? null : transaction, loadId, sourceNode.getNodeId(), totalTableCount + fileSyncBatches);
                            }
                            if (isFullLoad) {
                                this.callReloadListeners(false, targetNode, transactional, transaction, loadId);
                            }
                            this.engine.getStatisticManager().incrementNodesLoaded(1L);
                            if (reloadRequests != null && reloadRequests.size() > 0) {
                                this.updateTableReloadStatusFinalizeCount(this.platform.supportsMultiThreadedTransactions() ? null : transaction, loadId, sourceNode.getNodeId(), finalizeBatchCount);
                                int rowsAffected = transaction.prepareAndExecute(this.getSql("updateProcessedTableReloadRequest"), new Object[]{new Date(), loadId});
                                if (rowsAffected == 0) {
                                    List requests = transaction.query(this.getSql("selectTableReloadRequestsByLoadId"), (ISqlRowMapper)new TableReloadRequestMapper(), new Object[]{loadId}, new int[]{this.symmetricDialect.getSqlTypeForIds()});
                                    if (requests != null && requests.size() > 0 && ((TableReloadRequest)requests.get(0)).isProcessed()) {
                                        throw new InterruptedException("Table reload request appears to be cancelled");
                                    }
                                    throw new SymmetricException(String.format("Failed to update a table_reload_request as processed for loadId '%s' ", loadId), new Object[0]);
                                }
                                this.log.info("Table reload request(s) for load id " + loadId + " have been processed.");
                            }
                            this.update_outgoing_batch_and_extract_request_for_processing(transaction, sourceNode.getNodeId(), targetNode.getNodeId(), loadId);
                            this.checkInterrupted();
                            transaction.commit();
                        }
                        catch (Error ex) {
                            if (transaction != null) {
                                transaction.rollback();
                            }
                            throw ex;
                        }
                        catch (Exception ex) {
                            if (transaction != null) {
                                transaction.rollback();
                            }
                            if (ex instanceof InvalidSqlException) {
                                InvalidSqlException e = (InvalidSqlException)((Object)ex);
                                this.updateTableReloadRequestsError(loadId, sourceNode.getNodeId(), e.getErrorCode(), e.getSQLState(), ExceptionUtils.unwrapMessages((Throwable)ex));
                                this.log.warn("Cancelling load " + loadId, (Throwable)e);
                                this.updateTableReloadRequestsCancelled(loadId, sourceNode.getNodeId());
                            } else {
                                if (ex instanceof RuntimeException) {
                                    throw (RuntimeException)ex;
                                }
                                if (ex instanceof InterruptedException) {
                                    this.log.info("Insert reload events was interrupted: {}", (Object)(ex.getMessage() == null ? "" : ex.getMessage()));
                                }
                            }
                        }
                        finally {
                            this.close(transaction);
                        }
                        if (!reverse && isFullLoad) {
                            this.engine.getPurgeService().purgeAllIncomingEventsForNode(targetNode.getNodeId());
                        }
                        this.engine.getDataExtractorService().releaseMissedExtractRequests();
                        break block52;
                    }
                }
                finally {
                    this.engine.getClusterService().unlock("SyncTriggers");
                }
            }
            this.log.info("Not attempting to insert reload events because sync trigger is currently running");
        }
        return extractRequests;
    }

    private void update_outgoing_batch_and_extract_request_for_processing(ISqlTransaction transaction, String sourceNodeId, String targetNodeId, long loadId) {
        TableReloadStatus status = this.getTableReloadStatusByLoadIdAndSourceNodeId(loadId, sourceNodeId);
        if (status != null) {
            long startDataBatchId = status.getStartDataBatchId();
            long endDataBatchId = status.getEndDataBatchId();
            String reloadUpdateStatus = AbstractBatch.Status.NE.name();
            if (this.parameterService.is("initial.load.use.extract.job.enabled")) {
                reloadUpdateStatus = AbstractBatch.Status.RQ.name();
            }
            this.update_setup_batches(transaction, targetNodeId, loadId, AbstractBatch.Status.LS.name(), AbstractBatch.Status.NE.name(), startDataBatchId);
            this.update_load_batches(transaction, targetNodeId, loadId, AbstractBatch.Status.LS.name(), reloadUpdateStatus, startDataBatchId, endDataBatchId);
            this.update_finalize_batches(transaction, targetNodeId, loadId, AbstractBatch.Status.LS.name(), AbstractBatch.Status.NE.name(), endDataBatchId);
            this.update_extract_requests(transaction, loadId, this.engine.getNodeId(), ExtractRequest.ExtractStatus.LS.name(), ExtractRequest.ExtractStatus.NE.name());
        }
    }

    private void update_setup_batches(ISqlTransaction transaction, String targetNodeId, long loadId, String fromStatus, String toStatus, long maxBatchId) {
        this.engine.getOutgoingBatchService().updateOutgoingSetupBatchStatusByStatus(transaction, targetNodeId, loadId, maxBatchId, fromStatus, toStatus);
    }

    private void update_load_batches(ISqlTransaction transaction, String targetNodeId, long loadId, String fromStatus, String toStatus, long startDataBatchId, long endDataBatchId) {
        this.engine.getOutgoingBatchService().updateOutgoingLoadBatchStatusByStatus(transaction, targetNodeId, loadId, startDataBatchId, endDataBatchId, fromStatus, toStatus);
    }

    private void update_finalize_batches(ISqlTransaction transaction, String targetNodeId, long loadId, String fromStatus, String toStatus, long minBatchId) {
        this.engine.getOutgoingBatchService().updateOutgoingFinalizeBatchStatusByStatus(transaction, targetNodeId, loadId, minBatchId, fromStatus, toStatus);
    }

    private void update_extract_requests(ISqlTransaction transaction, long loadId, String sourceNodeId, String fromStatus, String toStatus) {
        this.engine.getDataExtractorService().updateExtractRequestStatuses(transaction, loadId, sourceNodeId, fromStatus, toStatus);
    }

    private long getBatchCountFor(Map<Integer, ExtractRequest> extractRequests) {
        long batchCount = 0L;
        for (ExtractRequest request : extractRequests.values()) {
            batchCount += request.getEndBatchId() - request.getStartBatchId() + 1L;
        }
        return batchCount;
    }

    private Trigger findTriggerFor(TriggerHistory history, List<TriggerRouter> triggerRouters) {
        for (TriggerRouter triggerRouter : triggerRouters) {
            if (!triggerRouter.getTrigger().getTriggerId().equals(history.getTriggerId())) continue;
            return triggerRouter.getTrigger();
        }
        return null;
    }

    protected Map<String, TableReloadRequest> convertReloadListToMap(List<TableReloadRequest> reloadRequests, List<TriggerRouter> triggerRouters, boolean isFullLoad, boolean isChannelLoad) {
        if (reloadRequests == null) {
            return null;
        }
        CaseInsensitiveMap reloadMap = new CaseInsensitiveMap();
        for (TableReloadRequest reloadRequest : reloadRequests) {
            if (!isFullLoad && !isChannelLoad) {
                this.validate(reloadRequest, triggerRouters);
            }
            reloadMap.put(reloadRequest.getIdentifier(), reloadRequest);
        }
        return reloadMap;
    }

    protected void validate(TableReloadRequest reloadRequest, List<TriggerRouter> triggerRouters) {
        boolean validMatch = false;
        for (TriggerRouter triggerRouter : triggerRouters) {
            if (!Objects.equals(triggerRouter.getTriggerId(), reloadRequest.getTriggerId()) || !Objects.equals(triggerRouter.getRouterId(), reloadRequest.getRouterId())) continue;
            validMatch = true;
            break;
        }
        if (!validMatch) {
            throw new InvalidSqlException("Invalid SQL", (Throwable)new SqlException("Table reload request submitted which does not have a valid trigger/router combination in sym_trigger_router. Request trigger id: '" + reloadRequest.getTriggerId() + "' router id: '" + reloadRequest.getRouterId() + "' create time: " + String.valueOf(reloadRequest.getCreateTime())));
        }
    }

    private void callReloadListeners(boolean before, Node targetNode, boolean transactional, ISqlTransaction transaction, long loadId) {
        for (IReloadListener listener : this.extensionService.getExtensionPointList(IReloadListener.class)) {
            if (before) {
                listener.beforeReload(transaction, targetNode, loadId);
            } else {
                listener.afterReload(transaction, targetNode, loadId);
            }
            if (transactional) continue;
            transaction.commit();
        }
    }

    private void insertCreateSchemaScriptPriorToReload(Node targetNode, String nodeIdRecord, long loadId, String createBy, boolean transactional, ISqlTransaction transaction) {
        String dumpCommand = this.parameterService.getString("initial.load.schema.dump.command");
        String loadCommand = this.parameterService.getString("initial.load.schema.load.command");
        if (StringUtils.isNotBlank((CharSequence)dumpCommand) && StringUtils.isNotBlank((CharSequence)loadCommand)) {
            try {
                this.log.info("Dumping schema using the following dump command: " + dumpCommand);
                ProcessBuilder pb = new ProcessBuilder(FormatUtils.splitOnSpacePreserveQuotedStrings((String)dumpCommand));
                pb.redirectErrorStream(true);
                Process process = pb.start();
                InputStream is = process.getInputStream();
                StringWriter ow = new StringWriter();
                IOUtils.copy((InputStream)is, (Writer)ow, (Charset)Charset.defaultCharset());
                String output = ow.toString();
                output = StringEscapeUtils.escapeEcmaScript((String)output);
                String script = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/load-schema-at-target.bsh"), (Charset)Charset.defaultCharset());
                script = script.replace("${data}", output);
                script = script.replace("${commands}", this.formatCommandForScript(loadCommand));
                if (process.waitFor() != 0) {
                    throw new IoException(output.toString(), new Object[0]);
                }
                this.log.info("Inserting script to load dump at client");
                this.engine.getDataService().insertScriptEvent(transaction, "reload", targetNode, script, true, loadId, "reload listener");
            }
            catch (Exception e) {
                throw new IoException(e);
            }
        }
    }

    private String formatCommandForScript(String command) {
        String[] tokens = FormatUtils.splitOnSpacePreserveQuotedStrings((String)command);
        StringBuilder builder = new StringBuilder();
        for (String string : tokens) {
            builder.append("\"" + StringEscapeUtils.escapeJava((String)string) + "\",");
        }
        return builder.substring(0, builder.length() - 1);
    }

    private int insertSqlEventsPriorToReload(Node targetNode, String nodeIdRecord, long loadId, String createBy, boolean transactional, ISqlTransaction transaction, boolean reverse, List<TriggerHistory> triggerHistories, Map<Integer, List<TriggerRouter>> triggerRoutersByHistoryId, Map<String, TableReloadRequest> reloadRequests, boolean isFullLoad, String channelId) {
        String beforeSql;
        int batchCount = 0;
        if (isFullLoad && !"rest".equals(targetNode.getDeploymentType())) {
            this.insertNodeSecurityUpdate(transaction, nodeIdRecord, targetNode.getNodeId(), true, loadId, createBy, channelId);
            ++batchCount;
            TableReloadRequest t = reloadRequests.get("ALLALL");
            if (t != null && StringUtils.isBlank((CharSequence)t.getReloadSelect())) {
                long curBatchId = this.engine.getSequenceService().currVal(transaction, "outgoing_batch");
                this.insertSqlEvent(transaction, targetNode, String.format("update %s_incoming_batch set status='OK', error_flag=0 where node_id='%s' and status != 'OK' and batch_id < " + curBatchId, this.tablePrefix, this.engine.getNodeService().findIdentityNodeId()), true, loadId, createBy, AbstractBatch.Status.LS);
                ++batchCount;
            }
        }
        if (isFullLoad && StringUtils.isNotBlank((CharSequence)(beforeSql = this.parameterService.getString(reverse ? "initial.load.reverse.before.sql" : "initial.load.before.sql")))) {
            this.insertSqlEvent(transaction, targetNode, beforeSql, true, loadId, createBy, AbstractBatch.Status.LS);
            ++batchCount;
        }
        return batchCount;
    }

    private int insertSqlEventsAfterReload(Node targetNode, String nodeIdRecord, long loadId, String createBy, boolean transactional, ISqlTransaction transaction, boolean reverse, List<TriggerHistory> triggerHistories, Map<Integer, List<TriggerRouter>> triggerRoutersByHistoryId, Map<String, TableReloadRequest> reloadRequests, boolean isFullLoad, String channelId) {
        String afterSql;
        int totalBatchCount = 0;
        if (isFullLoad && StringUtils.isNotBlank((CharSequence)(afterSql = this.parameterService.getString(reverse ? "initial.load.reverse.after.sql" : "initial.load.after.sql")))) {
            this.insertSqlEvent(transaction, targetNode, afterSql, true, loadId, createBy);
            ++totalBatchCount;
        }
        return totalBatchCount;
    }

    private int insertCreateBatchesForReload(Node targetNode, long loadId, String createBy, List<TriggerHistory> triggerHistories, Map<Integer, List<TriggerRouter>> triggerRoutersByHistoryId, boolean transactional, ISqlTransaction transaction, Map<String, TableReloadRequest> reloadRequests) throws InterruptedException {
        int createEventsSent = 0;
        if (reloadRequests != null && reloadRequests.size() > 0) {
            for (TriggerHistory triggerHistory : triggerHistories) {
                List<TriggerRouter> triggerRouters = triggerRoutersByHistoryId.get(triggerHistory.getTriggerHistoryId());
                TableReloadRequest currentRequest = reloadRequests.get("ALLALL");
                boolean fullLoad = currentRequest != null;
                for (TriggerRouter triggerRouter : triggerRouters) {
                    if (!fullLoad) {
                        currentRequest = reloadRequests.get(triggerRouter.getTriggerId() + triggerRouter.getRouterId());
                    }
                    if (triggerRouter.getInitialLoadOrder() > -1 && currentRequest != null && currentRequest.isCreateTable() && this.engine.getGroupletService().isTargetEnabled(triggerRouter, targetNode) && !triggerHistory.getSourceTableNameLowerCase().startsWith(this.symmetricDialect.getTablePrefix().toLowerCase() + "_")) {
                        this.insertCreateEvent(transaction, targetNode, triggerHistory, triggerRouter.getTrigger().getReloadChannelId(), true, loadId, createBy, false, false, false, AbstractBatch.Status.LS);
                        ++createEventsSent;
                        if (!transactional) {
                            transaction.commit();
                        }
                    }
                    this.checkInterrupted();
                }
            }
            if (createEventsSent > 0) {
                this.log.info("Before sending load {} to target node {} create table events were sent for {} tables", new Object[]{loadId, targetNode, createEventsSent});
            }
        } else if (this.parameterService.is("initial.load.create.first")) {
            for (TriggerHistory triggerHistory : triggerHistories) {
                List<TriggerRouter> triggerRouters = triggerRoutersByHistoryId.get(triggerHistory.getTriggerHistoryId());
                for (TriggerRouter triggerRouter : triggerRouters) {
                    if (triggerRouter.getInitialLoadOrder() < 0 || !this.engine.getGroupletService().isTargetEnabled(triggerRouter, targetNode)) continue;
                    this.insertCreateEvent(transaction, targetNode, triggerHistory, triggerRouter.getRouter().getRouterId(), true, loadId, createBy, false, false, false, AbstractBatch.Status.LS);
                    ++createEventsSent;
                    if (!transactional) {
                        transaction.commit();
                    }
                    this.checkInterrupted();
                }
            }
        }
        return createEventsSent;
    }

    private int insertDeleteBatchesForReload(Node targetNode, long loadId, String createBy, List<TriggerHistory> triggerHistories, Map<Integer, List<TriggerRouter>> triggerRoutersByHistoryId, boolean transactional, ISqlTransaction transaction, Map<String, TableReloadRequest> reloadRequests) throws InterruptedException {
        int deleteEventsSent = 0;
        if (reloadRequests != null && reloadRequests.size() > 0) {
            ListIterator<TriggerHistory> triggerHistoryIterator = triggerHistories.listIterator(triggerHistories.size());
            while (triggerHistoryIterator.hasPrevious()) {
                TriggerHistory triggerHistory = triggerHistoryIterator.previous();
                List<TriggerRouter> triggerRouters = triggerRoutersByHistoryId.get(triggerHistory.getTriggerHistoryId());
                TableReloadRequest currentRequest = reloadRequests.get("ALLALL");
                boolean fullLoad = currentRequest != null;
                ListIterator<TriggerRouter> iterator = triggerRouters.listIterator(triggerRouters.size());
                while (iterator.hasPrevious()) {
                    TriggerRouter triggerRouter = iterator.previous();
                    if (!fullLoad) {
                        currentRequest = reloadRequests.get(triggerRouter.getTriggerId() + triggerRouter.getRouterId());
                    }
                    if (triggerRouter.getInitialLoadOrder() > -1 && (currentRequest == null || currentRequest.isDeleteFirst()) && this.engine.getGroupletService().isTargetEnabled(triggerRouter, targetNode)) {
                        this.insertPurgeEvent(transaction, targetNode, triggerRouter, triggerHistory, true, currentRequest.getBeforeCustomSql(), loadId, createBy, AbstractBatch.Status.LS);
                        ++deleteEventsSent;
                        if (!transactional) {
                            transaction.commit();
                        }
                    }
                    this.checkInterrupted();
                }
            }
            if (deleteEventsSent > 0) {
                this.log.info("Before sending load {} to target node {} delete data events were sent for {} tables", new Object[]{loadId, targetNode, deleteEventsSent});
            }
        } else if (this.parameterService.is("initial.load.delete.first")) {
            ListIterator<TriggerHistory> triggerHistoryIterator = triggerHistories.listIterator(triggerHistories.size());
            while (triggerHistoryIterator.hasPrevious()) {
                TriggerHistory triggerHistory = triggerHistoryIterator.previous();
                List<TriggerRouter> triggerRouters = triggerRoutersByHistoryId.get(triggerHistory.getTriggerHistoryId());
                ListIterator<TriggerRouter> iterator = triggerRouters.listIterator(triggerRouters.size());
                while (iterator.hasPrevious()) {
                    TriggerRouter triggerRouter = iterator.previous();
                    if (!(triggerRouter.getInitialLoadOrder() < 0 || !this.engine.getGroupletService().isTargetEnabled(triggerRouter, targetNode) || StringUtils.isBlank((CharSequence)this.parameterService.getString("initial.load.delete.first.sql")) && StringUtils.isEmpty((CharSequence)triggerRouter.getInitialLoadDeleteStmt()))) {
                        this.insertPurgeEvent(transaction, targetNode, triggerRouter, triggerHistory, true, null, loadId, createBy, AbstractBatch.Status.LS);
                        ++deleteEventsSent;
                        if (!transactional) {
                            transaction.commit();
                        }
                    }
                    this.checkInterrupted();
                }
            }
        }
        return deleteEventsSent;
    }

    private int insertSQLBatchesForReload(Node targetNode, long loadId, String createBy, List<TriggerHistory> triggerHistories, Map<Integer, List<TriggerRouter>> triggerRoutersByHistoryId, boolean transactional, ISqlTransaction transaction, Map<String, TableReloadRequest> reloadRequests) throws InterruptedException {
        int sqlEventsSent = 0;
        if (reloadRequests != null && reloadRequests.size() > 0) {
            ArrayList<TriggerHistory> copyTriggerHistories = new ArrayList<TriggerHistory>(triggerHistories);
            Collections.reverse(copyTriggerHistories);
            for (TriggerHistory triggerHistory : copyTriggerHistories) {
                List<TriggerRouter> triggerRouters = triggerRoutersByHistoryId.get(triggerHistory.getTriggerHistoryId());
                TableReloadRequest currentRequest = reloadRequests.get("ALLALL");
                boolean fullLoad = currentRequest != null;
                for (TriggerRouter triggerRouter : triggerRouters) {
                    if (!fullLoad) {
                        currentRequest = reloadRequests.get(triggerRouter.getTriggerId() + triggerRouter.getRouterId());
                    }
                    if (triggerRouter.getInitialLoadOrder() > -1 && currentRequest != null && currentRequest.getBeforeCustomSql() != null && currentRequest.getBeforeCustomSql().length() > 0 && this.engine.getGroupletService().isTargetEnabled(triggerRouter, targetNode)) {
                        List<String> sqlStatements = this.resolveTargetTables(currentRequest.getBeforeCustomSql(), triggerRouter, triggerHistory, targetNode);
                        for (String sql : sqlStatements) {
                            this.insertSqlEvent(transaction, triggerHistory, triggerRouter.getTrigger().getChannelId(), targetNode, sql, true, loadId, createBy, AbstractBatch.Status.LS);
                            ++sqlEventsSent;
                        }
                        if (!transactional) {
                            transaction.commit();
                        }
                    }
                    this.checkInterrupted();
                }
            }
            if (sqlEventsSent > 0) {
                this.log.info("Before sending load {} to target node {} SQL data events were sent for {} tables", new Object[]{loadId, targetNode, sqlEventsSent});
            }
        }
        return sqlEventsSent;
    }

    private Map<Integer, ExtractRequest> insertLoadBatchesForReload(Node targetNode, long loadId, String createBy, List<TriggerHistory> triggerHistories, Map<Integer, List<TriggerRouter>> triggerRoutersByHistoryId, boolean transactional, ISqlTransaction transaction, Map<String, TableReloadRequest> reloadRequests, ProcessInfo processInfo, String selectSqlOverride, Map<Integer, ExtractRequest> extractRequests, boolean isFullLoad) throws InterruptedException {
        Map<String, Channel> channels = this.engine.getConfigurationService().getChannels(false);
        HashMap<Integer, ExtractRequest> requests = new HashMap<Integer, ExtractRequest>();
        if (extractRequests != null) {
            requests.putAll(extractRequests);
        }
        boolean canEngineBulkOperation = this.engine.getParameterService().is("mssql.bulk.extract.use.bcp") && this.engine.getSymmetricDialect().getTargetPlatform().getName().startsWith("mssql") || this.engine.getParameterService().is("ase.bulk.extract.use.bcp") && this.engine.getSymmetricDialect().getTargetPlatform().getName().startsWith("ase");
        boolean canBulkOperation = canEngineBulkOperation && this.isLocalNodeUsingBulkLoad(targetNode.getNodeId());
        boolean canParentBulkOperation = true;
        if (extractRequests != null && extractRequests.size() > 0) {
            canParentBulkOperation = canEngineBulkOperation && this.isLocalNodeUsingBulkLoad(extractRequests.values().iterator().next().getNodeId());
        }
        boolean shouldAbandonParent = canParentBulkOperation && !canBulkOperation;
        String sourceNodeId = this.engine.getNodeService().findIdentity().getNodeId();
        String tablePrefix = this.engine.getParameterService().getTablePrefix().toLowerCase();
        long firstBatchId = 0L;
        long totalDataCount = 0L;
        for (TriggerHistory triggerHist : triggerHistories) {
            if (triggerHist.getTriggerId().startsWith(tablePrefix)) continue;
            ++totalDataCount;
        }
        processInfo.setTotalDataCount(totalDataCount);
        for (TriggerHistory triggerHistory : triggerHistories) {
            if (!triggerHistory.getSourceTableNameLowerCase().startsWith(tablePrefix)) {
                processInfo.incrementCurrentDataCount();
            }
            List<TriggerRouter> triggerRouters = triggerRoutersByHistoryId.get(triggerHistory.getTriggerHistoryId());
            this.checkInterrupted();
            for (TriggerRouter triggerRouter : triggerRouters) {
                Table table;
                if (triggerRouter.getInitialLoadOrder() < 0 || !this.engine.getGroupletService().isTargetEnabled(triggerRouter, targetNode)) continue;
                String selectSql = selectSqlOverride;
                if (StringUtils.isEmpty((CharSequence)selectSql)) {
                    if (reloadRequests != null) {
                        if (isFullLoad && reloadRequests.size() == 1) {
                            reloadRequest = reloadRequests.values().stream().findFirst().get();
                            selectSql = reloadRequest != null ? reloadRequest.getReloadSelect() : null;
                        } else {
                            reloadRequest = reloadRequests.get(triggerRouter.getTriggerId() + triggerRouter.getRouterId());
                            String string = selectSql = reloadRequest != null ? reloadRequest.getReloadSelect() : null;
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)selectSql)) {
                        String string = selectSql = StringUtils.isBlank((CharSequence)triggerRouter.getInitialLoadSelect()) ? "1=1" : triggerRouter.getInitialLoadSelect();
                    }
                }
                if ((table = this.getTargetPlatform(triggerHistory.getSourceTableName()).getTableFromCache(triggerHistory.getSourceCatalogName(), triggerHistory.getSourceSchemaName(), triggerHistory.getSourceTableName(), false)) != null) {
                    Router router;
                    processInfo.setCurrentTableName(table.getName());
                    Trigger trigger = triggerRouter.getTrigger();
                    String reloadChannel = this.getReloadChannelIdForTrigger(trigger, channels);
                    Channel channel = channels.get(reloadChannel);
                    long rowCount = -1L;
                    long parentRequestId = 0L;
                    ExtractRequest parentRequest = (ExtractRequest)requests.get(triggerHistory.getTriggerHistoryId());
                    if (parentRequest != null && !shouldAbandonParent && (router = this.engine.getTriggerRouterService().getRouterById(triggerRouter.getRouterId(), false)) != null && router.getRouterType().equals("default")) {
                        parentRequestId = parentRequest.getRequestId();
                        rowCount = parentRequest.getRows();
                    }
                    if (rowCount == -1L) {
                        rowCount = this.getDataCountForReload(table, targetNode, selectSql, loadId);
                    }
                    long transformMultiplier = this.getTransformMultiplier(table, triggerRouter);
                    long startBatchId = 0L;
                    long numberOfBatches = 1L;
                    if (this.parameterService.is("initial.load.use.extract.job.enabled")) {
                        if (rowCount > 0L) {
                            processInfo.setCurrentRowCount(processInfo.getCurrentRowCount() + rowCount);
                            numberOfBatches = (long)Math.ceil((float)(rowCount * transformMultiplier) / ((float)channel.getMaxBatchSize() * 1.0f));
                            processInfo.setCurrentBatchCount(processInfo.getCurrentBatchCount() + numberOfBatches);
                        }
                        long maxBatchSize = channel.getMaxBatchSize();
                        if (canBulkOperation && canParentBulkOperation && channel.getDataLoaderType().equals("bulk")) {
                            numberOfBatches = 1L;
                            maxBatchSize = rowCount;
                        }
                        startBatchId = this.insertRequestedOutgoingBatches(transaction, targetNode, triggerRouter, triggerHistory, selectSql, loadId, createBy, reloadChannel, rowCount, maxBatchSize, numberOfBatches);
                    } else {
                        startBatchId = this.insertReloadEvent(transaction, targetNode, triggerRouter, triggerHistory, selectSql, true, loadId, createBy, AbstractBatch.Status.LS, null, -1L);
                    }
                    long endBatchId = startBatchId + numberOfBatches - 1L;
                    long l = firstBatchId = firstBatchId == 0L ? startBatchId : firstBatchId;
                    if (table.getNameLowerCase().startsWith(this.symmetricDialect.getTablePrefix() + "_file_snapshot")) {
                        TableReloadStatus reloadStatus = this.getTableReloadStatusByLoadIdAndSourceNodeId(loadId, sourceNodeId);
                        firstBatchId = reloadStatus.getStartDataBatchId() > 0L ? reloadStatus.getStartDataBatchId() : firstBatchId;
                    }
                    this.updateTableReloadStatusDataCounts(this.platform.supportsMultiThreadedTransactions() ? null : transaction, loadId, sourceNodeId, firstBatchId, endBatchId, numberOfBatches, rowCount);
                    ExtractRequest request = this.engine.getDataExtractorService().requestExtractRequest(transaction, targetNode.getNodeId(), channel.getQueue(), triggerRouter, startBatchId, endBatchId, loadId, table.getName(), rowCount, parentRequestId);
                    if (parentRequest == null) {
                        requests.put(triggerHistory.getTriggerHistoryId(), request);
                    }
                } else {
                    this.log.warn("The table defined by trigger_hist row {} no longer exists.  A load will not be queue'd up for the table", (Object)triggerHistory.getTriggerHistoryId());
                }
                if (transactional) continue;
                transaction.commit();
            }
        }
        if (firstBatchId == 0L) {
            long startBatchId = 0L;
            startBatchId = this.platform.supportsMultiThreadedTransactions() ? this.engine.getSequenceService().nextRange("outgoing_batch", 1L) : this.engine.getSequenceService().nextRange(transaction, "outgoing_batch", 1L);
            this.updateTableReloadStatusDataCounts(this.platform.supportsMultiThreadedTransactions() ? null : transaction, loadId, sourceNodeId, startBatchId, startBatchId, 0L, 0L);
        }
        return requests;
    }

    protected long getDataCountForReload(Table table, Node targetNode, String selectSql, long loadId) throws SqlException {
        long rowCount = -1L;
        if (this.parameterService.is("initial.load.use.estimated.counts") && (selectSql == null || StringUtils.isBlank((CharSequence)selectSql) || selectSql.replace(" ", "").equals("1=1"))) {
            rowCount = this.getTargetPlatform().getEstimatedRowCount(table);
        }
        if (rowCount < 0L) {
            DatabaseInfo dbInfo = this.getTargetPlatform().getDatabaseInfo();
            String quote = dbInfo.getDelimiterToken();
            String catalogSeparator = dbInfo.getCatalogSeparator();
            String schemaSeparator = dbInfo.getSchemaSeparator();
            if (selectSql != null && selectSql.trim().toUpperCase().startsWith("WHERE")) {
                selectSql = selectSql.trim().substring(5);
            }
            String sql = String.format("select count(*) from %s t where %s", table.getQualifiedTableName(quote, catalogSeparator, schemaSeparator), selectSql);
            sql = FormatUtils.replace((String)"groupId", (String)targetNode.getNodeGroupId(), (String)sql);
            sql = FormatUtils.replace((String)"externalId", (String)targetNode.getExternalId(), (String)sql);
            sql = FormatUtils.replace((String)"nodeId", (String)targetNode.getNodeId(), (String)sql);
            for (IReloadVariableFilter filter : this.extensionService.getExtensionPointList(IReloadVariableFilter.class)) {
                sql = filter.filterPurgeSql(sql, targetNode, table);
            }
            try {
                rowCount = this.getTargetPlatform().getSqlTemplateDirty().queryForLong(sql, new Object[0]);
            }
            catch (SqlException ex) {
                throw new InvalidSqlException("Failed to execute row count SQL for load ID " + loadId + " with: " + sql, (Throwable)ex);
            }
        }
        return rowCount;
    }

    protected int getTransformMultiplier(Table table, TriggerRouter triggerRouter) {
        int transformMultiplier = 0;
        List<TransformService.TransformTableNodeGroupLink> transforms = this.engine.getTransformService().findTransformsFor(triggerRouter.getRouter().getNodeGroupLink(), TransformPoint.EXTRACT);
        if (transforms != null) {
            for (TransformService.TransformTableNodeGroupLink transform : transforms) {
                if (!transform.getSourceTableName().equals(table.getName())) continue;
                ++transformMultiplier;
            }
        }
        transformMultiplier = Math.max(1, transformMultiplier);
        return transformMultiplier;
    }

    protected boolean isLocalNodeUsingBulkLoad(String nodeId) {
        ISymmetricEngine targetEngine = AbstractSymmetricEngine.findEngineByNodeId(nodeId);
        boolean isTargetUsingBulkLoad = targetEngine != null && (targetEngine.getParameterService().is("mssql.bulk.load.use.bcp") && targetEngine.getSymmetricDialect().getTargetPlatform().getName().startsWith("mssql") || targetEngine.getSymmetricDialect().getTargetPlatform().getName().startsWith("ase"));
        return isTargetUsingBulkLoad;
    }

    private int insertFileSyncBatchForReload(Node targetNode, long loadId, String createBy, boolean transactional, ISqlTransaction transaction, Map<String, TableReloadRequest> reloadRequests, boolean isFullLoad, ProcessInfo processInfo) throws InterruptedException {
        int totalBatchCount = 0;
        if (this.parameterService.is("file.sync.enable") && !"rest".equals(targetNode.getDeploymentType())) {
            ITriggerRouterService triggerRouterService = this.engine.getTriggerRouterService();
            IFileSyncService fileSyncService = this.engine.getFileSyncService();
            if (fileSyncService.getFileTriggerRoutersForCurrentNode(false).size() > 0) {
                String fileSnapshotTableName = TableConstants.getTableName(this.tablePrefix, "file_snapshot");
                TriggerHistory fileSyncSnapshotHistory = triggerRouterService.findTriggerHistory(null, null, fileSnapshotTableName);
                if (fileSyncSnapshotHistory == null) {
                    if (isFullLoad || reloadRequests == null || this.isReloadRequestForFileChannel(reloadRequests)) {
                        this.log.warn("Did not include file sync batches in load {} for target node {} because there is no valid trigger history for {}", new Object[]{loadId, targetNode, fileSnapshotTableName});
                    } else {
                        this.log.warn("Could not determine whether to include file sync batches in load {} for target node {} because there is no valid trigger history for {}", new Object[]{loadId, targetNode, fileSnapshotTableName});
                    }
                    return totalBatchCount;
                }
                String routerid = triggerRouterService.buildSymmetricTableRouterId(fileSyncSnapshotHistory.getTriggerId(), this.parameterService.getNodeGroupId(), targetNode.getNodeGroupId());
                TriggerRouter fileSyncSnapshotTriggerRouter = triggerRouterService.getTriggerRouterForCurrentNode(fileSyncSnapshotHistory.getTriggerId(), routerid, true);
                if (!isFullLoad && reloadRequests != null && reloadRequests.get(fileSyncSnapshotTriggerRouter.getTriggerId() + fileSyncSnapshotTriggerRouter.getRouterId()) == null && !this.isReloadRequestForFileChannel(reloadRequests)) {
                    return totalBatchCount;
                }
                List<TriggerHistory> triggerHistories = Collections.singletonList(fileSyncSnapshotHistory);
                List<TriggerRouter> triggerRouters = Collections.singletonList(fileSyncSnapshotTriggerRouter);
                HashMap<Integer, List<TriggerRouter>> triggerRoutersByHistoryId = new HashMap<Integer, List<TriggerRouter>>();
                triggerRoutersByHistoryId.put(fileSyncSnapshotHistory.getTriggerHistoryId(), triggerRouters);
                Object overrideSql = fileSyncSnapshotTriggerRouter.getInitialLoadSelect();
                if (this.parameterService.is("initial.load.use.extract.job.enabled")) {
                    String FILTER_ENABLED_FILE_SYNC_TRIGGER_ROUTERS = String.format("1=(select initial_load_enabled from %s tr where t.trigger_id = tr.trigger_id AND t.router_id = tr.router_id)", TableConstants.getTableName(this.tablePrefix, "file_trigger_router"));
                    overrideSql = StringUtils.isNotBlank((CharSequence)overrideSql) ? FILTER_ENABLED_FILE_SYNC_TRIGGER_ROUTERS + " AND " + (String)overrideSql : FILTER_ENABLED_FILE_SYNC_TRIGGER_ROUTERS;
                    totalBatchCount = (int)((long)totalBatchCount + this.getBatchCountFor(this.insertLoadBatchesForReload(targetNode, loadId, createBy, triggerHistories, triggerRoutersByHistoryId, transactional, transaction, null, processInfo, (String)overrideSql, null, isFullLoad)));
                } else {
                    List<Channel> channels = this.engine.getConfigurationService().getFileSyncChannels();
                    for (Channel channel : channels) {
                        String initialSql;
                        if (!channel.isReloadFlag()) continue;
                        String sql = initialSql = "reload_channel_id='" + channel.getChannelId() + "'";
                        if (StringUtils.isNotBlank((CharSequence)overrideSql)) {
                            sql = sql + " AND " + (String)overrideSql;
                        }
                        this.insertReloadEvent(transaction, targetNode, fileSyncSnapshotTriggerRouter, fileSyncSnapshotHistory, sql, true, loadId, createBy, AbstractBatch.Status.NE, channel.getChannelId(), -1L);
                        ++totalBatchCount;
                        if (transactional) continue;
                        transaction.commit();
                    }
                }
            }
        }
        return totalBatchCount;
    }

    private boolean isReloadRequestForFileChannel(Map<String, TableReloadRequest> reloadRequests) {
        for (TableReloadRequest reloadRequest : reloadRequests.values()) {
            if (reloadRequest.getChannelId() == null || !this.engine.getConfigurationService().getChannel(reloadRequest.getChannelId()).isFileSyncFlag()) continue;
            return true;
        }
        return false;
    }

    private TriggerHistory lookupTriggerHistory(Trigger trigger) {
        TriggerHistory history = this.engine.getTriggerRouterService().getNewestTriggerHistoryForTrigger(trigger.getTriggerId(), trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName());
        if (history == null) {
            this.engine.getTriggerRouterService().syncTriggers();
            history = this.engine.getTriggerRouterService().getNewestTriggerHistoryForTrigger(trigger.getTriggerId(), null, null, null);
        }
        if (history == null) {
            throw new RuntimeException("Cannot find history for trigger " + trigger.getTriggerId() + ", " + trigger.getSourceTableName());
        }
        return history;
    }

    protected void insertPurgeEvent(ISqlTransaction transaction, Node targetNode, TriggerRouter triggerRouter, TriggerHistory triggerHistory, boolean isLoad, String overrideDeleteStatement, long loadId, String createBy) {
        this.insertPurgeEvent(transaction, targetNode, triggerRouter, triggerHistory, isLoad, overrideDeleteStatement, loadId, createBy, AbstractBatch.Status.NE);
    }

    protected void insertPurgeEvent(ISqlTransaction transaction, Node targetNode, TriggerRouter triggerRouter, TriggerHistory triggerHistory, boolean isLoad, String overrideDeleteStatement, long loadId, String createBy, AbstractBatch.Status outgoingBatchStatus) {
        Node sourceNode = this.engine.getNodeService().findIdentity();
        List<TransformService.TransformTableNodeGroupLink> transforms = this.engine.getTransformService().findTransformsFor(sourceNode.getNodeGroupId(), targetNode.getNodeGroupId(), triggerRouter.getTargetTable(triggerHistory));
        if (StringUtils.isNotBlank((CharSequence)overrideDeleteStatement)) {
            List<String> sqlStatements = this.resolveTargetTables(overrideDeleteStatement, triggerRouter, triggerHistory, targetNode);
            for (String sql : sqlStatements) {
                this.createPurgeEvent(transaction, sql, targetNode, sourceNode, triggerRouter, triggerHistory, isLoad, loadId, createBy, outgoingBatchStatus);
            }
        } else if (transforms != null && transforms.size() > 0) {
            List<String> sqlStatements = this.symmetricDialect.createPurgeSqlForMultipleTables(targetNode, triggerRouter, triggerHistory, transforms, null);
            for (String sql : sqlStatements) {
                this.createPurgeEvent(transaction, sql, targetNode, sourceNode, triggerRouter, triggerHistory, isLoad, loadId, createBy, outgoingBatchStatus);
            }
        } else {
            this.createPurgeEvent(transaction, this.symmetricDialect.createPurgeSqlFor(targetNode, triggerRouter, triggerHistory, transforms), targetNode, sourceNode, triggerRouter, triggerHistory, isLoad, loadId, createBy, outgoingBatchStatus);
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<String> resolveTargetTables(String sql, TriggerRouter triggerRouter, TriggerHistory triggerHistory, Node targetNode) {
        if (sql == null) {
            return null;
        }
        ArrayList<String> sqlStatements = new ArrayList<String>();
        if (sql != null && sql.contains("%s")) {
            HashSet<String> tableNames = new HashSet<String>();
            Node sourceNode = this.engine.getNodeService().findIdentity();
            String sourceTableName = triggerRouter.qualifiedTargetTableName(triggerHistory);
            List<TransformService.TransformTableNodeGroupLink> transforms = this.engine.getTransformService().findTransformsFor(sourceNode.getNodeGroupId(), targetNode.getNodeGroupId(), triggerRouter.getTargetTable(triggerHistory));
            if (transforms != null) {
                for (TransformService.TransformTableNodeGroupLink transformTableNodeGroupLink : transforms) {
                    tableNames.add(transformTableNodeGroupLink.getFullyQualifiedTargetTableName());
                }
            } else {
                tableNames.add(sourceTableName);
            }
            for (String string : tableNames) {
                void var11_16;
                if (this.parameterService.is("db.delimited.identifier.mode")) {
                    String delimiter = this.engine.getTargetDialect().getTargetPlatform().getDatabaseInfo().getDelimiterToken();
                    String string3 = string.replaceAll("\\.", delimiter + "." + delimiter);
                    string3 = delimiter + string3 + delimiter;
                }
                sqlStatements.add(String.format(sql, var11_16));
            }
        } else {
            sqlStatements.add(sql);
        }
        return sqlStatements;
    }

    protected void createPurgeEvent(ISqlTransaction transaction, String sql, Node targetNode, Node sourceNode, TriggerRouter triggerRouter, TriggerHistory triggerHistory, boolean isLoad, long loadId, String createBy) {
        this.createPurgeEvent(transaction, sql, targetNode, sourceNode, triggerRouter, triggerHistory, isLoad, loadId, createBy, AbstractBatch.Status.NE);
    }

    protected void createPurgeEvent(ISqlTransaction transaction, String sql, Node targetNode, Node sourceNode, TriggerRouter triggerRouter, TriggerHistory triggerHistory, boolean isLoad, long loadId, String createBy, AbstractBatch.Status outgoingBatchStatus) {
        sql = FormatUtils.replace((String)"groupId", (String)targetNode.getNodeGroupId(), (String)sql);
        sql = FormatUtils.replace((String)"externalId", (String)targetNode.getExternalId(), (String)sql);
        sql = FormatUtils.replace((String)"nodeId", (String)targetNode.getNodeId(), (String)sql);
        sql = FormatUtils.replace((String)"targetGroupId", (String)targetNode.getNodeGroupId(), (String)sql);
        sql = FormatUtils.replace((String)"targetExternalId", (String)targetNode.getExternalId(), (String)sql);
        sql = FormatUtils.replace((String)"targetNodeId", (String)targetNode.getNodeId(), (String)sql);
        sql = FormatUtils.replace((String)"sourceGroupId", (String)sourceNode.getNodeGroupId(), (String)sql);
        sql = FormatUtils.replace((String)"sourceExternalId", (String)sourceNode.getExternalId(), (String)sql);
        sql = FormatUtils.replace((String)"sourceNodeId", (String)sourceNode.getNodeId(), (String)sql);
        Table table = new Table(triggerHistory.getSourceCatalogName(), triggerHistory.getSourceSchemaName(), triggerHistory.getSourceTableName(), triggerHistory.getParsedColumnNames(), triggerHistory.getParsedPkColumnNames());
        for (IReloadVariableFilter filter : this.extensionService.getExtensionPointList(IReloadVariableFilter.class)) {
            sql = filter.filterPurgeSql(sql, targetNode, table);
        }
        String channelId = this.getReloadChannelIdForTrigger(triggerRouter.getTrigger(), this.engine.getConfigurationService().getChannels(false));
        Data data = new Data(triggerHistory.getSourceTableName(), DataEventType.SQL, CsvUtils.escapeCsvData((String)sql), null, triggerHistory, channelId, null, null);
        data.setNodeList(targetNode.getNodeId());
        if (isLoad) {
            this.insertDataAndDataEventAndOutgoingBatch(transaction, data, targetNode.getNodeId(), isLoad, loadId, createBy, outgoingBatchStatus, null, -1L);
        } else {
            this.insertData(transaction, data);
        }
    }

    @Override
    public void insertSqlEvent(Node targetNode, String sql, boolean isLoad, long loadId, String createBy) {
        TriggerHistory history = this.engine.getTriggerRouterService().findTriggerHistoryForGenericSync();
        Trigger trigger = this.engine.getTriggerRouterService().getTriggerById(history.getTriggerId(), false);
        String reloadChannelId = this.getReloadChannelIdForTrigger(trigger, this.engine.getConfigurationService().getChannels(false));
        Data data = new Data(history.getSourceTableName(), DataEventType.SQL, CsvUtils.escapeCsvData((String)sql), null, history, isLoad ? reloadChannelId : "config", null, null);
        data.setNodeList(targetNode.getNodeId());
        if (isLoad) {
            this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), isLoad, loadId, createBy);
        } else {
            this.insertData(data);
        }
    }

    @Override
    public void insertSqlEvent(ISqlTransaction transaction, Node targetNode, String sql, boolean isLoad, long loadId, String createBy) {
        this.insertSqlEvent(transaction, targetNode, sql, isLoad, loadId, createBy, AbstractBatch.Status.NE);
    }

    public void insertSqlEvent(ISqlTransaction transaction, Node targetNode, String sql, boolean isLoad, long loadId, String createBy, AbstractBatch.Status outgoingBatchStatus) {
        TriggerHistory history = this.engine.getTriggerRouterService().findTriggerHistoryForGenericSync();
        this.insertSqlEvent(transaction, history, "config", targetNode, sql, isLoad, loadId, createBy, outgoingBatchStatus);
    }

    @Override
    public void insertSqlEvent(ISqlTransaction transaction, TriggerHistory history, String channelId, Node targetNode, String sql, boolean isLoad, long loadId, String createBy) {
        this.insertSqlEvent(transaction, history, channelId, targetNode, sql, isLoad, loadId, createBy, AbstractBatch.Status.NE);
    }

    public void insertSqlEvent(ISqlTransaction transaction, TriggerHistory history, String channelId, Node targetNode, String sql, boolean isLoad, long loadId, String createBy, AbstractBatch.Status outgoingBatchStatus) {
        Trigger trigger = this.engine.getTriggerRouterService().getTriggerById(history.getTriggerId(), false);
        String reloadChannelId = this.getReloadChannelIdForTrigger(trigger, this.engine.getConfigurationService().getChannels(false));
        Data data = new Data(history.getSourceTableName(), DataEventType.SQL, CsvUtils.escapeCsvData((String)sql), null, history, isLoad ? reloadChannelId : channelId, null, null);
        data.setNodeList(targetNode.getNodeId());
        if (isLoad) {
            this.insertDataAndDataEventAndOutgoingBatch(transaction, data, targetNode.getNodeId(), isLoad, loadId, createBy, outgoingBatchStatus, null, -1L);
        } else {
            this.insertData(transaction, data);
        }
    }

    @Override
    public void insertScriptEvent(String channelId, Node targetNode, String script, boolean isLoad, long loadId, String createBy) {
        try (ISqlTransaction transaction = null;){
            transaction = this.platform.getSqlTemplate().startSqlTransaction();
            this.insertScriptEvent(transaction, channelId, targetNode, script, isLoad, loadId, createBy);
            transaction.commit();
        }
    }

    @Override
    public void insertScriptEvent(ISqlTransaction transaction, String channelId, Node targetNode, String script, boolean isLoad, long loadId, String createBy) {
        TriggerHistory history = this.engine.getTriggerRouterService().findTriggerHistoryForGenericSync();
        Trigger trigger = this.engine.getTriggerRouterService().getTriggerById(history.getTriggerId(), false);
        String reloadChannelId = this.getReloadChannelIdForTrigger(trigger, this.engine.getConfigurationService().getChannels(false));
        Data data = new Data(history.getSourceTableName(), DataEventType.BSH, CsvUtils.escapeCsvData((String)script), null, history, isLoad ? reloadChannelId : channelId, null, null);
        data.setNodeList(targetNode.getNodeId());
        if (isLoad) {
            this.insertDataAndDataEventAndOutgoingBatch(transaction, data, targetNode.getNodeId(), isLoad, loadId, createBy, AbstractBatch.Status.NE, null, -1L);
        } else {
            this.insertData(transaction, data);
        }
    }

    @Override
    public int countDataInRange(long firstDataId, long secondDataId) {
        return this.sqlTemplate.queryForInt(this.getSql("countDataInRangeSql"), new Object[]{firstDataId, secondDataId});
    }

    @Override
    public int countData() {
        return this.sqlTemplate.queryForInt(this.getSql("countDataSql"), new Object[0]);
    }

    @Override
    public void insertCreateEvent(Node targetNode, TriggerHistory triggerHistory, boolean isLoad, long loadId, String createBy, boolean excludeIndices, boolean excludeForeignKeys, boolean excludeDefaults) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            this.insertCreateEvent(transaction, targetNode, triggerHistory, isLoad, loadId, createBy, excludeIndices, excludeForeignKeys, excludeDefaults);
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public void insertCreateEvent(Node targetNode, TriggerHistory triggerHistory, String createBy, boolean excludeIndices, boolean excludeForeignKeys, boolean excludeDefaults) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            Trigger trigger = this.engine.getTriggerRouterService().getTriggerById(triggerHistory.getTriggerId(), false);
            this.insertCreateEvent(transaction, targetNode, triggerHistory, trigger.getChannelId(), false, -1L, createBy, excludeIndices, excludeForeignKeys, excludeDefaults);
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    protected void insertCreateEvent(ISqlTransaction transaction, Node targetNode, TriggerHistory triggerHistory, boolean isLoad, long loadId, String createBy, boolean excludeIndices, boolean excludeForeignKeys, boolean excludeDefaults) {
        Trigger trigger = this.engine.getTriggerRouterService().getTriggerById(triggerHistory.getTriggerId(), false);
        String reloadChannelId = this.getReloadChannelIdForTrigger(trigger, this.engine.getConfigurationService().getChannels(false));
        this.insertCreateEvent(transaction, targetNode, triggerHistory, isLoad ? reloadChannelId : "config", isLoad, loadId, createBy, excludeIndices, excludeForeignKeys, excludeDefaults);
    }

    @Override
    public void insertCreateEvent(ISqlTransaction transaction, Node targetNode, TriggerHistory triggerHistory, String channelId, boolean isLoad, long loadId, String createBy, boolean excludeIndices, boolean excludeForeignKeys, boolean excludeDefaults) {
        this.insertCreateEvent(transaction, targetNode, triggerHistory, channelId, isLoad, loadId, createBy, excludeIndices, excludeForeignKeys, excludeDefaults, AbstractBatch.Status.NE);
    }

    public void insertCreateEvent(ISqlTransaction transaction, Node targetNode, TriggerHistory triggerHistory, String channelId, boolean isLoad, long loadId, String createBy, boolean excludeIndices, boolean excludeForeignKeys, boolean excludeDefaults, AbstractBatch.Status outgoingBatchStatus) {
        Data data = new Data(triggerHistory.getSourceTableName(), DataEventType.CREATE, null, null, triggerHistory, channelId, null, null);
        data.setNodeList(targetNode.getNodeId());
        data.setOldData(this.getOptionsForExclusions(excludeIndices, excludeForeignKeys, excludeDefaults));
        try {
            if (isLoad) {
                this.insertDataAndDataEventAndOutgoingBatch(transaction, data, targetNode.getNodeId(), isLoad, loadId, createBy, outgoingBatchStatus, null, -1L);
            } else {
                this.insertData(transaction, data);
            }
        }
        catch (UniqueKeyException e) {
            if (e.getRootCause() != null && e.getRootCause() instanceof DataTruncation) {
                this.log.error("Table data definition XML was too large and failed.  The feature to send table creates during the initial load may be limited on your platform.  You may need to set the initial.load.create.first parameter to false.");
            }
            throw e;
        }
    }

    @Override
    public Set<TriggerHistory> insertCreateEventsForOutgoingBatchInError(OutgoingBatch batch, String createBy) {
        HashSet<TriggerHistory> triggerHistorySet = new HashSet<TriggerHistory>();
        if (batch.isLoadFlag()) {
            triggerHistorySet.addAll(this.getTriggerHistoriesForOutgoingLoadBatchInError(batch));
        } else if (batch.getFailedDataId() > 0L) {
            CollectionUtils.addIgnoreNull(triggerHistorySet, (Object)this.getTriggerHistoryForOutgoingCdcBatchInError(batch));
        }
        String targetNodeId = batch.getNodeId();
        Node targetNode = new Node(targetNodeId, null);
        for (TriggerHistory triggerHistory : triggerHistorySet) {
            this.insertCreateEvent(targetNode, triggerHistory, false, -1L, createBy, false, false, false);
        }
        return triggerHistorySet;
    }

    protected Set<TriggerHistory> getTriggerHistoriesForOutgoingLoadBatchInError(OutgoingBatch batch) {
        HashSet<TriggerHistory> triggerHistorySet = new HashSet<TriggerHistory>();
        ITriggerRouterService triggerRouterService = this.engine.getTriggerRouterService();
        long batchId = batch.getBatchId();
        for (ExtractRequest extractRequest : this.engine.getDataExtractorService().getTablesForExtractByLoadIdAndNodeId(batch.getLoadId(), batch.getNodeId())) {
            if (batchId < extractRequest.getStartBatchId() || batchId > extractRequest.getEndBatchId()) continue;
            Trigger trigger = new Trigger(extractRequest.getTriggerId(), null);
            String tableName = extractRequest.getTableName();
            for (TriggerHistory triggerHistory : triggerRouterService.getActiveTriggerHistories(trigger)) {
                if (!triggerHistory.getSourceTableName().equalsIgnoreCase(tableName)) continue;
                triggerHistorySet.add(triggerHistory);
            }
        }
        return triggerHistorySet;
    }

    protected TriggerHistory getTriggerHistoryForOutgoingCdcBatchInError(OutgoingBatch batch) {
        Data data = this.findData(batch.getFailedDataId());
        if (data != null) {
            return data.getTriggerHistory();
        }
        return null;
    }

    private String getOptionsForExclusions(boolean excludeIndices, boolean excludeForeignKeys, boolean excludeDefaults) {
        StringBuilder sb = new StringBuilder();
        if (excludeIndices) {
            sb.append("excludeIndices");
        }
        if (excludeForeignKeys) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("excludeForeignKeys");
        }
        if (excludeDefaults) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("excludeDefaults");
        }
        return sb.toString();
    }

    @Override
    public long insertData(Data data) {
        ISqlTransaction transaction = null;
        long dataId = -1L;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            dataId = this.insertData(transaction, data);
            transaction.commit();
            long l = dataId;
            return l;
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public long insertData(ISqlTransaction transaction, Data data) {
        String sql = this.getSql("insertIntoDataSql");
        Object[] args = new Object[]{data.getTableName(), data.getDataEventType().getCode(), data.getRowData(), data.getPkData(), data.getOldData(), data.getTriggerHistory() != null ? data.getTriggerHistory().getTriggerHistoryId() : -1, data.getChannelId(), data.getExternalData(), data.getNodeList(), data.isPreRouted() ? 1 : 0, data.getTransactionId(), data.getSourceNodeId()};
        int[] types = new int[]{12, 1, 12, 12, 12, 2, 12, 12, 12, 2, 12, 12, 93};
        args = data.getCreateTime() != null ? ArrayUtils.add((Object[])args, (Object)data.getCreateTime()) : ArrayUtils.add((Object[])args, (Object)new Date());
        long id = transaction.insertWithGeneratedKey(sql, this.symmetricDialect.getSequenceKeyName(SequenceIdentifier.DATA), this.symmetricDialect.getSequenceName(SequenceIdentifier.DATA), args, types);
        data.setDataId(id);
        return id;
    }

    @Override
    public void insertData(ISqlTransaction transaction, List<Data> datas) {
        transaction.prepare(this.getSql("insertIntoDataBulkSql"));
        int[] types = new int[]{12, 1, 12, 12, 12, 2, 12, 12, 12, 93};
        for (Data data : datas) {
            Object[] args = new Object[]{data.getTableName(), data.getDataEventType().getCode(), data.getRowData(), data.getPkData(), data.getOldData(), data.getTriggerHistory() != null ? data.getTriggerHistory().getTriggerHistoryId() : -1, data.getChannelId(), data.getTransactionId(), data.getSourceNodeId(), data.getCreateTime()};
            transaction.addRow((Object)data, args, types);
        }
        transaction.flush();
    }

    protected void insertDataEvent(ISqlTransaction transaction, DataEvent dataEvent) {
        this.insertDataEvent(transaction, dataEvent.getDataId(), dataEvent.getBatchId());
    }

    protected void insertDataEvent(ISqlTransaction transaction, long dataId, long batchId) {
        try {
            transaction.prepareAndExecute(this.getSql("insertIntoDataEventSql"), new Object[]{dataId, batchId, new Date()}, new int[]{2, 2, 93});
        }
        catch (RuntimeException ex) {
            throw new RuntimeException(String.format("Could not insert a data event: data_id=%s batch_id=%s", dataId, batchId), ex);
        }
    }

    @Override
    public void insertDataEvents(ISqlTransaction transaction, List<DataEvent> events) {
        if (events.size() > 0) {
            transaction.prepare(this.getSql("insertIntoDataEventSql"));
            for (DataEvent dataEvent : events) {
                transaction.addRow((Object)dataEvent, new Object[]{dataEvent.getDataId(), dataEvent.getBatchId(), new Date()}, new int[]{2, 2, 93});
            }
            transaction.flush();
        }
    }

    @Override
    public void insertDataAndDataEventAndOutgoingBatch(Data data, String channelId, List<Node> nodes, boolean isLoad, long loadId, String createBy) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            data.setPreRouted(true);
            long dataId = this.insertData(transaction, data);
            for (Node node : nodes) {
                this.insertDataEventAndOutgoingBatch(transaction, dataId, channelId, node.getNodeId(), data.getDataEventType(), isLoad, loadId, createBy, AbstractBatch.Status.NE, data.getTableName(), -1L);
            }
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public long insertDataAndDataEventAndOutgoingBatch(Data data, String nodeId, boolean isLoad, long loadId, String createBy) {
        long batchId = 0L;
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            batchId = this.insertDataAndDataEventAndOutgoingBatch(transaction, data, nodeId, isLoad, loadId, createBy, AbstractBatch.Status.NE, null, -1L);
            transaction.commit();
            long l = batchId;
            return l;
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    public long insertDataAndDataEventAndOutgoingBatch(ISqlTransaction transaction, Data data, String nodeId, boolean isLoad, long loadId, String createBy, AbstractBatch.Status status, String overrideChannelId, long estimatedBatchRowCount) {
        data.setPreRouted(true);
        long dataId = this.insertData(transaction, data);
        String channelId = null;
        if (isLoad) {
            if (overrideChannelId != null) {
                channelId = overrideChannelId;
            } else {
                TriggerHistory history = data.getTriggerHistory();
                if (history != null && channelId == null) {
                    Trigger trigger = this.engine.getTriggerRouterService().getTriggerById(history.getTriggerId(), false);
                    channelId = this.getReloadChannelIdForTrigger(trigger, this.engine.getConfigurationService().getChannels(false));
                }
            }
        } else {
            channelId = data.getChannelId();
        }
        return this.insertDataEventAndOutgoingBatch(transaction, dataId, channelId, nodeId, data.getDataEventType(), isLoad, loadId, createBy, status, data.getTableName(), estimatedBatchRowCount);
    }

    @Override
    public long insertDataAndDataEventAndOutgoingBatch(ISqlTransaction transaction, Data data, String nodeId, boolean isLoad, long loadId, String createBy, AbstractBatch.Status status, long estimatedBatchRowCount) {
        return this.insertDataAndDataEventAndOutgoingBatch(transaction, data, nodeId, isLoad, loadId, createBy, status, null, estimatedBatchRowCount);
    }

    protected long insertDataEventAndOutgoingBatch(ISqlTransaction transaction, long dataId, String channelId, String nodeId, DataEventType eventType, boolean isLoad, long loadId, String createBy, AbstractBatch.Status status, String tableName, long estimatedBatchRowCount) {
        OutgoingBatch outgoingBatch = new OutgoingBatch(nodeId, channelId, status);
        outgoingBatch.setLoadId(loadId);
        outgoingBatch.setCreateBy(createBy);
        outgoingBatch.setLoadFlag(isLoad);
        outgoingBatch.incrementRowCount(eventType);
        if (estimatedBatchRowCount > 0L) {
            outgoingBatch.setDataRowCount(estimatedBatchRowCount);
        } else {
            outgoingBatch.incrementDataRowCount();
        }
        if (tableName != null) {
            outgoingBatch.incrementTableCount(tableName.toLowerCase());
        }
        if (status == AbstractBatch.Status.RQ) {
            outgoingBatch.setExtractJobFlag(true);
        }
        this.engine.getOutgoingBatchService().insertOutgoingBatch(transaction, outgoingBatch);
        this.insertDataEvent(transaction, new DataEvent(dataId, outgoingBatch.getBatchId()));
        return outgoingBatch.getBatchId();
    }

    @Override
    public String reloadNode(String nodeId, boolean reverseLoad, String createBy) {
        INodeService nodeService = this.engine.getNodeService();
        Node targetNode = this.engine.getNodeService().findNode(nodeId);
        if (targetNode == null) {
            return String.format("Unknown node %s", nodeId);
        }
        if (reverseLoad && nodeService.setReverseInitialLoadEnabled(nodeId, true, false, -1L, createBy)) {
            return String.format("Successfully enabled reverse initial load for node %s", nodeId);
        }
        if (nodeService.setInitialLoadEnabled(nodeId, true, false, -1L, createBy)) {
            return String.format("Successfully enabled initial load for node %s", nodeId);
        }
        return String.format("Could not enable initial load for %s", nodeId);
    }

    private void insertNodeSecurityUpdate(ISqlTransaction transaction, String nodeIdRecord, String targetNodeId, boolean isLoad, long loadId, String createBy, String channelId) {
        Data data = this.createData(transaction, null, null, this.tablePrefix + "_node_security", " t.node_id = '" + nodeIdRecord + "'");
        if (data == null) {
            throw new SymmetricException(String.format("Unable to issue an update for %s_node_security.  Check the %s_trigger_hist for %s_node_security.", this.tablePrefix, this.tablePrefix, this.tablePrefix), new Object[0]);
        }
        this.insertDataAndDataEventAndOutgoingBatch(transaction, data, targetNodeId, isLoad, loadId, createBy, AbstractBatch.Status.LS, channelId, -1L);
    }

    @Override
    public void sendScript(String nodeId, String script, boolean isLoad) {
        Node targetNode = this.engine.getNodeService().findNode(nodeId, true);
        TriggerHistory history = this.engine.getTriggerRouterService().findTriggerHistoryForGenericSync();
        Data data = new Data(history.getSourceTableName(), DataEventType.BSH, CsvUtils.escapeCsvData((String)script), null, history, "config", null, null);
        data.setNodeList(nodeId);
        if (!isLoad) {
            this.insertData(data);
        } else {
            this.insertDataAndDataEventAndOutgoingBatch(data, targetNode.getNodeId(), isLoad, -1L, null);
        }
    }

    @Override
    public boolean sendSchema(String nodeId, String catalogName, String schemaName, String tableName, boolean isLoad, boolean excludeIndices, boolean excludeForeignKeys, boolean excludeDefaults) {
        Node targetNode = this.engine.getNodeService().findNode(nodeId, true);
        if (targetNode == null) {
            this.log.error("Could not send schema to the node {}.  The target node does not exist", (Object)nodeId);
            return false;
        }
        ITriggerRouterService triggerRouterService = this.engine.getTriggerRouterService();
        List<TriggerHistory> triggerHistories = triggerRouterService.findTriggerHistories(catalogName, schemaName, tableName);
        int eventCount = 0;
        for (TriggerHistory triggerHistory : triggerHistories) {
            ++eventCount;
            this.insertCreateEvent(targetNode, triggerHistory, false, -1L, null, excludeIndices, excludeForeignKeys, excludeDefaults);
        }
        return eventCount > 0;
    }

    @Override
    public String sendSQL(String nodeId, String catalogName, String schemaName, String tableName, String sql) {
        Node sourceNode = this.engine.getNodeService().findIdentity();
        Node targetNode = this.engine.getNodeService().findNode(nodeId, true);
        if (targetNode == null) {
            return "Unknown node " + nodeId;
        }
        ITriggerRouterService triggerRouterService = this.engine.getTriggerRouterService();
        TriggerHistory triggerHistory = triggerRouterService.findTriggerHistory(catalogName, schemaName, tableName);
        if (triggerHistory == null) {
            return "Trigger for table " + tableName + " does not exist from node " + sourceNode.getNodeGroupId();
        }
        Trigger trigger = triggerRouterService.getTriggerById(triggerHistory.getTriggerId());
        if (trigger != null) {
            ISqlTransaction transaction = null;
            try {
                transaction = this.sqlTemplate.startSqlTransaction();
                this.insertSqlEvent(transaction, triggerHistory, trigger.getChannelId(), targetNode, sql, false, -1L, null);
                transaction.commit();
                String string = "Successfully create SQL event for node " + targetNode.getNodeId();
                return string;
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                this.close(transaction);
            }
        }
        return "Trigger for table " + tableName + " does not exist from node " + sourceNode.getNodeGroupId();
    }

    @Override
    public String sendSQL(String nodeId, String sql) {
        String tableName = TableConstants.getTableName(this.parameterService.getTablePrefix(), "node_host");
        Node sourceNode = this.engine.getNodeService().findIdentity();
        Node targetNode = this.engine.getNodeService().findNode(nodeId, true);
        if (targetNode == null) {
            return "Unknown node " + nodeId;
        }
        ITriggerRouterService triggerRouterService = this.engine.getTriggerRouterService();
        TriggerHistory triggerHistory = triggerRouterService.findTriggerHistory(null, null, tableName);
        if (triggerHistory == null) {
            return "Trigger for table " + tableName + " does not exist from node " + sourceNode.getNodeGroupId();
        }
        Trigger trigger = triggerRouterService.getTriggerById(triggerHistory.getTriggerId());
        if (trigger != null) {
            ISqlTransaction transaction = null;
            try {
                transaction = this.sqlTemplate.startSqlTransaction();
                Data data = new Data(triggerHistory.getSourceTableName(), DataEventType.SQL, CsvUtils.escapeCsvData((String)sql), null, triggerHistory, "config", null, null);
                data.setNodeList(targetNode.getNodeId());
                this.insertDataAndDataEventAndOutgoingBatch(transaction, data, targetNode.getNodeId(), false, -1L, null, AbstractBatch.Status.NE, null, -1L);
                transaction.commit();
                String string = "Successfully create SQL event for node " + targetNode.getNodeId();
                return string;
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                this.close(transaction);
            }
        }
        return "Trigger for table " + tableName + " does not exist from node " + sourceNode.getNodeGroupId();
    }

    @Override
    public String reloadTable(String nodeId, String catalogName, String schemaName, String tableName) {
        return this.reloadTable(nodeId, catalogName, schemaName, tableName, null);
    }

    @Override
    public String reloadTable(String nodeId, String catalogName, String schemaName, String tableName, String overrideInitialLoadSelect) {
        return this.reloadTable(nodeId, catalogName, schemaName, tableName, overrideInitialLoadSelect, null, false);
    }

    @Override
    public String reloadTableImmediate(String nodeId, String catalogName, String schemaName, String tableName, String overrideInitialLoadSelect, String overrideChannelId) {
        return this.reloadTable(nodeId, catalogName, schemaName, tableName, overrideInitialLoadSelect, overrideChannelId, true);
    }

    protected String reloadTable(String nodeId, String catalogName, String schemaName, String tableName, String overrideInitialLoadSelect, String overrideChannelId, boolean isImmediate) {
        Node sourceNode = this.engine.getNodeService().findIdentity();
        Node targetNode = this.engine.getNodeService().findNode(nodeId);
        if (targetNode == null) {
            return "Unknown node " + nodeId;
        }
        ITriggerRouterService triggerRouterService = this.engine.getTriggerRouterService();
        List<TriggerHistory> triggerHistories = triggerRouterService.findTriggerHistories(catalogName, schemaName, tableName);
        Map<Integer, List<TriggerRouter>> triggerRoutersByHistoryId = triggerRouterService.fillTriggerRoutersByHistIdAndSortHist(sourceNode.getNodeGroupId(), targetNode.getNodeGroupId(), targetNode.getExternalId(), triggerHistories, false);
        int eventCount = 0;
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            for (TriggerHistory triggerHistory : triggerHistories) {
                boolean hasTriggerRouters;
                List<TriggerRouter> triggerRouters = triggerRoutersByHistoryId.get(triggerHistory.getTriggerHistoryId());
                boolean bl = hasTriggerRouters = triggerRouters != null && triggerRouters.size() > 0;
                if (!hasTriggerRouters && triggerHistory.getSourceTableName().startsWith(this.parameterService.getTablePrefix())) {
                    if (overrideChannelId == null) {
                        overrideChannelId = "reload";
                    }
                    hasTriggerRouters = triggerRouters.add(new TriggerRouter());
                }
                if (!hasTriggerRouters) continue;
                for (TriggerRouter triggerRouter : triggerRouters) {
                    ++eventCount;
                    String channelId = overrideChannelId;
                    if (channelId == null) {
                        channelId = this.getReloadChannelIdForTrigger(triggerRouter.getTrigger(), this.engine.getConfigurationService().getChannels(false));
                    }
                    if (isImmediate) {
                        this.insertReloadEventImmediate(transaction, targetNode, triggerRouter, triggerHistory, overrideInitialLoadSelect, false, -1L, "reloadTable", AbstractBatch.Status.NE, channelId, -1L);
                        continue;
                    }
                    this.insertReloadEvent(transaction, targetNode, triggerRouter, triggerHistory, overrideInitialLoadSelect, false, -1L, "reloadTable", AbstractBatch.Status.NE, channelId, -1L);
                }
            }
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
        if (eventCount > 0) {
            return "Successfully created " + (String)(eventCount > 1 ? eventCount + " events" : "event") + " to reload table " + tableName + " for node " + targetNode.getNodeId();
        }
        return "Trigger for table " + tableName + " does not exist for source node group of " + sourceNode.getNodeGroupId();
    }

    @Override
    public void reloadMissingForeignKeyRowsReverse(String sourceNodeId, Table table, CsvData data, String channelId, boolean sendCorrectionToPeers) {
        try {
            IDatabasePlatform platform = this.engine.getTargetDialect().getPlatform();
            Map dataMap = data.toColumnNameValuePairs(table.getColumnNames(), "rowData");
            ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
            Row row = new Row(dataMap.size());
            row.putAll(dataMap);
            Table localTable = platform.getTableFromCache(table.getCatalog(), table.getSchema(), table.getName(), false);
            if (localTable == null) {
                this.log.info("Could not find table " + table.getFullyQualifiedTableName());
            }
            tableRows.add(new TableRow(localTable, row, null, null, null));
            List foreignTableRows = platform.getDdlReader().getImportedForeignTableRows(tableRows, new HashSet(), this.symmetricDialect.getBinaryEncoding());
            if (foreignTableRows.isEmpty()) {
                this.log.info("Could not determine foreign table rows to fix foreign key violation for nodeId '{}' table '{}'", (Object)sourceNodeId, (Object)localTable.getName());
            }
            Collections.reverse(foreignTableRows);
            HashSet<TableRow> visited = new HashSet<TableRow>();
            Node sourceNode = this.engine.getNodeService().findNode(sourceNodeId);
            Node identity = this.engine.getNodeService().findIdentity();
            StringBuilder script = new StringBuilder();
            ArrayList<Node> targetNodes = new ArrayList<Node>();
            targetNodes.add(identity);
            if (sendCorrectionToPeers) {
                targetNodes.addAll(this.engine.getNodeService().findEnabledNodesFromNodeGroup(sourceNode.getNodeGroupId()));
                targetNodes.remove(sourceNode);
            }
            for (TableRow foreignTableRow : foreignTableRows) {
                if (!visited.add(foreignTableRow)) continue;
                Table foreignTable = foreignTableRow.getTable();
                String catalog = foreignTable.getCatalog();
                String schema = foreignTable.getSchema();
                if (Strings.CS.equals(platform.getDefaultCatalog(), catalog)) {
                    catalog = null;
                    if (Strings.CS.equals(platform.getDefaultSchema(), schema)) {
                        schema = null;
                    }
                }
                this.log.info("Requesting foreign key correction reload nodeId {} catalog '{}' schema '{}' foreign table name '{}' fk name '{}' where sql '{}' to correct table '{}' for column '{}'", new Object[]{sourceNodeId, catalog, schema, foreignTable.getName(), foreignTableRow.getFkName(), foreignTableRow.getWhereSql(), localTable.getName(), foreignTableRow.getReferenceColumnName()});
                for (Node targetNode : targetNodes) {
                    script.append("engine.getDataService().reloadTableImmediate(\"" + targetNode.getNodeId() + "\", " + (String)(catalog == null ? catalog : "\"" + catalog + "\"") + ", " + (String)(schema == null ? schema : "\"" + schema + "\"") + ", \"" + foreignTable.getName().replace("\"", "\\\"") + "\", \"" + foreignTableRow.getWhereSql().replace("\"", "\\\"") + "\", " + (String)(channelId == null ? channelId : "\"" + channelId + "\"") + ");\n");
                }
            }
            if (script.length() > 0) {
                this.insertScriptEvent("config", sourceNode, script.toString(), false, -1L, "fk");
            }
        }
        catch (Exception e) {
            this.log.error("Unknown exception while processing foreign key for node id: " + sourceNodeId, (Throwable)e);
        }
    }

    @Override
    public void reloadMissingForeignKeyRowsForLoad(String sourceNodeId, long batchId, long rowNumber, Table table, CsvData data, String channelId) {
        String rowData = data.getCsvData("rowData");
        rowData = rowData.replaceAll("\n", "\\n").replaceAll("\r", "\\r");
        rowData = CsvUtils.escapeCsvData((String)rowData);
        Node sourceNode = this.engine.getNodeService().findNode(sourceNodeId);
        String script = "try { engine.getDataService().sendMissingForeignKeyRowsForLoad(" + batchId + ", \"" + this.engine.getNodeId() + "\", " + rowNumber + ", " + rowData + "); } catch (Exception e) { }";
        if (this.log.isDebugEnabled()) {
            this.log.debug("Requesting missing foreign key rows for batch {}-{} row {} for table {} row data {}", new Object[]{sourceNodeId, batchId, rowNumber, table.getFullyQualifiedTableName(), data.getCsvData("rowData")});
        } else {
            this.log.info("Requesting missing foreign key rows for batch {}-{} row {} for table {}", new Object[]{sourceNodeId, batchId, rowNumber, table.getFullyQualifiedTableName()});
        }
        this.insertScriptEvent("config", sourceNode, script, false, -1L, "fk");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMissingForeignKeyRowsForLoad(long batchId, String nodeId, long rowNumber, String rowData) {
        ISqlReadCursor<Data> cursor = null;
        Data data = null;
        long startBatchId = batchId;
        if (this.parameterService.is("initial.load.use.extract.job.enabled") && (startBatchId = this.sqlTemplateDirty.queryForLong(this.getSql("selectStartBatchExtractRequest"), new Object[]{batchId, nodeId, this.engine.getNodeId()})) == 0L) {
            startBatchId = batchId;
        }
        try {
            cursor = this.selectDataFor(startBatchId, nodeId, false);
            data = (Data)cursor.next();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (data != null) {
            data.putCsvData("rowData", rowData);
            data.setDataEventType(DataEventType.INSERT);
            this.reloadMissingForeignKeyRows(data, batchId, nodeId, -1L, rowNumber);
        } else {
            this.log.warn("Unable to correct missing foreign key error in batch {}-{} row {} because no data found", new Object[]{nodeId, batchId, rowNumber});
        }
    }

    @Override
    public void reloadMissingForeignKeyRows(long batchId, String nodeId, long dataId, long rowNumber) {
        this.reloadMissingForeignKeyRows(this.findData(dataId), batchId, nodeId, dataId, rowNumber);
    }

    protected void reloadMissingForeignKeyRows(Data data, long batchId, String nodeId, long dataId, long rowNumber) {
        String batchName = nodeId + "-" + batchId + " " + (dataId == -1L ? "row " + rowNumber : "data " + dataId);
        if (data == null) {
            this.log.warn("Unable to reload missing foreign data for data ID {} because data is not found", (Object)dataId);
            return;
        }
        if (data.getDataEventType() != DataEventType.INSERT && data.getDataEventType() != DataEventType.UPDATE && data.getDataEventType() != DataEventType.DELETE) {
            this.log.warn("Unable to reload missing foreign data for data ID {} because event type {} is not DML", (Object)dataId, (Object)data.getDataEventType());
            return;
        }
        this.log.debug("reloadMissingForeignKeyRows for batch {} table {}", (Object)batchName, (Object)data.getTableName());
        TriggerHistory hist = data.getTriggerHistory();
        IDatabasePlatform targetPlatform = this.getTargetPlatform(data.getTableName());
        ISymmetricDialect targetDialect = this.symmetricDialect.getTargetDialect(data.getTableName());
        Table table = targetPlatform.getTableFromCache(hist.getSourceCatalogName(), hist.getSourceSchemaName(), hist.getSourceTableName(), false);
        if (table == null) {
            this.log.info("Unable to lookup table " + hist.getFullyQualifiedSourceTableName());
            return;
        }
        table = table.copyAndFilterColumns(hist.getParsedColumnNames(), hist.getParsedPkColumnNames(), true, false);
        Object[] values = targetPlatform.getObjectValues(targetDialect.getBinaryEncoding(), data.getParsedData("rowData"), table.getColumns());
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        Row row = new Row(values.length);
        int i = 0;
        for (String columnName : table.getColumnNames()) {
            row.put(columnName, values.length > i ? values[i++] : null);
        }
        tableRows.add(new TableRow(table, row, null, null, null));
        List foreignTableRows = targetPlatform.getDdlReader().getImportedForeignTableRows(tableRows, new HashSet(), targetDialect.getBinaryEncoding());
        if (foreignTableRows.isEmpty()) {
            this.log.info("Could not determine foreign table rows to fix foreign key violation for batch {} table {}", (Object)batchName, (Object)data.getTableName());
        }
        this.sortTableRowsByForeignKeys(foreignTableRows);
        HashSet<TableRow> visited = new HashSet<TableRow>();
        boolean foundAllRows = true;
        for (TableRow foreignTableRow : foreignTableRows) {
            if (foreignTableRow.getRow().size() != 0) continue;
            this.log.info("Resolving batch {} to ignore the row because {} refers to a missing foreign row in {}", new Object[]{batchName, table.getFullyQualifiedTableName(), foreignTableRow.getTable().getFullyQualifiedTableName()});
            foundAllRows = false;
            break;
        }
        if (foundAllRows) {
            for (TableRow foreignTableRow : foreignTableRows) {
                if (!visited.add(foreignTableRow)) continue;
                Table foreignTable = foreignTableRow.getTable();
                String catalog = foreignTable.getCatalog();
                String schema = foreignTable.getSchema();
                if (Strings.CS.equals(targetPlatform.getDefaultCatalog(), catalog)) {
                    catalog = null;
                    if (Strings.CS.equals(targetPlatform.getDefaultSchema(), schema)) {
                        schema = null;
                    }
                }
                this.log.info("Issuing foreign key correction for batch {} table {}: foreign table '{}' column '{}' fk name '{}' where '{}'", new Object[]{batchName, data.getTableName(), Table.getFullyQualifiedTableName((String)catalog, (String)schema, (String)foreignTable.getName()), foreignTableRow.getReferenceColumnName(), foreignTableRow.getFkName(), foreignTableRow.getWhereSql()});
                try {
                    this.reloadTableImmediate(nodeId, catalog, schema, foreignTable.getName(), foreignTableRow.getWhereSql(), dataId == -1L ? "config" : null);
                }
                catch (Exception ex) {
                    this.log.info("Failed to issue foreign key correction, but will try again,", (Throwable)ex);
                    this.reloadTableImmediate(nodeId, catalog, schema, foreignTable.getName(), foreignTableRow.getWhereSql(), dataId == -1L ? "config" : null);
                }
            }
        } else {
            this.sendSQL(nodeId, "update " + this.engine.getParameterService().getTablePrefix() + "_incoming_error set resolve_ignore = 1 where batch_id = " + batchId + " and node_id = '" + this.engine.getNodeId() + "' and failed_row_number = " + rowNumber);
        }
    }

    protected void sortTableRowsByForeignKeys(List<TableRow> tableRows) {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (TableRow tableRow : tableRows) {
            tables.add(tableRow.getTable());
        }
        List sortedTables = Database.sortByForeignKeys(tables);
        final HashMap<Table, Integer> tableMap = new HashMap<Table, Integer>();
        int index = 0;
        for (Table table : sortedTables) {
            tableMap.put(table, index++);
        }
        Collections.sort(tableRows, new Comparator<TableRow>(){

            @Override
            public int compare(TableRow t1, TableRow t2) {
                Integer i1 = (Integer)tableMap.get(t1.getTable());
                Integer i2 = (Integer)tableMap.get(t2.getTable());
                return i1 == null ? -1 : (i2 == null ? 1 : i1.compareTo(i2));
            }
        });
    }

    @Override
    public void sendNewerDataToNode(ISqlTransaction transaction, String targetNodeId, String tableName, String pkCsvData, Date minCreateTime, String winningNodeId) {
        List datas;
        if (pkCsvData != null) {
            pkCsvData = pkCsvData.replace("\\n", "\n").replace("\\r", "\r");
        }
        if ((datas = transaction.query(this.getSql("selectData", "whereNewerData"), this.getDataMapper(), new Object[]{tableName, pkCsvData + "%", pkCsvData, minCreateTime}, new int[]{12, 12, 12, 93})) != null && datas.size() > 0) {
            Data data = (Data)datas.get(0);
            String dataNodeId = data.getSourceNodeId();
            if (dataNodeId == null || dataNodeId.equals("")) {
                dataNodeId = this.engine.getNodeId();
            }
            if (data.getCreateTime().getTime() > minCreateTime.getTime() || dataNodeId.hashCode() > winningNodeId.hashCode()) {
                data.setNodeList(targetNodeId);
                data.setChannelId("reload");
                this.insertData(transaction, data);
            }
        }
    }

    @Override
    public void insertHeartbeatEvent(Node node, boolean isReload) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            String tableName = TableConstants.getTableName(this.tablePrefix, "node_host");
            List<NodeGroupLink> links = this.engine.getConfigurationService().getNodeGroupLinksFor(this.parameterService.getNodeGroupId(), false);
            for (NodeGroupLink nodeGroupLink : links) {
                if (nodeGroupLink.getDataEventAction() != NodeGroupLinkAction.P) continue;
                Set<TriggerRouter> triggerRouters = this.engine.getTriggerRouterService().getTriggerRouterForTableForCurrentNode(nodeGroupLink, null, null, tableName, false);
                if (triggerRouters != null && triggerRouters.size() > 0) {
                    Data data = this.createData(transaction, triggerRouters.iterator().next().getTrigger(), String.format(" t.node_id = '%s'", node.getNodeId()));
                    if (data != null) {
                        this.insertData(transaction, data);
                        continue;
                    }
                    this.log.warn("Not generating data/data events for table {} because a trigger or trigger hist is not created yet.", (Object)tableName);
                    continue;
                }
                this.log.warn("Not generating data/data events for table {} because a trigger or trigger hist is not created yet.", (Object)tableName);
            }
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public Data createData(String catalogName, String schemaName, String tableName) {
        return this.createData(catalogName, schemaName, tableName, null);
    }

    @Override
    public Data createData(String catalogName, String schemaName, String tableName, String whereClause) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            Data data = this.createData(transaction, catalogName, schemaName, tableName, whereClause);
            transaction.commit();
            Data data2 = data;
            return data2;
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public Data createData(ISqlTransaction transaction, String catalogName, String schemaName, String tableName, String whereClause) {
        Data data = null;
        Set<TriggerRouter> triggerRouters = this.engine.getTriggerRouterService().getTriggerRouterForTableForCurrentNode(catalogName, schemaName, tableName, false);
        if (triggerRouters != null && triggerRouters.size() > 0) {
            data = this.createData(transaction, triggerRouters.iterator().next().getTrigger(), whereClause);
        }
        return data;
    }

    protected Data createData(ISqlTransaction transaction, Trigger trigger, String whereClause) {
        Data data = null;
        if (trigger != null) {
            TriggerHistory triggerHistory = this.engine.getTriggerRouterService().getNewestTriggerHistoryForTrigger(trigger.getTriggerId(), trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName());
            if (triggerHistory == null && (triggerHistory = this.engine.getTriggerRouterService().findTriggerHistory(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName())) == null) {
                triggerHistory = this.engine.getTriggerRouterService().findTriggerHistory(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName().toUpperCase());
            }
            if (triggerHistory != null) {
                String rowData = null;
                String pkData = null;
                if (whereClause != null) {
                    rowData = this.getCsvDataFor(transaction, trigger, triggerHistory, whereClause, false);
                    pkData = this.getCsvDataFor(transaction, trigger, triggerHistory, whereClause, true);
                }
                data = new Data(trigger.getSourceTableName(), DataEventType.UPDATE, rowData, pkData, triggerHistory, trigger.getChannelId(), null, null);
            }
        }
        return data;
    }

    protected String getCsvDataFor(ISqlTransaction transaction, Trigger trigger, TriggerHistory triggerHistory, String whereClause, boolean pkOnly, Table table) {
        String data = null;
        Object sql = null;
        try {
            sql = pkOnly ? this.symmetricDialect.createCsvPrimaryKeySql(trigger, triggerHistory, this.engine.getConfigurationService().getChannel(trigger.getChannelId()), whereClause, table) : this.symmetricDialect.createCsvDataSql(trigger, triggerHistory, this.engine.getConfigurationService().getChannel(trigger.getChannelId()), whereClause, table);
        }
        catch (NotImplementedException notImplementedException) {
            // empty catch block
        }
        if (StringUtils.isNotBlank(sql)) {
            data = (String)transaction.queryForObject(sql, String.class, new Object[0]);
        } else {
            DatabaseInfo databaseInfo = this.platform.getDatabaseInfo();
            String quote = databaseInfo.getDelimiterToken() == null || !this.parameterService.is("db.delimited.identifier.mode") ? "" : databaseInfo.getDelimiterToken();
            sql = "select " + triggerHistory.getColumnNames() + " from " + Table.getFullyQualifiedTableName((String)triggerHistory.getSourceCatalogName(), (String)triggerHistory.getSourceSchemaName(), (String)triggerHistory.getSourceTableName(), (String)quote, (String)databaseInfo.getCatalogSeparator(), (String)databaseInfo.getSchemaSeparator()) + " t where " + whereClause;
            Row row = transaction.queryForRow((String)sql, new Object[0]);
            if (row != null) {
                data = row.csvValue();
            }
        }
        if (data != null) {
            data = data.trim();
        }
        return data;
    }

    protected String getCsvDataFor(ISqlTransaction transaction, Trigger trigger, TriggerHistory triggerHistory, String whereClause, boolean pkOnly) {
        Table table = this.platform.getTableFromCache(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), trigger.getSourceTableName(), false);
        return this.getCsvDataFor(transaction, trigger, triggerHistory, whereClause, pkOnly, table);
    }

    @Override
    public long countDataGaps() {
        return this.sqlTemplate.queryForLong(this.getSql("countDataGapsSql"), new Object[0]);
    }

    @Override
    public List<DataGap> findDataGapsUnchecked() {
        return this.findDataGaps(false);
    }

    @Override
    public List<DataGap> findDataGapsExpired() {
        return this.findDataGaps(true);
    }

    protected List<DataGap> findDataGaps(boolean isExpired) {
        return this.sqlTemplate.query(this.getSql("findDataGapsSql"), (ISqlRowMapper)new ISqlRowMapper<DataGap>(){

            public DataGap mapRow(Row rs) {
                return new DataGap(rs.getLong("start_id"), rs.getLong("end_id"), rs.getDateTime("create_time"));
            }
        }, new Object[]{isExpired ? 1 : 0});
    }

    @Override
    public List<DataGap> findDataGaps() {
        long maxDataToSelect = this.parameterService.getLong("routing.largest.gap.size");
        List<DataGap> gaps = this.findDataGapsUnchecked();
        boolean lastGapExists = false;
        long lastGapStartId = 0L;
        for (DataGap dataGap : gaps) {
            lastGapExists |= dataGap.gapSize() >= maxDataToSelect - 1L;
            lastGapStartId = Math.max(lastGapStartId, dataGap.getEndId());
        }
        if (!lastGapExists) {
            if (lastGapStartId == 0L) {
                long maxRoutedDataId = this.findMaxDataEventDataId();
                long minDataId = this.findMinDataId() - 1L;
                lastGapStartId = Math.max(minDataId, maxRoutedDataId);
            }
            if (lastGapStartId > -1L) {
                ++lastGapStartId;
            }
            DataGap gap = new DataGap(lastGapStartId, lastGapStartId + maxDataToSelect);
            this.log.info("Inserting missing last data gap: {}", (Object)gap);
            this.insertDataGap(gap);
            gaps = this.findDataGaps();
        }
        return gaps;
    }

    public long findMaxDataEventDataId() {
        return this.sqlTemplate.queryForLong(this.getSql("selectMaxDataEventDataIdSql"), new Object[0]);
    }

    @Override
    public void insertDataGap(DataGap gap) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            this.insertDataGap(transaction, gap);
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public void insertDataGap(ISqlTransaction transaction, DataGap gap) {
        this.log.debug("Inserting data gap: {}", (Object)gap);
        transaction.prepareAndExecute(this.getSql("insertDataGapSql"), new Object[]{this.engine.getClusterService().getServerId(), gap.getStartId(), gap.getEndId(), 0, gap.getCreateTime()}, new int[]{12, 2, 2, 2, 93});
    }

    @Override
    public void insertDataGaps(ISqlTransaction transaction, Collection<DataGap> gaps) {
        if (gaps.size() > 0) {
            int[] types = new int[]{12, 2, 2, 2, 93};
            int maxRowsToFlush = this.engine.getParameterService().getInt("routing.flush.jdbc.batch.size");
            long lastUpdateTimestamp = System.currentTimeMillis();
            int flushCount = 0;
            int totalCount = 0;
            transaction.setInBatchMode(true);
            transaction.prepare(this.getSql("insertDataGapSql"));
            for (DataGap gap : gaps) {
                transaction.addRow((Object)gap, new Object[]{this.engine.getClusterService().getServerId(), gap.getStartId(), gap.getEndId(), 0, gap.getCreateTime()}, types);
                ++totalCount;
                if (++flushCount >= maxRowsToFlush) {
                    transaction.flush();
                    flushCount = 0;
                }
                if (System.currentTimeMillis() - lastUpdateTimestamp <= 30000L) continue;
                this.log.info("Inserted {} of {} new gaps", (Object)totalCount, (Object)gaps.size());
                lastUpdateTimestamp = System.currentTimeMillis();
            }
            transaction.flush();
        }
    }

    @Override
    public void deleteDataGap(DataGap gap) {
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            this.deleteDataGap(transaction, gap);
            transaction.commit();
        }
        catch (Error ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            this.close(transaction);
        }
    }

    @Override
    public void deleteDataGap(ISqlTransaction transaction, DataGap gap) {
        this.log.debug("Deleting data gap: {}", (Object)gap);
        int count = transaction.prepareAndExecute(this.getSql("deleteDataGapSql"), new Object[]{gap.getStartId(), gap.getEndId()}, new int[]{this.symmetricDialect.getSqlTypeForIds(), this.symmetricDialect.getSqlTypeForIds()});
        if (count == 0) {
            this.log.error("Failed to delete data gap: {}", (Object)gap);
        }
    }

    @Override
    public void deleteDataGaps(ISqlTransaction transaction, Collection<DataGap> gaps) {
        if (gaps.size() > 0) {
            int[] types = new int[]{this.symmetricDialect.getSqlTypeForIds(), this.symmetricDialect.getSqlTypeForIds()};
            int maxRowsToFlush = this.engine.getParameterService().getInt("routing.flush.jdbc.batch.size");
            long lastUpdateTimestamp = System.currentTimeMillis();
            int flushCount = 0;
            int totalCount = 0;
            transaction.setInBatchMode(true);
            transaction.prepare(this.getSql("deleteDataGapSql"));
            for (DataGap gap : gaps) {
                transaction.addRow((Object)gap, new Object[]{gap.getStartId(), gap.getEndId()}, types);
                if (++flushCount >= maxRowsToFlush) {
                    transaction.flush();
                    flushCount = 0;
                }
                if (System.currentTimeMillis() - lastUpdateTimestamp <= 30000L) continue;
                this.log.info("Deleted {} of {} old gaps", (Object)totalCount, (Object)gaps.size());
                lastUpdateTimestamp = System.currentTimeMillis();
            }
            transaction.flush();
        }
    }

    @Override
    public void deleteAllDataGaps(ISqlTransaction transaction) {
        transaction.prepareAndExecute(this.getSql("deleteAllDataGapsSql"), new Object[0]);
    }

    @Override
    public void expireDataGaps(ISqlTransaction transaction, Collection<DataGap> gaps) {
        if (gaps.size() > 0) {
            int[] types = new int[]{this.symmetricDialect.getSqlTypeForIds(), this.symmetricDialect.getSqlTypeForIds()};
            int maxRowsToFlush = this.engine.getParameterService().getInt("routing.flush.jdbc.batch.size");
            long lastUpdateTimestamp = System.currentTimeMillis();
            int flushCount = 0;
            int totalCount = 0;
            transaction.setInBatchMode(true);
            transaction.prepare(this.getSql("expireDataGapSql"));
            for (DataGap gap : gaps) {
                transaction.addRow((Object)gap, new Object[]{gap.getStartId(), gap.getEndId()}, types);
                if (++flushCount >= maxRowsToFlush) {
                    transaction.flush();
                    flushCount = 0;
                }
                if (System.currentTimeMillis() - lastUpdateTimestamp <= 30000L) continue;
                this.log.info("Expired {} of {} gaps", (Object)totalCount, (Object)gaps.size());
                lastUpdateTimestamp = System.currentTimeMillis();
            }
            transaction.flush();
        }
    }

    @Override
    public Date findCreateTimeOfEvent(long dataId) {
        return (Date)this.sqlTemplate.queryForObject(this.getSql("findDataEventCreateTimeSql"), Date.class, new Object[]{dataId});
    }

    @Override
    public Date findCreateTimeOfData(long dataId) {
        return (Date)this.sqlTemplate.queryForObject(this.getSql("findDataCreateTimeSql"), Date.class, new Object[]{dataId});
    }

    @Override
    public Date findNextCreateTimeOfDataStartingAt(long dataId) {
        return this.findCreateTimeOfData((Long)this.sqlTemplate.queryForObject(this.getSql("findMinDataSql"), Long.class, new Object[]{dataId}));
    }

    protected List<IHeartbeatListener> getHeartbeatListeners(boolean force) {
        if (force) {
            return this.extensionService.getExtensionPointList(IHeartbeatListener.class);
        }
        ArrayList<IHeartbeatListener> listeners = new ArrayList<IHeartbeatListener>();
        long ts = System.currentTimeMillis();
        for (IHeartbeatListener iHeartbeatListener : this.extensionService.getExtensionPointList(IHeartbeatListener.class)) {
            Long lastHeartbeatTimestamp = this.lastHeartbeatTimestamps.get(iHeartbeatListener);
            if (lastHeartbeatTimestamp != null && lastHeartbeatTimestamp > ts - iHeartbeatListener.getTimeBetweenHeartbeatsInSeconds() * 1000L) continue;
            listeners.add(iHeartbeatListener);
        }
        return listeners;
    }

    protected void updateLastHeartbeatTime(List<IHeartbeatListener> listeners) {
        if (listeners != null) {
            Long ts = System.currentTimeMillis();
            for (IHeartbeatListener iHeartbeatListener : listeners) {
                this.lastHeartbeatTimestamps.put(iHeartbeatListener, ts);
            }
        }
    }

    @Override
    public void heartbeat(boolean force) {
        List<IHeartbeatListener> listeners = this.getHeartbeatListeners(force);
        if (listeners.size() > 0) {
            Node me = this.engine.getNodeService().findIdentity();
            if (me != null) {
                ArrayList<IHeartbeatListener> successfulListeners = new ArrayList<IHeartbeatListener>();
                for (IHeartbeatListener l : listeners) {
                    try {
                        l.heartbeat(me);
                        successfulListeners.add(l);
                    }
                    catch (Throwable e) {
                        this.log.error("Failed to execute IHeartbeatListener " + l.getClass().getSimpleName(), e);
                    }
                }
                this.updateLastHeartbeatTime(successfulListeners);
            } else {
                this.log.debug("Did not run the heartbeat process because the node has not been configured");
            }
        }
    }

    @Override
    public List<Number> listDataIds(long batchId, String nodeId) {
        return this.sqlTemplateDirty.query(this.getSql("selectEventDataIdsSql", this.getDataOrderBy()), (ISqlRowMapper)new NumberMapper(), new Object[]{batchId, nodeId});
    }

    @Override
    public List<Data> listData(long batchId, String nodeId, long startDataId, String channelId, int maxRowsToRetrieve) {
        return this.sqlTemplateDirty.query(this.getDataSelectSql(batchId, startDataId, channelId), maxRowsToRetrieve, (ISqlRowMapper)new DataMapper(), new Object[]{batchId, nodeId, startDataId}, new int[]{this.symmetricDialect.getSqlTypeForIds(), 12, this.symmetricDialect.getSqlTypeForIds()});
    }

    @Override
    public Data findData(long dataId) {
        return (Data)this.sqlTemplateDirty.queryForObject(this.getSql("selectData", "whereDataId"), (ISqlRowMapper)new DataMapper(), new Object[]{dataId});
    }

    public List<Data> findData(long startDataId, long endDataId) {
        return this.sqlTemplateDirty.query(this.getSql("selectData", "whereDataIdBetween"), (ISqlRowMapper)new DataMapper(), new Object[]{startDataId, endDataId});
    }

    @Override
    public ISqlRowMapper<Data> getDataMapper() {
        return new DataMapper();
    }

    @Override
    public ISqlReadCursor<Data> selectDataFor(Batch batch) {
        return this.selectDataFor(batch.getBatchId(), batch.getTargetNodeId(), this.engine.getConfigurationService().getNodeChannel(batch.getChannelId(), false).getChannel().isContainsBigLob());
    }

    @Override
    public ISqlReadCursor<Data> selectDataFor(Long batchId, String targetNodeId, boolean isContainsBigLob) {
        return this.sqlTemplateDirty.queryForCursor(this.getDataSelectSql((long)batchId, -1L, isContainsBigLob), (ISqlRowMapper)new DataMapper(), new Object[]{batchId, targetNodeId}, new int[]{this.symmetricDialect.getSqlTypeForIds(), 12});
    }

    @Override
    public ISqlReadCursor<Data> selectDataFor(Long batchId, String channelId) {
        return this.sqlTemplateDirty.queryForCursor(this.getDataSelectByBatchSql(batchId, -1L, channelId), (ISqlRowMapper)new DataMapper(), new Object[]{batchId}, new int[]{this.symmetricDialect.getSqlTypeForIds()});
    }

    protected String getDataSelectByBatchSql(long batchId, long startDataId, String channelId) {
        String startAtDataIdSql = startDataId >= 0L ? " and d.data_id >= ? " : "";
        return this.symmetricDialect.massageDataExtractionSql(this.getSql("selectEventDataByBatchIdSql", startAtDataIdSql, this.getDataOrderBy()), this.engine.getConfigurationService().getNodeChannel(channelId, false).getChannel().isContainsBigLob());
    }

    protected String getDataSelectSql(long batchId, long startDataId, String channelId) {
        return this.getDataSelectSql(batchId, startDataId, this.engine.getConfigurationService().getNodeChannel(channelId, false).getChannel().isContainsBigLob());
    }

    protected String getDataSelectSql(long batchId, long startDataId, boolean isContainsBigLob) {
        String startAtDataIdSql = startDataId >= 0L ? " and d.data_id >= ? " : "";
        return this.symmetricDialect.massageDataExtractionSql(this.getSql("selectEventDataToExtractSql", startAtDataIdSql, this.getDataOrderBy()), isContainsBigLob);
    }

    protected String getDataOrderBy() {
        String orderBy = "";
        if (this.parameterService.is("oracle.sequence.noorder", false)) {
            orderBy = " order by d.create_time asc, d.data_id asc";
        } else if (this.parameterService.is("routing.data.reader.order.by.gap.id.enabled", true)) {
            orderBy = " order by d.data_id asc";
        }
        return orderBy;
    }

    @Override
    public long findMaxDataId() {
        long maxDataId = this.symmetricDialect.getCurrentSequenceValue(SequenceIdentifier.DATA);
        if (maxDataId == -1L) {
            maxDataId = this.sqlTemplateDirty.queryForLong(this.getSql("selectMaxDataIdSql"), new Object[0]);
        }
        return maxDataId;
    }

    @Override
    public long findMinDataId() {
        return this.sqlTemplateDirty.queryForLong(this.getSql("selectMinDataIdSql"), new Object[0]);
    }

    @Override
    public void deleteCapturedConfigChannelData() {
        int count = this.sqlTemplate.update(this.getSql("deleteCapturedConfigChannelDataSql"), new Object[0]);
        if (count > 0) {
            this.log.info("Deleted {} data rows that were on the config channel", (Object)count);
        }
    }

    @Override
    public Map<String, Date> getLastDataCaptureByChannel() {
        HashMap<String, Date> captureMap = new HashMap<String, Date>();
        LastCaptureByChannelMapper mapper = new LastCaptureByChannelMapper(captureMap);
        this.sqlTemplate.query(this.getSql("findLastCaptureTimeByChannelSql"), (ISqlRowMapper)mapper, new Object[0]);
        return mapper.getCaptureMap();
    }

    @Override
    public boolean fixLastDataGap() {
        DataGap lastGap;
        boolean fixed = false;
        long maxDataId = this.findMaxDataId();
        List<DataGap> gaps = this.findDataGaps();
        if (gaps.size() > 0 && (lastGap = gaps.get(gaps.size() - 1)).getEndId() < maxDataId) {
            fixed = true;
            this.log.warn("The last data id of {} was bigger than the last gap's end_id of {}.  Increasing the gap size", (Object)maxDataId, (Object)lastGap.getEndId());
            long maxDataToSelect = this.parameterService.getLong("routing.largest.gap.size");
            ISqlTransaction transaction = null;
            try {
                transaction = this.sqlTemplate.startSqlTransaction();
                this.deleteDataGap(transaction, lastGap);
                this.insertDataGap(transaction, new DataGap(lastGap.getStartId(), maxDataId + maxDataToSelect));
                transaction.commit();
            }
            catch (Error ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw ex;
            }
            finally {
                this.close(transaction);
            }
        }
        return fixed;
    }

    @Override
    public String findNodeIdsByNodeGroupId() {
        return this.getSql("findNodeIdsByNodeGroupIdSql");
    }

    protected void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException("Thread received interrupt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resendBatchAsReload(long batchId, String nodeId) {
        ArrayList<Data> dataList = new ArrayList<Data>();
        this.log.info("Resending as reload for batch {}-{}", (Object)nodeId, (Object)batchId);
        try (ISqlReadCursor<Data> cursor = this.selectDataFor(batchId, nodeId, true);){
            Data data = null;
            while ((data = (Data)cursor.next()) != null) {
                dataList.add(data);
            }
        }
        this.resendDataAsReload(dataList, nodeId);
        return dataList.size();
    }

    @Override
    public int resendDataAsReload(long minDataId, long maxDataId) {
        List<Data> dataList = this.findData(minDataId, maxDataId);
        if (dataList.size() > 0) {
            this.resendDataAsReload(dataList, null);
        }
        return dataList.size();
    }

    protected void resendDataAsReload(List<Data> dataList, String nodeId) {
        IDataService dataService = this.engine.getDataService();
        IDatabasePlatform platform = this.engine.getDatabasePlatform();
        for (Data data : dataList) {
            TriggerHistory hist = data.getTriggerHistory();
            Table table = platform.getTableFromCache(hist.getSourceCatalogName(), hist.getSourceSchemaName(), hist.getSourceTableName(), false);
            if (table == null) continue;
            table = table.copyAndFilterColumns(hist.getParsedColumnNames(), hist.getParsedPkColumnNames(), true, false);
            if (data.getDataEventType() == DataEventType.INSERT || data.getDataEventType() == DataEventType.UPDATE) {
                this.convertDataToReload(data, table, hist, nodeId);
                continue;
            }
            if (data.getDataEventType() != DataEventType.DELETE) continue;
            String[] pkData = data.getParsedData("pkData");
            Object[] values = platform.getObjectValues(this.engine.getSymmetricDialect().getBinaryEncoding(), pkData, table.getPrimaryKeyColumns());
            DmlStatement st = platform.createDmlStatement(DmlStatement.DmlType.COUNT, table.getCatalog(), table.getSchema(), table.getName(), table.getPrimaryKeyColumns(), table.getPrimaryKeyColumns(), DmlStatement.getNullKeyValues((Object[])values), null);
            int count = platform.getSqlTemplateDirty().queryForInt(st.getSql(), values);
            if (count > 0) {
                this.convertDataToReload(data, table, hist, nodeId);
                continue;
            }
            data.setNodeList(nodeId);
            data.setExternalData(null);
            data.setPreRouted(false);
            data.setChannelId("reload");
        }
        try (ISqlTransaction transaction = null;){
            transaction = this.engine.getSqlTemplate().startSqlTransaction();
            for (Data data : dataList) {
                dataService.insertData(transaction, data);
            }
            transaction.commit();
        }
    }

    protected void convertDataToReload(Data data, Table table, TriggerHistory hist, String nodeId) {
        IDatabasePlatform platform = this.engine.getDatabasePlatform();
        BinaryEncoding encoding = this.engine.getSymmetricDialect().getBinaryEncoding();
        String[] pkNames = hist.getParsedPkColumnNames();
        Object[] pkData = null;
        pkData = data.getDataEventType() == DataEventType.INSERT ? (String[])ArrayUtils.subarray((Object[])data.getParsedData("rowData"), (int)0, (int)pkNames.length) : data.getParsedData("pkData");
        DmlStatement st = platform.createDmlStatement(DmlStatement.DmlType.WHERE, table.getCatalog(), table.getSchema(), table.getName(), table.getPrimaryKeyColumns(), table.getPrimaryKeyColumns(), DmlStatement.getNullKeyValues((Object[])pkData), null);
        Row row = new Row(pkNames.length);
        Object[] values = platform.getObjectValues(encoding, (String[])pkData, table.getPrimaryKeyColumns());
        for (int i = 0; i < pkNames.length; ++i) {
            row.put(pkNames[i], values[i]);
        }
        String where = st.buildDynamicSql(encoding, row, false, false);
        String delimiter = this.engine.getDatabasePlatform().getDatabaseInfo().getSqlCommandDelimiter();
        if (where != null && where.endsWith(delimiter)) {
            where = where.substring(0, where.length() - delimiter.length());
        }
        data.setPkData(null);
        data.setRowData(where);
        data.setOldData(null);
        data.setNodeList(nodeId);
        data.setExternalData(null);
        data.setPreRouted(false);
        data.setDataEventType(DataEventType.RELOAD);
        data.setChannelId("reload");
    }

    @Override
    public int reCaptureData(long minDataId, long maxDataId) {
        long queryStartDataId = minDataId;
        long queryEndDataId = Long.min(minDataId + 1000L - 1L, maxDataId);
        List<Data> dataList = this.findData(queryStartDataId, queryEndDataId);
        if (dataList == null || dataList.size() < 1) {
            return 0;
        }
        int reCapturedCount = 0;
        while (queryStartDataId <= maxDataId) {
            if (dataList.size() > 0) {
                reCapturedCount += this.reCaptureData(dataList);
            }
            queryStartDataId = ++queryEndDataId;
            queryEndDataId = Long.min(queryEndDataId + 1000L - 1L, maxDataId);
            if (queryStartDataId > maxDataId) break;
            dataList = this.findData(queryStartDataId, queryEndDataId);
        }
        return reCapturedCount;
    }

    protected int reCaptureData(List<Data> dataList) {
        int insertedCount;
        block3: {
            ArrayList<Data> insertList = new ArrayList<Data>();
            long lastUpdateTimestamp = 0L;
            String recaptureTransactionId = this.generateTransactionIdFromTimestamp("recapture-", Instant.now());
            insertedCount = 0;
            try {
                for (Data data : dataList) {
                    Data recapturedData = this.fetchRecapturedData(data, recaptureTransactionId);
                    if (recapturedData == null) continue;
                    insertList.add(recapturedData);
                    if (System.currentTimeMillis() - lastUpdateTimestamp <= 30000L) continue;
                    lastUpdateTimestamp = System.currentTimeMillis();
                    this.log.info("Recaptured stale data_id={}, table={}, list.size={}, transactionid={}", new Object[]{recapturedData.getDataId(), recapturedData.getTableName(), dataList.size(), recaptureTransactionId});
                }
                insertedCount = this.insertRecapturedData(insertList);
            }
            catch (RuntimeException e) {
                if (insertedCount != 0 || insertList.size() <= 0) break block3;
                insertedCount = this.insertRecapturedData(insertList);
            }
        }
        return insertedCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Data fetchRecapturedData(Data data, String recaptureTransactionId) {
        Data data2;
        ISqlTransaction transaction;
        block34: {
            Data data3;
            block33: {
                Data data4;
                block32: {
                    Data data5;
                    block31: {
                        Object whereClause;
                        if (data == null) {
                            return null;
                        }
                        if (data.isPreRouted()) return null;
                        if (!data.getDataEventType().isDml()) {
                            return null;
                        }
                        Table table = null;
                        String[] keys = null;
                        transaction = null;
                        try {
                            TriggerHistory hist = data.getTriggerHistory();
                            if (hist == null) {
                                this.log.warn("Unable to recapture stale data_id={} because table={} no longer has trigger history! channel_id={}", new Object[]{data.getDataId(), data.getTableName(), data.getChannelId()});
                                Data data6 = null;
                                return data6;
                            }
                            String fullTableName = hist.getSourceCatalogName() + "." + hist.getSourceSchemaName() + "." + hist.getSourceTableName();
                            Set<TriggerRouter> triggerRouters = this.engine.getTriggerRouterService().getTriggerRouterForTableForCurrentNode(hist.getSourceCatalogName(), hist.getSourceSchemaName(), hist.getSourceTableName(), false);
                            if (triggerRouters == null || triggerRouters.size() <= 0) {
                                this.log.warn("Unable to recapture stale data_id={} because table={} no longer has a trigger-router! channel_id={}", new Object[]{data.getDataId(), fullTableName, data.getChannelId()});
                                Data data7 = null;
                                return data7;
                            }
                            table = this.platform.getTableFromCache(hist.getSourceCatalogName(), hist.getSourceSchemaName(), hist.getSourceTableName(), false);
                            if (table == null) {
                                this.log.warn("Unable to recapture stale data_id={} because table={} was not found!)", (Object)data.getDataId(), (Object)fullTableName);
                                Data data8 = null;
                                return data8;
                            }
                            Trigger trigger = triggerRouters.iterator().next().getTrigger();
                            table = table.copyAndFilterColumns(hist.getParsedColumnNames(), hist.getParsedPkColumnNames(), true, false);
                            keys = this.recaptureKeysForData(table, data);
                            Object[] values = this.platform.getObjectValues(this.engine.getSymmetricDialect().getBinaryEncoding(), keys, table.getPrimaryKeyColumns());
                            if (keys == null || values == null) {
                                Data data9 = null;
                                return data9;
                            }
                            whereClause = this.recaptureWhereFilterForKeys(table, hist, keys, values);
                            String actualRowData = null;
                            String pkData = data.getPkData();
                            String dataSummary4Log = String.format("data_id=%d, event=%s, table=%s, PK: %s", data.getDataId(), data.getDataEventType().toString(), table.getFullyQualifiedTableName(), ((String)whereClause).length() <= 100 ? whereClause : ((String)whereClause).substring(0, 100));
                            transaction = this.sqlTemplate.startSqlTransaction();
                            actualRowData = this.getCsvDataFor(transaction, trigger, hist, (String)whereClause, false, table);
                            if (actualRowData != null && data.getDataEventType() == DataEventType.INSERT) {
                                pkData = this.getCsvDataFor(transaction, trigger, hist, (String)whereClause, true, table);
                            }
                            this.close(transaction);
                            transaction = null;
                            Data recapturedData = null;
                            if (data.getDataEventType() == DataEventType.INSERT || data.getDataEventType() == DataEventType.UPDATE) {
                                if (actualRowData == null) {
                                    this.log.info("Skipped recapture of stale data because record no longer exists in database. {}", (Object)dataSummary4Log);
                                    data5 = null;
                                    if (transaction == null) return data5;
                                    break block31;
                                }
                                recapturedData = data;
                                recapturedData.setRowData(actualRowData);
                                recapturedData.setPkData(pkData);
                                recapturedData.setDataEventType(DataEventType.UPDATE);
                            } else if (data.getDataEventType() == DataEventType.DELETE) {
                                if (actualRowData != null) {
                                    this.log.info("Skipped recapture of stale data because record exists in database. {}", (Object)dataSummary4Log);
                                    data4 = null;
                                    if (transaction == null) return data4;
                                    break block32;
                                }
                                recapturedData = data;
                            }
                            if (!this.hasColumnDataIntegrity(recapturedData, hist)) {
                                this.log.warn("Unable to recapture stale data because row values no longer match tables columns! {}", (Object)dataSummary4Log);
                                data3 = null;
                                if (transaction == null) return data3;
                                break block33;
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Recaptured stale data. {}", (Object)dataSummary4Log);
                            }
                            data2 = recapturedData;
                            if (transaction == null) return data2;
                            break block34;
                        }
                        catch (RuntimeException e) {
                            if (table != null && keys != null) {
                                Column[] columns = table.getPrimaryKeyColumns();
                                String[] names = new String[columns.length];
                                String[] types = new String[columns.length];
                                int i = 0;
                                whereClause = columns;
                                int n = ((Column[])whereClause).length;
                                int n2 = 0;
                                while (true) {
                                    if (n2 >= n) {
                                        StringBuilder failureMessage = new StringBuilder();
                                        failureMessage.append("Failed to recapture for data ").append(data.getDataId());
                                        failureMessage.append(" event type ").append(data.getDataEventType().toString());
                                        failureMessage.append(" table ").append(table.getName());
                                        failureMessage.append(" with primary key ").append(ArrayUtils.toString((Object)names));
                                        failureMessage.append(" and types ").append(ArrayUtils.toString((Object)types)).append("\n");
                                        data.writeCsvDataDetails(failureMessage);
                                        this.log.info(failureMessage.toString());
                                        throw e;
                                    }
                                    Column col = whereClause[n2];
                                    names[i] = col.getName();
                                    types[i++] = col.getMappedType();
                                    ++n2;
                                }
                            }
                            this.log.warn("Exception during recapture of stale data_id={}; table={}; Event type={}; Message={}", new Object[]{data.getDataId(), data.getTableName(), data.getDataEventType().toString(), e.getMessage()});
                            throw e;
                        }
                        catch (Exception ex) {
                            this.log.error("Non-RuntimeException during recapture of stale data_id={}; table={}; Event type={}; Message={}", new Object[]{data.getDataId(), data.getTableName(), data.getDataEventType().toString(), ex.getMessage()});
                            throw ex;
                        }
                    }
                    this.close(transaction);
                    return data5;
                }
                this.close(transaction);
                return data4;
            }
            this.close(transaction);
            return data3;
        }
        this.close(transaction);
        return data2;
        finally {
            if (transaction != null) {
                this.close(transaction);
                transaction = null;
            }
        }
    }

    protected int insertRecapturedData(List<Data> insertList) {
        if (insertList == null || insertList.size() < 0) {
            return 0;
        }
        ISqlTransaction transaction = null;
        try {
            transaction = this.sqlTemplate.startSqlTransaction();
            for (int i = 0; i < insertList.size(); ++i) {
                Data data = insertList.get(i);
                this.insertData(transaction, data);
            }
            transaction.commit();
        }
        catch (Exception ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
        finally {
            if (transaction != null) {
                this.close(transaction);
            }
        }
        return insertList.size();
    }

    protected String[] recaptureKeysForData(Table table, Data data) {
        Object[] keys = null;
        if (data.getDataEventType() == DataEventType.INSERT) {
            keys = data.toParsedRowData();
            if (keys != null && keys.length >= table.getPrimaryKeyColumnCount()) {
                keys = (String[])ArrayUtils.subarray((Object[])keys, (int)0, (int)table.getPrimaryKeyColumnCount());
            }
        } else {
            keys = data.toParsedPkData();
        }
        return keys;
    }

    protected String recaptureWhereFilterForKeys(Table table, TriggerHistory hist, String[] keys, Object[] values) {
        Row row = new Row(keys.length);
        String[] keyNames = table.getPrimaryKeyColumnNames();
        for (int i = 0; i < keyNames.length && i < values.length; ++i) {
            row.put(keyNames[i], values[i]);
        }
        DmlStatement st = this.platform.createDmlStatement(DmlStatement.DmlType.WHERE, hist.getSourceCatalogName(), hist.getSourceSchemaName(), hist.getSourceTableName(), table.getPrimaryKeyColumns(), table.getColumns(), DmlStatement.getNullKeyValues((Object[])keys), null);
        String whereClause = st.buildDynamicSql(this.symmetricDialect.getBinaryEncoding(), row, false, this.platform.getDatabaseInfo().isJdbcTimestampAllowed()).substring(6);
        String delimiter = this.platform.getDatabaseInfo().getSqlCommandDelimiter();
        if (delimiter != null && delimiter.length() > 0) {
            whereClause = whereClause.substring(0, whereClause.length() - delimiter.length());
        }
        return whereClause;
    }

    protected boolean hasColumnDataIntegrity(Data data, TriggerHistory hist) {
        String[] colNames = hist.getParsedColumnNames();
        String[] pkNames = hist.getParsedPkColumnNames();
        String[] rowData = data.toParsedRowData();
        String[] oldData = data.toParsedOldData();
        String[] pkData = data.toParsedPkData();
        DataEventType type = data.getDataEventType();
        boolean okay = false;
        if (type == DataEventType.INSERT) {
            okay = rowData != null && rowData.length == colNames.length;
        } else if (type == DataEventType.UPDATE) {
            okay = !(rowData == null || rowData.length != colNames.length || oldData != null && oldData.length != colNames.length || pkData != null && pkData.length != pkNames.length || pkData == null && oldData == null);
        } else if (type == DataEventType.DELETE) {
            okay = !(pkData != null && pkData.length != pkNames.length || oldData != null && oldData.length != colNames.length || pkData == null && oldData == null);
        }
        return okay;
    }

    protected class TableReloadRequestMapper
    implements ISqlRowMapper<TableReloadRequest> {
        protected TableReloadRequestMapper() {
        }

        public TableReloadRequest mapRow(Row rs) {
            TableReloadRequest request = new TableReloadRequest();
            request.setSourceNodeId(rs.getString("source_node_id"));
            request.setTargetNodeId(rs.getString("target_node_id"));
            request.setCreateTable(rs.getBoolean("create_table"));
            request.setDeleteFirst(rs.getBoolean("delete_first"));
            request.setReloadSelect(rs.getString("reload_select"));
            request.setReloadTime(rs.getDateTime("reload_time"));
            request.setBeforeCustomSql(rs.getString("before_custom_sql"));
            request.setChannelId(rs.getString("channel_id"));
            request.setTriggerId(rs.getString("trigger_id"));
            request.setRouterId(rs.getString("router_id"));
            request.setCreateTime(rs.getDateTime("create_time"));
            request.setLastUpdateBy(rs.getString("last_update_by"));
            request.setLastUpdateTime(rs.getDateTime("last_update_time"));
            request.setLoadId(rs.getInt("load_id"));
            request.setProcessed(rs.getBoolean("processed"));
            return request;
        }
    }

    protected class TableReloadStatusMapper
    implements ISqlRowMapper<TableReloadStatus> {
        protected TableReloadStatusMapper() {
        }

        public TableReloadStatus mapRow(Row rs) {
            TableReloadStatus request = new TableReloadStatus();
            request.setLoadId(rs.getInt("load_id"));
            request.setSourceNodeId(rs.getString("source_node_id"));
            request.setTargetNodeId(rs.getString("target_node_id"));
            request.setCompleted(rs.getBoolean("completed"));
            request.setCancelled(rs.getBoolean("cancelled"));
            request.setFullLoad(rs.getBoolean("full_load"));
            request.setStartDataBatchId(rs.getLong("start_data_batch_id"));
            request.setEndDataBatchId(rs.getLong("end_data_batch_id"));
            request.setSetupBatchCount(rs.getInt("setup_batch_count"));
            request.setDataBatchCount(rs.getInt("data_batch_count"));
            request.setFinalizeBatchCount(rs.getInt("finalize_batch_count"));
            request.setSetupBatchLoaded(rs.getInt("setup_batch_loaded"));
            request.setDataBatchLoaded(rs.getInt("data_batch_loaded"));
            request.setFinalizeBatchLoaded(rs.getInt("finalize_batch_loaded"));
            request.setTableCount(rs.getInt("table_count"));
            request.setRowsLoaded(rs.getLong("rows_loaded"));
            request.setRowsCount(rs.getLong("rows_count"));
            request.setErrorFlag(rs.getBoolean("error_flag"));
            request.setSqlState(rs.getString("sql_state"));
            request.setSqlCode(rs.getInt("sql_code"));
            request.setSqlMessage(rs.getString("sql_message"));
            request.setStartTime(rs.getDateTime("start_time"));
            request.setEndTime(rs.getDateTime("end_time"));
            request.setLastUpdateTime(rs.getDateTime("last_update_time"));
            request.setLastUpdatedBy(rs.getString("last_update_by"));
            request.setNumBatchesBulkLoaded(rs.getInt("batch_bulk_load_count"));
            request.setNumRowsBulkLoaded(rs.getLong("row_bulk_load_count"));
            return request;
        }
    }

    public class DataMapper
    implements ISqlRowMapper<Data> {
        private List<TriggerRouter> triggerRouters;
        private List<TriggerHistory> activeTriggerHistories;
        private Collection<TriggerHistory> allTriggerHistories;
        private Map<Integer, TriggerHistory> remappedTriggerHistIds = new HashMap<Integer, TriggerHistory>();
        private HashMap<String, TriggerHistory> mismatchedTableName;
        private HashSet<Integer> missingConfigTriggerHist;
        private boolean lookupTriggerHist = true;

        public DataMapper() {
        }

        public DataMapper(boolean lookupTriggerHist) {
            this.lookupTriggerHist = lookupTriggerHist;
        }

        public Data mapRow(Row row) {
            Data data = new Data();
            String rowData = row.getString("ROW_DATA", false);
            data.putCsvData("rowData", StringUtils.isNotBlank((CharSequence)rowData) ? rowData : null);
            String pkData = row.getString("PK_DATA", false);
            data.putCsvData("pkData", StringUtils.isNotBlank((CharSequence)pkData) ? pkData : null);
            String oldData = row.getString("OLD_DATA", false);
            data.putCsvData("oldData", StringUtils.isNotBlank((CharSequence)oldData) ? oldData : null);
            data.putAttribute("channelId", row.getString("CHANNEL_ID"));
            data.putAttribute("transactionId", row.getString("TRANSACTION_ID", false));
            String tableName = row.getString("TABLE_NAME");
            data.putAttribute("tableName", tableName);
            data.setDataEventType(DataEventType.getEventType((String)row.getString("EVENT_TYPE")));
            data.putAttribute("sourceNodeId", row.getString("SOURCE_NODE_ID"));
            data.putAttribute("externalData", row.getString("EXTERNAL_DATA"));
            data.putAttribute("nodeList", row.getString("NODE_LIST"));
            data.putAttribute("dataId", row.getLong("DATA_ID"));
            data.putAttribute("createTime", row.getDateTime("CREATE_TIME"));
            int triggerHistId = row.getInt("TRIGGER_HIST_ID");
            data.putAttribute("tableId", triggerHistId);
            if (this.lookupTriggerHist) {
                TriggerHistory triggerHistory = DataService.this.engine.getTriggerRouterService().getTriggerHistory(triggerHistId);
                if (triggerHistory == null) {
                    triggerHistory = this.findOrCreateTriggerHistory(tableName, triggerHistId, data, false);
                } else if (!triggerHistory.getSourceTableName().equals(tableName)) {
                    TriggerHistory cachedTriggerHistory;
                    if (this.mismatchedTableName == null) {
                        this.mismatchedTableName = new HashMap();
                    }
                    if ((cachedTriggerHistory = this.mismatchedTableName.get(data.getTableName())) == null) {
                        DataService.this.log.warn("There was a mismatch between the data table name {} and the trigger_hist table name {} for data_id {}.  Attempting to look up a valid trigger_hist row by table name", new Object[]{data.getTableName(), triggerHistory.getSourceTableName(), data.getDataId()});
                        triggerHistory = this.findOrCreateTriggerHistory(tableName, triggerHistId, data, true);
                        this.mismatchedTableName.put(data.getTableName(), triggerHistory);
                    } else {
                        triggerHistory = cachedTriggerHistory;
                    }
                }
                data.setTriggerHistory(triggerHistory);
            }
            data.setPreRouted(row.getBoolean("IS_PREROUTED"));
            return data;
        }

        private TriggerHistory findOrCreateTriggerHistory(String tableName, int triggerHistId, Data data, boolean isExistingTriggerHist) {
            TriggerHistory triggerHistory = null;
            Trigger trigger = null;
            Table table = null;
            long dataId = data.getDataId();
            triggerHistory = this.remappedTriggerHistIds.get(triggerHistId);
            if (triggerHistory != null) {
                return triggerHistory;
            }
            if (this.triggerRouters == null) {
                this.triggerRouters = DataService.this.engine.getTriggerRouterService().getAllTriggerRoutersForCurrentNode(DataService.this.engine.getNodeService().findIdentity().getNodeGroupId());
            }
            for (TriggerRouter triggerRouter : this.triggerRouters) {
                if (!triggerRouter.isEnabled() || !triggerRouter.getTrigger().getSourceTableName().equalsIgnoreCase(tableName)) continue;
                trigger = triggerRouter.getTrigger();
                table = DataService.this.platform.getTableFromCache(trigger.getSourceCatalogName(), trigger.getSourceSchemaName(), tableName, false);
                break;
            }
            if (table != null && trigger != null) {
                if (this.activeTriggerHistories == null) {
                    this.activeTriggerHistories = DataService.this.engine.getTriggerRouterService().getActiveTriggerHistories();
                    this.allTriggerHistories = DataService.this.engine.getTriggerRouterService().getHistoryRecords().values();
                }
                if ((triggerHistory = this.findMatchingTriggerHistory(trigger, data, tableName)) == null) {
                    triggerHistory = new TriggerHistory(table, trigger, DataService.this.engine.getSymmetricDialect().getTriggerTemplate());
                    triggerHistory.setTriggerHistoryId(isExistingTriggerHist ? 0 : triggerHistId);
                    triggerHistory.setLastTriggerBuildReason(TriggerReBuildReason.TRIGGER_HIST_MISSING);
                    ArrayList<String> triggerNamesGeneratedThisSession = new ArrayList<String>();
                    triggerHistory.setNameForInsertTrigger(DataService.this.engine.getTriggerRouterService().getTriggerName(DataEventType.INSERT, DataService.this.symmetricDialect.getMaxTriggerNameLength(), trigger, table, this.activeTriggerHistories, null, triggerNamesGeneratedThisSession));
                    triggerHistory.setNameForUpdateTrigger(DataService.this.engine.getTriggerRouterService().getTriggerName(DataEventType.UPDATE, DataService.this.symmetricDialect.getMaxTriggerNameLength(), trigger, table, this.activeTriggerHistories, null, triggerNamesGeneratedThisSession));
                    triggerHistory.setNameForDeleteTrigger(DataService.this.engine.getTriggerRouterService().getTriggerName(DataEventType.DELETE, DataService.this.symmetricDialect.getMaxTriggerNameLength(), trigger, table, this.activeTriggerHistories, null, triggerNamesGeneratedThisSession));
                    DataService.this.log.warn("Could not find trigger history {} for table {} for data_id {}.  Generating a new trigger history row.", new Object[]{triggerHistId, tableName, dataId});
                    DataService.this.engine.getTriggerRouterService().insert(triggerHistory);
                    this.activeTriggerHistories.add(triggerHistory);
                    this.allTriggerHistories.add(triggerHistory);
                } else {
                    this.remappedTriggerHistIds.put(triggerHistId, triggerHistory);
                    DataService.this.log.warn("Could not find trigger history {} for table {} for data_id {}.  Using trigger hist {} instead.", new Object[]{triggerHistId, tableName, dataId, triggerHistory.getTriggerHistoryId()});
                }
            } else {
                if (this.missingConfigTriggerHist == null) {
                    this.missingConfigTriggerHist = new HashSet();
                }
                if (this.missingConfigTriggerHist.add(triggerHistId)) {
                    DataService.this.log.warn("Could not find trigger history {} for table {} for data_id {}.  Table is not configured to sync, so ignoring it.", new Object[]{triggerHistId, tableName, dataId});
                }
                triggerHistory = new TriggerHistory(tableName, "", "");
                triggerHistory.setTriggerHistoryId(triggerHistId);
            }
            return triggerHistory;
        }

        private TriggerHistory findMatchingTriggerHistory(Trigger trigger, Data data, String tableName) {
            TriggerHistory triggerHistory = null;
            int columnCount = 0;
            int pkColumnCount = 0;
            if (data.getDataEventType() == DataEventType.INSERT || data.getDataEventType() == DataEventType.UPDATE) {
                String[] rowData = data.getParsedData("rowData");
                if (rowData == null && (data = this.findData(data.getDataId())) != null) {
                    rowData = data.getParsedData("rowData");
                }
                if (rowData != null) {
                    columnCount = rowData.length;
                }
            }
            if (data.getDataEventType() == DataEventType.DELETE || data.getDataEventType() == DataEventType.UPDATE) {
                String[] pkData = data.getParsedData("pkData");
                if (pkData == null && (data = this.findData(data.getDataId())) != null) {
                    pkData = data.getParsedData("pkData");
                }
                if (pkData != null) {
                    pkColumnCount = pkData.length;
                }
            }
            for (TriggerHistory hist : this.allTriggerHistories) {
                if (!hist.getTriggerId().equals(trigger.getTriggerId()) || !hist.getSourceTableName().equalsIgnoreCase(tableName) || columnCount != 0 && columnCount != hist.getParsedColumnNames().length || pkColumnCount != 0 && pkColumnCount != hist.getParsedPkColumnNames().length) continue;
                triggerHistory = hist;
                break;
            }
            if (triggerHistory == null) {
                for (TriggerHistory hist : this.activeTriggerHistories) {
                    if (!hist.getTriggerId().equals(trigger.getTriggerId()) || !hist.getSourceTableName().equalsIgnoreCase(tableName)) continue;
                    triggerHistory = hist;
                    break;
                }
            }
            return triggerHistory;
        }

        public Data findData(long dataId) {
            return (Data)DataService.this.sqlTemplateDirty.queryForObject(DataService.this.getSql("selectData", "whereDataId"), (ISqlRowMapper)new DataMapper(false), new Object[]{dataId});
        }
    }

    public static class LastCaptureByChannelMapper
    implements ISqlRowMapper<String> {
        private Map<String, Date> captureMap;

        public LastCaptureByChannelMapper(Map<String, Date> map) {
            this.captureMap = map;
        }

        public Map<String, Date> getCaptureMap() {
            return this.captureMap;
        }

        public String mapRow(Row row) {
            this.captureMap.put(row.getString("CHANNEL_ID"), row.getDateTime("CREATE_TIME"));
            return null;
        }
    }
}

