/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.service.IBandwidthService;
import org.jumpmind.symmetric.transport.BandwidthTestResults;
import org.jumpmind.symmetric.transport.IIncomingTransport;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.transport.http.HttpConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BandwidthService
implements IBandwidthService {
    public static final String Diagnostic_BandwidthFail = "Could not get Bandwidth";
    public static final String Diagnostic_BandwidthFailure = "%s";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ISymmetricEngine engine;

    public BandwidthService(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public double getDownloadKbpsFor(String syncUrl, long sampleSize, long maxTestDuration) {
        return this.getDownloadKbpsForImpl(syncUrl, null, null, sampleSize, maxTestDuration);
    }

    @Override
    public double getDownloadKbpsFor(Node remoteNode, Node localNode, long sampleSize, long maxTestDuration) {
        return this.getDownloadKbpsForImpl(remoteNode.getSyncUrl(), remoteNode, localNode, sampleSize, maxTestDuration);
    }

    protected double getDownloadKbpsForImpl(String syncUrl, Node remoteNode, Node localNode, long sampleSize, long maxTestDuration) {
        double downloadSpeed = -1.0;
        try {
            BandwidthTestResults bw = remoteNode != null && localNode != null ? this.getDownloadResultsFor(remoteNode, localNode, sampleSize, maxTestDuration) : this.getDownloadResultsFor(syncUrl, sampleSize, maxTestDuration);
            downloadSpeed = (int)bw.getKbps();
        }
        catch (SocketTimeoutException e) {
            this.log.warn("Socket timeout while attempting to contact {}", (Object)syncUrl);
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
        }
        return downloadSpeed;
    }

    protected BandwidthTestResults getDownloadResultsFor(String syncUrl, long sampleSize, long maxTestDuration) throws IOException {
        byte[] buffer = new byte[1024];
        BandwidthTestResults bw = new BandwidthTestResults();
        URL u = new URL(String.format("%s/bandwidth?direction=pull&sampleSize=%s", syncUrl, sampleSize));
        bw.start();
        try (HttpConnection conn = new HttpConnection(u);
             InputStream is = conn.getInputStream();){
            int r;
            while (-1 != (r = is.read(buffer)) && bw.getElapsed() <= maxTestDuration) {
                bw.transmitted(r);
            }
        }
        bw.stop();
        this.log.info("{} was calculated to have a download bandwidth of {} kbps", (Object)syncUrl, (Object)bw.getKbps());
        return bw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BandwidthTestResults getDownloadResultsFor(Node remoteNode, Node localNode, long sampleSize, long maxTestDuration) throws IOException {
        try (IIncomingTransport incoming = null;){
            NodeSecurity identitySecurity = this.engine.getNodeService().findNodeSecurity(localNode.getNodeId(), true);
            incoming = this.engine.getTransportManager().getBandwidthPullTransport(remoteNode, localNode, identitySecurity.getNodePassword(), new HashMap<String, String>(), this.engine.getParameterService().getRegistrationUrl(), sampleSize);
            byte[] buffer = new byte[1024];
            BandwidthTestResults bw = new BandwidthTestResults();
            bw.start();
            try (InputStream is = incoming.openStream();){
                int r;
                while (-1 != (r = is.read(buffer)) && bw.getElapsed() <= maxTestDuration) {
                    bw.transmitted(r);
                }
            }
            bw.stop();
            this.log.info("{} was calculated to have a download bandwidth of {} kbps", (Object)remoteNode.getSyncUrl(), (Object)bw.getKbps());
            BandwidthTestResults bandwidthTestResults = bw;
            return bandwidthTestResults;
        }
    }

    @Override
    public double getUploadKbpsFor(Node remoteNode, Node localNode, long sampleSize, long maxTestDuration) throws IOException {
        double uploadSpeed = -1.0;
        try {
            BandwidthTestResults bwtr = this.getUploadResultsFor(remoteNode, localNode, sampleSize, maxTestDuration);
            uploadSpeed = bwtr.getKbps();
        }
        catch (SocketTimeoutException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return uploadSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BandwidthTestResults getUploadResultsFor(Node remoteNode, Node localNode, long sampleSize, long maxTestDuration) throws IOException {
        try (IOutgoingTransport outgoing = null;){
            NodeSecurity identitySecurity = this.engine.getNodeService().findNodeSecurity(localNode.getNodeId(), true);
            outgoing = this.engine.getTransportManager().getBandwidthPushTransport(remoteNode, localNode, identitySecurity.getNodePassword(), new HashMap<String, String>(), this.engine.getParameterService().getRegistrationUrl());
            outgoing.getSuspendIgnoreChannelLists(this.engine.getConfigurationService(), "default", remoteNode);
            long startTime = System.currentTimeMillis();
            BufferedWriter writer = outgoing.openWriter();
            String stringToWriter = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
            for (long i = 0L; i < sampleSize; i += (long)stringToWriter.length()) {
                writer.write(stringToWriter);
                if (System.currentTimeMillis() - startTime <= maxTestDuration) continue;
            }
            String response = outgoing.readResponse().readLine();
            BandwidthTestResults results = (BandwidthTestResults)new Gson().fromJson(response, BandwidthTestResults.class);
            this.log.info("{} was calculated to have a upload bandwidth of {} kbps", (Object)remoteNode.getSyncUrl(), (Object)results.getKbps());
            BandwidthTestResults bandwidthTestResults = results;
            return bandwidthTestResults;
        }
    }

    @Override
    public List<BandwidthResults> diagnoseDownloadBandwidth(Node localNode, Node remoteNode) {
        ArrayList<Long> downloadPayloadsList = new ArrayList<Long>();
        ArrayList<BandwidthResults> downloadBandwidthResultsList = new ArrayList<BandwidthResults>();
        String downloadPayloads = this.engine.getParameterService().getString("console.node.connection.diagnostic.download.bandwidth.payloads", "");
        if (downloadPayloads != null && downloadPayloads.length() > 0) {
            for (String s : Arrays.asList(downloadPayloads.split(","))) {
                downloadPayloadsList.add(Long.valueOf(s));
            }
        }
        for (Long payload : downloadPayloadsList) {
            BandwidthResults bw = (BandwidthService)this.engine.getBandwidthService().new BandwidthResults();
            bw.setPayloadSize(payload);
            double dlSpeed = 0.0;
            if (this.isPullEnabled(localNode, remoteNode)) {
                try {
                    dlSpeed = this.engine.getBandwidthService().getDownloadKbpsFor(remoteNode, localNode, payload, 5000L);
                    bw.setKbps(dlSpeed);
                }
                catch (Exception e) {
                    bw.setFailure(true);
                    bw.setFailureMessage(Diagnostic_BandwidthFail);
                    bw.setException(e);
                }
            } else {
                bw.setFailure(true);
                bw.setFailureMessage("Pull is not enabled");
            }
            downloadBandwidthResultsList.add(bw);
        }
        return downloadBandwidthResultsList;
    }

    protected boolean isPullEnabled(Node localNode, Node remoteNode) {
        List<NodeGroupLink> groupLinks = this.engine.getConfigurationService().getNodeGroupLinks(false);
        for (NodeGroupLink link : groupLinks) {
            if (!link.getSourceNodeGroupId().equals(remoteNode.getNodeGroupId()) || !link.getTargetNodeGroupId().equals(localNode.getNodeGroupId()) || !link.getDataEventAction().getShortName().equals("pull")) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BandwidthResults> diagnoseUploadBandwidth(Node localNode, Node remoteNode) {
        ArrayList<Long> uploadPayloadsList = new ArrayList<Long>();
        ArrayList<BandwidthResults> uploadBandwidthResultsList = new ArrayList<BandwidthResults>();
        String uploadPayloads = this.engine.getParameterService().getString("console.node.connection.diagnostic.upload.bandwidth.payloads", "");
        if (uploadPayloads != null && uploadPayloads.length() > 0) {
            for (String s : Arrays.asList(uploadPayloads.split(","))) {
                uploadPayloadsList.add(Long.valueOf(s));
            }
        }
        for (Long payload : uploadPayloadsList) {
            BandwidthResults bw = (BandwidthService)this.engine.getBandwidthService().new BandwidthResults();
            bw.setPayloadSize(payload);
            double dlSpeed = 0.0;
            if (this.isPushEnabled(localNode, remoteNode)) {
                try {
                    dlSpeed = this.engine.getBandwidthService().getUploadKbpsFor(remoteNode, localNode, payload, 5000L);
                    bw.setKbps(dlSpeed);
                }
                catch (Exception e) {
                    bw.setFailure(true);
                    bw.setFailureMessage(Diagnostic_BandwidthFail);
                    bw.setException(e);
                }
            } else {
                bw.setFailure(true);
                bw.setFailureMessage("Push is not enabled");
            }
            uploadBandwidthResultsList.add(bw);
        }
        return uploadBandwidthResultsList;
    }

    protected boolean isPushEnabled(Node localNode, Node remoteNode) {
        List<NodeGroupLink> groupLinks = this.engine.getConfigurationService().getNodeGroupLinks(false);
        for (NodeGroupLink link : groupLinks) {
            if (!link.getSourceNodeGroupId().equals(localNode.getNodeGroupId()) || !link.getTargetNodeGroupId().equals(remoteNode.getNodeGroupId()) || !link.getDataEventAction().getShortName().equals("push")) continue;
            return true;
        }
        return false;
    }

    public class BandwidthResults {
        private long payloadSize;
        private double kbps;
        private boolean failure = false;
        private String failureMessage = null;
        private Exception exception = null;

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public boolean isFailure() {
            return this.failure;
        }

        public void setFailure(boolean failure) {
            this.failure = failure;
        }

        public String getFailureMessage() {
            return this.failureMessage;
        }

        public void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public long getPayloadSize() {
            return this.payloadSize;
        }

        public void setPayloadSize(long payloadSize) {
            this.payloadSize = payloadSize;
        }

        public double getKbps() {
            return this.kbps;
        }

        public void setKbps(double kbps) {
            this.kbps = kbps;
        }
    }
}

