/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route.parse;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jumpmind.symmetric.route.parse.DBFException;

public class DBFField {
    private String name;
    private char type;
    private int length;
    private int decimalCount;
    private boolean validate;

    public DBFField(boolean validate, String s, char c, int i, int j) throws DBFException {
        this.validate = validate;
        if (this.validate) {
            if (s.length() > 10) {
                throw new DBFException("The field name is more than 10 characters long: " + s);
            }
            if (c != 'C' && c != 'N' && c != 'L' && c != 'D' && c != 'F') {
                throw new DBFException("The field type is not a valid. Got: " + c);
            }
            if (i < 1) {
                throw new DBFException("The field length should be a positive integer. Got: " + i);
            }
            if (c == 'C' && i >= 255) {
                throw new DBFException("The field length should be less than 255 characters for character fields. Got: " + i);
            }
            if (c == 'N' && i >= 21) {
                throw new DBFException("The field length should be less than 21 digits for numeric fields. Got: " + i);
            }
            if (c == 'L' && i != 1) {
                throw new DBFException("The field length should be 1 characater for logical fields. Got: " + i);
            }
            if (c == 'D' && i != 8) {
                throw new DBFException("The field length should be 8 characaters for date fields. Got: " + i);
            }
            if (c == 'F' && i >= 21) {
                throw new DBFException("The field length should be less than 21 digits for floating point fields. Got: " + i);
            }
            if (j < 0) {
                throw new DBFException("The field decimal count should not be a negative integer. Got: " + j);
            }
            if ((c == 'C' || c == 'L' || c == 'D') && j != 0) {
                throw new DBFException("The field decimal count should be 0 for character, logical, and date fields. Got: " + j);
            }
            if (j > i - 1) {
                throw new DBFException("The field decimal count should be less than the length - 1. Got: " + j);
            }
        }
        this.name = s;
        this.type = c;
        this.length = i;
        this.decimalCount = j;
    }

    public String getName() {
        return this.name;
    }

    public char getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getDecimalCount() {
        return this.decimalCount;
    }

    public String format(Object obj) throws DBFException {
        if (this.type == 'N' || this.type == 'F') {
            if (obj == null) {
                obj = 0.0;
            }
            if (obj instanceof Number) {
                Number number = (Number)obj;
                StringBuffer stringbuffer = new StringBuffer(this.getLength());
                for (int i = 0; i < this.getLength(); ++i) {
                    stringbuffer.append("#");
                }
                if (this.getDecimalCount() > 0) {
                    stringbuffer.setCharAt(this.getLength() - this.getDecimalCount() - 1, '.');
                }
                DecimalFormat decimalformat = new DecimalFormat(stringbuffer.toString());
                String s1 = decimalformat.format(number);
                int k = this.getLength() - s1.length();
                if (k < 0) {
                    throw new DBFException("Value " + String.valueOf(number) + " cannot fit in pattern: '" + String.valueOf(stringbuffer) + "'.");
                }
                StringBuffer stringbuffer2 = new StringBuffer(k);
                for (int l = 0; l < k; ++l) {
                    stringbuffer2.append(" ");
                }
                return String.valueOf(stringbuffer2) + s1;
            }
            throw new DBFException("Expected a Number, got " + String.valueOf(obj.getClass()) + ".");
        }
        if (this.type == 'C') {
            if (obj == null) {
                obj = "";
            }
            if (obj instanceof String) {
                String s = (String)obj;
                if (s.length() > this.getLength()) {
                    throw new DBFException("'" + String.valueOf(obj) + "' is longer than " + this.getLength() + " characters.");
                }
                StringBuffer stringbuffer1 = new StringBuffer(this.getLength() - s.length());
                for (int j = 0; j < this.getLength() - s.length(); ++j) {
                    stringbuffer1.append(' ');
                }
                return s + String.valueOf(stringbuffer1);
            }
            throw new DBFException("Expected a String, got " + String.valueOf(obj.getClass()) + ".");
        }
        if (this.type == 'L') {
            if (obj == null) {
                obj = false;
            }
            if (obj instanceof Boolean) {
                Boolean boolean1 = (Boolean)obj;
                return boolean1 != false ? "Y" : "N";
            }
            throw new DBFException("Expected a Boolean, got " + String.valueOf(obj.getClass()) + ".");
        }
        if (this.type == 'D') {
            if (obj == null) {
                obj = new Date();
            }
            if (obj instanceof Date) {
                Date date = (Date)obj;
                SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyyMMdd");
                return simpledateformat.format(date);
            }
            throw new DBFException("Expected a Date, got " + String.valueOf(obj.getClass()) + ".");
        }
        throw new DBFException("Unrecognized DBFField type: " + this.type);
    }

    public Object parse(String s) throws DBFException {
        s = s.trim();
        if (this.type == 'N' || this.type == 'F') {
            if (s.equals("")) {
                s = "0";
            }
            try {
                if (this.getDecimalCount() == 0) {
                    return Long.valueOf(s);
                }
                return Double.valueOf(s);
            }
            catch (NumberFormatException numberformatexception) {
                throw new DBFException(numberformatexception);
            }
        }
        if (this.type == 'C') {
            return s;
        }
        if (this.type == 'L') {
            if (s.equals("Y") || s.equals("y") || s.equals("T") || s.equals("t")) {
                return true;
            }
            if (s.equals("N") || s.equals("n") || s.equals("F") || s.equals("f")) {
                return false;
            }
            throw new DBFException("Unrecognized value for logical field: " + s);
        }
        if (this.type == 'D') {
            SimpleDateFormat simpledateformat = new SimpleDateFormat("yyyyMMdd");
            try {
                if ("".equals(s)) {
                    return null;
                }
                return simpledateformat.parse(s);
            }
            catch (ParseException parseexception) {
                throw new DBFException(parseexception);
            }
        }
        throw new DBFException("Unrecognized DBFField type: " + this.type);
    }

    public String toString() {
        return this.name;
    }
}

