/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.SyntaxParsingException;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupTableDataRouter
extends AbstractDataRouter
implements IDataRouter,
IBuiltInExtensionPoint {
    private static final Logger log = LoggerFactory.getLogger(LookupTableDataRouter.class);
    public static final String PARAM_LOOKUP_TABLE = "LOOKUP_TABLE";
    public static final String PARAM_KEY_COLUMN = "KEY_COLUMN";
    public static final String PARAM_MAPPED_KEY_COLUMN = "LOOKUP_KEY_COLUMN";
    public static final String PARAM_EXTERNAL_ID_COLUMN = "EXTERNAL_ID_COLUMN";
    public static final String PARAM_ALL_NODES_VALUE = "ALL_NODES_VALUE";
    static final String EXPRESSION_KEY = String.format("%s.Expression.", LookupTableDataRouter.class.getName());
    static final String LOOKUP_TABLE_KEY = String.format("%s.Table.", LookupTableDataRouter.class.getName());
    private ISymmetricDialect symmetricDialect;

    public LookupTableDataRouter(ISymmetricDialect symmetricDialect) {
        this.symmetricDialect = symmetricDialect;
    }

    public LookupTableDataRouter() {
    }

    @Override
    public Set<String> routeToNodes(SimpleRouterContext routingContext, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        Set<String> nodeIds = null;
        if (initialLoadSelectUsed && initialLoad) {
            nodeIds = this.toNodeIds(nodes, null);
        } else {
            Router router = dataMetaData.getRouter();
            Map<String, String> params = null;
            params = this.getParams(router, routingContext);
            Map<String, String> dataMap = this.getDataMap(dataMetaData, this.symmetricDialect);
            Map<String, Set<String>> lookupTable = this.getLookupTable(params, router, routingContext);
            String column = params.get(PARAM_KEY_COLUMN);
            if (dataMap.containsKey(column)) {
                String keyData = dataMap.get(column);
                Set<String> externalIds = lookupTable.get(keyData);
                if (externalIds != null) {
                    for (Node node : nodes) {
                        if (!externalIds.contains(node.getExternalId()) && !externalIds.contains(params.get(PARAM_ALL_NODES_VALUE))) continue;
                        nodeIds = this.addNodeId(node.getNodeId(), nodeIds, nodes);
                    }
                } else if (Strings.CS.equals(keyData, params.get(PARAM_ALL_NODES_VALUE))) {
                    for (Node node : nodes) {
                        nodeIds = this.addNodeId(node.getNodeId(), nodeIds, nodes);
                    }
                }
            } else {
                log.error("Could not route data with an id of {} using the {} router because the column {} was not captured for the {} table", new Object[]{dataMetaData.getData().getDataId(), this.getClass().getSimpleName(), column, dataMetaData.getTable().getName()});
            }
        }
        return nodeIds;
    }

    protected Map<String, String> getParams(Router router, SimpleRouterContext routingContext) {
        String KEY = EXPRESSION_KEY + router.getRouterId();
        Map<String, String> params = (Map<String, String>)routingContext.getContextCache().get(KEY);
        if (params == null) {
            params = this.parse(router.getRouterExpression());
            routingContext.getContextCache().put(KEY, params);
        }
        return params;
    }

    public Map<String, String> parse(String routerExpression) throws SyntaxParsingException {
        boolean valid = true;
        HashMap<String, String> params = new HashMap<String, String>();
        if (!StringUtils.isBlank((CharSequence)routerExpression)) {
            String[] expTokens = routerExpression.split("\\s");
            if (expTokens != null) {
                for (String t : expTokens) {
                    if (StringUtils.isBlank((CharSequence)t)) continue;
                    String[] tokens = t.split("=");
                    if (tokens.length == 2 && !params.containsKey(tokens[0].trim())) {
                        String token1 = tokens[1].trim();
                        if (token1.equalsIgnoreCase("null")) {
                            token1 = null;
                        }
                        params.put(tokens[0].trim(), token1);
                        continue;
                    }
                    valid = false;
                    break;
                }
                if (!(valid && params.size() >= 4 && params.size() <= 5 && params.containsKey(PARAM_LOOKUP_TABLE) && params.containsKey(PARAM_KEY_COLUMN) && params.containsKey(PARAM_MAPPED_KEY_COLUMN) && params.containsKey(PARAM_EXTERNAL_ID_COLUMN))) {
                    log.warn("The provided lookup table router expression was invalid. The full expression is " + routerExpression + ".");
                    throw new SyntaxParsingException("The provided lookup table router expression was invalid. The full expression is " + routerExpression + ".", new Object[0]);
                }
            }
        } else {
            log.warn("The provided lookup table router expression is empty");
        }
        return params;
    }

    protected Map<String, Set<String>> getLookupTable(Map<String, String> params, Router router, SimpleRouterContext routingContext) {
        String CTX_CACHE_KEY = LOOKUP_TABLE_KEY + "." + params.get(PARAM_LOOKUP_TABLE);
        HashMap<String, Set<String>> lookupMap = (HashMap<String, Set<String>>)routingContext.getContextCache().get(CTX_CACHE_KEY);
        if (lookupMap == null) {
            ISqlTemplate template = this.symmetricDialect.getTargetPlatform().getSqlTemplate();
            HashMap<String, Set<String>> fillMap = new HashMap<String, Set<String>>();
            RowMapper rowMapper = new RowMapper(fillMap, params);
            template.query(String.format("select %s, %s from %s", params.get(PARAM_MAPPED_KEY_COLUMN), params.get(PARAM_EXTERNAL_ID_COLUMN), params.get(PARAM_LOOKUP_TABLE)), (ISqlRowMapper)rowMapper, new Object[0]);
            if (System.currentTimeMillis() - rowMapper.getTs() > 10000L) {
                log.info("Done querying table {} for {} seconds, {} rows, and {} bytes", new Object[]{params.get(PARAM_LOOKUP_TABLE), (System.currentTimeMillis() - rowMapper.getTs()) / 1000L, rowMapper.getNumRows(), rowMapper.getBytes()});
            }
            lookupMap = fillMap;
            routingContext.getContextCache().put(CTX_CACHE_KEY, lookupMap);
        }
        return lookupMap;
    }

    protected class RowMapper
    implements ISqlRowMapper<Object> {
        private long numRows;
        private long bytes;
        private long tenSecondTimer;
        private long ts;
        private final Map<String, String> params;
        private Map<String, Set<String>> fillMap;

        public RowMapper(Map<String, Set<String>> fillMap, Map<String, String> params) {
            this.fillMap = fillMap;
            this.params = params;
            this.numRows = 0L;
            this.bytes = 0L;
            this.tenSecondTimer = System.currentTimeMillis();
            this.ts = System.currentTimeMillis();
        }

        public long getNumRows() {
            return this.numRows;
        }

        public long getBytes() {
            return this.bytes;
        }

        public long getTs() {
            return this.ts;
        }

        public Object mapRow(Row rs) {
            Set<String> ids;
            ++this.numRows;
            String key = rs.getString(this.params.get(LookupTableDataRouter.PARAM_MAPPED_KEY_COLUMN));
            String value = rs.getString(this.params.get(LookupTableDataRouter.PARAM_EXTERNAL_ID_COLUMN));
            this.bytes += (long)value.getBytes(Charset.defaultCharset()).length;
            if (System.currentTimeMillis() - this.tenSecondTimer > 10000L) {
                log.info("Querying table {} for {} seconds, {} rows, and {} bytes", new Object[]{this.params.get(LookupTableDataRouter.PARAM_LOOKUP_TABLE), (System.currentTimeMillis() - this.ts) / 1000L, this.numRows, this.bytes});
                this.tenSecondTimer = System.currentTimeMillis();
            }
            if ((ids = this.fillMap.get(key)) == null) {
                ids = new HashSet<String>();
                this.fillMap.put(key, ids);
                this.bytes += key == null ? 0L : (long)key.getBytes(Charset.defaultCharset()).length;
            }
            ids.add(value);
            return value;
        }
    }
}

