/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.route.AbstractDataGapRouteCursor;
import org.jumpmind.symmetric.route.ChannelRouterContext;
import org.jumpmind.symmetric.route.DataGapRouteCursor;
import org.jumpmind.symmetric.route.DataGapRouteMultiCursor;
import org.jumpmind.symmetric.route.IDataToRouteReader;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DataGapRouteReader
implements IDataToRouteReader {
    private static final Logger log = LoggerFactory.getLogger(DataGapRouteReader.class);
    protected List<DataGap> dataGaps;
    protected DataGap currentGap;
    protected BlockingQueue<Data> dataQueue;
    protected ChannelRouterContext context;
    protected ISymmetricEngine engine;
    protected volatile boolean reading = true;
    protected int peekAheadCount = 1000;
    protected int takeTimeout;
    protected ProcessInfo processInfo;
    protected double percentOfHeapToUse = 0.5;
    protected long peekAheadSizeInBytes = 0L;
    protected boolean finishTransactionMode = false;
    protected boolean isEachGapQueried;
    protected boolean isOracleNoOrder;
    protected String lastTransactionId = null;
    protected long lastStatsPrintOutBaselineInMs = System.currentTimeMillis();

    public DataGapRouteReader(ChannelRouterContext context, ISymmetricEngine engine) {
        this.engine = engine;
        IParameterService parameterService = engine.getParameterService();
        this.peekAheadCount = parameterService.getInt("routing.peek.ahead.window.after.max.size");
        this.percentOfHeapToUse = (double)parameterService.getInt("routing.peek.ahead.memory.threshold.percent") / 100.0;
        this.takeTimeout = engine.getParameterService().getInt("routing.wait.for.data.timeout.seconds", 330);
        this.dataQueue = parameterService.is("jobs.synchronized.enable") ? new LinkedBlockingQueue<Data>() : new LinkedBlockingQueue<Data>(this.peekAheadCount);
        this.context = context;
    }

    @Override
    public void run() {
        try {
            MDC.put((String)"engineName", (String)this.engine.getParameterService().getEngineName());
            this.execute();
        }
        catch (Throwable ex) {
            log.error("", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        ISymmetricDialect symmetricDialect = this.engine.getSymmetricDialect();
        AbstractDataGapRouteCursor cursor = null;
        this.processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(this.engine.getNodeService().findIdentityNodeId(), this.context.getChannel().getChannelId(), null, ProcessType.ROUTER_READER));
        this.processInfo.setCurrentChannelId(this.context.getChannel().getChannelId());
        try {
            boolean transactional = !this.context.getChannel().getBatchAlgorithm().equals("nontransactional") || !symmetricDialect.supportsTransactionId();
            this.processInfo.setStatus(ProcessInfo.ProcessStatus.QUERYING);
            cursor = this.engine.getParameterService().is("routing.data.reader.use.multiple.queries") ? new DataGapRouteMultiCursor(this.context, this.engine) : new DataGapRouteCursor(this.context, this.engine);
            this.isOracleNoOrder = cursor.isOracleNoOrder();
            this.isEachGapQueried = cursor.isEachGapQueried();
            if (this.isOracleNoOrder) {
                this.dataGaps = this.context.getDataGaps();
            } else if (!this.isEachGapQueried) {
                this.dataGaps = new ArrayList<DataGap>(this.context.getDataGaps());
                this.currentGap = this.dataGaps.remove(0);
            }
            this.processInfo.setStatus(ProcessInfo.ProcessStatus.EXTRACTING);
            if (transactional) {
                this.executeTransactional(cursor);
            } else {
                this.executeNonTransactional(cursor);
            }
            this.processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
        }
        catch (Throwable ex) {
            this.processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
            if (!this.context.isOverrideContainsBigLob() && this.engine.getSqlTemplate().isDataTruncationViolation(ex)) {
                log.warn(ex.getMessage());
                log.info("Re-attempting routing with contains_big_lobs temporarily enabled for channel {}", (Object)this.context.getChannel().getChannelId());
                this.context.setOverrideContainsBigLob(true);
                this.execute();
            } else {
                log.error("Failed to read data for routing", ex);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.copyToQueue(new EOD());
            this.reading = false;
        }
    }

    protected void executeTransactional(ISqlReadCursor<Data> cursor) throws Exception {
        long maxPeekAheadSizeInBytes = (long)((double)Runtime.getRuntime().maxMemory() * this.percentOfHeapToUse);
        int lastPeekAheadIndex = 0;
        int dataCount = 0;
        long maxDataToRoute = this.context.getChannel().getMaxDataToRoute();
        ArrayList<Data> peekAheadQueue = new ArrayList<Data>(this.peekAheadCount);
        boolean moreData = true;
        while ((long)dataCount < maxDataToRoute || this.lastTransactionId != null) {
            if (moreData && (this.lastTransactionId != null || peekAheadQueue.size() == 0)) {
                moreData = this.fillPeekAheadQueue(peekAheadQueue, this.peekAheadCount, cursor);
            }
            int dataWithSameTransactionIdCount = 0;
            while (peekAheadQueue.size() > 0 && this.lastTransactionId == null && (long)dataCount < maxDataToRoute) {
                Data data = (Data)peekAheadQueue.remove(0);
                this.copyToQueue(data);
                ++dataCount;
                this.processInfo.incrementCurrentDataCount();
                this.processInfo.setCurrentTableName(data.getTableName());
                this.lastTransactionId = data.getTransactionId();
                ++dataWithSameTransactionIdCount;
            }
            if (this.lastTransactionId != null && peekAheadQueue.size() > 0) {
                Iterator datas = peekAheadQueue.iterator();
                int index = 0;
                while (datas.hasNext()) {
                    Data data = (Data)datas.next();
                    if (this.lastTransactionId.equals(data.getTransactionId())) {
                        ++dataWithSameTransactionIdCount;
                        datas.remove();
                        this.copyToQueue(data);
                        ++dataCount;
                        this.processInfo.incrementCurrentDataCount();
                        this.processInfo.setCurrentTableName(data.getTableName());
                        lastPeekAheadIndex = index;
                        continue;
                    }
                    ++index;
                }
                if (dataWithSameTransactionIdCount == 0 || peekAheadQueue.size() - lastPeekAheadIndex > this.peekAheadCount) {
                    this.lastTransactionId = null;
                    lastPeekAheadIndex = 0;
                }
            }
            if (!moreData && peekAheadQueue.size() == 0) break;
            if (this.peekAheadSizeInBytes < maxPeekAheadSizeInBytes) continue;
            log.info("The peek ahead queue has reached its max size of {} bytes.  Finishing reading the current transaction", (Object)this.peekAheadSizeInBytes);
            this.finishTransactionMode = true;
            peekAheadQueue.clear();
        }
    }

    protected void executeNonTransactional(ISqlReadCursor<Data> cursor) throws Exception {
        long maxDataToRoute = this.context.getChannel().getMaxDataToRoute();
        ArrayList<Data> peekAheadQueue = new ArrayList<Data>(this.peekAheadCount);
        int dataCount = 0;
        while ((long)dataCount < maxDataToRoute) {
            this.fillPeekAheadQueue(peekAheadQueue, this.peekAheadCount, cursor);
            if (peekAheadQueue.size() <= 0) break;
            while (peekAheadQueue.size() > 0 && (long)dataCount < maxDataToRoute) {
                Data data = (Data)peekAheadQueue.remove(0);
                this.copyToQueue(data);
                ++dataCount;
                this.processInfo.incrementCurrentDataCount();
                this.processInfo.setCurrentTableName(data.getTableName());
            }
        }
    }

    protected boolean process(Data data) {
        long dataId = data.getDataId();
        boolean okToProcess = false;
        if (!this.finishTransactionMode || this.lastTransactionId != null && this.finishTransactionMode && this.lastTransactionId.equals(data.getTransactionId())) {
            if (this.isEachGapQueried) {
                okToProcess = true;
            } else if (this.isOracleNoOrder) {
                okToProcess = this.isInDataGap(dataId);
            } else {
                while (!okToProcess && this.currentGap != null && dataId >= this.currentGap.getStartId()) {
                    if (dataId <= this.currentGap.getEndId()) {
                        okToProcess = true;
                        continue;
                    }
                    if (this.dataGaps.size() > 0) {
                        this.currentGap = this.dataGaps.remove(0);
                        continue;
                    }
                    this.currentGap = null;
                }
            }
        }
        return okToProcess;
    }

    protected boolean isInDataGap(long dataId) {
        int start = 0;
        int end = this.dataGaps.size() - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            DataGap midGap = this.dataGaps.get(mid);
            if (dataId >= midGap.getStartId() && dataId <= midGap.getEndId()) {
                return true;
            }
            if (dataId < midGap.getStartId()) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        return false;
    }

    @Override
    public Data take() throws InterruptedException {
        Data data = null;
        do {
            if ((data = this.dataQueue.poll(this.takeTimeout, TimeUnit.SECONDS)) == null && !this.reading) {
                throw new SymmetricException("The read of the data to route queue has timed out", new Object[0]);
            }
            if (!(data instanceof EOD)) continue;
            data = null;
            break;
        } while (data == null && this.reading);
        return data;
    }

    protected boolean fillPeekAheadQueue(List<Data> peekAheadQueue, int peekAheadCount, ISqlReadCursor<Data> cursor) throws SQLException {
        boolean isFirstRead;
        boolean moreData = true;
        int dataCount = 0;
        long ts = System.currentTimeMillis();
        Data data = null;
        boolean bl = isFirstRead = this.context.getStartDataId() == 0L;
        while (this.reading && dataCount < peekAheadCount) {
            data = (Data)cursor.next();
            if (data != null) {
                if (this.process(data)) {
                    peekAheadQueue.add(data);
                    this.peekAheadSizeInBytes += data.getSizeInBytes();
                    ++dataCount;
                    this.context.incrementStat(System.currentTimeMillis() - ts, "data.read.total.time.ms");
                } else {
                    this.context.incrementDataRereadCount();
                    this.context.incrementStat(System.currentTimeMillis() - ts, "data.reread.time.ms");
                }
                if (isFirstRead) {
                    this.context.setStartDataId(data.getDataId());
                    isFirstRead = false;
                }
                this.context.setEndDataId(data.getDataId());
                ts = System.currentTimeMillis();
                long totalTimeInMs = System.currentTimeMillis() - this.lastStatsPrintOutBaselineInMs;
                if (totalTimeInMs <= 60000L) continue;
                log.info("Reading channel '{}' for {} seconds, dataCount={}, dataRereadCount={}", new Object[]{this.context.getChannel().getChannelId(), (System.currentTimeMillis() - this.context.getCreatedTimeInMs()) / 1000L, (long)dataCount + this.context.getDataReadCount(), this.context.getDataRereadCount()});
                this.lastStatsPrintOutBaselineInMs = System.currentTimeMillis();
                continue;
            }
            moreData = false;
            break;
        }
        this.context.incrementDataReadCount(dataCount);
        this.context.incrementPeekAheadFillCount(1L);
        int size = peekAheadQueue.size();
        if (this.context.getMaxPeekAheadQueueSize() < (long)size) {
            this.context.setMaxPeekAheadQueueSize(size);
        }
        return moreData && this.reading;
    }

    protected void copyToQueue(Data data) {
        long ts = System.currentTimeMillis();
        this.peekAheadSizeInBytes -= data.getSizeInBytes();
        while (!this.dataQueue.offer(data) && this.reading) {
            AppUtils.sleep((long)50L);
        }
        this.context.incrementStat(System.currentTimeMillis() - ts, "data.enqueue.time.ms");
    }

    @Override
    public boolean isReading() {
        return this.reading;
    }

    @Override
    public void setReading(boolean reading) {
        this.reading = reading;
        if (this.processInfo != null && this.processInfo.getStatus() != ProcessInfo.ProcessStatus.ERROR) {
            this.processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
        }
    }

    public BlockingQueue<Data> getDataQueue() {
        return this.dataQueue;
    }

    static class EOD
    extends Data {
        private static final long serialVersionUID = 1L;

        EOD() {
        }
    }
}

