/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.ArrayList;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.route.AbstractDataGapRouteCursor;
import org.jumpmind.symmetric.route.ChannelRouterContext;

public class DataGapRouteMultiCursor
extends AbstractDataGapRouteCursor {
    protected int maxGapsToQualify;
    protected int gapIndex;
    protected int dataCount;
    protected int queryCount;
    protected int queryMillis;

    public DataGapRouteMultiCursor(ChannelRouterContext context, ISymmetricEngine engine) {
        super(context, engine);
        this.isEachGapQueried = true;
        this.maxGapsToQualify = this.parameterService.getInt("routing.max.gaps.to.qualify.in.sql", 100);
        this.cursor = this.prepareCursor();
    }

    @Override
    public Data next() {
        Data data = (Data)this.cursor.next();
        while (data == null && this.dataGaps.size() - this.gapIndex > 0) {
            this.cursor.close();
            this.cursor = this.prepareCursor();
            data = (Data)this.cursor.next();
        }
        if (data != null) {
            ++this.dataCount;
        }
        return data;
    }

    protected ISqlReadCursor<Data> prepareCursor() {
        int gapsRemaining = this.dataGaps.size() - this.gapIndex;
        int numberOfGaps = gapsRemaining > this.maxGapsToQualify ? this.maxGapsToQualify : gapsRemaining;
        int numberOfArgs = 1 + 2 * numberOfGaps;
        Object[] args = new Object[numberOfArgs];
        int[] types = new int[numberOfArgs];
        int dataIdSqlType = this.engine.getSymmetricDialect().getSqlTypeForIds();
        ArrayList<DataGap> gapsToQualify = new ArrayList<DataGap>();
        args[0] = this.context.getChannel().getChannelId();
        types[0] = 12;
        this.log.trace("Querying for gaps {} through {} of total {}", new Object[]{this.gapIndex + 1, this.gapIndex + numberOfGaps, this.dataGaps.size()});
        int i = 1;
        while (i + 1 < numberOfArgs && this.gapIndex < this.dataGaps.size()) {
            DataGap gap = (DataGap)this.dataGaps.get(this.gapIndex);
            args[i] = gap.getStartId();
            types[i] = dataIdSqlType;
            args[i + 1] = gap.getEndId();
            types[i + 1] = dataIdSqlType;
            gapsToQualify.add(gap);
            i += 2;
            ++this.gapIndex;
        }
        String sql = this.qualifyForOrder(this.qualifyUsingDataGaps(gapsToQualify, numberOfGaps, this.getSql("selectDataUsingGapsSql")));
        long ts = System.currentTimeMillis();
        ISqlReadCursor<Data> cursor = this.executeCursor(sql, args, types);
        this.queryMillis = (int)((long)this.queryMillis + (System.currentTimeMillis() - ts));
        ++this.queryCount;
        this.context.incrementStat(1L, "multi.query.count");
        return cursor;
    }

    @Override
    public void close() {
        super.close();
        String message = "Queried for {} gaps using {} queries with {} ms spent waiting on query executions";
        if (this.log.isDebugEnabled()) {
            this.log.debug(message, new Object[]{this.dataGaps.size(), this.queryCount, this.queryMillis});
        } else if (this.queryCount > 1 && this.queryMillis > 60000) {
            this.log.warn(message, new Object[]{this.dataGaps.size(), this.queryCount, this.queryMillis});
        }
    }
}

