/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.FileSnapshot;
import org.jumpmind.symmetric.model.FileTrigger;
import org.jumpmind.symmetric.model.FileTriggerRouter;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerReBuildReason;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.symmetric.service.IContextService;

public abstract class AbstractFileParsingRouter
extends AbstractDataRouter {
    public static final String TRIGGER_ID_FILE_PARSER = "SYM_VIRTUAL_FILE_PARSE_TRIGGER";
    public static final String EXTERNAL_DATA_ROUTER_KEY = "R";
    public static final String EXTERNAL_DATA_TRIGGER_KEY = "T";
    public static final String EXTERNAL_DATA_FILE_DATA_ID = "D";
    public static final String ROUTER_EXPRESSION_CHANNEL_KEY = "CHANNEL";
    public static final String ROUTER_EXPRESSION_INCLUDE_TRANSACTION_ID = "INCLUDE_TRANSACTION_ID";

    public abstract List<String> parse(File var1, int var2, int var3);

    public abstract String getColumnNames();

    public abstract ISymmetricEngine getEngine();

    @Override
    public Set<String> routeToNodes(SimpleRouterContext context, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        Map<String, String> newData = this.getNewDataAsString(null, dataMetaData, this.getEngine().getSymmetricDialect());
        String targetTableName = dataMetaData.getRouter().getTargetTableName();
        String fileName = newData.get("FILE_NAME");
        String relativeDir = newData.get("RELATIVE_DIR");
        String triggerId = newData.get("TRIGGER_ID");
        String lastEventType = newData.get("LAST_EVENT_TYPE");
        String routerExpression = dataMetaData.getRouter().getRouterExpression();
        String channelId = "default";
        boolean includeTransactionId = false;
        String filePath = relativeDir + "/" + fileName;
        IContextService contextService = this.getEngine().getContextService();
        if (lastEventType.equals(DataEventType.DELETE.toString())) {
            this.log.debug("File deleted (" + filePath + "), cleaning up context value.");
            contextService.delete(filePath);
        } else {
            if (routerExpression != null) {
                String[] keyValues = routerExpression.split(",");
                for (int i = 0; i < keyValues.length; ++i) {
                    String[] keyValue = keyValues[i].split("=");
                    if (keyValue.length <= 1) continue;
                    if (ROUTER_EXPRESSION_CHANNEL_KEY.equals(keyValue[0])) {
                        channelId = keyValue[1];
                        continue;
                    }
                    if (!ROUTER_EXPRESSION_INCLUDE_TRANSACTION_ID.equalsIgnoreCase(keyValue[0])) continue;
                    includeTransactionId = Boolean.valueOf(keyValue[1]);
                }
            }
            if (triggerId != null) {
                try {
                    String baseDir = this.getEngine().getFileSyncService().getFileTrigger(triggerId).getBaseDir();
                    File file = this.createSourceFile(baseDir, relativeDir, fileName);
                    String nodeList = this.buildNodeList(nodes);
                    String externalData = EXTERNAL_DATA_TRIGGER_KEY + "=" + triggerId + "," + EXTERNAL_DATA_ROUTER_KEY + "=" + dataMetaData.getRouter().getRouterId() + "," + EXTERNAL_DATA_FILE_DATA_ID + "=" + dataMetaData.getData().getDataId();
                    Map<Integer, String> tableNames = this.getTableNames(this.getTargetTableName(targetTableName, fileName), file);
                    int tableIndex = 0;
                    String transactionId = null;
                    if (includeTransactionId) {
                        transactionId = String.valueOf(System.currentTimeMillis());
                    }
                    for (Map.Entry<Integer, String> tableEntry : tableNames.entrySet()) {
                        String contextId = filePath + "[" + tableEntry.getValue() + "]";
                        Integer lineNumber = contextService.getString(contextId) == null ? 0 : Integer.valueOf(contextService.getString(contextId));
                        List<String> dataRows = this.parse(file, lineNumber, tableEntry.getKey());
                        String columnNames = this.getColumnNames();
                        for (String row : dataRows) {
                            Data data = new Data();
                            data.setChannelId(channelId);
                            data.setDataEventType(DataEventType.INSERT);
                            data.setRowData(row);
                            data.setTableName(tableEntry.getValue());
                            data.setNodeList(nodeList);
                            data.setTriggerHistory(this.getTriggerHistory(tableEntry.getValue(), columnNames));
                            data.setExternalData(externalData);
                            data.setDataId(this.getEngine().getDataService().insertData(data));
                            if (includeTransactionId) {
                                data.setTransactionId(transactionId);
                            }
                            Integer n = lineNumber;
                            lineNumber = lineNumber + 1;
                        }
                        if (!dataRows.isEmpty()) {
                            try {
                                contextService.save(contextId, lineNumber.toString());
                                if (tableNames.size() - 1 == tableIndex) {
                                    this.deleteFileIfNecessary(dataMetaData);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        this.log.info("Finished parsing file[table] " + fileName + "[" + tableEntry.getValue() + "]");
                        ++tableIndex;
                    }
                }
                catch (IOException ioe) {
                    this.log.error("Unable to load file", (Throwable)ioe);
                }
            }
        }
        return new HashSet<String>();
    }

    public Map<Integer, String> getTableNames(String tableName, File file) throws IOException {
        HashMap<Integer, String> tableNames = new HashMap<Integer, String>();
        tableNames.put(1, tableName);
        return tableNames;
    }

    public String getTargetTableName(String targetTableName, String fileName) {
        if (targetTableName == null) {
            targetTableName = fileName.substring(0, fileName.indexOf("."));
        }
        return targetTableName;
    }

    public String buildNodeList(Set<Node> nodes) {
        StringBuilder sb = new StringBuilder();
        for (Node n : nodes) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(n.getNodeId());
        }
        return sb.toString();
    }

    public Map<String, Integer> readStagingFile(IStagedResource resource) {
        HashMap<String, Integer> bookmarkMap = new HashMap<String, Integer>();
        try {
            String thisLine = null;
            if (resource.exists()) {
                while ((thisLine = resource.getReader().readLine()) != null) {
                    String[] split = thisLine.split("=");
                    if (split.length != 2) continue;
                    bookmarkMap.put(split[0].trim(), Integer.valueOf(split[1].trim()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bookmarkMap;
    }

    public File createSourceFile(String baseDir, String relativeDir, String fileName) {
        File sourceBaseDir = new File(baseDir);
        if (!relativeDir.equals(".")) {
            String sourcePath = relativeDir + "/";
            sourceBaseDir = new File(sourceBaseDir, sourcePath);
        }
        return new File(sourceBaseDir, fileName);
    }

    protected TriggerHistory getTriggerHistory(String tableName, String columnNames) {
        List<TriggerHistory> triggerHistories = this.getEngine().getTriggerRouterService().getActiveTriggerHistories(tableName);
        for (TriggerHistory history : triggerHistories) {
            if (!history.getTriggerId().equals(TRIGGER_ID_FILE_PARSER)) continue;
            return history;
        }
        TriggerHistory newTriggerHist = new TriggerHistory(tableName, "", columnNames);
        newTriggerHist.setTriggerId(TRIGGER_ID_FILE_PARSER);
        newTriggerHist.setTableHash(0);
        newTriggerHist.setTriggerRowHash(0L);
        newTriggerHist.setTriggerTemplateHash(0L);
        newTriggerHist.setLastTriggerBuildReason(TriggerReBuildReason.NEW_TRIGGERS);
        newTriggerHist.setColumnNames(columnNames);
        newTriggerHist.setPkColumnNames(columnNames);
        this.getEngine().getTriggerRouterService().insert(newTriggerHist);
        return newTriggerHist;
    }

    public static String getRouterIdFromExternalData(String externalData) {
        return AbstractFileParsingRouter.parseExternalData(externalData).get(EXTERNAL_DATA_ROUTER_KEY);
    }

    public static Map<String, String> parseExternalData(String externalData) {
        String[] keyValues;
        HashMap<String, String> result = new HashMap<String, String>();
        if (externalData != null && (keyValues = externalData.split(",")).length > 0) {
            for (int i = 0; i < keyValues.length; ++i) {
                String[] keyValue = keyValues[i].split("=");
                if (keyValue.length <= 1) continue;
                for (int j = 0; j < keyValue.length; ++j) {
                    result.put(keyValue[0], keyValue[1]);
                }
            }
        }
        return result;
    }

    public void deleteFileIfNecessary(DataMetaData dataMetaData) {
        Data data = dataMetaData.getData();
        Table snapshotTable = dataMetaData.getTable();
        if (data.getDataEventType() == DataEventType.INSERT || data.getDataEventType() == DataEventType.UPDATE) {
            ArrayList<File> filesToDelete = new ArrayList<File>();
            Map columnData = data.toColumnNameValuePairs(snapshotTable.getColumnNames(), "rowData");
            FileSnapshot fileSnapshot = new FileSnapshot();
            fileSnapshot.setTriggerId((String)columnData.get("TRIGGER_ID"));
            fileSnapshot.setRouterId((String)columnData.get("ROUTER_ID"));
            fileSnapshot.setFileModifiedTime(Long.parseLong((String)columnData.get("FILE_MODIFIED_TIME")));
            fileSnapshot.setFileName((String)columnData.get("FILE_NAME"));
            fileSnapshot.setRelativeDir((String)columnData.get("RELATIVE_DIR"));
            fileSnapshot.setLastEventType(FileSnapshot.LastEventType.fromCode((String)columnData.get("LAST_EVENT_TYPE")));
            FileTriggerRouter triggerRouter = this.getEngine().getFileSyncService().getFileTriggerRouter(fileSnapshot.getTriggerId(), fileSnapshot.getRouterId(), true);
            if (triggerRouter != null) {
                File file;
                FileTrigger fileTrigger = triggerRouter.getFileTrigger();
                if (fileTrigger.isDeleteAfterSync()) {
                    file = fileTrigger.createSourceFile(fileSnapshot);
                    if (!file.isDirectory()) {
                        filesToDelete.add(file);
                        if (fileTrigger.isSyncOnCtlFile()) {
                            ctlFile = this.getEngine().getFileSyncService().getControleFile(file);
                            filesToDelete.add(ctlFile);
                        }
                    }
                } else if (this.getEngine().getParameterService().is("file.sync.delete.ctl.file.after.sync", false) && !(file = fileTrigger.createSourceFile(fileSnapshot)).isDirectory() && fileTrigger.isSyncOnCtlFile()) {
                    ctlFile = this.getEngine().getFileSyncService().getControleFile(file);
                    filesToDelete.add(ctlFile);
                }
            }
            if (filesToDelete != null && filesToDelete.size() > 0) {
                for (File file : filesToDelete) {
                    if (file != null && file.exists()) {
                        this.log.debug("Deleting the '{}' file", (Object)file.getAbsolutePath());
                        boolean deleted = FileUtils.deleteQuietly((File)file);
                        if (!deleted) {
                            this.log.warn("Failed to 'delete on sync' the {} file", (Object)file.getAbsolutePath());
                        }
                    }
                    file = null;
                }
                filesToDelete = null;
            }
        }
    }
}

