/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trigger
implements IModelObject,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Trigger.class);
    private static final String DEFAULT_CONDITION = "1=1";
    private String triggerId;
    private String sourceTableName;
    private String sourceTableNameLowerCase;
    private String sourceSchemaName;
    private String sourceCatalogName;
    private boolean isSourceTableNameWildCarded;
    private boolean isSourceSchemaWildCarded;
    private boolean isSourceCatalogWildCarded;
    private boolean isSourceTableNameExpanded;
    private String sourceTableNameUnescaped;
    private String sourceSchemaNameUnescaped;
    private String sourceCatalogNameUnescaped;
    private String channelId = "default";
    private String reloadChannelId = "reload";
    private boolean syncOnUpdate = true;
    private boolean syncOnInsert = true;
    private boolean syncOnDelete = true;
    private boolean syncOnIncomingBatch = false;
    private boolean useStreamLobs = false;
    private boolean useCaptureLobs = false;
    private boolean useCaptureOldData = true;
    private boolean useHandleKeyUpdates = true;
    private boolean streamRow = false;
    private String nameForInsertTrigger;
    private String nameForUpdateTrigger;
    private String nameForDeleteTrigger;
    private String syncOnUpdateCondition = "1=1";
    private String syncOnInsertCondition = "1=1";
    private String syncOnDeleteCondition = "1=1";
    private String channelExpression = null;
    private String customBeforeUpdateText;
    private String customBeforeInsertText;
    private String customBeforeDeleteText;
    private String customOnUpdateText;
    private String customOnInsertText;
    private String customOnDeleteText;
    private String excludedColumnNames = null;
    private String includedColumnNames = null;
    private String syncKeyNames = null;
    private String timeBasedCaptureColumn = null;
    private String txIdExpression = null;
    private String externalSelect = null;
    private Date createTime;
    private Date lastUpdateTime;
    private String lastUpdateBy;

    public Trigger() {
    }

    public Trigger(String tableName, String channelId) {
        this.triggerId = tableName;
        this.setSourceTableName(tableName);
        this.channelId = channelId;
    }

    public Trigger(String tableName, String channelId, boolean syncOnIncomingBatch) {
        this(tableName, channelId);
        this.syncOnIncomingBatch = syncOnIncomingBatch;
    }

    public final String qualifiedSourceTableName() {
        return this.qualifiedSourceTablePrefix() + this.sourceTableName;
    }

    public final String qualifiedSourceTablePrefix() {
        String schemaPlus = this.getSourceSchemaName() != null ? this.getSourceSchemaName() + "." : "";
        String catalogPlus = (String)(this.getSourceCatalogName() != null ? this.getSourceCatalogName() + "." : "") + schemaPlus;
        return catalogPlus;
    }

    public void nullOutBlankFields() {
        if (StringUtils.isBlank((CharSequence)this.sourceCatalogName)) {
            this.sourceCatalogName = null;
            this.sourceCatalogNameUnescaped = null;
            this.isSourceCatalogWildCarded = false;
        }
        if (StringUtils.isBlank((CharSequence)this.sourceSchemaName)) {
            this.sourceSchemaName = null;
            this.sourceSchemaNameUnescaped = null;
            this.isSourceSchemaWildCarded = false;
        }
        this.syncOnInsertCondition = Objects.toString(StringUtils.trimToNull((String)this.syncOnInsertCondition), DEFAULT_CONDITION);
        this.syncOnUpdateCondition = Objects.toString(StringUtils.trimToNull((String)this.syncOnUpdateCondition), DEFAULT_CONDITION);
        this.syncOnDeleteCondition = Objects.toString(StringUtils.trimToNull((String)this.syncOnDeleteCondition), DEFAULT_CONDITION);
        this.externalSelect = StringUtils.trimToNull((String)this.externalSelect);
        this.excludedColumnNames = StringUtils.trimToNull((String)this.excludedColumnNames);
        this.includedColumnNames = StringUtils.trimToNull((String)this.includedColumnNames);
        this.syncKeyNames = StringUtils.trimToNull((String)this.syncKeyNames);
        this.channelExpression = StringUtils.trimToNull((String)this.channelExpression);
        this.customBeforeInsertText = StringUtils.trimToNull((String)this.customBeforeInsertText);
        this.customBeforeUpdateText = StringUtils.trimToNull((String)this.customBeforeUpdateText);
        this.customBeforeDeleteText = StringUtils.trimToNull((String)this.customBeforeDeleteText);
        this.customOnInsertText = StringUtils.trimToNull((String)this.customOnInsertText);
        this.customOnUpdateText = StringUtils.trimToNull((String)this.customOnUpdateText);
        this.customOnDeleteText = StringUtils.trimToNull((String)this.customOnDeleteText);
        this.timeBasedCaptureColumn = StringUtils.trimToNull((String)this.timeBasedCaptureColumn);
    }

    public Column[] filterExcludedAndIncludedColumns(Column[] src) {
        return this.filterIncludedColumns(this.filterExcludedColumns(src));
    }

    public Column[] filterExcludedColumns(Column[] src) {
        if (src != null) {
            List<String> excludedColumnNames = this.getExcludedColumnNamesAsList();
            ArrayList<Column> filtered = new ArrayList<Column>(src.length);
            for (int i = 0; i < src.length; ++i) {
                Column col = src[i];
                if (excludedColumnNames.contains(col.getName().toLowerCase())) continue;
                filtered.add(col);
            }
            return filtered.toArray(new Column[filtered.size()]);
        }
        return new Column[0];
    }

    public Column[] filterIncludedColumns(Column[] src) {
        if (src != null) {
            List<String> includedColumnNames = this.getIncludedColumnNamesAsList();
            if (includedColumnNames.size() == 0) {
                return src;
            }
            ArrayList<Column> filtered = new ArrayList<Column>(src.length);
            for (int i = 0; i < src.length; ++i) {
                Column col = src[i];
                if (!includedColumnNames.contains(col.getName().toLowerCase())) continue;
                filtered.add(col);
            }
            return filtered.toArray(new Column[filtered.size()]);
        }
        return new Column[0];
    }

    public Column[] getSyncKeysColumnsForTable(Table table) {
        List<String> syncKeys = this.getSyncKeyNamesAsList();
        if (syncKeys.size() > 0) {
            ArrayList<Column> columns = new ArrayList<Column>();
            for (String syncKey : syncKeys) {
                Column col = table.getColumnWithName(syncKey);
                if (col != null) {
                    columns.add(col);
                    continue;
                }
                log.error("The sync key column '{}' was specified for the '{}' trigger but was not found in the table", (Object)syncKey, (Object)this.triggerId);
            }
            if (columns.size() > 0) {
                return columns.toArray(new Column[columns.size()]);
            }
            return table.getPrimaryKeyColumns();
        }
        return table.getPrimaryKeyColumns();
    }

    public Column[] orderColumnsForTable(Table table) {
        if (table != null) {
            Column[] pks = this.getSyncKeysColumnsForTable(table);
            Column[] cols = table.getColumns();
            ArrayList<Column> orderedColumns = new ArrayList<Column>(cols.length);
            for (int i = 0; i < pks.length; ++i) {
                orderedColumns.add(pks[i]);
            }
            ArrayList<Column> endingColumns = new ArrayList<Column>();
            for (int i = 0; i < cols.length; ++i) {
                boolean syncKey = false;
                for (int j = 0; j < pks.length; ++j) {
                    if (!cols[i].getName().equals(pks[j].getName())) continue;
                    syncKey = true;
                    break;
                }
                if ("LONG".equalsIgnoreCase(cols[i].getJdbcTypeName())) {
                    endingColumns.add(cols[i]);
                    continue;
                }
                if (syncKey) continue;
                orderedColumns.add(cols[i]);
            }
            for (Column column : endingColumns) {
                orderedColumns.add(column);
            }
            Column[] result = orderedColumns.toArray(new Column[orderedColumns.size()]);
            return this.filterExcludedAndIncludedColumns(result);
        }
        return new Column[0];
    }

    private List<String> getExcludedColumnNamesAsList() {
        if (StringUtils.isNotBlank((CharSequence)this.excludedColumnNames)) {
            StringTokenizer tokenizer = new StringTokenizer(this.excludedColumnNames, ",");
            ArrayList<String> columnNames = new ArrayList<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                columnNames.add(tokenizer.nextToken().toLowerCase().trim());
            }
            return columnNames;
        }
        return Collections.EMPTY_LIST;
    }

    private List<String> getIncludedColumnNamesAsList() {
        if (StringUtils.isNotBlank((CharSequence)this.includedColumnNames)) {
            StringTokenizer tokenizer = new StringTokenizer(this.includedColumnNames, ",");
            ArrayList<String> columnNames = new ArrayList<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                columnNames.add(tokenizer.nextToken().toLowerCase().trim());
            }
            return columnNames;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean hasChangedSinceLastTriggerBuild(Date lastTriggerBuildTime) {
        return lastTriggerBuildTime == null || this.getLastUpdateTime() == null || lastTriggerBuildTime.before(this.getLastUpdateTime());
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public String getSourceTableNameLowerCase() {
        return this.sourceTableNameLowerCase;
    }

    public String getSourceTableNameUnescaped() {
        return this.sourceTableNameUnescaped;
    }

    public boolean isSourceWildCarded() {
        return this.isSourceTableNameWildCarded() || this.isSourceCatalogNameWildCarded() || this.isSourceSchemaNameWildCarded();
    }

    public boolean isSourceTableNameWildCarded() {
        return this.isSourceTableNameWildCarded;
    }

    public boolean isSourceTableNameExpanded() {
        return this.isSourceTableNameExpanded;
    }

    public void setSourceTableNameExpanded(boolean isSourceTableNameExpanded) {
        this.isSourceTableNameExpanded = isSourceTableNameExpanded;
    }

    public boolean isSourceCatalogNameWildCarded() {
        return this.isSourceCatalogWildCarded;
    }

    public boolean isSourceSchemaNameWildCarded() {
        return this.isSourceSchemaWildCarded;
    }

    public String getChannelExpression() {
        return this.channelExpression;
    }

    public void setChannelExpression(String channelExpression) {
        this.channelExpression = channelExpression;
    }

    public void setSourceTableName(String sourceTableName) {
        this.sourceTableName = sourceTableName;
        this.sourceTableNameLowerCase = sourceTableName == null ? null : sourceTableName.toLowerCase();
        this.isSourceTableNameWildCarded = FormatUtils.isWildCarded((String)sourceTableName);
        if (!this.isSourceTableNameWildCarded) {
            this.sourceTableNameUnescaped = FormatUtils.unescapeWildCards((String)sourceTableName);
        }
    }

    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public String getSourceSchemaNameUnescaped() {
        return this.sourceSchemaNameUnescaped;
    }

    public void setSourceSchemaName(String sourceSchemaName) {
        this.sourceSchemaName = sourceSchemaName;
        this.isSourceSchemaWildCarded = FormatUtils.isWildCarded((String)sourceSchemaName);
        if (!this.isSourceSchemaWildCarded) {
            this.sourceSchemaNameUnescaped = FormatUtils.unescapeWildCards((String)sourceSchemaName);
        }
    }

    public String getSourceCatalogName() {
        return this.sourceCatalogName;
    }

    public String getSourceCatalogNameUnescaped() {
        return this.sourceCatalogNameUnescaped;
    }

    public void setSourceCatalogName(String sourceCatalogName) {
        this.sourceCatalogName = sourceCatalogName;
        this.isSourceCatalogWildCarded = FormatUtils.isWildCarded((String)sourceCatalogName);
        if (!this.isSourceCatalogWildCarded) {
            this.sourceCatalogNameUnescaped = FormatUtils.unescapeWildCards((String)sourceCatalogName);
        }
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getReloadChannelId() {
        return this.reloadChannelId;
    }

    public void setReloadChannelId(String reloadChannelId) {
        this.reloadChannelId = reloadChannelId;
    }

    public boolean isSyncOnUpdate() {
        return this.syncOnUpdate;
    }

    public void setSyncOnUpdate(boolean syncOnUpdate) {
        this.syncOnUpdate = syncOnUpdate;
    }

    public boolean isSyncOnInsert() {
        return this.syncOnInsert;
    }

    public void setSyncOnInsert(boolean syncOnInsert) {
        this.syncOnInsert = syncOnInsert;
    }

    public boolean isSyncOnDelete() {
        return this.syncOnDelete;
    }

    public void setSyncOnDelete(boolean syncOnDelete) {
        this.syncOnDelete = syncOnDelete;
    }

    public boolean isSyncOnIncomingBatch() {
        return this.syncOnIncomingBatch;
    }

    public void setSyncOnIncomingBatch(boolean syncOnIncomingBatch) {
        this.syncOnIncomingBatch = syncOnIncomingBatch;
    }

    public String getNameForInsertTrigger() {
        return this.nameForInsertTrigger;
    }

    public void setNameForInsertTrigger(String nameForInsertTrigger) {
        this.nameForInsertTrigger = nameForInsertTrigger;
    }

    public String getNameForUpdateTrigger() {
        return this.nameForUpdateTrigger;
    }

    public void setNameForUpdateTrigger(String nameForUpdateTrigger) {
        this.nameForUpdateTrigger = nameForUpdateTrigger;
    }

    public String getNameForDeleteTrigger() {
        return this.nameForDeleteTrigger;
    }

    public void setNameForDeleteTrigger(String nameForDeleteTrigger) {
        this.nameForDeleteTrigger = nameForDeleteTrigger;
    }

    public String getSyncOnUpdateCondition() {
        return this.syncOnUpdateCondition;
    }

    public void setSyncOnUpdateCondition(String syncOnUpdateCondition) {
        this.syncOnUpdateCondition = syncOnUpdateCondition;
    }

    public String getSyncOnInsertCondition() {
        return this.syncOnInsertCondition;
    }

    public void setSyncOnInsertCondition(String syncOnInsertCondition) {
        this.syncOnInsertCondition = syncOnInsertCondition;
    }

    public String getSyncOnDeleteCondition() {
        return this.syncOnDeleteCondition;
    }

    public void setSyncOnDeleteCondition(String syncOnDeleteCondition) {
        this.syncOnDeleteCondition = syncOnDeleteCondition;
    }

    public String getCustomBeforeUpdateText() {
        return this.customBeforeUpdateText;
    }

    public void setCustomBeforeUpdateText(String customBeforeUpdateText) {
        this.customBeforeUpdateText = customBeforeUpdateText;
    }

    public String getCustomBeforeInsertText() {
        return this.customBeforeInsertText;
    }

    public void setCustomBeforeInsertText(String customBeforeInsertText) {
        this.customBeforeInsertText = customBeforeInsertText;
    }

    public String getCustomBeforeDeleteText() {
        return this.customBeforeDeleteText;
    }

    public void setCustomBeforeDeleteText(String customBeforeDeleteText) {
        this.customBeforeDeleteText = customBeforeDeleteText;
    }

    public String getCustomOnUpdateText() {
        return this.customOnUpdateText;
    }

    public void setCustomOnUpdateText(String customOnUpdateText) {
        this.customOnUpdateText = customOnUpdateText;
    }

    public String getCustomOnInsertText() {
        return this.customOnInsertText;
    }

    public void setCustomOnInsertText(String customOnInsertText) {
        this.customOnInsertText = customOnInsertText;
    }

    public String getCustomOnDeleteText() {
        return this.customOnDeleteText;
    }

    public void setCustomOnDeleteText(String customOnDeleteText) {
        this.customOnDeleteText = customOnDeleteText;
    }

    public String getExcludedColumnNames() {
        return this.excludedColumnNames;
    }

    public void setExcludedColumnNames(String excludedColumnNames) {
        this.excludedColumnNames = excludedColumnNames;
    }

    public String getIncludedColumnNames() {
        return this.includedColumnNames;
    }

    public void setIncludedColumnNames(String includedColumnNames) {
        this.includedColumnNames = includedColumnNames;
    }

    public String getTxIdExpression() {
        return this.txIdExpression;
    }

    public void setTxIdExpression(String txIdExpression) {
        this.txIdExpression = txIdExpression;
    }

    public String getExternalSelect() {
        return this.externalSelect;
    }

    public void setExternalSelect(String externalSelect) {
        this.externalSelect = externalSelect;
    }

    @Override
    public void setLastUpdateBy(String updatedBy) {
        this.lastUpdateBy = updatedBy;
    }

    @Override
    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    @Override
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastUpdateTime(Date lastModifiedOn) {
        this.lastUpdateTime = lastModifiedOn;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Date createdOn) {
        this.createTime = createdOn;
    }

    public void setUseStreamLobs(boolean useStreamLobs) {
        this.useStreamLobs = useStreamLobs;
    }

    public boolean isUseStreamLobs() {
        return this.useStreamLobs;
    }

    public void setUseCaptureLobs(boolean useCaptureLobs) {
        this.useCaptureLobs = useCaptureLobs;
    }

    public boolean isUseCaptureLobs() {
        return this.useCaptureLobs;
    }

    public boolean isUseHandleKeyUpdates() {
        return this.useHandleKeyUpdates;
    }

    public void setUseHandleKeyUpdates(boolean useHandleKeyUpdates) {
        this.useHandleKeyUpdates = useHandleKeyUpdates;
    }

    public void setUseCaptureOldData(boolean useCaptureOldData) {
        this.useCaptureOldData = useCaptureOldData;
    }

    public boolean isUseCaptureOldData() {
        return this.useCaptureOldData;
    }

    public void setSyncKeyNames(String syncKeys) {
        this.syncKeyNames = syncKeys;
    }

    public String getSyncKeyNames() {
        return this.syncKeyNames;
    }

    public boolean isStreamRow() {
        return this.streamRow;
    }

    public void setStreamRow(boolean streamRow) {
        this.streamRow = streamRow;
    }

    public String getTimeBasedCaptureColumn() {
        return this.timeBasedCaptureColumn;
    }

    public void setTimeBasedCaptureColumn(String timeBasedCaptureColumn) {
        this.timeBasedCaptureColumn = timeBasedCaptureColumn;
    }

    private List<String> getSyncKeyNamesAsList() {
        if (StringUtils.isNotBlank((CharSequence)this.syncKeyNames)) {
            StringTokenizer tokenizer = new StringTokenizer(this.syncKeyNames, ",");
            ArrayList<String> columnNames = new ArrayList<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                String columnName = tokenizer.nextToken().toLowerCase().trim();
                if (columnNames.contains(columnName)) continue;
                columnNames.add(columnName);
            }
            return columnNames;
        }
        return Collections.EMPTY_LIST;
    }

    public String getFullyQualifiedSourceTableName() {
        return Table.getFullyQualifiedTableName((String)this.sourceCatalogName, (String)this.sourceSchemaName, (String)this.sourceTableName);
    }

    public long toHashedValue() {
        long hashedValue;
        long l = hashedValue = this.triggerId != null ? (long)this.triggerId.hashCode() : 0L;
        if (null != this.sourceTableName) {
            hashedValue += (long)this.sourceTableName.hashCode();
        }
        if (null != this.channelId) {
            hashedValue += (long)this.channelId.hashCode();
        }
        if (null != this.sourceSchemaName) {
            hashedValue += (long)this.sourceSchemaName.hashCode();
        }
        if (null != this.sourceCatalogName) {
            hashedValue += (long)this.sourceCatalogName.hashCode();
        }
        hashedValue += this.syncOnUpdate ? (long)"syncOnUpdate".hashCode() : 0L;
        hashedValue += this.syncOnInsert ? (long)"syncOnInsert".hashCode() : 0L;
        hashedValue += this.syncOnDelete ? (long)"syncOnDelete".hashCode() : 0L;
        hashedValue += this.syncOnIncomingBatch ? (long)"syncOnIncomingBatch".hashCode() : 0L;
        hashedValue += this.useStreamLobs ? (long)"useStreamLobs".hashCode() : 0L;
        hashedValue += this.useCaptureLobs ? (long)"useCaptureLobs".hashCode() : 0L;
        hashedValue += this.useCaptureOldData ? (long)"useCaptureOldData".hashCode() : 0L;
        hashedValue += this.useHandleKeyUpdates ? (long)"useHandleKeyUpdates".hashCode() : 0L;
        if (null != this.nameForInsertTrigger) {
            hashedValue += (long)this.nameForInsertTrigger.hashCode();
        }
        if (null != this.nameForUpdateTrigger) {
            hashedValue += (long)this.nameForUpdateTrigger.hashCode();
        }
        if (null != this.nameForDeleteTrigger) {
            hashedValue += (long)this.nameForDeleteTrigger.hashCode();
        }
        if (null != this.syncOnUpdateCondition) {
            hashedValue += (long)this.syncOnUpdateCondition.hashCode();
        }
        if (null != this.syncOnInsertCondition) {
            hashedValue += (long)this.syncOnInsertCondition.hashCode();
        }
        if (null != this.syncOnDeleteCondition) {
            hashedValue += (long)this.syncOnDeleteCondition.hashCode();
        }
        if (null != this.customBeforeUpdateText) {
            hashedValue += (long)this.customBeforeUpdateText.hashCode();
        }
        if (null != this.customBeforeInsertText) {
            hashedValue += (long)this.customBeforeInsertText.hashCode();
        }
        if (null != this.customBeforeDeleteText) {
            hashedValue += (long)this.customBeforeDeleteText.hashCode();
        }
        if (null != this.customOnUpdateText) {
            hashedValue += (long)this.customOnUpdateText.hashCode();
        }
        if (null != this.customOnInsertText) {
            hashedValue += (long)this.customOnInsertText.hashCode();
        }
        if (null != this.customOnDeleteText) {
            hashedValue += (long)this.customOnDeleteText.hashCode();
        }
        if (null != this.excludedColumnNames) {
            hashedValue += (long)this.excludedColumnNames.hashCode();
        }
        if (null != this.includedColumnNames) {
            hashedValue += (long)this.includedColumnNames.hashCode();
        }
        if (null != this.externalSelect) {
            hashedValue += (long)this.externalSelect.hashCode();
        }
        if (null != this.txIdExpression) {
            hashedValue += (long)this.txIdExpression.hashCode();
        }
        if (null != this.syncKeyNames) {
            hashedValue += (long)this.syncKeyNames.hashCode();
        }
        return hashedValue;
    }

    public boolean matchesCatalogName(String catalogName, boolean ignoreCase) {
        return this.matches(this.sourceCatalogName, catalogName, ignoreCase);
    }

    public boolean matchesSchemaName(String schemaName, boolean ignoreCase) {
        return this.matches(this.sourceSchemaName, schemaName, ignoreCase);
    }

    protected boolean matches(String match, String target, boolean ignoreCase) {
        String[] wildcardTokens;
        boolean matches = false;
        for (String wildcardToken : wildcardTokens = match.split(",")) {
            if (!FormatUtils.isWildCardMatch((String)target, (String)wildcardToken, (boolean)ignoreCase)) continue;
            if (!wildcardToken.startsWith("!")) {
                matches = true;
                continue;
            }
            matches = false;
            break;
        }
        return matches;
    }

    public boolean matches(Table table, String defaultCatalog, String defaultSchema, boolean ignoreCase) {
        boolean catalogMatch = false;
        catalogMatch = this.isSourceCatalogWildCarded ? this.matches(this.sourceCatalogName, table.getCatalog(), ignoreCase) : Strings.CS.equals(this.sourceCatalogNameUnescaped, table.getCatalog()) || StringUtils.isBlank((CharSequence)this.sourceCatalogName) && Strings.CS.equals(defaultCatalog, table.getCatalog());
        boolean schemaMatch = false;
        schemaMatch = this.isSourceSchemaWildCarded ? this.matches(this.sourceSchemaName, table.getSchema(), ignoreCase) : Strings.CS.equals(this.sourceSchemaNameUnescaped, table.getSchema()) || StringUtils.isBlank((CharSequence)this.sourceSchemaName) && Strings.CS.equals(defaultSchema, table.getSchema());
        boolean tableMatch = false;
        tableMatch = this.isSourceTableNameWildCarded ? this.matches(this.sourceTableName, table.getName(), ignoreCase) : (this.isSourceTableNameExpanded ? this.matches(this.sourceTableName.replace("$(targetExternalId)", "*"), table.getName(), ignoreCase) : (ignoreCase ? table.getName().equalsIgnoreCase(this.sourceTableNameUnescaped) : table.getName().equals(this.sourceTableNameUnescaped)));
        return catalogMatch && schemaMatch && tableMatch;
    }

    public boolean matches(Trigger trigger) {
        return Strings.CS.equals(this.sourceCatalogName, trigger.sourceCatalogName) && Strings.CS.equals(this.sourceSchemaName, trigger.sourceSchemaName) && trigger.sourceTableName.equalsIgnoreCase(this.sourceTableName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Trigger && this.triggerId != null) {
            return this.triggerId.equals(((Trigger)obj).triggerId);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.triggerId != null ? this.triggerId.hashCode() : super.hashCode();
    }

    public String toString() {
        if (this.triggerId != null) {
            return this.triggerId;
        }
        return super.toString();
    }

    public Trigger copy() {
        Trigger trigger = null;
        try {
            trigger = (Trigger)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return trigger;
    }
}

