/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.IModelObject;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.util.FormatUtils;

public class Router
implements IModelObject,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static int maxRouterId;
    private String routerId;
    private NodeGroupLink nodeGroupLink;
    private String routerType = "default";
    private String routerExpression = null;
    private boolean syncOnUpdate = true;
    private boolean syncOnInsert = true;
    private boolean syncOnDelete = true;
    private String targetCatalogName;
    private String targetSchemaName;
    private String targetTableName;
    private boolean useSourceCatalogSchema;
    private Date createTime;
    private Date lastUpdateTime;
    private String lastUpdateBy;

    public Router() {
        this.routerId = Integer.toString(maxRouterId++);
    }

    public Router(String id, String sourceNodeGroupId, String targetNodeGroupId, String routerType) {
        this(id, new NodeGroupLink(sourceNodeGroupId, targetNodeGroupId));
        this.routerType = routerType;
    }

    public Router(String id, NodeGroupLink link) {
        this.routerId = id;
        this.nodeGroupLink = link;
        this.createTime = new Date();
        this.lastUpdateBy = "symmetricds";
        this.lastUpdateTime = this.createTime;
    }

    public void nullOutBlankFields() {
        if (StringUtils.isBlank((CharSequence)this.targetCatalogName)) {
            this.targetCatalogName = null;
        }
        if (StringUtils.isBlank((CharSequence)this.targetSchemaName)) {
            this.targetSchemaName = null;
        }
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    @Override
    public void setCreateTime(Date createdOn) {
        this.createTime = createdOn;
    }

    @Override
    public void setLastUpdateTime(Date lastModifiedOn) {
        this.lastUpdateTime = lastModifiedOn;
    }

    @Override
    public void setLastUpdateBy(String updatedBy) {
        this.lastUpdateBy = updatedBy;
    }

    public boolean hasChangedSinceLastTriggerBuild(Date lastTriggerBuildTime) {
        return lastTriggerBuildTime == null || this.getLastUpdateTime() == null || lastTriggerBuildTime.before(this.getLastUpdateTime());
    }

    public void setNodeGroupLink(NodeGroupLink nodeGroupLink) {
        this.nodeGroupLink = nodeGroupLink;
    }

    public NodeGroupLink getNodeGroupLink() {
        return this.nodeGroupLink;
    }

    public String getRouterId() {
        return this.routerId;
    }

    public void setRouterId(String routerId) {
        int id;
        this.routerId = routerId;
        if (StringUtils.isNotBlank((CharSequence)routerId) && StringUtils.isNumeric((CharSequence)routerId) && (id = Integer.parseInt(routerId)) >= maxRouterId) {
            maxRouterId = id + 1;
        }
    }

    public String getTargetSchemaName() {
        return this.targetSchemaName;
    }

    public void setTargetSchemaName(String targetSchemaName) {
        this.targetSchemaName = targetSchemaName;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public void setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
    }

    public String getTargetCatalogName() {
        return this.targetCatalogName;
    }

    public void setTargetCatalogName(String targetCatalogName) {
        this.targetCatalogName = targetCatalogName;
    }

    public void setRouterType(String routerName) {
        this.routerType = routerName;
    }

    public String getRouterType() {
        return this.routerType;
    }

    public String getRouterExpression() {
        return this.routerExpression;
    }

    public void setRouterExpression(String routingExpression) {
        this.routerExpression = routingExpression;
    }

    public void setSyncOnDelete(boolean syncOnDelete) {
        this.syncOnDelete = syncOnDelete;
    }

    public boolean isSyncOnDelete() {
        return this.syncOnDelete;
    }

    public void setSyncOnInsert(boolean syncOnInsert) {
        this.syncOnInsert = syncOnInsert;
    }

    public boolean isSyncOnInsert() {
        return this.syncOnInsert;
    }

    public void setSyncOnUpdate(boolean syncOnUpdate) {
        this.syncOnUpdate = syncOnUpdate;
    }

    public boolean isSyncOnUpdate() {
        return this.syncOnUpdate;
    }

    public String createDefaultName() {
        if (this.nodeGroupLink != null) {
            String abbrevName;
            Object defaultName = null;
            String name = this.nodeGroupLink.getSourceNodeGroupId().toLowerCase() + " to " + this.nodeGroupLink.getTargetNodeGroupId().toLowerCase();
            defaultName = name.length() > 50 ? ((abbrevName = FormatUtils.replaceCharsToShortenName((String)name)).length() > 50 ? StringUtils.abbreviate((String)abbrevName, (int)50) : abbrevName) : name;
            return defaultName;
        }
        throw new IllegalStateException("Need the nodeGroupLink to be set");
    }

    public boolean isUseSourceCatalogSchema() {
        return this.useSourceCatalogSchema;
    }

    public void setUseSourceCatalogSchema(boolean useSourceCatalogSchema) {
        this.useSourceCatalogSchema = useSourceCatalogSchema;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Router && this.routerId != null) {
            return this.routerId.equals(((Router)obj).routerId);
        }
        return false;
    }

    public int hashCode() {
        return this.routerId != null ? this.routerId.hashCode() : super.hashCode();
    }

    public String toString() {
        if (this.routerId != null) {
            return this.routerId;
        }
        return super.toString();
    }

    public Router copy() {
        Router router = null;
        try {
            router = (Router)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return router;
    }
}

