/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.BatchAck;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.IncomingBatch;
import org.jumpmind.symmetric.model.OutgoingBatch;

public class RemoteNodeStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object monitor = new Object();
    private String nodeId;
    private String queue;
    private Status status;
    private long dataProcessed;
    private long batchesProcessed;
    private long reloadBatchesProcessed;
    private volatile boolean complete = false;
    private Map<String, Channel> channels;
    private Map<String, Integer> tableCounts = new LinkedHashMap<String, Integer>();
    private Set<String> tableSummary = new LinkedHashSet<String>();

    public RemoteNodeStatus(String nodeId, String channelId, Map<String, Channel> channels) {
        this.status = Status.NO_DATA;
        this.nodeId = nodeId;
        this.channels = channels;
        this.queue = channelId;
    }

    public boolean failed() {
        return this.status != Status.NO_DATA && this.status != Status.DATA_PROCESSED;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getDataProcessed() {
        return this.dataProcessed;
    }

    public void setDataProcessed(long dataProcessed) {
        this.dataProcessed = dataProcessed;
    }

    public long getBatchesProcessed() {
        return this.batchesProcessed;
    }

    public long getReloadBatchesProcessed() {
        return this.reloadBatchesProcessed;
    }

    public void updateIncomingStatus(List<IncomingBatch> incomingBatches) {
        if (incomingBatches != null) {
            for (IncomingBatch incomingBatch : incomingBatches) {
                if (incomingBatch.getIgnoreCount() == 0L) {
                    this.incrementTableCounts(incomingBatch);
                    this.dataProcessed += incomingBatch.getLoadRowCount();
                }
                ++this.batchesProcessed;
                if (incomingBatch.getStatus() != AbstractBatch.Status.ER) continue;
                this.status = Status.DATA_ERROR;
            }
        }
        if (this.status != Status.DATA_ERROR && this.dataProcessed > 0L) {
            this.status = Status.DATA_PROCESSED;
        }
    }

    public void updateOutgoingStatus(List<OutgoingBatch> outgoingBatches, List<BatchAck> batches) {
        int numberOfAcks = 0;
        if (batches != null) {
            numberOfAcks = batches.size();
            for (BatchAck batch : batches) {
                if (batch.isOk()) continue;
                this.status = Status.DATA_ERROR;
            }
        }
        int numberOfBatches = 0;
        if (outgoingBatches != null) {
            numberOfBatches = outgoingBatches.size();
            for (OutgoingBatch batch : outgoingBatches) {
                Channel channel;
                ++this.batchesProcessed;
                if (batch.getIgnoreCount() == 0L) {
                    this.incrementTableCounts(batch);
                    this.dataProcessed += batch.totalRowCount();
                }
                if ((channel = this.channels.get(batch.getChannelId())) != null && channel.isReloadFlag()) {
                    ++this.reloadBatchesProcessed;
                }
                if (batch.getStatus() != AbstractBatch.Status.ER) continue;
                this.status = Status.DATA_ERROR;
            }
        }
        if (numberOfAcks != numberOfBatches) {
            this.status = Status.DATA_ERROR;
        }
        if (this.status != Status.DATA_ERROR && this.dataProcessed > 0L) {
            this.status = Status.DATA_PROCESSED;
        }
    }

    public void resetCounts() {
        this.dataProcessed = 0L;
        this.batchesProcessed = 0L;
        this.reloadBatchesProcessed = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComplete(boolean complete) {
        Object object = this.monitor;
        synchronized (object) {
            this.complete = complete;
            this.monitor.notifyAll();
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitCompleted(long milliseconds) throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.complete) {
                return true;
            }
            this.monitor.wait(milliseconds);
            return this.complete;
        }
    }

    public Map<String, Integer> getTableCounts() {
        return this.tableCounts;
    }

    public String getTableSummary() {
        int MAX_SUMMARY_LENGTH = 512;
        if (this.tableCounts != null && !this.tableCounts.isEmpty()) {
            StringBuilder buff = new StringBuilder();
            for (String table : this.tableCounts.keySet()) {
                buff.append(table).append(", ");
            }
            if (buff.length() > 2) {
                buff.setLength(buff.length() - 2);
            }
            return StringUtils.abbreviate((String)buff.toString(), (int)512);
        }
        if (!this.tableSummary.isEmpty()) {
            StringBuilder buff = new StringBuilder();
            for (String table : this.tableSummary) {
                buff.append(table).append(", ");
            }
            if (buff.length() > 2) {
                buff.setLength(buff.length() - 2);
            }
            return StringUtils.abbreviate((String)buff.toString(), (int)512);
        }
        return "";
    }

    protected void incrementTableCounts(AbstractBatch batch) {
        block4: {
            String[] tables;
            block3: {
                if (batch.getTableCounts().isEmpty()) break block3;
                for (String table : batch.getTableCounts().keySet()) {
                    Integer value = this.tableCounts.get(table);
                    if (value == null) {
                        this.tableCounts.put(table, 1);
                        continue;
                    }
                    this.tableCounts.replace(table, value + batch.getTableCounts().get(table));
                }
                break block4;
            }
            if (StringUtils.isEmpty((CharSequence)batch.getSummary())) break block4;
            for (String table : tables = batch.getSummary().split(",")) {
                String tableTrimmed = table.trim();
                if (this.tableSummary.contains(tableTrimmed)) continue;
                this.tableSummary.add(tableTrimmed);
            }
        }
    }

    public void resetTableSummary() {
        this.tableCounts.clear();
        this.tableSummary.clear();
    }

    public static enum Status {
        OFFLINE,
        BUSY,
        NOT_AUTHORIZED,
        REGISTRATION_REQUIRED,
        INITIAL_LOAD_PENDING,
        SYNC_DISABLED,
        NO_DATA,
        DATA_PROCESSED,
        DATA_ERROR,
        UNKNOWN_ERROR;

    }
}

