/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

public enum NodeGroupLinkAction {
    P("pushes to", "push"),
    W("waits for pull from", "pull"),
    R("only routes to", "routes");

    private String description;
    private String shortName;

    private NodeGroupLinkAction(String desc, String shortName) {
        this.description = desc;
        this.shortName = shortName;
    }

    public static NodeGroupLinkAction fromCode(String code) {
        if (code != null && code.length() > 0) {
            if (P.name().equals(code)) {
                return P;
            }
            if (W.name().equals(code)) {
                return W;
            }
            if (R.name().equals(code)) {
                return R;
            }
        }
        return null;
    }

    public static NodeGroupLinkAction fromShortName(String shortName) {
        if (shortName != null && shortName.length() > 0) {
            if (P.getShortName().equals(shortName)) {
                return P;
            }
            if (W.getShortName().equals(shortName)) {
                return W;
            }
            if (R.getShortName().equals(shortName)) {
                return R;
            }
        }
        return null;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String toString() {
        return this.description;
    }
}

