/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.Node;

public class NetworkedNode
implements Comparable<NetworkedNode> {
    private Node node;
    private NetworkedNode parent;
    private TreeMap<String, NetworkedNode> children;
    private Map<String, NetworkedNode> allNetworkedNodes;

    public NetworkedNode(Node node) {
        this.node = node;
    }

    public Set<NetworkedNode> getChildren() {
        if (this.children != null) {
            return new TreeSet<NetworkedNode>(this.children.values());
        }
        return null;
    }

    public void addChild(NetworkedNode node) {
        if (this.children == null) {
            this.children = new TreeMap();
        }
        node.parent = this;
        this.children.put(node.getNode().getNodeId(), node);
    }

    public Node getNode() {
        return this.node;
    }

    public NetworkedNode getParent() {
        return this.parent;
    }

    public int getNumberOfLinksAwayFromRoot(String nodeId) {
        int numberOfLinksAwayFromRoot = this.getRoot().getNumberOfLinksAwayFromMe(nodeId, 0);
        if (numberOfLinksAwayFromRoot == 0 && !this.node.getNodeId().equals(nodeId)) {
            return -1;
        }
        return numberOfLinksAwayFromRoot;
    }

    protected int getNumberOfLinksAwayFromMe(String nodeId, int numberOfLinksIAmFromRoot) {
        if (!this.node.getNodeId().equals(nodeId) && this.children != null) {
            NetworkedNode node = this.children.get(nodeId);
            if (node != null) {
                return numberOfLinksIAmFromRoot + 1;
            }
            for (NetworkedNode child : this.children.values()) {
                int numberOfLinksAwayFromMe = child.getNumberOfLinksAwayFromMe(nodeId, numberOfLinksIAmFromRoot + 1);
                if (numberOfLinksAwayFromMe <= numberOfLinksIAmFromRoot + 1) continue;
                return numberOfLinksAwayFromMe;
            }
        }
        return numberOfLinksIAmFromRoot;
    }

    public NetworkedNode findNetworkedNode(String nodeId) {
        if (this.node.getNodeId().equals(nodeId)) {
            return this;
        }
        if (this.allNetworkedNodes != null) {
            return this.allNetworkedNodes.get(nodeId);
        }
        if (this.children != null) {
            NetworkedNode node = this.children.get(nodeId);
            if (node != null) {
                return node;
            }
            for (NetworkedNode child : this.children.values()) {
                NetworkedNode foundIt = child.findNetworkedNode(nodeId);
                if (foundIt == null) continue;
                return foundIt;
            }
        }
        return null;
    }

    public boolean isInParentHierarchy(String nodeId) {
        if (this.parent != null) {
            if (this.parent.getNode().getNodeId().equals(nodeId)) {
                return true;
            }
            return this.parent.isInParentHierarchy(nodeId);
        }
        return false;
    }

    public boolean hasChildrenThatBelongToGroups(Set<String> groupIds) {
        if (this.children != null) {
            for (NetworkedNode child : this.children.values()) {
                if (groupIds.contains(child.getNode().getNodeGroupId())) {
                    return true;
                }
                if (!child.hasChildrenThatBelongToGroups(groupIds)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInChildHierarchy(String nodeId) {
        if (this.children != null) {
            for (NetworkedNode child : this.children.values()) {
                if (child.getNode().getNodeId().equals(nodeId)) {
                    return true;
                }
                if (!child.isInChildHierarchy(nodeId)) continue;
                return true;
            }
        }
        return false;
    }

    public void addParents(Map<String, Node> nodes, Map<String, NetworkedNode> leaves) {
        String parentNodeId = this.node.getCreatedAtNodeId();
        if (parentNodeId != null && !parentNodeId.equals(this.node.getNodeId())) {
            Node parentNode;
            NetworkedNode parentNetworkedNode = leaves.get(parentNodeId);
            if (parentNetworkedNode == null && (parentNode = nodes.get(parentNodeId)) != null) {
                parentNetworkedNode = new NetworkedNode(parentNode);
                parentNetworkedNode.addParents(nodes, leaves);
                leaves.put(parentNodeId, parentNetworkedNode);
            }
            if (parentNetworkedNode != null) {
                parentNetworkedNode.addChild(this);
            }
            this.parent = parentNetworkedNode;
        }
    }

    public NetworkedNode getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    @Override
    public int compareTo(NetworkedNode o) {
        return this.node.compareTo(o.getNode());
    }

    public void setAllNetworkedNodes(Map<String, NetworkedNode> allNetworkedNodes) {
        this.allNetworkedNodes = allNetworkedNodes;
    }

    public int getNumberOfLinksFromRoot() {
        int count = 0;
        NetworkedNode root = this.parent;
        while (root != null) {
            root = root.getParent();
            ++count;
        }
        return count;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(StringUtils.repeat((String)"-", (int)this.getNumberOfLinksFromRoot())).append(this.node.getNodeId());
        if (this.children != null) {
            Collection<NetworkedNode> set = this.children.values();
            for (NetworkedNode networkedNode : set) {
                string.append("\n").append(networkedNode);
            }
        }
        return string.toString();
    }
}

