/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.util.Date;
import org.apache.commons.lang3.math.NumberUtils;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.model.IModelObject;

public class JobDefinition
implements IModelObject {
    private static final long serialVersionUID = 1L;
    private String jobName;
    private JobType jobType;
    private boolean requiresRegistration;
    private String jobExpression;
    private String description;
    private String createBy;
    private Date createTime;
    private String lastUpdateBy;
    private Date lastUpdateTime;
    private boolean defaultAutomaticStartup;
    private String defaultSchedule;
    private String nodeGroupId;
    private transient boolean automaticStartup = true;
    private boolean clustered;
    private transient String schedule;

    public boolean isCronSchedule() {
        return !this.isPeriodicSchedule();
    }

    public boolean isPeriodicSchedule() {
        return NumberUtils.isDigits((String)this.schedule);
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public boolean isRequiresRegistration() {
        return this.requiresRegistration;
    }

    public void setRequiresRegistration(boolean requiresRegistration) {
        this.requiresRegistration = requiresRegistration;
    }

    public String getJobExpression() {
        return this.jobExpression;
    }

    public void setJobExpression(String jobExpression) {
        this.jobExpression = jobExpression;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    @Override
    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    @Override
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public boolean isDefaultAutomaticStartup() {
        return this.defaultAutomaticStartup;
    }

    public void setDefaultAutomaticStartup(boolean defaultAutomaticStartup) {
        this.defaultAutomaticStartup = defaultAutomaticStartup;
    }

    public String getDefaultSchedule() {
        return this.defaultSchedule;
    }

    public void setDefaultSchedule(String defaultSchedule) {
        this.defaultSchedule = defaultSchedule;
    }

    public String getNodeGroupId() {
        return this.nodeGroupId;
    }

    public void setNodeGroupId(String nodeGroupId) {
        this.nodeGroupId = nodeGroupId;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public boolean isAutomaticStartup() {
        return this.automaticStartup;
    }

    public void setAutomaticStartup(boolean automaticStartup) {
        this.automaticStartup = automaticStartup;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public static String getJobNameParameter(String name) {
        if (name != null) {
            return name.toLowerCase().replace(' ', '.');
        }
        return null;
    }

    public String getStartParameter() {
        return String.format("start.%s.job", JobDefinition.getJobNameParameter(this.jobName));
    }

    public String getPeriodicParameter() {
        return String.format("job.%s.period.time.ms", JobDefinition.getJobNameParameter(this.jobName));
    }

    public String getCronParameter() {
        return String.format("job.%s.cron", JobDefinition.getJobNameParameter(this.jobName));
    }

    public static String getJobNameFromParameter(String paramName) {
        String jobName = null;
        if (paramName != null) {
            if (paramName.startsWith("start.") && paramName.endsWith(".job") && paramName.length() > 10) {
                jobName = paramName.substring(6, paramName.length() - 4);
            } else if (paramName.startsWith("job.") && paramName.endsWith(".cron") && paramName.length() > 9) {
                jobName = paramName.substring(4, paramName.length() - 5);
            } else if (paramName.startsWith("job.") && paramName.endsWith(".period.time.ms") && paramName.length() > 19) {
                jobName = paramName.substring(4, paramName.length() - 15);
            }
        }
        if (jobName != null) {
            jobName = jobName.replace(".", " ");
        }
        return jobName;
    }

    public static String getJobNameFromData(CsvData data) {
        String[] parsedData = data.getParsedData("rowData");
        if (parsedData == null) {
            parsedData = data.getParsedData("pkData");
        }
        if (parsedData != null && parsedData.length >= 3) {
            return JobDefinition.getJobNameFromParameter(parsedData[2]);
        }
        return null;
    }

    public static enum JobType {
        BUILT_IN,
        BSH,
        JAVA,
        SQL;

    }
}

