/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class DataGap
implements Serializable,
Comparable<DataGap> {
    private static final long serialVersionUID = 1L;
    private long startId;
    private long endId;
    private Date createTime;

    public DataGap(long startId, long endId) {
        this.startId = startId;
        this.endId = endId;
        this.createTime = new Date();
    }

    public DataGap(long startId, long endId, Date createTime) {
        this.startId = startId;
        this.endId = endId;
        this.createTime = createTime;
    }

    public String toString() {
        return "{ startId: " + this.startId + ", endId: " + this.endId + ", createTime: \"" + String.valueOf(this.createTime) + "\" }";
    }

    public long getEndId() {
        return this.endId;
    }

    public long getStartId() {
        return this.startId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public boolean contains(DataGap gap) {
        return this.startId <= gap.startId && this.endId >= gap.endId;
    }

    public boolean containsAny(List<Long> dataIds) {
        for (Long dataId : dataIds) {
            if (dataId == null || this.startId < dataId || this.endId > dataId) continue;
            return true;
        }
        return false;
    }

    public boolean overlaps(DataGap gap) {
        return this.startId >= gap.startId && this.startId <= gap.endId || this.endId >= gap.startId && this.endId <= gap.endId || this.startId <= gap.startId && this.endId >= gap.endId;
    }

    public long gapSize() {
        return this.endId - this.startId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.endId ^ this.endId >>> 32);
        result = 31 * result + (int)(this.startId ^ this.startId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataGap other = (DataGap)obj;
        if (this.endId != other.endId) {
            return false;
        }
        return this.startId == other.startId;
    }

    @Override
    public int compareTo(DataGap gap) {
        if (this.startId < gap.getStartId() || this.startId == gap.getStartId() && this.endId < gap.getEndId()) {
            return -1;
        }
        if (this.startId > gap.getStartId() || this.startId == gap.getStartId() && this.endId > gap.getEndId()) {
            return 1;
        }
        return 0;
    }
}

