/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.stage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.IBatchStagingExtension;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.StagingManager;
import org.jumpmind.symmetric.io.stage.StagingPurgeContext;
import org.jumpmind.symmetric.model.BatchId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchStagingManager
extends StagingManager {
    private static final Logger log = LoggerFactory.getLogger(BatchStagingManager.class);
    ISymmetricEngine engine;

    public BatchStagingManager(ISymmetricEngine engine, String directory) {
        super(directory, engine.getParameterService().is("cluster.lock.enabled"), engine.getParameterService().getLong("staging.low.space.threshold.megabytes", 0L));
        this.engine = engine;
    }

    protected Map<String, Long> getBiggestBatchIds(Set<BatchId> batches) {
        HashMap<String, Long> biggest = new HashMap<String, Long>();
        for (BatchId batchId : batches) {
            Long batchNumber = (Long)biggest.get(batchId.getNodeId());
            if (batchNumber != null && batchNumber >= batchId.getBatchId()) continue;
            biggest.put(batchId.getNodeId(), batchId.getBatchId());
        }
        return biggest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long clean(long ttlInMs) {
        boolean isLockAcquired;
        block12: {
            isLockAcquired = false;
            try {
                boolean clusterStagingEnabled = this.engine.getParameterService().is("cluster.staging.enabled", false);
                if (!clusterStagingEnabled) break block12;
                if (this.engine.getClusterService().lock("Stage Management")) {
                    isLockAcquired = true;
                    break block12;
                }
                log.debug("Could not get a lock to run stage management");
                return 0L;
            }
            catch (Exception clusterStagingEnabled) {
                // empty catch block
            }
        }
        try {
            long startTime = System.currentTimeMillis();
            boolean purgeBasedOnTTL = this.engine.getParameterService().is("stream.to.file.purge.on.ttl.enabled", false);
            boolean recordIncomingBatchesEnabled = this.engine.getIncomingBatchService().isRecordOkBatchesEnabled();
            long minTtlInMs = this.engine.getParameterService().getLong("stream.to.file.min.ttl.ms", 600000L);
            HashSet outgoingBatches = ttlInMs == 0L ? new HashSet() : new HashSet<Long>(this.engine.getOutgoingBatchService().getAllBatches());
            HashSet<BatchId> incomingBatches = ttlInMs == 0L ? new HashSet<BatchId>() : new HashSet<BatchId>(this.engine.getIncomingBatchService().getAllBatches());
            Map<String, Long> biggestIncomingByNode = this.getBiggestBatchIds(incomingBatches);
            StagingPurgeContext context = new StagingPurgeContext();
            context.putContextValue("startTime", (Object)startTime);
            context.putContextValue("purgeBasedOnTTL", (Object)purgeBasedOnTTL);
            context.putContextValue("recordIncomingBatchesEnabled", (Object)recordIncomingBatchesEnabled);
            context.putContextValue("minTtlInMs", (Object)minTtlInMs);
            context.putContextValue("outgoingBatches", outgoingBatches);
            context.putContextValue("incomingBatches", incomingBatches);
            context.putContextValue("biggestIncomingByNode", biggestIncomingByNode);
            IBatchStagingExtension ext = this.engine.getExtensionService().getExtensionPoint(IBatchStagingExtension.class);
            if (ext != null) {
                context.putContextValue("extension", (Object)ext);
                ext.beforeClean(context);
            }
            long l = super.clean(ttlInMs, context);
            return l;
        }
        finally {
            if (isLockAcquired) {
                try {
                    this.engine.getClusterService().unlock("Stage Management");
                }
                catch (Exception exception) {}
            }
        }
    }

    protected boolean shouldCleanPath(IStagedResource resource, long ttlInMs, StagingPurgeContext context) {
        boolean resourceClearsMinTimeHurdle;
        if (context.getBoolean("purgeBasedOnTTL")) {
            return super.shouldCleanPath(resource, ttlInMs, context);
        }
        String[] path = resource.getPath().split("/");
        boolean resourceIsOld = System.currentTimeMillis() - resource.getLastUpdateTime() > ttlInMs;
        boolean bl = resourceClearsMinTimeHurdle = resource.getLastUpdateTime() < context.getLong("startTime") && System.currentTimeMillis() - resource.getLastUpdateTime() > context.getLong("minTtlInMs");
        if (path[0].equals("outgoing")) {
            return this.shouldCleanOutgoingPath(resource, ttlInMs, context, path, resourceIsOld, resourceClearsMinTimeHurdle);
        }
        if (path[0].equals("incoming")) {
            return this.shouldCleanIncomingPath(resource, ttlInMs, context, path, resourceIsOld, resourceClearsMinTimeHurdle);
        }
        if (path[0].equals("logminer")) {
            return false;
        }
        if (path[0].equals("bulkloaddir") || path[0].equals("bulkextract")) {
            return this.shouldCleanBulkPath(resource, ttlInMs, context, path, resourceIsOld, resourceClearsMinTimeHurdle);
        }
        IBatchStagingExtension ext = (IBatchStagingExtension)context.getContextValue("extension");
        if (ext != null && ext.isValidPath(path[0])) {
            return ext.shouldCleanPath(resource, ttlInMs, context, path, resourceIsOld, resourceClearsMinTimeHurdle);
        }
        log.warn("Unrecognized path: " + resource.getPath());
        return false;
    }

    protected boolean shouldCleanOutgoingPath(IStagedResource resource, long ttlInMs, StagingPurgeContext context, String[] path, boolean resourceIsOld, boolean resourceClearsMinTimeHurdle) {
        block3: {
            Set outgoingBatches = (Set)context.getContextValue("outgoingBatches");
            try {
                Long batchId = Long.valueOf(path[path.length - 1].replace("_filesync", ""));
                if (resourceClearsMinTimeHurdle && !outgoingBatches.contains(batchId) || ttlInMs == 0L) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                if (!resourceIsOld && ttlInMs != 0L) break block3;
                return true;
            }
        }
        return false;
    }

    protected boolean shouldCleanBulkPath(IStagedResource resource, long ttlInMs, StagingPurgeContext context, String[] path, boolean resourceIsOld, boolean resourceClearsMinTimeHurdle) {
        block3: {
            Set outgoingBatches = (Set)context.getContextValue("outgoingBatches");
            try {
                Long batchId = Long.valueOf(path[path.length - 1].replaceAll("[^0-9]", ""));
                if (resourceClearsMinTimeHurdle && !outgoingBatches.contains(batchId) || ttlInMs == 0L) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                if (!resourceIsOld && ttlInMs != 0L) break block3;
                return true;
            }
        }
        return false;
    }

    protected boolean shouldCleanIncomingPath(IStagedResource resource, long ttlInMs, StagingPurgeContext context, String[] path, boolean resourceIsOld, boolean resourceClearsMinTimeHurdle) {
        block3: {
            Set incomingBatches = (Set)context.getContextValue("incomingBatches");
            Map biggestIncomingByNode = (Map)context.getContextValue("biggestIncomingByNode");
            boolean recordIncomingBatchesEnabled = context.getBoolean("recordIncomingBatchesEnabled");
            try {
                BatchId batchId = new BatchId(Long.valueOf(path[path.length - 1].replace("_filesync", "")), path[1]);
                Long biggestBatchId = (Long)biggestIncomingByNode.get(batchId.getNodeId());
                if (recordIncomingBatchesEnabled && resourceClearsMinTimeHurdle && biggestBatchId != null && biggestBatchId > batchId.getBatchId() && !incomingBatches.contains(batchId) || !recordIncomingBatchesEnabled && resourceIsOld || ttlInMs == 0L) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                if (!resourceIsOld && ttlInMs != 0L) break block3;
                return true;
            }
        }
        return false;
    }
}

