/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.transform.AbstractColumnTransform;
import org.jumpmind.symmetric.io.data.transform.ISingleNewAndOldValueColumnTransform;
import org.jumpmind.symmetric.io.data.transform.IgnoreColumnException;
import org.jumpmind.symmetric.io.data.transform.IgnoreRowException;
import org.jumpmind.symmetric.io.data.transform.NewAndOldValue;
import org.jumpmind.symmetric.io.data.transform.TransformColumn;
import org.jumpmind.symmetric.io.data.transform.TransformedData;
import org.jumpmind.symmetric.model.Data;

public class VariableColumnTransform
extends AbstractColumnTransform
implements ISingleNewAndOldValueColumnTransform {
    public static final String NAME = "variable";
    final String SOURCE_NODE_KEY = String.format("%d.SourceNode", this.hashCode());
    protected static final String TS_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    protected static final String DATE_PATTERN = "yyyy-MM-dd";
    protected static final String OPTION_TIMESTAMP = "system_timestamp";
    protected static final String OPTION_TIMESTAMP_UTC = "system_timestamp_utc";
    protected static final String OPTION_DATE = "system_date";
    protected static final String OPTION_SOURCE_NODE_ID = "source_node_id";
    protected static final String OPTION_TARGET_NODE_ID = "target_node_id";
    protected static final String OPTION_SOURCE_NODE_ID_FROM_DATA = "source_node_id_from_data";
    protected static final String OPTION_NULL = "null";
    protected static final String OPTION_OLD_VALUE = "old_column_value";
    protected static final String OPTION_SOURCE_TABLE_NAME = "source_table_name";
    protected static final String OPTION_SOURCE_CATALOG_NAME = "source_catalog_name";
    protected static final String OPTION_SOURCE_SCHEMA_NAME = "source_schema_name";
    protected static final String OPTION_SOURCE_DML_TYPE = "source_dml_type";
    protected static final String OPTION_BATCH_ID = "batch_id";
    protected static final String OPTION_BATCH_START_TIME = "batch_start_time";
    protected static final String OPTION_DELETE_INDICATOR_FLAG = "delete_indicator_flag";
    private static final String[] OPTIONS = new String[]{"system_timestamp", "system_timestamp_utc", "system_date", "source_node_id", "target_node_id", "source_node_id_from_data", "null", "old_column_value", "source_catalog_name", "source_schema_name", "source_table_name", "source_dml_type", "batch_id", "batch_start_time", "delete_indicator_flag"};

    @Override
    public String getName() {
        return NAME;
    }

    public boolean isExtractColumnTransform() {
        return true;
    }

    public boolean isLoadColumnTransform() {
        return true;
    }

    public static String[] getOptions() {
        return OPTIONS;
    }

    public NewAndOldValue transform(IDatabasePlatform platform, DataContext context, TransformColumn column, TransformedData data, Map<String, String> sourceValues, String newValue, String oldValue) throws IgnoreColumnException, IgnoreRowException {
        String varName = column.getTransformExpression();
        String value = null;
        if (varName != null) {
            if (varName.equalsIgnoreCase(OPTION_TIMESTAMP)) {
                value = DateFormatUtils.format((long)System.currentTimeMillis(), (String)TS_PATTERN);
            } else if (varName.equalsIgnoreCase(OPTION_TIMESTAMP_UTC)) {
                value = DateFormatUtils.format((long)System.currentTimeMillis(), (String)TS_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT"));
            } else if (varName.equalsIgnoreCase(OPTION_DATE)) {
                value = DateFormatUtils.format((long)System.currentTimeMillis(), (String)DATE_PATTERN);
            } else if (varName.equalsIgnoreCase(OPTION_SOURCE_NODE_ID)) {
                value = context.getBatch().getSourceNodeId();
            } else if (varName.equalsIgnoreCase(OPTION_TARGET_NODE_ID)) {
                value = context.getBatch().getTargetNodeId();
            } else if (varName.equalsIgnoreCase(OPTION_SOURCE_NODE_ID_FROM_DATA)) {
                value = (String)context.getData().getAttribute("sourceNodeId");
            } else if (varName.equalsIgnoreCase(OPTION_OLD_VALUE)) {
                value = oldValue;
            } else if (varName.equals(OPTION_NULL)) {
                value = null;
            } else if (varName.equals(OPTION_SOURCE_TABLE_NAME)) {
                Data csvData = (Data)context.get("csvData");
                if (csvData != null && csvData.getTriggerHistory() != null) {
                    value = csvData.getTriggerHistory().getSourceTableName();
                }
            } else if (varName.equals(OPTION_SOURCE_CATALOG_NAME)) {
                Data csvData = (Data)context.get("csvData");
                if (csvData != null && csvData.getTriggerHistory() != null) {
                    value = csvData.getTriggerHistory().getSourceCatalogName();
                }
            } else if (varName.equals(OPTION_SOURCE_SCHEMA_NAME)) {
                Data csvData = (Data)context.get("csvData");
                if (csvData != null && csvData.getTriggerHistory() != null) {
                    value = csvData.getTriggerHistory().getSourceSchemaName();
                }
            } else if (varName.equals(OPTION_SOURCE_DML_TYPE)) {
                value = data.getSourceDmlType().toString();
            } else if (varName.equals(OPTION_BATCH_ID)) {
                value = String.valueOf(context.getBatch().getBatchId());
            } else if (varName.equals(OPTION_BATCH_START_TIME)) {
                value = DateFormatUtils.format((Date)context.getBatch().getStartTime(), (String)TS_PATTERN);
            } else if (varName.equals(OPTION_DELETE_INDICATOR_FLAG)) {
                value = data.getSourceDmlType().equals((Object)DataEventType.DELETE) ? "Y" : "N";
            }
        }
        return new NewAndOldValue(column, data, value);
    }
}

