/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.DbCompareRow;
import org.jumpmind.symmetric.io.DbCompareTables;
import org.jumpmind.symmetric.io.DbValueComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCompareDiffWriter {
    private static final Logger log = LoggerFactory.getLogger(DbCompareDiffWriter.class);
    private boolean continueAfterError = false;
    private boolean error = false;
    private Throwable throwable = null;
    private String longVarbinary = "LONGVARBINARY";
    private String varchar = "VARCHAR";
    private ISymmetricEngine targetEngine;
    private DbCompareTables tables;
    private OutputStream stream;

    public DbCompareDiffWriter(ISymmetricEngine targetEngine, DbCompareTables tables, OutputStream stream) {
        this.targetEngine = targetEngine;
        this.tables = tables;
        this.stream = stream;
    }

    public void writeDelete(DbCompareRow targetCompareRow) {
        block6: {
            if (this.stream == null) {
                return;
            }
            try {
                Table table = targetCompareRow.getTable();
                DmlStatement statement = this.targetEngine.getDatabasePlatform().createDmlStatement(DmlStatement.DmlType.DELETE, table.getCatalog(), table.getSchema(), table.getName(), table.getPrimaryKeyColumns(), null, null, null);
                Row row = new Row(targetCompareRow.getTable().getPrimaryKeyColumnCount());
                for (int i = 0; i < targetCompareRow.getTable().getPrimaryKeyColumnCount(); ++i) {
                    if (this.isUniType(table.getColumn(i).getJdbcTypeName())) {
                        table.getColumn(i).setMappedType(this.varchar);
                        String convertedValue = DbValueComparator.convertString(targetCompareRow.getRowValues().get(targetCompareRow.getTable().getColumn(i).getName()), targetCompareRow.getTable().getColumn(i), false);
                        row.put(table.getColumn(i).getName(), (Object)convertedValue);
                        continue;
                    }
                    row.put(table.getColumn(i).getName(), (Object)targetCompareRow.getRowValues().get(targetCompareRow.getTable().getColumn(i).getName()));
                }
                String sql = statement.buildDynamicDeleteSql(BinaryEncoding.HEX, row, false, true);
                this.writeLine(sql);
                for (int i = 0; i < targetCompareRow.getTable().getPrimaryKeyColumnCount(); ++i) {
                    if (!this.isUniType(table.getColumn(i).getJdbcTypeName())) continue;
                    table.getColumn(i).setMappedType(this.longVarbinary);
                }
            }
            catch (RuntimeException e) {
                this.error = true;
                this.throwable = e;
                log.error(e.getMessage(), (Throwable)e);
                if (this.isContinueAfterError()) break block6;
                throw e;
            }
        }
    }

    public void writeInsert(DbCompareRow sourceCompareRow) {
        block10: {
            if (this.stream == null) {
                return;
            }
            try {
                Table targetTable = this.tables.getTargetTable();
                ArrayList<Column> targetColumns = new ArrayList<Column>();
                ArrayList<Column> targetPkColumns = new ArrayList<Column>();
                for (Column targetColumn : targetTable.getColumns()) {
                    if (!this.tables.getColumnMapping().containsValue(targetColumn) && targetColumn.isRequired() && targetColumn.getDefaultValue() != null) continue;
                    targetColumns.add(targetColumn);
                    if (!targetColumn.isPrimaryKey()) continue;
                    targetPkColumns.add(targetColumn);
                }
                DmlStatement statement = this.targetEngine.getDatabasePlatform().createDmlStatement(DmlStatement.DmlType.INSERT, targetTable.getCatalog(), targetTable.getSchema(), targetTable.getName(), targetPkColumns.toArray(new Column[targetPkColumns.size()]), targetColumns.toArray(new Column[targetColumns.size()]), null, null);
                Row row = new Row(targetColumns.size());
                for (Column sourceColumn : this.tables.getSourceTable().getColumns()) {
                    Column targetColumn = this.tables.getColumnMapping().get(sourceColumn);
                    if (targetColumn == null) continue;
                    boolean targetUnitype = this.isUniType(targetColumn.getJdbcTypeName());
                    boolean sourceUnitype = this.isUniType(sourceColumn.getJdbcTypeName());
                    if (targetUnitype || sourceUnitype) {
                        if (sourceUnitype) {
                            sourceColumn.setMappedType("VARCHAR");
                            if (sourceColumn.getJdbcTypeName().equalsIgnoreCase("unitext")) {
                                row.put(targetColumn.getName(), (Object)sourceCompareRow.getRowValues().get(sourceColumn.getName()));
                                continue;
                            }
                            String convertedString = DbValueComparator.convertString(sourceCompareRow.getRowValues().get(sourceColumn.getName()), sourceColumn, false);
                            row.put(targetColumn.getName(), (Object)convertedString);
                            continue;
                        }
                        if (!targetUnitype) continue;
                        targetColumn.setMappedType("VARCHAR");
                        row.put(targetColumn.getName(), (Object)sourceCompareRow.getRowValues().get(sourceColumn.getName()));
                        continue;
                    }
                    row.put(targetColumn.getName(), (Object)sourceCompareRow.getRowValues().get(sourceColumn.getName()));
                }
                String sql = statement.buildDynamicSql(BinaryEncoding.HEX, row, false, false);
                this.writeLine(sql);
                for (Column sourceColumn : this.tables.getSourceTable().getColumns()) {
                    Column targetColumn = this.tables.getColumnMapping().get(sourceColumn);
                    if (targetColumn == null) continue;
                    if (this.isUniType(targetColumn.getJdbcTypeName())) {
                        targetColumn.setMappedType(this.longVarbinary);
                    }
                    if (!this.isUniType(sourceColumn.getJdbcTypeName())) continue;
                    sourceColumn.setMappedType(this.longVarbinary);
                }
            }
            catch (RuntimeException e) {
                this.error = true;
                this.throwable = e;
                log.error(e.getMessage(), (Throwable)e);
                if (this.isContinueAfterError()) break block10;
                throw e;
            }
        }
    }

    public void writeUpdate(DbCompareRow targetCompareRow, Map<Column, String> deltas) {
        if (this.stream == null) {
            return;
        }
        try {
            Column pkColumn;
            Table table = targetCompareRow.getTable();
            LinkedHashMap<Column, String> deltasCopy = new LinkedHashMap<Column, String>();
            for (Column column : deltas.keySet()) {
                deltasCopy.put((Column)column.clone(), deltas.get(column));
            }
            Column[] changedColumns = deltasCopy.keySet().toArray(new Column[deltasCopy.keySet().size()]);
            DmlStatement statement = this.targetEngine.getDatabasePlatform().createDmlStatement(DmlStatement.DmlType.UPDATE, table.getCatalog(), table.getSchema(), table.getName(), table.getPrimaryKeyColumns(), changedColumns, null, null);
            Row row = new Row(changedColumns.length + table.getPrimaryKeyColumnCount());
            for (Column changedColumn : deltasCopy.keySet()) {
                String value = (String)deltasCopy.get(changedColumn);
                if (this.isUniType(targetCompareRow.getTable().getColumnWithName(changedColumn.getName()).getJdbcTypeName())) {
                    changedColumn.setMappedType(this.varchar);
                    row.put(changedColumn.getName(), (Object)value);
                    continue;
                }
                if (this.isUniType(changedColumn.getJdbcTypeName())) {
                    changedColumn.setMappedType(this.varchar);
                    if (changedColumn.getJdbcTypeName().equalsIgnoreCase("unitext")) {
                        row.put(changedColumn.getName(), (Object)value);
                        continue;
                    }
                    String convertedValue = DbValueComparator.convertString(value, changedColumn, false);
                    row.put(changedColumn.getName(), (Object)convertedValue);
                    continue;
                }
                row.put(changedColumn.getName(), (Object)value);
            }
            for (String pkColumnName : table.getPrimaryKeyColumnNames()) {
                String value = targetCompareRow.getRow().getString(pkColumnName);
                pkColumn = targetCompareRow.getTable().getColumnWithName(pkColumnName);
                if (this.isUniType(pkColumn.getJdbcTypeName())) {
                    String convertedValue = DbValueComparator.convertString(value, pkColumn, true);
                    row.put(pkColumnName, (Object)convertedValue);
                    continue;
                }
                row.put(pkColumnName, (Object)value);
            }
            String sql = statement.buildDynamicSql(BinaryEncoding.HEX, row, false, true);
            this.writeLine(sql);
            for (Column changedColumn : deltasCopy.keySet()) {
                if (!this.isUniType(changedColumn.getJdbcTypeName())) continue;
                changedColumn.setMappedType(this.longVarbinary);
            }
            for (String pkColumnName : table.getPrimaryKeyColumnNames()) {
                pkColumn = targetCompareRow.getTable().getColumnWithName(pkColumnName);
                if (!this.isUniType(pkColumn.getJdbcTypeName())) continue;
                pkColumn.setMappedType(this.longVarbinary);
            }
        }
        catch (RuntimeException e) {
            this.error = true;
            this.throwable = e;
            log.error(e.getMessage(), (Throwable)e);
            if (!this.isContinueAfterError()) {
                throw e;
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                log.debug("CAUGHT EXCEPTION while closing stream", (Throwable)e);
            }
            this.stream = null;
        }
    }

    protected void writeLine(String line) {
        try {
            this.stream.write(line.getBytes());
            this.stream.write("\r\n".getBytes());
        }
        catch (Exception ex) {
            throw new RuntimeException("failed to write to stream '" + line + "'", ex);
        }
    }

    public boolean isUniType(String type) {
        return type.equalsIgnoreCase("UNITEXT") || type.equalsIgnoreCase("UNICHAR") || type.equalsIgnoreCase("UNIVARCHAR");
    }

    public void setContinueAfterError(boolean continueAfterError) {
        this.continueAfterError = continueAfterError;
    }

    public boolean isContinueAfterError() {
        return this.continueAfterError;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isError() {
        return this.error;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

