/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.extract.ColumnsAccordingToTriggerHistory;
import org.jumpmind.symmetric.extract.SelectFromSource;
import org.jumpmind.symmetric.extract.SelectFromTableEvent;
import org.jumpmind.symmetric.extract.SelectFromTableOptions;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.load.IReloadVariableFilter;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TableReloadRequest;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.DefaultDataRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectFromTableSource
extends SelectFromSource {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected OutgoingBatch outgoingBatch;
    protected List<SelectFromTableEvent> selectFromTableEventsToSend;
    protected SelectFromTableEvent currentInitialLoadEvent;
    protected ISqlReadCursor<Data> cursor;
    protected SimpleRouterContext routingContext;
    protected Node node;
    protected Set<Node> nodeSet;
    protected TriggerRouter triggerRouter;
    protected Map<String, IDataRouter> routers;
    protected IDataRouter dataRouter;
    protected boolean isDefaultRouter;
    protected ColumnsAccordingToTriggerHistory columnsAccordingToTriggerHistory;
    protected String overrideSelectSql;
    protected boolean initialLoadSelectUsed;
    protected boolean isSelfReferencingFk;
    protected int selfRefLevel;
    protected String selfRefParentColumnName;
    protected String selfRefChildColumnName;
    protected boolean isFirstRow;
    protected boolean isLobFirstPass;
    protected boolean isConfiguration;
    protected boolean isInitialLoadUseColumnTemplates;

    public SelectFromTableSource(ISymmetricEngine engine, OutgoingBatch outgoingBatch, Batch batch, SelectFromTableEvent event) {
        super(engine);
        this.outgoingBatch = outgoingBatch;
        ArrayList<SelectFromTableEvent> initialLoadEvents = new ArrayList<SelectFromTableEvent>(1);
        initialLoadEvents.add(event);
        outgoingBatch.resetExtractRowStats();
        this.init(batch, initialLoadEvents);
    }

    public SelectFromTableSource(ISymmetricEngine engine, Batch batch, List<SelectFromTableEvent> initialLoadEvents) {
        super(engine);
        this.init(batch, initialLoadEvents);
    }

    protected final void init(Batch batch, List<SelectFromTableEvent> initialLoadEvents) {
        this.batch = batch;
        this.selectFromTableEventsToSend = new ArrayList<SelectFromTableEvent>(initialLoadEvents);
        this.node = this.nodeService.findNode(batch.getTargetNodeId(), true);
        this.nodeSet = new HashSet<Node>(1);
        this.nodeSet.add(this.node);
        this.routers = this.engine.getRouterService().getRouters();
        if (this.node == null) {
            throw new SymmetricException("Could not find a node represented by %s", batch.getTargetNodeId());
        }
        this.columnsAccordingToTriggerHistory = new ColumnsAccordingToTriggerHistory(this.engine, this.nodeService.findIdentity(), this.node);
        this.isInitialLoadUseColumnTemplates = this.parameterService.is("initial.load.use.column.templates.enabled");
    }

    public void setConfiguration(boolean isConfiguration) {
        this.isConfiguration = isConfiguration;
    }

    public CsvData next() {
        CsvData data = null;
        while ((data = this.selectNext()) != null && this.routingContext != null && !this.isDefaultRouter && !this.shouldDataBeRouted(data)) {
        }
        if (data != null && this.outgoingBatch != null && !this.outgoingBatch.isExtractJobFlag()) {
            this.outgoingBatch.incrementExtractRowCount();
            this.outgoingBatch.incrementExtractRowCount(data.getDataEventType());
        }
        return data;
    }

    public boolean shouldDataBeRouted(CsvData data) {
        DataMetaData dataMetaData = new DataMetaData((Data)data, this.sourceTable, this.triggerRouter.getRouter(), this.routingContext.getChannel());
        Set<String> nodeIds = this.dataRouter.routeToNodes(this.routingContext, dataMetaData, this.nodeSet, true, this.initialLoadSelectUsed, this.triggerRouter);
        return nodeIds != null && nodeIds.contains(this.node.getNodeId());
    }

    protected CsvData selectNext() {
        CsvData data = null;
        if (this.currentInitialLoadEvent == null && this.selectFromTableEventsToSend.size() > 0) {
            this.currentInitialLoadEvent = this.selectFromTableEventsToSend.remove(0);
            TriggerHistory history = this.currentInitialLoadEvent.getTriggerHistory();
            this.isSelfReferencingFk = false;
            this.isFirstRow = true;
            if (this.currentInitialLoadEvent.containsData()) {
                data = this.currentInitialLoadEvent.getData();
                this.sourceTable = this.columnsAccordingToTriggerHistory.lookup(this.currentInitialLoadEvent.getTriggerRouter().getRouterId(), history, false, true, false, false);
                this.targetTable = this.columnsAccordingToTriggerHistory.lookup(this.currentInitialLoadEvent.getTriggerRouter().getRouterId(), history, true, false, false, false);
                this.currentInitialLoadEvent = null;
            } else {
                ForeignKey fk;
                this.triggerRouter = this.currentInitialLoadEvent.getTriggerRouter();
                this.initialLoadSelectUsed = this.currentInitialLoadEvent.getInitialLoadSelect() != null && !this.currentInitialLoadEvent.getInitialLoadSelect().equals("1=1") ? true : StringUtils.isNotBlank((CharSequence)this.triggerRouter.getInitialLoadSelect());
                Router router = this.triggerRouter.getRouter();
                if (!StringUtils.isBlank((CharSequence)router.getRouterType())) {
                    this.dataRouter = this.routers.get(router.getRouterType());
                }
                if (this.dataRouter == null) {
                    this.dataRouter = this.routers.get("default");
                }
                this.isDefaultRouter = this.dataRouter instanceof DefaultDataRouter;
                if (this.routingContext == null) {
                    NodeChannel channel;
                    NodeChannel nodeChannel = channel = this.batch != null ? this.configurationService.getNodeChannel(this.batch.getChannelId(), false) : null;
                    if (channel == null) {
                        channel = new NodeChannel(this.triggerRouter.getTrigger().getChannelId());
                    }
                    this.routingContext = new SimpleRouterContext(this.batch == null ? null : this.batch.getTargetNodeId(), channel);
                }
                this.sourceTable = this.columnsAccordingToTriggerHistory.lookup(this.triggerRouter.getRouter().getRouterId(), history, false, true, false, false);
                this.targetTable = this.columnsAccordingToTriggerHistory.lookup(this.triggerRouter.getRouter().getRouterId(), history, true, false, false, false);
                this.overrideSelectSql = this.currentInitialLoadEvent.getInitialLoadSelect();
                if (this.overrideSelectSql != null && this.overrideSelectSql.trim().toUpperCase().startsWith("WHERE")) {
                    this.overrideSelectSql = this.overrideSelectSql.trim().substring(5);
                }
                if (this.parameterService.is("initial.load.recursion.self.fk") && (StringUtils.isBlank((CharSequence)this.overrideSelectSql) || this.overrideSelectSql.equals("1=1")) && (fk = this.sourceTable.getSelfReferencingForeignKey()) != null) {
                    Reference[] refs = fk.getReferences();
                    if (refs.length == 1) {
                        TableReloadRequest loadRequest = null;
                        if (this.outgoingBatch != null) {
                            loadRequest = this.dataService.getTableReloadRequest(this.outgoingBatch.getLoadId());
                        }
                        if (loadRequest == null || !loadRequest.isCreateTable() || !this.parameterService.is("initial.load.defer.create.constraints")) {
                            this.isSelfReferencingFk = true;
                            this.selfRefParentColumnName = refs[0].getLocalColumnName();
                            this.selfRefChildColumnName = refs[0].getForeignColumnName();
                            this.selfRefLevel = 0;
                            this.log.info("Ordering rows for table {} using self-referencing foreign key {} -> {}", new Object[]{this.sourceTable.getName(), this.selfRefParentColumnName, this.selfRefChildColumnName});
                        }
                    } else {
                        this.log.warn("Unable to order rows for self-referencing foreign key because it contains multiple columns");
                    }
                }
                ISymmetricDialect symmetricDialectToUse = this.getSymmetricDialect();
                if (this.routingContext.getChannel().isReloadFlag() && symmetricDialectToUse.isInitialLoadTwoPassLob(this.sourceTable)) {
                    this.isLobFirstPass = true;
                }
                this.startNewCursor(history, this.triggerRouter);
            }
        }
        if (this.cursor != null) {
            data = (CsvData)this.cursor.next();
            if (data == null) {
                this.closeCursor();
                ISymmetricDialect symmetricDialectToUse = this.getSymmetricDialect();
                if (this.isSelfReferencingFk && !this.isFirstRow) {
                    ++this.selfRefLevel;
                    this.startNewCursor(this.currentInitialLoadEvent.getTriggerHistory(), this.triggerRouter);
                    this.isFirstRow = true;
                } else if (symmetricDialectToUse.isInitialLoadTwoPassLob(this.sourceTable) && this.isLobFirstPass) {
                    this.isLobFirstPass = false;
                    this.startNewCursor(this.currentInitialLoadEvent.getTriggerHistory(), this.triggerRouter);
                } else {
                    this.currentInitialLoadEvent = null;
                }
                data = this.next();
            } else if (this.isFirstRow) {
                this.isFirstRow = false;
            }
        }
        return data;
    }

    protected void closeCursor() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }

    public ISymmetricDialect getSymmetricDialect() {
        ISymmetricDialect dialect = null;
        dialect = this.isConfiguration || this.sourceTable != null && this.sourceTable.getNameLowerCase().startsWith(this.parameterService.getTablePrefix().toLowerCase() + "_") ? this.symmetricDialect : this.symmetricDialect.getTargetDialect();
        return dialect;
    }

    protected void startNewCursor(TriggerHistory triggerHistory, TriggerRouter triggerRouter) {
        Channel channel;
        ISymmetricDialect symmetricDialectToUse = this.getSymmetricDialect();
        Object selectSql = this.overrideSelectSql;
        if (this.isSelfReferencingFk) {
            selectSql = "";
            if (this.selfRefLevel == 0) {
                selectSql = (String)selectSql + "(" + SymmetricUtils.quote(symmetricDialectToUse, this.selfRefParentColumnName) + " is null or " + SymmetricUtils.quote(symmetricDialectToUse, this.selfRefParentColumnName) + " = " + SymmetricUtils.quote(symmetricDialectToUse, this.selfRefChildColumnName) + ") ";
            } else {
                DatabaseInfo info = symmetricDialectToUse.getPlatform().getDatabaseInfo();
                String tableName = Table.getFullyQualifiedTableName((String)this.sourceTable.getCatalog(), (String)this.sourceTable.getSchema(), (String)this.sourceTable.getName(), (String)info.getDelimiterToken(), (String)info.getCatalogSeparator(), (String)info.getSchemaSeparator());
                String refSql = "select " + SymmetricUtils.quote(symmetricDialectToUse, this.selfRefChildColumnName) + " from " + tableName + " where " + SymmetricUtils.quote(symmetricDialectToUse, this.selfRefParentColumnName);
                selectSql = (String)selectSql + SymmetricUtils.quote(symmetricDialectToUse, this.selfRefParentColumnName) + " in (";
                for (int i = 1; i < this.selfRefLevel; ++i) {
                    selectSql = (String)selectSql + (String)refSql + " in (";
                }
                selectSql = (String)selectSql + (String)refSql + " is null or " + SymmetricUtils.quote(symmetricDialectToUse, this.selfRefChildColumnName) + " = " + SymmetricUtils.quote(symmetricDialectToUse, this.selfRefParentColumnName) + " ) and " + SymmetricUtils.quote(symmetricDialectToUse, this.selfRefParentColumnName) + " != " + SymmetricUtils.quote(symmetricDialectToUse, this.selfRefChildColumnName) + StringUtils.repeat((String)")", (int)(this.selfRefLevel - 1));
            }
            this.log.info("Querying level {} for table {}: {}", new Object[]{this.selfRefLevel, this.sourceTable.getName(), selectSql});
        }
        if ((channel = this.configurationService.getChannel(triggerRouter.getTrigger().getReloadChannelId())).isReloadFlag() && symmetricDialectToUse.isInitialLoadTwoPassLob(this.sourceTable)) {
            channel = new Channel();
            channel.setContainsBigLob(!this.isLobFirstPass);
            selectSql = symmetricDialectToUse.getInitialLoadTwoPassLobSql((String)selectSql, this.sourceTable, this.isLobFirstPass);
            this.log.info("Querying {} pass LOB for table {}: {}", new Object[]{this.isLobFirstPass ? "first" : "second", this.sourceTable.getName(), selectSql});
        }
        String sql = symmetricDialectToUse.createInitialLoadSqlFor(this.currentInitialLoadEvent.getNode(), triggerRouter, this.sourceTable, triggerHistory, channel, (String)selectSql);
        for (IReloadVariableFilter filter : this.extensionService.getExtensionPointList(IReloadVariableFilter.class)) {
            sql = filter.filterInitalLoadSql(sql, this.node, this.targetTable);
        }
        boolean checkRowLength = this.parameterService.is("extract.check.row.size", false);
        SelectFromTableOptions options = new SelectFromTableOptions().triggerHistory(triggerHistory).initialLoadSql(sql).expectedCommaCount(triggerHistory.getParsedColumnNames().length - 1).selectedAsCsv(symmetricDialectToUse.getParameterService().is("initial.load.concat.csv.in.sql.enabled")).maxBatchSize(channel.getMaxBatchSize()).objectValuesWillNeedEscaped(!symmetricDialectToUse.getTriggerTemplate().useTriggerTemplateForColumnTemplatesDuringInitialLoad()).columnPositionUsingTemplate(symmetricDialectToUse.getColumnPositionUsingTemplate(this.sourceTable, triggerHistory)).checkRowLength(checkRowLength).rowMaxLength(this.parameterService.getLong("extract.row.max.length", 1000000000L)).returnLobObjects(checkRowLength && this.sourceTable.containsLobColumns(this.symmetricDialect.getPlatform()) && !this.sourceTable.getNameLowerCase().startsWith(this.symmetricDialect.getTablePrefix()));
        this.log.debug(sql);
        this.cursor = this.createCursor(symmetricDialectToUse, options);
    }

    protected ISqlReadCursor<Data> createCursor(ISymmetricDialect symmetricDialectToUse, final SelectFromTableOptions options) {
        return symmetricDialectToUse.getPlatform().getSqlTemplate().queryForCursor(options.getInitialLoadSql(), (ISqlRowMapper)new ISqlRowMapper<Data>(){

            public Data mapRow(Row row) {
                long rowSize;
                if (options.isCheckRowLength() && (rowSize = row.getLength() * 2L) > options.getRowMaxLength()) {
                    StringBuilder pkValues = new StringBuilder();
                    int i = 0;
                    Object[] rowValues = row.values().toArray();
                    for (String name : SelectFromTableSource.this.sourceTable.getPrimaryKeyColumnNames()) {
                        pkValues.append(name).append("=").append(rowValues[i]);
                        ++i;
                    }
                    SelectFromTableSource.this.log.warn("Extract row max size exceeded, keys [" + pkValues.toString() + "], size=" + rowSize);
                    Data data = new Data(0L, null, "", DataEventType.SQL, options.getTriggerHistory().getSourceTableName(), null, options.getTriggerHistory(), SelectFromTableSource.this.batch.getChannelId(), null, null);
                    return data;
                }
                String csvRow = null;
                if (options.isSelectedAsCsv()) {
                    csvRow = row.stringValue();
                    int commaCount = StringUtils.countMatches((CharSequence)csvRow, (CharSequence)",");
                    if (commaCount < options.getExpectedCommaCount()) {
                        throw new SymmetricException("The extracted row data did not have the expected (%d) number of columns (actual=%s): %s.  The initial load sql was: %s", options.getExpectedCommaCount(), commaCount, csvRow, options.getInitialLoadSql());
                    }
                } else {
                    csvRow = options.isObjectValuesWillNeedEscaped() ? SelectFromTableSource.this.platform.getCsvStringValue(SelectFromTableSource.this.symmetricDialect.getBinaryEncoding(), SelectFromTableSource.this.sourceTable.getColumns(), row, options.isColumnPositionUsingTemplate()) : row.csvValue();
                }
                Data data = new Data(0L, null, csvRow, DataEventType.INSERT, options.getTriggerHistory().getSourceTableName(), null, options.getTriggerHistory(), SelectFromTableSource.this.batch.getChannelId(), null, null);
                return data;
            }
        }, options.isReturnLobObjects());
    }

    public boolean requiresLobsSelectedFromSource(CsvData data) {
        if (this.isInitialLoadUseColumnTemplates && this.currentInitialLoadEvent != null && this.currentInitialLoadEvent.getTriggerRouter() != null) {
            if (this.currentInitialLoadEvent.getTriggerRouter().getTrigger().isUseStreamLobs() || data != null && this.hasLobsThatNeedExtract(this.sourceTable, data)) {
                return true;
            }
            return this.currentInitialLoadEvent.getTriggerRouter().getTrigger().isUseStreamLobs();
        }
        return false;
    }

    public void close() {
        this.closeCursor();
    }
}

