/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.sql.DmlStatement;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.Row;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.extract.ColumnsAccordingToTriggerHistory;
import org.jumpmind.symmetric.extract.SelectFromSource;
import org.jumpmind.symmetric.extract.SelectFromTableEvent;
import org.jumpmind.symmetric.extract.SelectFromTableSource;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.CsvUtils;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.ProtocolException;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.TableReloadRequest;
import org.jumpmind.symmetric.model.TableReloadStatus;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractFileParsingRouter;
import org.jumpmind.symmetric.util.CounterStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectFromSymDataSource
extends SelectFromSource {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected OutgoingBatch outgoingBatch;
    protected TriggerHistory lastTriggerHistory;
    protected String lastRouterId;
    protected boolean requiresLobSelectedFromSource;
    protected ISqlReadCursor<Data> cursor;
    protected SelectFromTableSource reloadSource;
    protected Node targetNode;
    protected ProcessInfo processInfo;
    protected ColumnsAccordingToTriggerHistory columnsAccordingToTriggerHistory;
    protected Map<Integer, TriggerRouter> triggerRoutersByTriggerHist;
    protected Map<Integer, CounterStat> missingTriggerRoutersByTriggerHist = new HashMap<Integer, CounterStat>();
    protected boolean containsBigLob;
    protected boolean dialectHasNoOldBinaryData;

    public SelectFromSymDataSource(ISymmetricEngine engine, OutgoingBatch outgoingBatch, Node sourceNode, Node targetNode, ProcessInfo processInfo, boolean containsBigLob) {
        super(engine);
        this.outgoingBatch = outgoingBatch;
        this.processInfo = processInfo;
        this.targetNode = targetNode;
        this.containsBigLob = containsBigLob;
        this.batch = new Batch(Batch.BatchType.EXTRACT, outgoingBatch.getBatchId(), outgoingBatch.getChannelId(), this.symmetricDialect.getBinaryEncoding(), sourceNode.getNodeId(), outgoingBatch.getNodeId(), outgoingBatch.isCommonFlag());
        this.columnsAccordingToTriggerHistory = new ColumnsAccordingToTriggerHistory(engine, sourceNode, targetNode);
        outgoingBatch.resetExtractRowStats();
        this.triggerRoutersByTriggerHist = this.triggerRouterService.getTriggerRoutersByTriggerHist(targetNode.getNodeGroupId(), false);
        this.dialectHasNoOldBinaryData = this.symmetricDialect.getName().equals("mssql2000") || this.symmetricDialect.getName().equals("mssql2005") || this.symmetricDialect.getName().equals("mssql2008") || this.symmetricDialect.getName().equals("mssql2016");
    }

    public CsvData next() {
        if (this.cursor == null) {
            this.cursor = this.dataService.selectDataFor(this.batch.getBatchId(), this.batch.getTargetNodeId(), this.containsBigLob);
        }
        Data data = null;
        if (this.reloadSource != null) {
            data = (Data)this.reloadSource.next();
            this.targetTable = this.reloadSource.getTargetTable();
            this.sourceTable = this.reloadSource.getSourceTable();
            if (data == null) {
                this.reloadSource.close();
                this.reloadSource = null;
            } else {
                this.requiresLobSelectedFromSource = this.reloadSource.requiresLobsSelectedFromSource(data);
            }
            this.lastTriggerHistory = null;
        }
        if (data == null) {
            data = (Data)this.cursor.next();
            if (data != null) {
                TriggerHistory triggerHistory = null;
                TriggerRouter triggerRouter = null;
                boolean isFileParserRouter = false;
                do {
                    if (isFileParserRouter = (triggerHistory = data.getTriggerHistory()).getTriggerId().equals("SYM_VIRTUAL_FILE_PARSE_TRIGGER")) {
                        triggerRouter = new TriggerRouter();
                        triggerRouter.setTriggerId(triggerHistory.getTriggerId());
                        triggerRouter.setRouterId(AbstractFileParsingRouter.getRouterIdFromExternalData(data.getExternalData()));
                    } else {
                        triggerRouter = this.triggerRoutersByTriggerHist.get(triggerHistory.getTriggerHistoryId());
                    }
                    if (triggerRouter != null) continue;
                    CounterStat counterStat = this.missingTriggerRoutersByTriggerHist.get(triggerHistory.getTriggerHistoryId());
                    if (counterStat == null) {
                        triggerRouter = this.triggerRouterService.getTriggerRouterByTriggerHist(this.targetNode.getNodeGroupId(), triggerHistory.getTriggerHistoryId(), true);
                        if (triggerRouter == null) {
                            counterStat = new CounterStat(data.getDataId(), 1L);
                            this.missingTriggerRoutersByTriggerHist.put(triggerHistory.getTriggerHistoryId(), counterStat);
                            data = (Data)this.cursor.next();
                        }
                    } else {
                        counterStat.incrementCount();
                        data = (Data)this.cursor.next();
                    }
                    if (data == null) {
                        this.closeCursor();
                        return null;
                    }
                    this.triggerRoutersByTriggerHist.put(triggerHistory.getTriggerHistoryId(), triggerRouter);
                } while (triggerRouter == null);
                String routerId = triggerRouter.getRouterId();
                if (data.getDataEventType() == DataEventType.RELOAD) {
                    data = this.processReloadEvent(triggerHistory, triggerRouter, data);
                } else {
                    Trigger trigger = triggerRouter.getTrigger();
                    if (this.lastTriggerHistory == null || this.lastTriggerHistory.getTriggerHistoryId() != triggerHistory.getTriggerHistoryId() || this.lastRouterId == null || !this.lastRouterId.equals(routerId)) {
                        this.sourceTable = this.columnsAccordingToTriggerHistory.lookup(routerId, triggerHistory, false, !isFileParserRouter, false, true);
                        this.targetTable = this.columnsAccordingToTriggerHistory.lookup(routerId, triggerHistory, true, false, false, true);
                        this.requiresLobSelectedFromSource = trigger != null && trigger.isUseStreamLobs() || data.getRowData() != null && this.hasLobsThatNeedExtract(this.sourceTable, data);
                    }
                    data.setNoBinaryOldData(this.requiresLobSelectedFromSource || this.dialectHasNoOldBinaryData);
                    this.outgoingBatch.incrementExtractRowCount();
                    this.outgoingBatch.incrementExtractRowCount(data.getDataEventType());
                    if (data.getDataEventType() == DataEventType.INSERT || data.getDataEventType() == DataEventType.UPDATE) {
                        int expectedColumnCount = triggerHistory.getParsedColumnNames().length;
                        int columnCount = 0;
                        boolean corrupted = false;
                        if (this.outgoingBatch.getSqlCode() == -888) {
                            columnCount = data.getParsedData("rowData").length;
                            corrupted = columnCount != expectedColumnCount;
                        } else {
                            columnCount = StringUtils.countMatches((CharSequence)data.getRowData(), (CharSequence)",") + 1;
                            boolean bl = corrupted = columnCount < expectedColumnCount;
                        }
                        if (corrupted) {
                            Object message = "The extracted row for table %s had %d columns but expected %d.  ";
                            message = this.containsBigLob ? (String)message + "Trigger history " + triggerHistory.getTriggerHistoryId() + " has columns: " + triggerHistory.getColumnNames() + ".  Corrupted row for data ID " + data.getDataId() + ": " + data.getRowData() : (String)message + "If this happens often, it might be better to isolate the table with sym_channel.contains_big_lobs enabled.";
                            throw new ProtocolException((String)message, new Object[]{data.getTableName(), columnCount, expectedColumnCount});
                        }
                    } else if (data.getDataEventType() == DataEventType.DELETE && this.outgoingBatch.getSqlCode() == -888) {
                        int expectedColumnCount = triggerHistory.getParsedPkColumnNames().length;
                        int columnCount = data.getParsedData("pkData").length;
                        if (columnCount != expectedColumnCount) {
                            String message = "The extracted row for table %s had %d pk columns but expected %d.  Trigger history " + triggerHistory.getTriggerHistoryId() + " has pk columns: " + triggerHistory.getPkColumnNames() + ".  Corrupted row for data ID " + data.getDataId() + ": " + data.getPkData();
                            throw new ProtocolException(message, new Object[]{data.getTableName(), columnCount, expectedColumnCount});
                        }
                    } else if (data.getDataEventType() == DataEventType.CREATE && StringUtils.isBlank((CharSequence)data.getCsvData("rowData")) && !this.processCreateEvent(triggerHistory, routerId, data)) {
                        return null;
                    }
                }
                if (data != null) {
                    this.lastTriggerHistory = data.getTriggerHistory();
                    this.lastRouterId = routerId;
                }
            } else {
                this.closeCursor();
            }
        }
        return data;
    }

    protected Data processReloadEvent(TriggerHistory triggerHistory, TriggerRouter triggerRouter, Data data) {
        this.processInfo.setCurrentTableName(triggerHistory.getSourceTableName());
        String initialLoadSelect = data.getRowData();
        if (initialLoadSelect == null && triggerRouter.getTrigger().isStreamRow()) {
            this.sourceTable = this.columnsAccordingToTriggerHistory.lookup(triggerRouter.getRouter().getRouterId(), triggerHistory, false, true, false, false);
            Column[] columns = this.sourceTable.getPrimaryKeyColumns();
            String[] pkData = data.getParsedData("pkData");
            boolean[] nullKeyValues = new boolean[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                nullKeyValues[i] = !column.isRequired() && pkData[i] == null;
            }
            DmlStatement dmlStmt = this.platform.createDmlStatement(DmlStatement.DmlType.WHERE, this.sourceTable.getCatalog(), this.sourceTable.getSchema(), this.sourceTable.getName(), this.sourceTable.getPrimaryKeyColumns(), this.sourceTable.getColumns(), nullKeyValues, null);
            Row row = new Row(columns.length);
            for (int i = 0; i < columns.length; ++i) {
                row.put(columns[i].getName(), (Object)pkData[i]);
            }
            initialLoadSelect = dmlStmt.buildDynamicSql(this.batch.getBinaryEncoding(), row, false, true, columns);
            if (initialLoadSelect.endsWith(this.platform.getDatabaseInfo().getSqlCommandDelimiter())) {
                initialLoadSelect = initialLoadSelect.substring(0, initialLoadSelect.length() - this.platform.getDatabaseInfo().getSqlCommandDelimiter().length());
            }
        }
        SelectFromTableEvent event = new SelectFromTableEvent(this.targetNode, triggerRouter, triggerHistory, initialLoadSelect);
        this.reloadSource = this.createSelectFromTableSource(event);
        data = (Data)this.reloadSource.next();
        this.sourceTable = this.reloadSource.getSourceTable();
        this.targetTable = this.reloadSource.getTargetTable();
        this.requiresLobSelectedFromSource = this.reloadSource.requiresLobsSelectedFromSource(data);
        if (data == null) {
            data = new Data();
        }
        return data;
    }

    protected SelectFromTableSource createSelectFromTableSource(SelectFromTableEvent event) {
        return new SelectFromTableSource(this.engine, this.outgoingBatch, this.batch, event);
    }

    protected boolean evaluateDeferTableLogging(OutgoingBatch batch, boolean deferIndices) {
        if (!this.outgoingBatch.isLoadFlag()) {
            return false;
        }
        if (!this.parameterService.is("initial.load.defer.table.logging", false)) {
            return false;
        }
        DatabaseInfo databaseInfo = this.platform.getDatabaseInfo();
        if (databaseInfo == null || !databaseInfo.isTableLevelLoggingSupported()) {
            return false;
        }
        TableReloadRequest outgoingLoad = this.dataService.getTableReloadRequest(batch.getLoadId());
        if (outgoingLoad == null) {
            return false;
        }
        return deferIndices || outgoingLoad.isCreateTable();
    }

    protected boolean processCreateEvent(TriggerHistory triggerHistory, String routerId, Data data) {
        Object triggers;
        TableReloadStatus tableReloadStatus;
        String oldData = data.getCsvData("oldData");
        boolean sendSchemaExcludeIndices = false;
        boolean sendSchemaExcludeForeignKeys = false;
        boolean sendSchemaExcludeDefaults = false;
        if (oldData != null && oldData.length() > 0) {
            String[] excludes;
            for (String exclude : excludes = data.getCsvData("oldData").split(",")) {
                if ("excludeIndices".equals(exclude)) {
                    sendSchemaExcludeIndices = true;
                    continue;
                }
                if ("excludeForeignKeys".equals(exclude)) {
                    sendSchemaExcludeForeignKeys = true;
                    continue;
                }
                if (!"excludeDefaults".equals(exclude)) continue;
                sendSchemaExcludeDefaults = true;
            }
        }
        boolean excludeDefaults = this.parameterService.is("create.table.without.defaults", false) | sendSchemaExcludeDefaults;
        boolean excludeForeignKeys = this.parameterService.is("create.table.without.foreign.keys", false) | sendSchemaExcludeForeignKeys;
        boolean excludeIndexes = this.parameterService.is("create.table.without.indexes", false) | sendSchemaExcludeIndices;
        boolean deferConstraints = this.outgoingBatch.isLoadFlag() && this.parameterService.is("initial.load.defer.create.constraints", false);
        boolean deferTableLogging = this.evaluateDeferTableLogging(this.outgoingBatch, sendSchemaExcludeIndices);
        boolean includeTriggerDdl = this.parameterService.is("create.table.include.application.triggers", false);
        if (this.outgoingBatch.getLoadId() > 0L && (tableReloadStatus = this.dataService.getTableReloadStatusByLoadIdAndSourceNodeId(this.outgoingBatch.getLoadId(), this.engine.getNodeId())) != null && tableReloadStatus.isCompleted()) {
            return false;
        }
        this.sourceTable = this.symmetricDialect.getTargetDialect().getPlatform().getTableFromCache(this.sourceTable.getCatalog(), this.sourceTable.getSchema(), this.sourceTable.getName(), true);
        this.targetTable = this.columnsAccordingToTriggerHistory.lookup(routerId, triggerHistory, true, true, true, false);
        Table copyTargetTable = this.targetTable.copy();
        Database db = new Database();
        db.setName("dataextractor");
        db.setCatalog(copyTargetTable.getCatalog());
        db.setSchema(copyTargetTable.getSchema());
        db.addTable(copyTargetTable);
        if (deferTableLogging) {
            copyTargetTable.setLogging(false);
        }
        if (excludeDefaults) {
            copyTargetTable.removeAllColumnDefaults();
        }
        if (excludeForeignKeys || deferConstraints) {
            copyTargetTable.removeAllForeignKeys();
        }
        if (excludeIndexes || deferConstraints) {
            copyTargetTable.removeAllIndexes();
        }
        if (includeTriggerDdl && (triggers = this.platform.getDdlReader().getApplicationTriggersForModel(this.sourceTable.getCatalog(), this.sourceTable.getSchema(), this.sourceTable.getName(), this.symmetricDialect.getTablePrefix())) != null && triggers.size() > 0) {
            copyTargetTable.addTriggers((Collection)triggers);
        }
        if (this.parameterService.is("create.table.without.pk.if.source.without.pk", false) && this.sourceTable.getPrimaryKeyColumnCount() == 0 && copyTargetTable.getPrimaryKeyColumnCount() > 0) {
            for (Column column : copyTargetTable.getColumns()) {
                column.setPrimaryKey(false);
            }
        }
        if (this.parameterService.is("mysql.tinyint.ddl.to.boolean", false)) {
            for (Column column : copyTargetTable.getColumns()) {
                if (column.getJdbcTypeCode() != -6) continue;
                column.setJdbcTypeCode(16);
                column.setMappedTypeCode(16);
            }
        }
        if (this.parameterService.is("sybase.ase.convert.unitypes.for.sync")) {
            for (Column column : copyTargetTable.getColumns()) {
                Map platformColumns = column.getPlatformColumns();
                if (!platformColumns.containsKey("ase")) continue;
                String platformColumnType = ((PlatformColumn)platformColumns.get("ase")).getType();
                if (platformColumnType.equalsIgnoreCase("UNITEXT")) {
                    column.setMappedType("CLOB");
                    column.setMappedTypeCode(2005);
                    continue;
                }
                if (platformColumnType.equalsIgnoreCase("UNICHAR")) {
                    column.setMappedType("CHAR");
                    column.setMappedTypeCode(1);
                    continue;
                }
                if (!platformColumnType.equalsIgnoreCase("UNIVARCHAR")) continue;
                column.setMappedType("VARCHAR");
                column.setMappedTypeCode(12);
            }
        }
        String xml = DatabaseXmlUtil.toXml((Database)db);
        data.setRowData(CsvUtils.escapeCsvData((String)xml));
        if (excludeDefaults || excludeForeignKeys || excludeIndexes || deferConstraints || deferTableLogging) {
            this.log.debug("Adjusted batch {} channel {} table definition: {}", new Object[]{this.outgoingBatch.getNodeBatchId(), this.outgoingBatch.getChannelId(), xml});
        }
        return true;
    }

    public boolean requiresLobsSelectedFromSource(CsvData data) {
        return this.requiresLobSelectedFromSource;
    }

    protected void closeCursor() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
        this.batch = null;
        this.sourceTable = null;
        this.targetTable = null;
    }

    public void close() {
        this.closeCursor();
        if (this.reloadSource != null) {
            this.reloadSource.close();
        }
        for (Map.Entry<Integer, CounterStat> entry : this.missingTriggerRoutersByTriggerHist.entrySet()) {
            this.log.warn("Could not find trigger router for trigger hist of {}.  Skipped {} events starting with data id of {}", new Object[]{entry.getKey(), entry.getValue().getCount(), entry.getValue().getObject()});
        }
    }
}

