/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.extract;

import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.reader.IExtractDataReaderSource;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.ITriggerRouterService;

public abstract class SelectFromSource
implements IExtractDataReaderSource {
    protected ISymmetricEngine engine;
    protected IDatabasePlatform platform;
    protected ISymmetricDialect symmetricDialect;
    protected IParameterService parameterService;
    protected IDataService dataService;
    protected ITriggerRouterService triggerRouterService;
    protected IConfigurationService configurationService;
    protected INodeService nodeService;
    protected IExtensionService extensionService;
    protected Batch batch;
    protected Table sourceTable;
    protected Table targetTable;

    public SelectFromSource(ISymmetricEngine engine) {
        this.engine = engine;
        this.platform = engine.getDatabasePlatform();
        this.symmetricDialect = engine.getSymmetricDialect();
        this.parameterService = engine.getParameterService();
        this.dataService = engine.getDataService();
        this.triggerRouterService = engine.getTriggerRouterService();
        this.configurationService = engine.getConfigurationService();
        this.nodeService = engine.getNodeService();
        this.extensionService = engine.getExtensionService();
    }

    public Batch getBatch() {
        return this.batch;
    }

    public Table getSourceTable() {
        return this.sourceTable;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    protected boolean hasLobsThatNeedExtract(Table table, CsvData data) {
        if (table.containsLobColumns(this.platform)) {
            String[] colNames = table.getColumnNames();
            Map colMap = data.toColumnNameValuePairs(colNames, "rowData");
            List lobColumns = table.getLobColumns(this.platform);
            for (Column c : lobColumns) {
                String value = (String)colMap.get(c.getName());
                if (value == null || !value.equals("\b") && !value.equals("08")) continue;
                return true;
            }
        }
        return false;
    }
}

