/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.cache;

import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.LoadFilter;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.service.ILoadFilterService;
import org.jumpmind.symmetric.service.IParameterService;

public class LoadFilterCache {
    private IParameterService parameterService;
    private ILoadFilterService loadFilterService;
    private volatile Map<NodeGroupLink, Map<LoadFilter.LoadFilterType, Map<String, List<LoadFilter>>>> loadFilterCache;
    private volatile long loadFilterCacheTime = 0L;
    private volatile Object loadFilterCacheLock = new Object();

    public LoadFilterCache(ISymmetricEngine engine) {
        this.parameterService = engine.getParameterService();
        this.loadFilterService = engine.getLoadFilterService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<NodeGroupLink, Map<LoadFilter.LoadFilterType, Map<String, List<LoadFilter>>>> findLoadFilters(NodeGroupLink nodeGroupLink, boolean useCache) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.load.filter.time.ms");
        if (System.currentTimeMillis() - this.loadFilterCacheTime >= cacheTimeoutInMs || this.loadFilterCache == null) {
            Object object = this.loadFilterCacheLock;
            synchronized (object) {
                if (System.currentTimeMillis() - this.loadFilterCacheTime >= cacheTimeoutInMs || this.loadFilterCache == null) {
                    this.loadFilterCache = this.loadFilterService.findLoadFiltersFromDb();
                    this.loadFilterCacheTime = System.currentTimeMillis();
                }
            }
        }
        return this.loadFilterCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLoadFilterCache() {
        Object object = this.loadFilterCacheLock;
        synchronized (object) {
            this.loadFilterCacheTime = 0L;
        }
    }
}

