/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.RegistrationRedirectException;
import org.jumpmind.symmetric.transport.http.HttpTransportManager;
import org.jumpmind.symmetric.web.AbstractUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;

public class RegistrationUriHandler
extends AbstractUriHandler {
    private IRegistrationService registrationService;

    public RegistrationUriHandler(IParameterService parameterService, IRegistrationService registrationService, IInterceptor ... interceptors) {
        super("/registration/*", parameterService, interceptors);
        this.registrationService = registrationService;
    }

    public void handle(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Node node = this.transform(req);
        try {
            ServletOutputStream outputStream = res.getOutputStream();
            String userId = ServletUtils.getParameter((HttpServletRequest)req, (String)"regUserId");
            String password = ServletUtils.getParameter((HttpServletRequest)req, (String)"regPassword");
            if (!this.registerNode(node, this.getHostName(req), this.getIpAddress(req), (OutputStream)outputStream, userId, password)) {
                this.log.warn("{} was not allowed to register.", (Object)node);
                ServletUtils.sendError((HttpServletResponse)res, (int)656, (String)String.format("%s was not allowed to register.", node));
            }
        }
        catch (RegistrationRedirectException e) {
            String redirectedRegistrationURL = HttpTransportManager.buildRegistrationUrl((String)e.getRedirectionUrl(), (Node)node);
            if (StringUtils.isNotEmpty((CharSequence)req.getQueryString())) {
                redirectedRegistrationURL = redirectedRegistrationURL + "?" + req.getQueryString();
            }
            res.sendRedirect(redirectedRegistrationURL);
        }
    }

    private Node transform(HttpServletRequest req) {
        Node node = new Node();
        node.setNodeGroupId(ServletUtils.getParameter((HttpServletRequest)req, (String)"nodeGroupId"));
        node.setSymmetricVersion(ServletUtils.getParameter((HttpServletRequest)req, (String)"symmetricVersion"));
        node.setExternalId(ServletUtils.getParameter((HttpServletRequest)req, (String)"externalId"));
        String syncUrlString = ServletUtils.getParameter((HttpServletRequest)req, (String)"syncURL");
        if (StringUtils.isNotBlank((CharSequence)syncUrlString)) {
            node.setSyncUrl(syncUrlString);
        }
        node.setSchemaVersion(ServletUtils.getParameter((HttpServletRequest)req, (String)"schemaVersion"));
        node.setDatabaseType(ServletUtils.getParameter((HttpServletRequest)req, (String)"databaseType"));
        node.setDatabaseVersion(ServletUtils.getParameter((HttpServletRequest)req, (String)"databaseVersion"));
        node.setDeploymentType(ServletUtils.getParameter((HttpServletRequest)req, (String)"deploymentType"));
        node.setDatabaseName(ServletUtils.getParameter((HttpServletRequest)req, (String)"databaseName"));
        return node;
    }

    protected String getHostName(HttpServletRequest req) {
        String hostName = ServletUtils.getParameter((HttpServletRequest)req, (String)"hostName");
        if (StringUtils.isBlank((CharSequence)hostName)) {
            hostName = req.getRemoteHost();
        }
        return hostName;
    }

    protected String getIpAddress(HttpServletRequest req) {
        String ipAdddress = ServletUtils.getParameter((HttpServletRequest)req, (String)"ipAddress");
        if (StringUtils.isBlank((CharSequence)ipAdddress)) {
            ipAdddress = req.getRemoteAddr();
        }
        return ipAdddress;
    }

    protected boolean registerNode(Node node, String remoteHost, String remoteAddress, OutputStream outputStream, String userId, String password) throws IOException {
        return this.registrationService.registerNode(node, remoteHost, remoteAddress, outputStream, userId, password, true);
    }
}

