/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker.dau;

import com.vaadin.pro.licensechecker.LocalSubscriptionKey;
import com.vaadin.pro.licensechecker.SubscriptionKey;
import com.vaadin.pro.licensechecker.Util;
import com.vaadin.pro.licensechecker.dau.DauStorage;
import com.vaadin.pro.licensechecker.dau.EnforcementException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public final class DauIntegration {
    public static void startTracking(String applicationName) {
        LocalSubscriptionKey.getOrFail();
        DauStorage.getInstance().start(applicationName);
    }

    public static void stopTracking() {
        DauStorage.getInstance().stop();
    }

    public static String newTrackingHash() {
        return DauIntegration.hashValue(UUID.randomUUID().toString());
    }

    public static void trackUser(String trackingHash) throws EnforcementException {
        DauStorage.getInstance().track(trackingHash);
    }

    public static void trackUser(String trackingHash, String userIdentity) {
        userIdentity = userIdentity == null || userIdentity.trim().isEmpty() ? null : DauIntegration.hashValue(userIdentity);
        DauStorage.getInstance().track(trackingHash, userIdentity);
    }

    private static String hashValue(String value) {
        SubscriptionKey key = LocalSubscriptionKey.getOrFail();
        return Util.getHash(value, key.getKey().getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
    }

    public static void checkSubscriptionKey() {
        DauStorage.getInstance().checkSubscriptionKey();
    }

    public static boolean shouldEnforce() {
        return DauStorage.getInstance().shouldEnforceThisUser();
    }
}

