/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.open.Open;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.History;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.LocalOfflineKey;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.LocalSubscriptionKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.OfflineKey;
import com.vaadin.pro.licensechecker.OfflineKeyValidator;
import com.vaadin.pro.licensechecker.OnlineKeyValidator;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Product;
import com.vaadin.pro.licensechecker.SubscriptionKey;
import com.vaadin.pro.licensechecker.VaadinComIntegration;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseChecker {
    static final int DEFAULT_KEY_URL_HANDLER_TIMEOUT_SECONDS = 60;
    private static boolean strictOffline = false;
    static String loggedLicenseOwner = null;
    static Consumer<String> systemBrowserUrlHandler = url -> {
        try {
            LicenseChecker.getLogger().info("Opening system browser to validate license. If the browser is not opened, please open " + url + " manually");
            Open.open((String)url);
            LicenseChecker.getLogger().info("For CI/CD build servers, you need to download a server license key, which can only be used for production builds. You can download a server license key from https://vaadin.com/myaccount/licenses.\nIf you are working offline in development mode, please visit " + OfflineKeyValidator.getOfflineUrl(MachineId.get()) + " for an offline development mode license.");
        }
        catch (Exception e) {
            LicenseChecker.getLogger().error("Error opening system browser to validate license. Please open " + url + " manually", (Throwable)e);
        }
    };

    @Deprecated
    public static void checkLicenseFromStaticBlock(String productName, String productVersion) {
        LicenseChecker.checkLicenseFromStaticBlock(productName, productVersion, BuildType.DEVELOPMENT);
    }

    public static void checkLicenseFromStaticBlock(String productName, String productVersion, BuildType buildType) {
        try {
            LicenseChecker.checkLicense(productName, productVersion, buildType);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @Deprecated
    public static void checkLicense(String productName, String productVersion) {
        LicenseChecker.checkLicense(productName, productVersion, BuildType.DEVELOPMENT, systemBrowserUrlHandler);
    }

    public static void checkLicense(String productName, String productVersion, BuildType buildType) {
        LicenseChecker.checkLicense(productName, productVersion, buildType, systemBrowserUrlHandler);
    }

    public static void checkLicense(String productName, String productVersion, BuildType buildType, Consumer<String> noKeyUrlHandler, String machineId, ProKey proKey, SubscriptionKey subscriptionKey, OfflineKey offlineKey) {
        LicenseChecker.checkLicense(new Product(productName, productVersion), buildType, noKeyUrlHandler, machineId, proKey, subscriptionKey, offlineKey, new OnlineKeyValidator(), new OfflineKeyValidator(), new VaadinComIntegration(), 60);
    }

    public static void checkLicense(String productName, String productVersion, Consumer<String> noKeyUrlHandler) {
        LicenseChecker.checkLicense(productName, productVersion, BuildType.DEVELOPMENT, noKeyUrlHandler);
    }

    public static void checkLicense(String productName, String productVersion, BuildType buildType, Consumer<String> noKeyUrlHandler) {
        LicenseChecker.checkLicense(productName, productVersion, buildType, noKeyUrlHandler, 60);
    }

    public static void checkLicense(String productName, String productVersion, BuildType buildType, Consumer<String> noKeyUrlHandler, int timeoutKeyUrlHandler) {
        LicenseChecker.checkLicense(new Product(productName, productVersion), buildType, noKeyUrlHandler, timeoutKeyUrlHandler);
    }

    public static boolean isValidLicense(String productName, String productVersion, BuildType buildType) {
        try {
            LicenseChecker.checkLicense(productName, productVersion, buildType, null);
            return true;
        }
        catch (LicenseException e) {
            return false;
        }
    }

    @Deprecated
    public static void checkLicenseAsync(String productName, String productVersion, Callback callback) {
        LicenseChecker.checkLicenseAsync(productName, productVersion, BuildType.DEVELOPMENT, callback);
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback) {
        LicenseChecker.checkLicenseAsync(productName, productVersion, buildType, callback, systemBrowserUrlHandler);
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback, Consumer<String> noKeyUrlHandler, String machineId, ProKey proKey, SubscriptionKey subscriptionKey, OfflineKey offlineKey) {
        LicenseChecker.checkLicenseAsync(new Product(productName, productVersion), buildType, callback, noKeyUrlHandler, machineId, proKey, subscriptionKey, offlineKey, new OnlineKeyValidator(), new OfflineKeyValidator(), new VaadinComIntegration(), 60);
    }

    @Deprecated
    public static void checkLicenseAsync(String productName, String productVersion, Callback callback, Consumer<String> noKeyUrlHandler) {
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback, Consumer<String> noKeyUrlHandler) {
        LicenseChecker.checkLicenseAsync(productName, productVersion, buildType, callback, noKeyUrlHandler, 60);
    }

    public static void checkLicenseAsync(String productName, String productVersion, BuildType buildType, Callback callback, Consumer<String> noKeyUrlHandler, int timeoutKeyUrlHandler) {
        LicenseChecker.checkLicenseAsync(new Product(productName, productVersion), buildType, callback, noKeyUrlHandler, MachineId.get(), LocalProKey.get(), LocalSubscriptionKey.get(), LocalOfflineKey.get(), new OnlineKeyValidator(), new OfflineKeyValidator(), new VaadinComIntegration(), timeoutKeyUrlHandler);
    }

    static void checkLicenseAsync(Product product, BuildType buildType, Callback callback, Consumer<String> noKeyUrlHandler, String machineId, ProKey proKey, SubscriptionKey subscriptionKey, OfflineKey offlineKey, OnlineKeyValidator proKeyValidator, OfflineKeyValidator offlineKeyValidator, VaadinComIntegration vaadinComIntegration, int timeoutKeyUrlHandler) {
        new Thread(() -> {
            try {
                LicenseChecker.checkLicense(product, buildType, noKeyUrlHandler, machineId, proKey, subscriptionKey, offlineKey, proKeyValidator, offlineKeyValidator, vaadinComIntegration, timeoutKeyUrlHandler);
                callback.ok();
            }
            catch (Exception e) {
                callback.failed(e);
            }
        }).start();
    }

    static void checkLicense(Product product, BuildType buildType, Consumer<String> noKeyUrlHandler, int timeoutKeyUrlHandler) {
        LicenseChecker.getLogger().debug("Checking license for " + product);
        LicenseChecker.checkLicense(product, buildType, noKeyUrlHandler, MachineId.get(), LocalProKey.get(), LocalSubscriptionKey.get(), LocalOfflineKey.get(), new OnlineKeyValidator(), new OfflineKeyValidator(), new VaadinComIntegration(), timeoutKeyUrlHandler);
    }

    static void checkLicense(Product product, BuildType buildType, Consumer<String> noKeyUrlHandler, String machineId, ProKey proKey, SubscriptionKey subscriptionKey, OfflineKey offlineKey, OnlineKeyValidator proKeyValidator, OfflineKeyValidator offlineKeyValidator, VaadinComIntegration vaadinComIntegration, int timeoutKeyUrlHandler) {
        OnlineKeyValidator.Result onlineCheckResult;
        if (subscriptionKey == null && offlineKey != null && offlineKey.getSubscriptionKey() != null) {
            subscriptionKey = new SubscriptionKey(offlineKey.getSubscriptionKey());
        }
        if ((onlineCheckResult = proKeyValidator.validate(product, subscriptionKey, buildType, noKeyUrlHandler == null)) == OnlineKeyValidator.Result.OK) {
            return;
        }
        if (subscriptionKey != null) {
            if (onlineCheckResult == OnlineKeyValidator.Result.CANNOT_REACH_SERVER) {
                if (offlineKey != null && offlineKey.getSubscriptionKey() != null && offlineKeyValidator.validate(null, null, offlineKey, machineId)) {
                    return;
                }
                if (LicenseChecker.canWorkOffline(product, buildType, machineId, new ProKey(null, subscriptionKey.getKey()))) {
                    return;
                }
            }
            throw new LicenseException("The provided license subscription key does not allow usage of " + product.getName() + " " + product.getVersion() + ". Check that the license has not expired.");
        }
        onlineCheckResult = proKeyValidator.validate(product, proKey, machineId, buildType, noKeyUrlHandler == null);
        if (onlineCheckResult == OnlineKeyValidator.Result.OK) {
            return;
        }
        if (onlineCheckResult == OnlineKeyValidator.Result.NO_ACCESS && proKey != null) {
            throw new LicenseException("The provided license key does not allow usage of " + product.getName() + " " + product.getVersion() + ". Check that the license has not expired and that the product you are trying to use does not require another type of subscription.");
        }
        if (offlineKeyValidator.validate(product, buildType, offlineKey, machineId)) {
            if (loggedLicenseOwner == null && offlineKey.getName() != null) {
                LocalDateTime expires = LocalDateTime.ofEpochSecond(offlineKey.getExpires() / 1000L, 0, ZoneOffset.UTC);
                long expiresInDays = Duration.between(LocalDateTime.now(), expires).toDays();
                loggedLicenseOwner = "Using offline license registered to " + offlineKey.getName() + " / " + offlineKey.getAccount() + ". Expires in " + expiresInDays + " days.";
                LicenseChecker.getLogger().info(loggedLicenseOwner);
            }
            return;
        }
        if (onlineCheckResult == OnlineKeyValidator.Result.CANNOT_REACH_SERVER && LicenseChecker.canWorkOffline(product, buildType, machineId, proKey)) {
            return;
        }
        if (proKey == null && noKeyUrlHandler != null && (proKey = vaadinComIntegration.openBrowserAndWaitForKey(product, noKeyUrlHandler, timeoutKeyUrlHandler)) != null) {
            LocalProKey.write(proKey);
            if (proKeyValidator.validate(product, proKey, machineId, buildType, false) == OnlineKeyValidator.Result.OK) {
                return;
            }
        }
        throw new LicenseException("Unable to validate the license, please check your internet connection. If you need to work offline then " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId));
    }

    private static boolean canWorkOffline(Product product, BuildType buildType, String machineId, ProKey proKey) {
        if (History.isRecentlyValidated(product, Period.ofDays(2), buildType, proKey)) {
            return true;
        }
        if (strictOffline) {
            throw new LicenseException(OfflineKeyValidator.getMissingOfflineKeyMessage(machineId));
        }
        LicenseChecker.getLogger().warn("Unable to validate the license, please check your internet connection");
        return true;
    }

    static Logger getLogger() {
        return LoggerFactory.getLogger(LicenseChecker.class);
    }

    public static void setStrictOffline(boolean strictOffline) {
        LicenseChecker.strictOffline = strictOffline;
    }

    public static interface Callback {
        public void ok();

        public void failed(Exception var1);
    }
}

