/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bigsorter;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;

public interface Writer<T>
extends Closeable {
    public void write(T var1) throws IOException;

    public void flush() throws IOException;

    default public <S> Writer<S> map(final Function<? super S, ? extends T> mapper) {
        final Writer w = this;
        return new Writer<S>(){

            @Override
            public void write(S value) throws IOException {
                w.write(mapper.apply(value));
            }

            @Override
            public void flush() throws IOException {
                w.close();
            }

            @Override
            public void close() throws IOException {
                w.close();
            }
        };
    }
}

