/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bigsorter;

import com.github.davidmoten.bigsorter.InputStreamReaderFactory;
import com.github.davidmoten.bigsorter.OutputStreamWriterFactory;
import com.github.davidmoten.bigsorter.Reader;
import com.github.davidmoten.bigsorter.Serializer;
import com.github.davidmoten.bigsorter.Writer;
import com.github.davidmoten.guavamini.Lists;
import com.github.davidmoten.guavamini.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public final class Util {
    private Util() {
    }

    public static <T> void findSame(Reader<? extends T> readerA, Reader<? extends T> readerB, Comparator<? super T> comparator, Writer<T> writer) throws IOException {
        T x = readerA.read();
        T y = readerB.read();
        while (x != null && y != null) {
            int compare = comparator.compare(x, y);
            if (compare == 0) {
                writer.write(x);
                x = readerA.read();
                y = readerB.read();
                continue;
            }
            if (compare < 0) {
                x = readerA.read();
                continue;
            }
            y = readerB.read();
        }
    }

    public static <T> void findSame(File a, File b, Serializer<T> serializer, Comparator<? super T> comparator, File output) throws IOException {
        try (Reader readerA = serializer.createReader(a);
             Reader readerB = serializer.createReader(b);
             Writer writer = serializer.createWriter(output);){
            Util.findSame(readerA, readerB, comparator, writer);
        }
    }

    public static <T> void findDifferent(Reader<? extends T> readerA, Reader<? extends T> readerB, Comparator<? super T> comparator, Writer<T> writer) throws IOException {
        T x = readerA.read();
        T y = readerB.read();
        while (x != null && y != null) {
            int compare = comparator.compare(x, y);
            if (compare == 0) {
                x = readerA.read();
                y = readerB.read();
                continue;
            }
            if (compare < 0) {
                writer.write(x);
                x = readerA.read();
                continue;
            }
            writer.write(y);
            y = readerB.read();
        }
        while (x != null) {
            writer.write(x);
            x = readerA.read();
        }
        while (y != null) {
            writer.write(y);
            y = readerB.read();
        }
    }

    public static <T> void findDifferent(File a, File b, Serializer<T> serializer, Comparator<? super T> comparator, File output) throws IOException {
        try (Reader readerA = serializer.createReader(a);
             Reader readerB = serializer.createReader(b);
             Writer writer = serializer.createWriter(output);){
            Util.findDifferent(readerA, readerB, comparator, writer);
        }
    }

    public static <T> void findComplement(Reader<? extends T> readerA, Reader<? extends T> readerB, Comparator<? super T> comparator, Writer<T> writer) throws IOException {
        T x = readerA.read();
        T y = readerB.read();
        while (x != null && y != null) {
            int compare = comparator.compare(x, y);
            if (compare == 0) {
                x = readerA.read();
                y = readerB.read();
                continue;
            }
            if (compare < 0) {
                writer.write(x);
                x = readerA.read();
                continue;
            }
            y = readerB.read();
        }
        while (x != null) {
            writer.write(x);
            x = readerA.read();
        }
    }

    public static <T> void findComplement(File a, File b, Serializer<T> serializer, Comparator<? super T> comparator, File output) throws IOException {
        try (Reader readerA = serializer.createReader(a);
             Reader readerB = serializer.createReader(b);
             Writer writer = serializer.createWriter(output);){
            Util.findComplement(readerA, readerB, comparator, writer);
        }
    }

    public static <T> List<File> splitByCount(File input, Serializer<T> serializer, long count) throws IOException {
        return Util.splitByCount(input, serializer, (Integer n) -> new File(input.getParentFile(), input.getName() + "-" + n), count);
    }

    public static <T> List<File> splitByCount(File input, Serializer<T> serializer, Function<Integer, File> output, long count) throws IOException {
        return Util.splitByCount(Collections.singletonList(input), serializer, output, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<File> splitByCount(List<File> input, Serializer<T> serializer, Function<Integer, File> output, long count) throws IOException {
        Preconditions.checkArgument((count > 0L ? 1 : 0) != 0, (String)"count must be greater than 0");
        ArrayList list = Lists.newArrayList();
        int fileNumber = 0;
        long i = 0L;
        try (Writer writer = null;){
            for (File file : input) {
                Reader reader = serializer.createReader(file);
                Throwable throwable = null;
                try {
                    Object t;
                    while ((t = reader.read()) != null) {
                        if (writer == null) {
                            File f = output.apply(++fileNumber);
                            list.add(f);
                            writer = serializer.createWriter(f);
                        }
                        writer.write(t);
                        if (++i != count) continue;
                        writer.close();
                        writer = null;
                        i = 0L;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        return list;
    }

    public static <T> List<File> splitBySize(File input, Serializer<T> serializer, long maxSize) throws IOException {
        return Util.splitBySize(input, serializer, (Integer n) -> new File(input.getParentFile(), input.getName() + "-" + n), maxSize);
    }

    public static <T> List<File> splitBySize(File input, Serializer<T> serializer, Function<Integer, File> output, long maxSize) throws IOException {
        return Util.splitBySize(Collections.singletonList(input), serializer, output, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<File> splitBySize(List<File> input, Serializer<T> serializer, Function<Integer, File> output, long maxSize) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Writer buffer = serializer.createWriter(bytes);
        ArrayList list = Lists.newArrayList();
        int fileNumber = 0;
        long n = 0L;
        try (Writer writer = null;){
            for (File file : input) {
                Reader reader = serializer.createReader(file);
                Throwable throwable = null;
                try {
                    Object t;
                    while ((t = reader.read()) != null) {
                        File f;
                        bytes.reset();
                        buffer.write(t);
                        buffer.flush();
                        n += (long)bytes.size();
                        if (writer == null) {
                            f = output.apply(++fileNumber);
                            list.add(f);
                            writer = serializer.createWriter(f);
                            n = bytes.size();
                        } else if (n > maxSize) {
                            writer.close();
                            f = output.apply(++fileNumber);
                            list.add(f);
                            writer = serializer.createWriter(f);
                            n = bytes.size();
                        }
                        writer.write(t);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        return list;
    }

    static void close(Closeable c) {
        try {
            c.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static RuntimeException toRuntimeException(Throwable e) {
        if (e instanceof IOException) {
            return new UncheckedIOException((IOException)e);
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static <S, T> void convert(File in, InputStreamReaderFactory<S> readerFactory, File out, OutputStreamWriterFactory<T> writerFactory, Function<? super S, ? extends T> mapper) {
        try (Reader<S> r = readerFactory.createReader(in);
             Writer<T> w = writerFactory.createWriter(out);){
            S s;
            while ((s = r.read()) != null) {
                w.write(mapper.apply(s));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

