/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bigsorter;

import com.github.davidmoten.bigsorter.LineDelimiter;
import com.github.davidmoten.bigsorter.Reader;
import com.github.davidmoten.bigsorter.Serializer;
import com.github.davidmoten.bigsorter.Writer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

final class LinesSerializer
implements Serializer<String> {
    static final Serializer<String> LINES_UTF8_LF = new LinesSerializer(StandardCharsets.UTF_8, LineDelimiter.LINE_FEED);
    static final Serializer<String> LINES_UTF8_CR_LF = new LinesSerializer(StandardCharsets.UTF_8, LineDelimiter.CARRIAGE_RETURN_LINE_FEED);
    private final Charset charset;
    private final LineDelimiter delimiter;

    LinesSerializer(Charset charset, LineDelimiter delimiter) {
        this.charset = charset;
        this.delimiter = delimiter;
    }

    @Override
    public Reader<String> createReader(final InputStream in) {
        return new Reader<String>(){
            BufferedReader br;
            {
                this.br = new BufferedReader(new InputStreamReader(in, LinesSerializer.this.charset));
            }

            @Override
            public String read() throws IOException {
                return this.br.readLine();
            }

            @Override
            public void close() throws IOException {
                this.br.close();
            }
        };
    }

    @Override
    public Writer<String> createWriter(final OutputStream out) {
        return new Writer<String>(){
            BufferedWriter bw;
            {
                this.bw = new BufferedWriter(new OutputStreamWriter(out, LinesSerializer.this.charset));
            }

            @Override
            public void write(String value) throws IOException {
                this.bw.write(value);
                this.bw.write(LinesSerializer.this.delimiter.value());
            }

            @Override
            public void close() throws IOException {
                this.bw.close();
            }

            @Override
            public void flush() throws IOException {
                this.bw.flush();
            }
        };
    }
}

