/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.bigsorter;

import com.github.davidmoten.bigsorter.Reader;
import com.github.davidmoten.bigsorter.Serializer;
import com.github.davidmoten.bigsorter.Writer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class DataSerializer<T>
implements Serializer<T> {
    public abstract T read(DataInputStream var1) throws IOException;

    public abstract void write(DataOutputStream var1, T var2) throws IOException;

    @Override
    public Reader<T> createReader(final InputStream in) {
        return new Reader<T>(){
            final DataInputStream dis;
            {
                this.dis = new DataInputStream(in);
            }

            @Override
            public T read() throws IOException {
                try {
                    return DataSerializer.this.read(this.dis);
                }
                catch (EOFException e) {
                    return null;
                }
            }

            @Override
            public void close() throws IOException {
                this.dis.close();
            }
        };
    }

    @Override
    public Writer<T> createWriter(final OutputStream out) {
        return new Writer<T>(){
            final DataOutputStream dos;
            {
                this.dos = new DataOutputStream(out);
            }

            @Override
            public void write(T value) throws IOException {
                DataSerializer.this.write(this.dos, value);
            }

            @Override
            public void close() throws IOException {
                this.dos.close();
            }

            @Override
            public void flush() throws IOException {
                this.dos.flush();
            }
        };
    }
}

