/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SymmetricIzPackHelper {
    private static Writer logWriter;

    public static String getSymLinkIfExists(String dir, int parentLevels) {
        SymmetricIzPackHelper.log("Symlink requested for " + dir);
        String containingDir = dir;
        String targetDir = dir;
        for (int i = 0; i < parentLevels; ++i) {
            if (containingDir == null) continue;
            targetDir = containingDir;
            containingDir = new File(containingDir).getParent();
        }
        if (containingDir != null) {
            SymmetricIzPackHelper.log("Looking for symlinks in " + containingDir);
            File[] files = new File(containingDir).listFiles();
            if (files != null) {
                for (File file : files) {
                    try {
                        if (file.getPath().equals(targetDir) || !file.getCanonicalPath().equals(targetDir)) continue;
                        dir = dir.replace(targetDir, file.getAbsolutePath());
                        SymmetricIzPackHelper.log("Found symlink at " + file.getAbsolutePath());
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return dir;
    }

    public static String runCommand(String[] cmd) {
        StringBuilder output = new StringBuilder();
        try {
            Process proc = SymmetricIzPackHelper.runCommandForProcess(cmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                output.append(line).append(System.lineSeparator());
                SymmetricIzPackHelper.log("Output: " + line);
            }
            reader.close();
            SymmetricIzPackHelper.log("RC=" + proc.waitFor());
        }
        catch (Exception e) {
            SymmetricIzPackHelper.log("Error while running command: " + e);
        }
        return output.toString();
    }

    public static Process runCommandForProcess(String[] cmd) throws IOException {
        StringBuilder cmdStr = new StringBuilder();
        for (String c : cmd) {
            cmdStr.append(c).append(" ");
        }
        SymmetricIzPackHelper.log("Running: " + cmdStr.toString());
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        return pb.start();
    }

    public static void openLog(String installPath) {
        SymmetricIzPackHelper.openLog(installPath, true);
    }

    public static void openLog(String installPath, boolean append) {
        try {
            String logDir = installPath + File.separator + "logs";
            String logFile = logDir + File.separator + "install.log";
            System.out.println("[ Writing log to " + logFile + " ]");
            new File(logDir).mkdirs();
            logWriter = new FileWriter(logFile, append);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void log(String message) {
        SymmetricIzPackHelper.log(message, null);
    }

    public static void log(String message, Throwable t) {
        if (t != null) {
            t.printStackTrace();
        }
        if (logWriter != null) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                logWriter.write("[" + df.format(new Date()) + "] " + message);
                logWriter.write(System.lineSeparator());
                if (t != null) {
                    PrintWriter writer = new PrintWriter(logWriter, true);
                    t.printStackTrace(writer);
                }
                logWriter.flush();
            }
            catch (IOException iOException) {}
        } else if (SymmetricIzPackHelper.isTrace()) {
            System.out.println(message);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public static void closeLog() {
        if (logWriter != null) {
            try {
                logWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isTrace() {
        String traceProp = System.getProperty("TRACE");
        return traceProp != null && traceProp.equalsIgnoreCase("true");
    }

    public static void createLockFile(String installPath) {
        try {
            File file = new File(installPath + File.separator + "tmp" + File.separator + "upgrade.tmp");
            new FileOutputStream(file).close();
            file.deleteOnExit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

