/*
 * Decompiled with CFR 0.152.
 */
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.event.AbstractProgressInstallerListener;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.Platforms;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.collections4.properties.SortedProperties;
import org.apache.commons.io.FileUtils;

public class SymmetricInstallerListener
extends AbstractProgressInstallerListener {
    String oldVersion;
    boolean isUsingService = false;
    boolean wasServiceRunning = false;
    String keystorePassword;
    int packCount;
    int packTotal;
    long fileLastModified;
    boolean isUpgrade;
    public static final int MAJOR_INDEX = 0;
    public static final int MINOR_INDEX = 1;
    public static final int PATCH_INDEX = 2;

    public SymmetricInstallerListener(InstallData idata) {
        super(idata);
    }

    @Override
    public void afterPacks(List<Pack> packs, ProgressListener listener) {
        String output;
        String runAsUser;
        this.log("Callback afterPacks");
        InstallData installData = this.getInstallData();
        if (this.isUpgrade) {
            File serverProperties = new File(installData.getInstallPath() + "/conf/symmetric-server.properties");
            if (this.fileContains("${select.install.httpPort}", serverProperties)) {
                this.log("Fixing symmetric-server.properties file");
                serverProperties.delete();
            }
            this.log("Clearing patches");
            this.archivePatchesOnUpgrade(installData);
            if (this.isUsingService && this.isOlderThanVersion(this.oldVersion, "3.6.4")) {
                this.installService(installData.getInstallPath());
            }
            if (this.isOlderThanVersion(this.oldVersion, "3.12.0")) {
                if (installData.getPlatform().isA(Platforms.WINDOWS)) {
                    this.upgradeFileToLog4j2(new File(installData.getInstallPath() + "/bin/setenv.bat"));
                } else {
                    this.upgradeFileToLog4j2(new File(installData.getInstallPath() + "/bin/setenv"));
                }
                this.upgradeFileToLog4j2(new File(installData.getInstallPath() + "/conf/sym_service.conf"));
                try {
                    FileUtils.write(serverProperties, (CharSequence)"https2.enable=false", Charset.defaultCharset(), true);
                }
                catch (IOException e) {
                    this.log("Failed to append server properties because " + e.getMessage());
                }
            }
            try {
                this.log("Upgrading H2 database connections");
                this.alterLegacyModeForH2(installData.getInstallPath());
            }
            catch (Exception e) {
                this.log("Error upgrading H2 database connections");
                e.printStackTrace();
            }
            if (this.isOlderThanVersion(this.oldVersion, "3.16.0")) {
                try {
                    this.log("Importing H2 databases");
                    this.importH2Databases(installData.getInstallPath(), this.isOlderThanVersion(this.oldVersion, "3.15.0"));
                }
                catch (Exception e) {
                    this.log("Error importing H2 databases", e);
                }
            }
            if (this.wasServiceRunning) {
                this.startService(installData.getInstallPath());
            }
        } else {
            try {
                this.log("Replacing keystore password in files");
                String installPath = installData.getInstallPath();
                this.replaceInFile("${keystore.password}", installData.getVariable("keystore.password"), new File(installPath + "/bin/setenv.bat"));
                this.replaceInFile("${keystore.password}", installData.getVariable("keystore.password"), new File(installPath + "/bin/setenv"));
                this.log("Changing keystore password");
                String keystoreFilename = installData.getInstallPath() + "/security/keystore";
                KeyStore ks = KeyStore.getInstance("PKCS12");
                FileInputStream is = new FileInputStream(keystoreFilename);
                ks.load(is, null);
                is.close();
                FileOutputStream os = new FileOutputStream(keystoreFilename);
                ks.store(os, this.keystorePassword.toCharArray());
                os.close();
            }
            catch (Exception e) {
                this.log("Unable to change keystore password: " + e.getMessage());
            }
        }
        if (!this.isUpgrade || this.isOlderThanVersion(this.oldVersion, "3.12.1")) {
            this.log("Changing JMX password");
            File jmxFile = new File(installData.getInstallPath() + "/security/jmxremote.password");
            this.replaceInFile("admin changeit", "admin " + this.generatePassword(8, 12), jmxFile);
            this.replaceInFile("monitor changeit", "monitor " + this.generatePassword(8, 12), jmxFile);
        }
        this.log("Changing permissions of security directory");
        if (installData.getPlatform().isA(Platforms.WINDOWS)) {
            this.changePermissionsOfFiles(installData.getInstallPath() + "/security", "Users");
        } else {
            this.changePermissionsOfFiles(installData.getInstallPath() + "/security");
        }
        if ((installData.getPlatform().isA(Platforms.LINUX) || installData.getPlatform().isA(Platforms.MAC)) && (runAsUser = installData.getVariable("select.install.run.as.user")) != null && runAsUser.length() > 0) {
            this.log("Changing ownership of files");
            output = this.changeOwnerOfFiles(installData.getInstallPath(), installData.getVariable("select.install.run.as.user"));
            if (output != null && output.length() > 0) {
                this.log(output);
            }
        }
        if (this.isUpgrade && installData.getPlatform().isA(Platforms.WINDOWS)) {
            this.log("Checking for module upgrade list");
            String command = installData.getInstallPath() + File.separator + "bin" + File.separator + "symadmin.bat";
            output = SymmetricIzPackHelper.runCommand(new String[]{command, "module", "list-upgrade"});
            try (BufferedReader reader = new BufferedReader(new StringReader(output));){
                String line = null;
                boolean startReading = false;
                while ((line = reader.readLine()) != null) {
                    if (startReading) {
                        File file = new File(installData.getInstallPath() + File.separator + "lib" + File.separator + line);
                        if (file.exists()) {
                            boolean deleted = file.delete();
                            this.log("Deleting " + line + " (" + (deleted ? "OK" : "FAIL") + ")");
                            continue;
                        }
                        this.log("Not found " + line);
                        continue;
                    }
                    if (line.indexOf("Files that need upgraded") == -1) continue;
                    startReading = true;
                }
            }
            catch (IOException e) {
                this.log("Error checking module upgrade list", e);
            }
        }
        this.log("Ending " + (this.isUpgrade ? "UPGRADE" : "INSTALL"));
        this.log("");
    }

    @Override
    public void beforePack(Pack pack) {
        this.log("Processing package: " + pack.getName() + " (" + ++this.packCount + "/" + this.packTotal + ")");
    }

    @Override
    public void beforeDir(File dir, PackFile packFile, Pack pack) {
        this.log("Making directory " + dir.getName());
    }

    @Override
    public void beforeFile(File file, PackFile packFile, Pack pack) {
        this.fileLastModified = file.lastModified();
    }

    @Override
    public void afterFile(File file, PackFile packFile, Pack pack) {
        if (this.fileLastModified == 0L || this.fileLastModified != file.lastModified()) {
            this.log("Installed file " + file.getPath());
        }
    }

    @Override
    public boolean isFileListener() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforePacks(List<Pack> packs) {
        String stagingDir;
        String javaLinkCmd;
        InstallData idata = this.getInstallData();
        SymmetricIzPackHelper.openLog(idata.getInstallPath());
        String installVar = idata.getVariable("select.install.upgrade");
        this.isUpgrade = installVar != null && installVar.equals("false");
        this.log("Starting " + (this.isUpgrade ? "UPGRADE" : "INSTALL"));
        this.log("Application: " + idata.getInfo().getAppName() + " " + idata.getInfo().getAppVersion());
        this.log("Platform: " + idata.getPlatform());
        this.log("Install Path: " + idata.getInstallPath());
        this.oldVersion = this.getVersion(idata.getInstallPath());
        this.log("Old version is " + this.oldVersion);
        if (this.isUpgrade) {
            if (this.isOlderThanVersion(this.oldVersion, "3.12.0")) {
                idata.setVariable("var.convert.modules", "true");
            } else {
                idata.setVariable("var.upgrade.modules", "true");
            }
        }
        this.packTotal = idata.getSelectedPacks().size();
        this.log("Packages: " + this.packTotal);
        this.defaultVariable(idata, "select.install.httpPort", "31415");
        this.defaultVariable(idata, "select.install.httpsPort", "31417");
        this.defaultVariable(idata, "select.install.jmxAgentPort", "31418");
        this.checkBcpVariables(packs, idata);
        this.log("Variables: ");
        Properties prop = idata.getVariables().getProperties();
        for (Object key : prop.keySet()) {
            this.log(key.toString() + " = " + prop.getProperty(key.toString()));
        }
        this.log("Finding Java command");
        String javaCmd = null;
        if (this.getInstallData().getPlatform().getName() == Platform.Name.WINDOWS) {
            javaLinkCmd = "C:\\ProgramData\\Oracle\\Java\\javapath\\javaw.exe";
            javaCmd = new File(javaLinkCmd).exists() ? javaLinkCmd : idata.getInstallPath() + "\\bin\\sym_service.exe";
        }
        if (javaCmd == null) {
            String jreHome = prop.getProperty("JAVA_HOME");
            if (jreHome == null || jreHome.trim().equals("")) {
                jreHome = System.getenv("JAVA_HOME");
            }
            if (jreHome != null && !jreHome.trim().equals("")) {
                String jdkHome = null;
                String javaExe = null;
                if (this.getInstallData().getPlatform().getName() == Platform.Name.WINDOWS) {
                    jreHome = jreHome.replaceAll("\\\\$", "");
                    jdkHome = jreHome.replaceAll("\\\\jre$", "");
                    javaExe = "\\bin\\javaw";
                } else {
                    jreHome = SymmetricIzPackHelper.getSymLinkIfExists(jreHome.replaceAll("/$", ""), jreHome.contains("/jre") ? 2 : 1);
                    jdkHome = jreHome.replaceAll("/jre$", "/").replaceAll("/$", "");
                    javaExe = "/bin/java";
                }
                this.log("Resolved JRE home is " + jreHome);
                javaCmd = jdkHome + javaExe;
                this.log("Testing for JDK at " + javaCmd);
                if (!new File(javaCmd).exists()) {
                    javaCmd = jreHome + javaExe;
                }
            }
        }
        if (this.getInstallData().getPlatform().getName() != Platform.Name.WINDOWS && new File(javaLinkCmd = "/usr/bin/java").exists()) {
            String output = SymmetricIzPackHelper.runCommand(new String[]{"readlink", "-f", javaLinkCmd});
            this.log("Testing readlink /usr/bin/java = " + output);
            if (output != null && output.trim().equals(javaCmd)) {
                javaCmd = javaLinkCmd;
            }
        }
        if (javaCmd == null) {
            javaCmd = this.getInstallData().getPlatform().getName() == Platform.Name.WINDOWS ? "javaw" : "java";
        }
        idata.setVariable("wrapper.java.command", javaCmd);
        this.log("Java is " + javaCmd);
        String memorySize = idata.getVariable("select.memory");
        if (memorySize != null && !memorySize.equals("0")) {
            idata.setVariable("memory.size", memorySize);
            this.log("Setting memory to " + memorySize);
        }
        if ((stagingDir = idata.getVariable("select.staging.directory")) != null && !stagingDir.equals("0")) {
            idata.setVariable("staging.directory", stagingDir);
            this.log("Setting staging to " + stagingDir);
        }
        this.log("Generating random password for keystore");
        this.keystorePassword = this.generatePassword(8, 12);
        idata.setVariable("keystore.password", "obf:" + this.obfuscate(this.keystorePassword));
        if (!this.isUpgrade) {
            this.log("beforePacks done");
            return;
        }
        if (this.isOlderThanVersion(this.oldVersion, "3.16.0")) {
            try {
                this.log("Exporting H2 databases");
                this.exportH2Databases(idata.getInstallPath());
            }
            catch (Exception e) {
                this.log("Error exporting H2 databases", e);
                throw new IzPackException("Failed to export H2 databases", e);
            }
        }
        if (this.getInstallData().getPlatform().getName() == Platform.Name.WINDOWS || this.isAtLeastVersion(this.oldVersion, "3.6.0")) {
            this.isUsingService = this.isUsingService(idata.getInstallPath());
        }
        if (this.isUsingService) {
            this.wasServiceRunning = this.stopService(idata.getInstallPath());
            if (this.isOlderThanVersion(this.oldVersion, "3.6.4")) {
                this.uninstallService(idata.getInstallPath());
            }
        }
        if (this.isOlderThanVersion(this.oldVersion, "2.5.0")) {
            try {
                this.log("Upgrading to multi server");
                this.upgradeToMultiServer(idata.getInstallPath());
            }
            catch (Exception e) {
                this.log("An error occurred while upgrading to multi-server");
                e.printStackTrace();
            }
        }
        if (this.isOlderThanVersion(this.oldVersion, "3.12.2")) {
            try {
                this.log("Upgrading REST service");
                this.upgradeSymConfRestApi(new File(idata.getInstallPath() + "/conf/sym_service.conf"));
            }
            catch (Exception e) {
                this.log("An error occurred while upgrading REST service");
                e.printStackTrace();
            }
        }
        this.log("Checking for uninstaller");
        String uninstallerLocation = idata.getInstallPath() + "/Uninstaller/uninstaller.jar";
        File uninstallerFile = new File(uninstallerLocation);
        boolean uninstalled = false;
        if (uninstallerFile.isFile()) {
            this.log("Uninstaller file found: " + uninstallerFile);
            try {
                List<Object> fileList = new ArrayList();
                ZipFile zf = new ZipFile(uninstallerFile);
                Enumeration<? extends ZipEntry> e = zf.entries();
                while (e.hasMoreElements()) {
                    ZipEntry ze = e.nextElement();
                    if (!ze.getName().equals("install.log")) continue;
                    try (InputStream is = null;){
                        is = zf.getInputStream(ze);
                        fileList = this.getFileList(idata.getInstallPath(), is);
                        break;
                    }
                }
                zf.close();
                for (File file : fileList) {
                    boolean success = file.delete();
                    if (!success && !file.exists()) {
                        success = true;
                    }
                    this.log("Removed [" + success + "] " + file.getAbsolutePath());
                    if (success) continue;
                    throw new IzPackException("Failed to remove old files.  Make sure SymmetricDS is stopped and try again.  Delete failed for file: " + file.getPath());
                }
                uninstalled = true;
            }
            catch (Exception ex) {
                this.log("Uninstall encountered error", ex);
                if (ex instanceof IzPackException) {
                    throw (IzPackException)ex;
                }
                throw new IzPackException(ex);
            }
        } else {
            this.log("Uninstaller file was NOT found: " + uninstallerFile);
        }
        this.fixFilesForUpgrade(idata.getInstallPath());
        if (!uninstalled) {
            String[] files;
            String libLoc = idata.getInstallPath() + "/lib";
            File libDir = new File(libLoc);
            String dateFormat = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            String oldLibLoc = idata.getInstallPath() + "/lib." + dateFormat;
            File oldLibDir = new File(oldLibLoc);
            this.log("Unable to uninstall. Creating backup libary (" + oldLibLoc + ")");
            boolean result = libDir.renameTo(oldLibDir);
            if (!result) {
                this.log("Unable to rename directory '" + libLoc + "' to '" + oldLibLoc + "'");
            }
            if (!(result = libDir.mkdir())) {
                this.log("Unable to create directory '" + libLoc + "' to '" + oldLibLoc + "'");
            }
            if (oldLibDir.isDirectory() && (files = oldLibDir.list()) != null) {
                for (String filename : files) {
                    if (!filename.startsWith("ojdbc") && !filename.startsWith("ifx") && !filename.startsWith("interclient") && !filename.startsWith("db2")) continue;
                    this.copyFile(oldLibDir.getPath() + "/" + filename, libDir.getPath() + "/" + filename);
                }
            }
            new File(idata.getInstallPath() + "/web").renameTo(new File(idata.getInstallPath() + "/web." + dateFormat));
        }
        this.log("beforePacks done");
    }

    private void defaultVariable(InstallData idata, String name, String defaultValue) {
        if (idata.getVariable(name) == null) {
            idata.getVariables().set(name, defaultValue);
        }
    }

    private void fixFilesForUpgrade(String installPath) {
        this.fixLog4jFilesForUpgrade(installPath);
        this.fixLog4jFilesForUpgrade315(installPath);
        File symmetricProperties = new File(installPath + "/conf/symmetric.properties");
        if (symmetricProperties.exists()) {
            this.log("Fixing symmetric.properties file");
            symmetricProperties.renameTo(new File(installPath + "/conf/symmetric.properties.deprecated"));
        }
        this.replaceInFile("wrapper.app.parameter.2=--noconsole", "wrapper.app.parameter.2=--no-log-console", new File(installPath + "/conf/sym_service.conf"));
        this.replaceInFile("com.jumpmind.symmetric.console.FtpDataLoaderFactory", "org.jumpmind.symmetric.ext.FtpDataLoaderFactory", new File(installPath + "/conf/ftp-extensions.xml"));
        this.replaceInFile("../", "", new File(installPath + "/conf/sym_service.conf"));
    }

    private void fixLog4jFilesForUpgrade(String installPath) {
        File LOG4J_XML = new File(installPath + "/conf/log4j.xml");
        File LOG4J_DEBUG_XML = new File(installPath + "/conf/log4j-debug.xml");
        String PRE_39_VAADIN_SUPRESSION = "    <category name=\"com.vaadin.event.ConnectorActionManager\">\n        <priority value=\"ERROR\" />\n    </category>\n    \n    <category name=\"org.atmosphere.container\">";
        String POST_39_VAADIN_SUPRESSION = "    <category name=\"com.vaadin.event.ConnectorActionManager\">\n        <priority value=\"ERROR\" />\n    </category>\n    \n    <category name=\"com.vaadin.server.communication\">\n        <priority value=\"FATAL\" />\n    </category>\n    \n    <category name=\"org.atmosphere\">";
        this.replaceInFile("org.jumpmind.symmetric.util.BufferedLogAppender", "org.jumpmind.util.BufferedLogAppender", LOG4J_XML);
        this.replaceInFile("org.apache.log4j.PatternLayout", "org.jumpmind.symmetric.web.SymPatternLayout", LOG4J_XML);
        this.replaceInFile("10MB", "20MB", LOG4J_XML);
        this.replaceInFile("org.jumpmind.symmetric.util.BufferedLogAppender", "org.jumpmind.util.BufferedLogAppender", LOG4J_DEBUG_XML);
        this.replaceInFile("org.jumpmind.symmetric.ClientSymmetricEngine$PropertiesFactoryBean", "org.jumpmind.symmetric.util.PropertiesFactoryBean", LOG4J_XML);
        this.replaceInFile("org.jumpmind.symmetric.ClientSymmetricEngine$PropertiesFactoryBean", "org.jumpmind.symmetric.util.PropertiesFactoryBean", LOG4J_DEBUG_XML);
        this.replaceInFile("../", "\\${log4j.sym.home}/", LOG4J_XML);
        this.replaceInFile("../", "\\${log4j.sym.home}/", LOG4J_DEBUG_XML);
        this.replaceInFile("    <category name=\"com.vaadin.event.ConnectorActionManager\">\n        <priority value=\"ERROR\" />\n    </category>\n    \n    <category name=\"org.atmosphere.container\">", "    <category name=\"com.vaadin.event.ConnectorActionManager\">\n        <priority value=\"ERROR\" />\n    </category>\n    \n    <category name=\"com.vaadin.server.communication\">\n        <priority value=\"FATAL\" />\n    </category>\n    \n    <category name=\"org.atmosphere\">", LOG4J_XML);
        this.replaceInFile("org.atmosphere.container", "org.atmosphere", LOG4J_XML);
    }

    private void fixLog4jFilesForUpgrade315(String installPath) {
        File LOG4J_XML = new File(installPath + "/conf/log4j2.xml");
        File LOG4J_DEBUG_XML = new File(installPath + "/conf/log4j2-debug.xml");
        File LOG4J_BLANK_XML = new File(installPath + "/conf/log4j2-blank.xml");
        String PACKAGES = " packages=\"org.jumpmind.util\"";
        this.replaceInFile(" packages=\"org.jumpmind.util\"", "", LOG4J_XML);
        this.replaceInFile(" packages=\"org.jumpmind.util\"", "", LOG4J_DEBUG_XML);
        this.replaceInFile(" packages=\"org.jumpmind.util\"", "", LOG4J_BLANK_XML);
    }

    private void upgradeFileToLog4j2(File file) {
        if (this.fileContains("log4j.configuration", file)) {
            this.log("Upgrading " + file.getName() + " to log4j2");
            this.replaceInFile("log4j.configuration", "log4j2.configurationFile", file);
            this.replaceInFile("log4j.xml", "log4j2.xml", file);
            this.replaceInFile("file:%SYM_HOME%", "file:///%SYM_HOME%", file);
        }
    }

    private void upgradeSymConfRestApi(File file) {
        this.log("Updating sym_service.conf file");
        try {
            FileUtils.write(file, (CharSequence)"wrapper.java.additional=-Dsym.rest.properties.file=security/rest.properties", Charset.defaultCharset(), true);
        }
        catch (IOException e) {
            this.log("Failed in upgradeSymConfRestApi() for file " + file.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fileContains(String value, File file) {
        try {
            if (!file.exists()) return false;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line = reader.readLine();
                do {
                    if (line == null || !line.contains(value)) continue;
                    boolean bl = true;
                    return bl;
                } while ((line = reader.readLine()) != null);
                return false;
            }
        }
        catch (Exception e) {
            this.log("Failed in fileContains() for file " + file.getName(), e);
        }
        return false;
    }

    private void replaceInFile(String oldValue, String newValue, File file) {
        try {
            if (file.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                StringBuilder fileContents = new StringBuilder(256);
                String line = reader.readLine();
                do {
                    if (line == null) continue;
                    fileContents.append(String.format("%s%n", line));
                } while ((line = reader.readLine()) != null);
                reader.close();
                if (fileContents.toString().contains(oldValue)) {
                    this.log("Fixing " + file.getName() + " [" + oldValue + "]");
                    String updatedContents = fileContents.toString().replaceAll(Pattern.quote(oldValue), newValue);
                    PrintWriter writer = new PrintWriter(file);
                    writer.println(updatedContents);
                    writer.close();
                }
            }
        }
        catch (Exception e) {
            this.log("Failed in replaceInFile() for file " + file.getName(), e);
        }
    }

    private String getVersion(String path) {
        File dir = new File(path + "/web/WEB-INF/lib");
        if (dir.isDirectory()) {
            String[] files = dir.list();
            if (files != null) {
                for (String filename : files) {
                    if (!filename.startsWith("symmetric-core-")) continue;
                    this.log("Symmetric core file is " + filename);
                    return filename.split("-")[2];
                }
            }
        } else {
            this.log("Web directory is missing: " + dir);
        }
        return null;
    }

    private void upgradeToMultiServer(String path) throws Exception {
        new File(path + "/engines").mkdir();
        String symFileName = path + "/conf/symmetric.properties";
        BufferedReader reader = new BufferedReader(new FileReader(symFileName));
        Properties prop = new Properties();
        prop.load(reader);
        reader.close();
        String groupId = prop.getProperty("group.id");
        String externalId = prop.getProperty("external.id");
        this.log("groupId is " + groupId);
        this.log("externalId is " + externalId);
        if (groupId != null && !groupId.equals("please set me")) {
            String engineFileName = path + "/engines/" + groupId + "-" + externalId + ".properties";
            this.copyFile(symFileName, engineFileName);
        }
        new File(symFileName).delete();
    }

    private void alterLegacyModeForH2(String path) throws IOException {
        for (File engine : this.getEngineFiles(path)) {
            Properties properties = new Properties();
            properties.load(new BufferedReader(new FileReader(engine)));
            boolean saveProperties = this.alterH2Properties(properties, "db.url", "db.init.sql", "SET MODE LEGACY");
            if (!(saveProperties |= this.alterH2Properties(properties, "target.db.url", "target.db.init.sql", "SET MODE LEGACY"))) continue;
            SortedProperties sproperties = new SortedProperties();
            sproperties.putAll((Map<?, ?>)properties);
            try (FileOutputStream os = new FileOutputStream(engine);){
                sproperties.store(os, "Updated by SymmetricDS Installer");
            }
        }
    }

    private File[] getEngineFiles(String installPath) {
        File enginesDir = new File(installPath + File.separator + "engines");
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        };
        return enginesDir.listFiles(filter);
    }

    public static void main(String[] args) {
        String dbUrl = "jdbc:h2:file:load-only-20221214142725;LOCK_TIMEOUT=60000;WRITE_DELAY=0;AUTO_SERVER=TRUE;LOCK_TIMEOUT=60000;WRITE_DELAY=0;DB_CLOSE_ON_EXIT=FALSE";
        if (dbUrl.startsWith("jdbc:h2:file:") && dbUrl.contains("AUTO_SERVER=") && dbUrl.contains("DB_CLOSE_ON_EXIT=")) {
            dbUrl = dbUrl.replaceAll(";[Dd][Bb]_[Cc][Ll][Oo][Ss][Ee]_[Oo][Nn]_[Ee][Xx][Ii][Tt]=[a-zA-Z]*", "");
            dbUrl = dbUrl.replaceAll("[Dd][Bb]_[Cc][Ll][Oo][Ss][Ee]_[Oo][Nn]_[Ee][Xx][Ii][Tt]=[a-zA-Z]*;", "");
        }
        System.out.println(dbUrl);
    }

    private boolean alterH2Properties(Properties properties, String dbUrlName, String propertyName, String propertyValue) {
        boolean saveProperties = false;
        String dbUrl = properties.getProperty(dbUrlName);
        if (dbUrl != null && dbUrl.length() > 0 && dbUrl.startsWith("jdbc:h2:file:")) {
            String dbInitSql;
            if (dbUrl.contains("AUTO_SERVER=") && dbUrl.contains("DB_CLOSE_ON_EXIT=")) {
                this.log("Removing DB_CLOSE_ON_EXIT from db URL " + dbUrl);
                saveProperties = true;
                dbUrl = dbUrl.replaceAll(";[Dd][Bb]_[Cc][Ll][Oo][Ss][Ee]_[Oo][Nn]_[Ee][Xx][Ii][Tt]=[a-zA-Z]*", "");
                dbUrl = dbUrl.replaceAll("[Dd][Bb]_[Cc][Ll][Oo][Ss][Ee]_[Oo][Nn]_[Ee][Xx][Ii][Tt]=[a-zA-Z]*;", "");
                properties.put(dbUrlName, dbUrl);
            }
            if ((dbInitSql = properties.getProperty(propertyName)) == null) {
                dbInitSql = "";
            }
            if (!dbInitSql.contains("SET MODE LEGACY")) {
                this.log("Setting SET MODE LEGACY for db URL " + dbUrl);
                saveProperties = true;
                if (dbInitSql.length() > 0) {
                    dbInitSql = dbInitSql + ";";
                }
                dbInitSql = dbInitSql + propertyValue;
                properties.setProperty(propertyName, dbInitSql);
            }
        }
        return saveProperties;
    }

    private void exportH2Databases(String installPath) throws Exception {
        String tmpDirPath = this.getTmpDirPath(installPath);
        String dbSqlCommand = this.getDbSqlCommand(installPath);
        for (File engine : this.getEngineFiles(installPath)) {
            String targetDbUrl;
            Properties properties = this.getProperties(engine);
            String scriptFileName = engine.getName().replace(".properties", ".sql");
            String dbUrl = String.valueOf(properties.get("db.url"));
            if (dbUrl != null && dbUrl.startsWith("jdbc:h2:file:")) {
                String engineCopyPath = tmpDirPath + engine.getName();
                this.copyEngineFile(engine.getCanonicalPath(), engineCopyPath);
                engineCopyPath = "\"" + engineCopyPath + "\"";
                String sql = "\"SCRIPT TO '" + tmpDirPath + scriptFileName + "'\"";
                this.runDbSqlCommand(new String[]{dbSqlCommand, "-p", engineCopyPath, "-sql", sql});
            }
            if ((targetDbUrl = String.valueOf(properties.get("target.db.url"))) == null || !targetDbUrl.startsWith("jdbc:h2:file:")) continue;
            String enginePath = "\"" + engine.getCanonicalPath() + "\"";
            String sql = "\"SCRIPT TO '" + tmpDirPath + "target-" + scriptFileName + "'\"";
            this.runDbSqlCommand(new String[]{dbSqlCommand, "-p", enginePath, "-sql", sql});
        }
    }

    private void importH2Databases(String installPath, boolean fromVersion1) throws Exception {
        if (!fromVersion1) {
            this.deleteH2Databases(installPath);
        }
        String tmpDirPath = this.getTmpDirPath(installPath);
        String dbSqlCommand = this.getDbSqlCommand(installPath);
        for (File engine : this.getEngineFiles(installPath)) {
            String targetDbUrl;
            String sql;
            String scriptFilePath;
            Properties properties = this.getProperties(engine);
            String scriptFileName = engine.getName().replace(".properties", ".sql");
            String dbUrl = String.valueOf(properties.get("db.url"));
            if (dbUrl != null && dbUrl.startsWith("jdbc:h2:file:")) {
                String engineCopyPath = tmpDirPath + engine.getName();
                File engineCopy = new File(engineCopyPath);
                this.copyEngineFile(engine.getCanonicalPath(), engineCopyPath);
                engineCopyPath = "\"" + engineCopyPath + "\"";
                scriptFilePath = tmpDirPath + scriptFileName;
                sql = "\"RUNSCRIPT FROM '" + scriptFilePath + (fromVersion1 ? "' FROM_1X\"" : "'\"");
                this.runDbSqlCommand(new String[]{dbSqlCommand, "-p", engineCopyPath, "-sql", sql});
                new File(scriptFilePath).delete();
                engineCopy.delete();
            }
            if ((targetDbUrl = String.valueOf(properties.get("target.db.url"))) == null || !targetDbUrl.startsWith("jdbc:h2:file:")) continue;
            String enginePath = "\"" + engine.getCanonicalPath() + "\"";
            scriptFilePath = tmpDirPath + "target-" + scriptFileName;
            sql = "\"RUNSCRIPT FROM '" + scriptFilePath + (fromVersion1 ? "' FROM_1X\"" : "'\"");
            this.runDbSqlCommand(new String[]{dbSqlCommand, "-p", enginePath, "-sql", sql});
            new File(scriptFilePath).delete();
        }
    }

    private void deleteH2Databases(String installPath) throws Exception {
        String baseDirPath = System.getProperty("h2.baseDir", installPath + File.separator + "db" + File.separator + "h2");
        File baseDir = new File(baseDirPath);
        if (baseDir.exists() && baseDir.isDirectory()) {
            this.log("Deleting old H2 databases from " + baseDirPath);
            this.deleteH2DatabasesRecursive(baseDir.listFiles());
        }
    }

    private void deleteH2DatabasesRecursive(File[] fileList) {
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isDirectory()) {
                    this.deleteH2DatabasesRecursive(file.listFiles());
                    continue;
                }
                String fileName = file.toString().toLowerCase();
                if (!fileName.endsWith(".lock.db") && !fileName.endsWith(".trace.db") && !fileName.endsWith(".mv.db")) continue;
                file.delete();
            }
        }
    }

    private String getTmpDirPath(String installPath) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir", installPath + File.separator + "tmp"));
        String tmpDirPath = tmpDir.getAbsolutePath();
        if (!tmpDirPath.endsWith(File.separator)) {
            tmpDirPath = tmpDirPath + File.separator;
        }
        return tmpDirPath;
    }

    private Properties getProperties(File engine) throws Exception {
        Properties properties = new Properties();
        BufferedReader engineReader = new BufferedReader(new FileReader(engine));
        properties.load(engineReader);
        engineReader.close();
        return properties;
    }

    private void copyEngineFile(String enginePath, String engineCopyPath) throws Exception {
        File engineCopy = new File(engineCopyPath);
        if (engineCopy.exists()) {
            engineCopy.delete();
        }
        this.copyFile(enginePath, engineCopyPath);
        Properties propertiesCopy = new Properties();
        BufferedReader engineCopyReader = new BufferedReader(new FileReader(engineCopy));
        propertiesCopy.load(engineCopyReader);
        engineCopyReader.close();
        propertiesCopy.put("load.only", "false");
        try (FileOutputStream os = new FileOutputStream(engineCopy);){
            propertiesCopy.store(os, "Temporary engine file created by SymmetricDS Installer");
        }
    }

    private String getDbSqlCommand(String path) throws IOException {
        String filename = path + File.separator + "bin" + File.separator + "dbsql";
        if (this.getInstallData().getPlatform().getName() == Platform.Name.WINDOWS) {
            filename = filename + ".bat";
        }
        File exeFile = new File(filename);
        return exeFile.getCanonicalPath();
    }

    private void runDbSqlCommand(String[] cmd) throws Exception {
        StringBuilder output = new StringBuilder();
        Process proc = SymmetricIzPackHelper.runCommandForProcess(cmd);
        BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            output.append(line);
            this.log("Output: " + line);
        }
        reader.close();
        int rc = proc.waitFor();
        this.log("RC=" + rc);
        if (rc != 0) {
            throw new IzPackException("DbSql command returned code " + rc);
        }
    }

    private boolean isUsingService(String path) {
        try {
            this.log("Checking if service is installed");
            if (this.isOlderThanVersion(this.oldVersion, "3.6.0")) {
                String output = SymmetricIzPackHelper.runCommand(new String[]{this.getSymServiceCommand(path, true), "--query", ".." + File.separator + "conf" + File.separator + "sym_service.conf"});
                return output.indexOf("is installed") != -1;
            }
            String output = SymmetricIzPackHelper.runCommand(new String[]{this.getSymServiceCommand(path, true), "status"});
            return output.indexOf("Installed: true") != -1;
        }
        catch (IOException e) {
            this.log("Exception while trying to check status of service: " + e.getMessage());
            return false;
        }
    }

    private boolean startService(String path) {
        try {
            if (this.isAtLeastVersion(this.oldVersion, "3.6.0")) {
                this.log("Starting service");
                String output = SymmetricIzPackHelper.runCommand(new String[]{this.getSymServiceCommand(path, true), "start"});
                return output != null && output.indexOf("Started") != -1;
            }
        }
        catch (IOException e) {
            this.log("Exception while trying to start service: " + e.getMessage());
        }
        return false;
    }

    private boolean stopService(String path) {
        try {
            this.log("Stopping service");
            if (!this.isOlderThanVersion(this.oldVersion, "3.6.0")) {
                String output = SymmetricIzPackHelper.runCommand(new String[]{this.getSymServiceCommand(path, true), "stop"});
                return output != null && output.indexOf("Stopped") != -1;
            }
            SymmetricIzPackHelper.runCommand(new String[]{this.getSymServiceCommand(path, true), "--stop", ".." + File.separator + "conf" + File.separator + "sym_service.conf"});
        }
        catch (IOException e) {
            this.log("Exception while trying to stop service: " + e.getMessage());
        }
        return false;
    }

    private void uninstallService(String path) {
        try {
            this.log("Uninstalling service");
            if (this.isOlderThanVersion(this.oldVersion, "3.6.0")) {
                SymmetricIzPackHelper.runCommand(new String[]{this.getSymServiceCommand(path, true), "--remove", ".." + File.separator + "conf" + File.separator + "sym_service.conf"});
            } else {
                SymmetricIzPackHelper.runCommand(new String[]{this.getSymServiceCommand(path, true), "uninstall"});
            }
            boolean isServiceInstalled = this.isUsingService(path);
            if (this.isOlderThanVersion(this.oldVersion, "3.6.5")) {
                for (int seconds = 0; isServiceInstalled && seconds <= 30; ++seconds) {
                    this.log("Waiting for service to uninstall");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    isServiceInstalled = this.isUsingService(path);
                }
            }
            if (isServiceInstalled) {
                this.log("ERROR: Unable to uninstall service");
            }
        }
        catch (IOException e) {
            this.log("Exception while trying to uninstall service: " + e.getMessage());
        }
    }

    private void installService(String path) {
        try {
            this.log("Installing service");
            SymmetricIzPackHelper.runCommand(new String[]{this.getSymServiceCommand(path, false), "install"});
        }
        catch (IOException e) {
            this.log("Exception while trying to install service: " + e.getMessage());
        }
    }

    private String getSymServiceCommand(String path, boolean runOldVersion) throws IOException {
        String filename = path + File.separator + "bin" + File.separator + "sym_service";
        if (this.getInstallData().getPlatform().getName() == Platform.Name.WINDOWS) {
            filename = runOldVersion && this.isOlderThanVersion(this.oldVersion, "3.6.0") ? filename + ".exe" : filename + ".bat";
        }
        File exeFile = new File(filename);
        return exeFile.getCanonicalPath();
    }

    private List<File> getFileList(String path, InputStream is) throws IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String filename = null;
        String topDir = reader.readLine();
        while ((filename = reader.readLine()) != null) {
            File file;
            if (filename.length() <= topDir.length() || (filename = path + "/" + filename.substring(topDir.length() + 1)).startsWith(path + "/security") || filename.startsWith(path + "/conf") || filename.endsWith("setenv") || filename.endsWith("setenv.bat") || !(file = new File(filename)).isFile()) continue;
            fileList.add(file);
        }
        reader.close();
        return fileList;
    }

    private void copyFile(String sourceFileName, String destFileName) {
        this.log("Copying " + sourceFileName + " to " + destFileName);
        try {
            int len;
            FileInputStream in = new FileInputStream(sourceFileName);
            FileOutputStream out = new FileOutputStream(destFileName);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            this.log("An error occurred while trying to copy " + sourceFileName + " to " + destFileName);
            e.printStackTrace();
        }
    }

    public boolean isOlderThanVersion(String checkVersion, String targetVersion) {
        int[] targetVersions;
        if (this.noVersion(targetVersion) || this.noVersion(checkVersion)) {
            return false;
        }
        int[] checkVersions = this.parseVersion(checkVersion);
        if (checkVersions[0] < (targetVersions = this.parseVersion(targetVersion))[0]) {
            return true;
        }
        if (checkVersions[0] == targetVersions[0] && checkVersions[1] < targetVersions[1]) {
            return true;
        }
        return checkVersions[0] == targetVersions[0] && checkVersions[1] == targetVersions[1] && checkVersions[2] < targetVersions[2];
    }

    public boolean isAtLeastVersion(String checkVersion, String targetVersion) {
        int[] targetVersions;
        if (this.noVersion(targetVersion) || this.noVersion(checkVersion)) {
            return false;
        }
        int[] checkVersions = this.parseVersion(checkVersion);
        if (checkVersions[0] > (targetVersions = this.parseVersion(targetVersion))[0]) {
            return true;
        }
        if (checkVersions[0] == targetVersions[0] && checkVersions[1] > targetVersions[1]) {
            return true;
        }
        return checkVersions[0] == targetVersions[0] && checkVersions[1] == targetVersions[1] && checkVersions[2] >= targetVersions[2];
    }

    protected boolean noVersion(String targetVersion) {
        return targetVersion == null || targetVersion.trim().equals("") || "development".equals(targetVersion);
    }

    public int[] parseVersion(String version) {
        version = version.replaceAll("[^0-9\\.]", "");
        int[] versions = new int[3];
        if (version != null && !version.trim().equals("")) {
            String[] splitVersion = version.split("\\.");
            if (splitVersion.length >= 3) {
                versions[2] = this.parseVersionComponent(splitVersion[2]);
            }
            if (splitVersion.length >= 2) {
                versions[1] = this.parseVersionComponent(splitVersion[1]);
            }
            if (splitVersion.length >= 1) {
                versions[0] = this.parseVersionComponent(splitVersion[0]);
            }
        }
        return versions;
    }

    private int parseVersionComponent(String versionComponent) {
        int version = 0;
        try {
            if (versionComponent != null) {
                version = Integer.parseInt(versionComponent.trim());
            }
        }
        catch (NumberFormatException e) {
            this.log("Couldn't parse versionComponent '" + versionComponent + "' " + e);
        }
        return version;
    }

    private void archivePatchesOnUpgrade(InstallData installData) {
        File patchesDir = new File(installData.getInstallPath() + "/patches/");
        File patchesArchiveDir = new File(installData.getInstallPath() + "/patches/old");
        File[] patchList = patchesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".jar");
            }
        });
        if (patchList != null && patchList.length > 0) {
            this.log("Archiving patches to " + patchesArchiveDir);
            patchesArchiveDir.mkdirs();
            for (File patchFile : patchList) {
                File dest = new File(patchesArchiveDir + "/" + patchFile.getName());
                boolean success = patchFile.renameTo(dest);
                if (success) continue;
                this.log("Failed to move patch '" + patchFile + "' to '" + dest + "'");
            }
        }
    }

    private String generatePassword(int minLen, int maxLen) {
        SecureRandom random = new SecureRandom();
        int len = minLen + random.nextInt(maxLen - minLen + 1);
        return this.generatePassword(len);
    }

    private String generatePassword(int len) {
        String passwordChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.+!*";
        SecureRandom random = new SecureRandom();
        int maxInt = passwordChars.length();
        char[] password = new char[len];
        for (int i = 0; i < len; ++i) {
            password[i] = passwordChars.charAt(random.nextInt(maxInt));
        }
        return new String(password);
    }

    private String obfuscate(String plainText) {
        return new String(Base64.getEncoder().encode(this.rot13(plainText).getBytes(Charset.defaultCharset())), Charset.defaultCharset());
    }

    private String rot13(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= 'a' && c <= 'm' || c >= 'A' && c <= 'M') {
                c = (char)(c + 13);
            } else if (c >= 'n' && c <= 'z' || c >= 'N' && c <= 'Z') {
                c = (char)(c - 13);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void log(String message) {
        SymmetricIzPackHelper.log(message);
    }

    private void log(String message, Throwable t) {
        SymmetricIzPackHelper.log(message, t);
    }

    private String changeOwnerOfFiles(String installPath, String user) {
        String userAndGroup = user + ":" + this.getGroupId(user);
        String output = SymmetricIzPackHelper.runCommand(new String[]{"chown", "-R", userAndGroup, installPath});
        return output;
    }

    private void changePermissionsOfFiles(String installPath, String userOrGroup) {
        SymmetricIzPackHelper.runCommand(new String[]{"icacls", installPath, "/inheritancelevel:d", "/t"});
        SymmetricIzPackHelper.runCommand(new String[]{"icacls", installPath, "/remove", userOrGroup, "/t"});
    }

    private void changePermissionsOfFiles(String installPath) {
        File installDir = new File(installPath);
        File[] files = installDir.listFiles();
        if (files != null) {
            for (File file : files) {
                this.log("Changing permissions for " + file.getName());
                file.setReadable(false, false);
                file.setWritable(false, false);
                file.setExecutable(false, false);
                file.setReadable(true, true);
                file.setWritable(true, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroupId(String user) {
        int ret = -1;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("id");
        cmd.add("-g");
        cmd.add(user);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        System.out.println("Running " + pb.command());
        Process process = null;
        try {
            process = pb.start();
            ret = process.waitFor();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ArrayList<String> cmdOutput = new ArrayList<String>();
        BufferedReader reader = null;
        if (process != null) {
            try {
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    cmdOutput.add(line);
                }
            }
            catch (Exception e) {
                this.log("Unable to read from service command: " + cmd, e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (ret != 0) {
            this.log("Unable to run id command for user " + user);
        }
        return cmdOutput != null && cmdOutput.size() > 0 ? (String)cmdOutput.get(0) : "";
    }

    protected void checkBcpVariables(List<Pack> packs, InstallData idata) {
        boolean isSqlServerOnWindows = false;
        if (idata.getPlatform().isA(Platforms.WINDOWS)) {
            for (Pack pack : packs) {
                if (!pack.getName().toLowerCase().matches(".*sql.*server.*")) continue;
                this.log("Found pack " + pack.getName());
                isSqlServerOnWindows = true;
                break;
            }
        }
        if (isSqlServerOnWindows) {
            boolean isRuntimeInstalled = false;
            String[] files = new File("C:/Windows/System32").list();
            if (files != null) {
                for (String name : files) {
                    if (!name.toLowerCase().equals("vcruntime140_1.dll")) continue;
                    isRuntimeInstalled = true;
                    break;
                }
                if (!isRuntimeInstalled) {
                    this.log("MS-VCRT needs installed");
                    idata.setVariable("var.install.msvcrt", "true");
                } else {
                    this.log("MS-VCRT is already installed");
                }
            }
            boolean isDriverInstalled = false;
            files = new File("C:/Windows/SysWOW64").list();
            if (files != null) {
                for (String name : files) {
                    if (!name.toLowerCase().equals("msodbcsql17.dll")) continue;
                    isDriverInstalled = true;
                    break;
                }
                if (!isDriverInstalled) {
                    this.log("MS-SQL ODBC Driver needs installed");
                    idata.setVariable("var.install.msodbc", "true");
                } else {
                    this.log("MS-SQL ODBC Driver is already installed");
                }
            }
        }
    }
}

