/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.driver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.jumpmind.driver.InterceptResult;
import org.jumpmind.driver.WrapperInterceptor;

public class StatementWrapper
implements Statement {
    private WrapperInterceptor interceptor;
    private Statement wrapped;

    public StatementWrapper(Statement wrapped) {
        this.wrapped = wrapped;
        this.interceptor = WrapperInterceptor.createInterceptor(this, null);
    }

    public StatementWrapper(Statement wrapped, WrapperInterceptor interceptor) {
        this.wrapped = wrapped;
        this.interceptor = interceptor;
    }

    @Override
    public void close() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("close", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.close();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("close", null, startTime, endTime, new Object[0]);
    }

    @Override
    public Connection getConnection() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getConnection", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Connection)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Connection value = this.wrapped.getConnection();
        InterceptResult postResult = this.interceptor.postExecute("getConnection", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (Connection)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean execute(String arg1, int arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("execute", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.execute(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("execute", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean execute(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("execute", arg1);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.execute(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("execute", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean execute(String arg1, String[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("execute", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.execute(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("execute", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean execute(String arg1, int[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("execute", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.execute(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("execute", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean isClosed() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("isClosed", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.isClosed();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("isClosed", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getWarnings", new Object[0]);
        if (preResult.isIntercepted()) {
            return (SQLWarning)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        SQLWarning value = this.wrapped.getWarnings();
        InterceptResult postResult = this.interceptor.postExecute("getWarnings", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (SQLWarning)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void clearWarnings() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("clearWarnings", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.clearWarnings();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("clearWarnings", null, startTime, endTime, new Object[0]);
    }

    @Override
    public ResultSet executeQuery(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("executeQuery", arg1);
        if (preResult.isIntercepted()) {
            return (ResultSet)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        ResultSet value = this.wrapped.executeQuery(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("executeQuery", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (ResultSet)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int executeUpdate(String arg1, int arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("executeUpdate", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.executeUpdate(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("executeUpdate", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int executeUpdate(String arg1, int[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("executeUpdate", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.executeUpdate(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("executeUpdate", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int executeUpdate(String arg1, String[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("executeUpdate", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.executeUpdate(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("executeUpdate", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int executeUpdate(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("executeUpdate", arg1);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.executeUpdate(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("executeUpdate", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getMaxFieldSize", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getMaxFieldSize();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getMaxFieldSize", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setMaxFieldSize(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setMaxFieldSize", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setMaxFieldSize(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setMaxFieldSize", null, startTime, endTime, arg1);
    }

    @Override
    public int getMaxRows() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getMaxRows", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getMaxRows();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getMaxRows", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setMaxRows(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setMaxRows", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setMaxRows(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setMaxRows", null, startTime, endTime, arg1);
    }

    @Override
    public void setEscapeProcessing(boolean arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setEscapeProcessing", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setEscapeProcessing(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setEscapeProcessing", null, startTime, endTime, arg1);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getQueryTimeout", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getQueryTimeout();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getQueryTimeout", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setQueryTimeout(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setQueryTimeout", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setQueryTimeout(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setQueryTimeout", null, startTime, endTime, arg1);
    }

    @Override
    public void cancel() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("cancel", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.cancel();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("cancel", null, startTime, endTime, new Object[0]);
    }

    @Override
    public void setCursorName(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setCursorName", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setCursorName(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setCursorName", null, startTime, endTime, arg1);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getResultSet", new Object[0]);
        if (preResult.isIntercepted()) {
            return (ResultSet)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        ResultSet value = this.wrapped.getResultSet();
        InterceptResult postResult = this.interceptor.postExecute("getResultSet", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (ResultSet)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getUpdateCount", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getUpdateCount();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getUpdateCount", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean getMoreResults(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getMoreResults", arg1);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.getMoreResults(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getMoreResults", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getMoreResults", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.getMoreResults();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getMoreResults", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setFetchDirection(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setFetchDirection", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setFetchDirection(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setFetchDirection", null, startTime, endTime, arg1);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getFetchDirection", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getFetchDirection();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getFetchDirection", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setFetchSize(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setFetchSize", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setFetchSize(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setFetchSize", null, startTime, endTime, arg1);
    }

    @Override
    public int getFetchSize() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getFetchSize", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getFetchSize();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getFetchSize", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getResultSetConcurrency", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getResultSetConcurrency();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getResultSetConcurrency", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int getResultSetType() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getResultSetType", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getResultSetType();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getResultSetType", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void addBatch(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("addBatch", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.addBatch(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("addBatch", null, startTime, endTime, arg1);
    }

    @Override
    public void clearBatch() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("clearBatch", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.clearBatch();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("clearBatch", null, startTime, endTime, new Object[0]);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("executeBatch", new Object[0]);
        if (preResult.isIntercepted()) {
            return (int[])preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int[] value = this.wrapped.executeBatch();
        InterceptResult postResult = this.interceptor.postExecute("executeBatch", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (int[])postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getGeneratedKeys", new Object[0]);
        if (preResult.isIntercepted()) {
            return (ResultSet)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        ResultSet value = this.wrapped.getGeneratedKeys();
        InterceptResult postResult = this.interceptor.postExecute("getGeneratedKeys", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (ResultSet)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getResultSetHoldability", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getResultSetHoldability();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getResultSetHoldability", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setPoolable(boolean arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setPoolable", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setPoolable(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setPoolable", null, startTime, endTime, arg1);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("isPoolable", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.isPoolable();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("isPoolable", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("closeOnCompletion", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.closeOnCompletion();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("closeOnCompletion", null, startTime, endTime, new Object[0]);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("isCloseOnCompletion", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.isCloseOnCompletion();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("isCloseOnCompletion", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    public Object unwrap(Class arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("unwrap", arg1);
        if (preResult.isIntercepted()) {
            return preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Object value = this.wrapped.unwrap(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("unwrap", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return postResult.getInterceptResult();
        }
        return value;
    }

    public boolean isWrapperFor(Class arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("isWrapperFor", arg1);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.isWrapperFor(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("isWrapperFor", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }
}

