/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.postgresql.PostgresLobHandler;
import org.jumpmind.db.sql.AbstractSqlTemplate;
import org.jumpmind.db.sql.IConnectionCallback;
import org.jumpmind.db.sql.IConnectionHandler;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlResultsListener;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlStatementSource;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.JdbcSqlReadCursor;
import org.jumpmind.db.sql.JdbcSqlTransaction;
import org.jumpmind.db.sql.ListSqlStatementSource;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;
import org.jumpmind.exception.IoException;
import org.jumpmind.util.LinkedCaseInsensitiveMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;

public class JdbcSqlTemplate
extends AbstractSqlTemplate
implements ISqlTemplate {
    private static final Logger log = LoggerFactory.getLogger(JdbcSqlTemplate.class);
    protected DataSource dataSource;
    protected boolean requiresAutoCommitFalseToSetFetchSize = false;
    protected SqlTemplateSettings settings;
    protected SymmetricLobHandler lobHandler;
    protected Boolean supportsGetGeneratedKeys = null;
    protected int[] primaryKeyViolationCodes;
    protected String[] primaryKeyViolationSqlStates;
    protected String[] primaryKeyViolationMessageParts;
    protected String[] uniqueKeyViolationNameRegex;
    protected int[] foreignKeyViolationCodes;
    protected String[] foreignKeyViolationSqlStates;
    protected String[] foreignKeyViolationMessageParts;
    protected int[] foreignKeyChildExistsViolationCodes;
    protected String[] foreignKeyChildExistsViolationSqlStates;
    protected String[] foreignKeyChildExistsViolationMessageParts;
    protected int[] deadlockCodes;
    protected String[] deadlockSqlStates;
    protected int[] dataTruncationCodes;
    protected String[] dataTruncationStates;
    protected int[] objectAlreadyExistsCodes;
    protected String[] objectAlreadyExistsStates;
    protected int[] objectDoesNotExistCodes;
    protected String[] objectDoesNotExistStates;
    protected int isolationLevel;
    protected boolean isEmptyStringNulled;

    public JdbcSqlTemplate(DataSource dataSource, SqlTemplateSettings settings, SymmetricLobHandler lobHandler, DatabaseInfo databaseInfo) {
        this.dataSource = dataSource;
        this.settings = settings = settings == null ? new SqlTemplateSettings() : settings;
        this.lobHandler = lobHandler == null ? new SymmetricLobHandler((LobHandler)new DefaultLobHandler()) : lobHandler;
        this.isolationLevel = settings.getOverrideIsolationLevel() >= 0 ? settings.getOverrideIsolationLevel() : databaseInfo.getMinIsolationLevelToPreventPhantomReads();
        if (settings.getLogSqlBuilder() != null) {
            this.logSqlBuilder = settings.getLogSqlBuilder();
        }
        this.isEmptyStringNulled = databaseInfo.isEmptyStringNulled();
    }

    protected Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isRequiresAutoCommitFalseToSetFetchSize() {
        return this.requiresAutoCommitFalseToSetFetchSize;
    }

    public void setSettings(SqlTemplateSettings settings) {
        this.settings = settings;
    }

    public SqlTemplateSettings getSettings() {
        return this.settings;
    }

    public SymmetricLobHandler getLobHandler() {
        return this.lobHandler;
    }

    public <T> ISqlReadCursor<T> queryForCursor(String sql, ISqlRowMapper<T> mapper, Object[] args, int[] types) {
        return this.queryForCursor(sql, mapper, null, args, types, false);
    }

    public <T> ISqlReadCursor<T> queryForCursor(String sql, ISqlRowMapper<T> mapper, IConnectionHandler connectionHandler, Object[] args, int[] types) {
        return this.queryForCursor(sql, mapper, connectionHandler, args, types, false);
    }

    public <T> ISqlReadCursor<T> queryForCursor(String sql, ISqlRowMapper<T> mapper, boolean returnLobObjects) {
        return this.queryForCursor(sql, mapper, null, null, null, returnLobObjects);
    }

    public <T> ISqlReadCursor<T> queryForCursor(String sql, ISqlRowMapper<T> mapper, IConnectionHandler connectionHandler, Object[] args, int[] types, boolean returnLobObjects) {
        long startTime = System.currentTimeMillis();
        JdbcSqlReadCursor<T> cursor = new JdbcSqlReadCursor<T>(this, mapper, sql, args, types, connectionHandler, returnLobObjects);
        long endTime = System.currentTimeMillis();
        this.logSqlBuilder.logSql(log, sql, args, types, endTime - startTime);
        return cursor;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public <T> T queryForObject(final String sql, final Class<T> clazz, final Object ... args) {
        return this.execute(new IConnectionCallback<T>(){

            @Override
            public T execute(Connection con) throws SQLException {
                Object result = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                String expandedSql = JdbcSqlTemplate.this.expandSql(sql, args);
                try {
                    ps = con.prepareStatement(expandedSql);
                    ps.setQueryTimeout(JdbcSqlTemplate.this.settings.getQueryTimeout());
                    JdbcSqlTemplate.this.setValues(ps, JdbcSqlTemplate.this.expandArgs(sql, args));
                    long startTime = System.currentTimeMillis();
                    rs = ps.executeQuery();
                    long endTime = System.currentTimeMillis();
                    JdbcSqlTemplate.this.logSqlBuilder.logSql(log, expandedSql, args, null, endTime - startTime);
                    if (rs.next()) {
                        result = JdbcSqlTemplate.this.getObjectFromResultSet(rs, clazz);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw JdbcSqlTemplate.this.logSqlBuilder.logSqlAfterException(log, expandedSql, args, e);
                    }
                    catch (Throwable throwable) {
                        JdbcSqlTemplate.close(rs);
                        JdbcSqlTemplate.close(ps);
                        throw throwable;
                    }
                }
                JdbcSqlTemplate.close(rs);
                JdbcSqlTemplate.close(ps);
                return result;
            }
        });
    }

    @Deprecated
    public byte[] queryForBlob(String sql, Object ... args) {
        return this.queryForBlob(sql, -1, null, args);
    }

    public byte[] queryForBlob(final String sql, final int jdbcTypeCode, final String jdbcTypeName, final Object ... args) {
        return this.execute(new IConnectionCallback<byte[]>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public byte[] execute(Connection con) throws SQLException {
                ResultSet rs;
                PreparedStatement ps;
                byte[] result;
                block7: {
                    if (JdbcSqlTemplate.this.lobHandler.needsAutoCommitFalseForBlob(jdbcTypeCode, jdbcTypeName)) {
                        con.setAutoCommit(false);
                    }
                    result = null;
                    ps = null;
                    rs = null;
                    try {
                        ps = con.prepareStatement(sql);
                        ps.setQueryTimeout(JdbcSqlTemplate.this.settings.getQueryTimeout());
                        JdbcSqlTemplate.this.setValues(ps, args);
                        long startTime = System.currentTimeMillis();
                        rs = ps.executeQuery();
                        long endTime = System.currentTimeMillis();
                        JdbcSqlTemplate.this.logSqlBuilder.logSql(log, sql, args, null, endTime - startTime);
                        if (rs.next()) {
                            result = JdbcSqlTemplate.this.lobHandler.getBlobAsBytes(rs, 1, jdbcTypeCode, jdbcTypeName);
                        }
                        if (!JdbcSqlTemplate.this.lobHandler.needsAutoCommitFalseForBlob(jdbcTypeCode, jdbcTypeName) || con == null) break block7;
                    }
                    catch (SQLException e) {
                        try {
                            throw JdbcSqlTemplate.this.logSqlBuilder.logSqlAfterException(log, sql, args, e);
                        }
                        catch (Throwable throwable) {
                            if (JdbcSqlTemplate.this.lobHandler.needsAutoCommitFalseForBlob(jdbcTypeCode, jdbcTypeName) && con != null) {
                                con.setAutoCommit(true);
                            }
                            JdbcSqlTemplate.close(rs);
                            JdbcSqlTemplate.close(ps);
                            throw throwable;
                        }
                    }
                    con.setAutoCommit(true);
                }
                JdbcSqlTemplate.close(rs);
                JdbcSqlTemplate.close(ps);
                return result;
            }
        });
    }

    @Deprecated
    public String queryForClob(String sql, Object ... args) {
        return this.queryForClob(sql, -1, null, args);
    }

    public String queryForClob(final String sql, final int jdbcTypeCode, final String jdbcTypeName, final Object ... args) {
        return this.execute(new IConnectionCallback<String>(){

            @Override
            public String execute(Connection con) throws SQLException {
                String result = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    ps = con.prepareStatement(sql);
                    ps.setQueryTimeout(JdbcSqlTemplate.this.settings.getQueryTimeout());
                    JdbcSqlTemplate.this.setValues(ps, args);
                    long startTime = System.currentTimeMillis();
                    rs = ps.executeQuery();
                    long endTime = System.currentTimeMillis();
                    JdbcSqlTemplate.this.logSqlBuilder.logSql(log, sql, args, null, endTime - startTime);
                    if (rs.next()) {
                        result = JdbcSqlTemplate.this.lobHandler.getClobAsString(rs, 1, jdbcTypeCode, jdbcTypeName);
                    }
                }
                catch (SQLException e) {
                    try {
                        throw JdbcSqlTemplate.this.logSqlBuilder.logSqlAfterException(log, sql, args, e);
                    }
                    catch (Throwable throwable) {
                        JdbcSqlTemplate.close(rs);
                        JdbcSqlTemplate.close(ps);
                        throw throwable;
                    }
                }
                JdbcSqlTemplate.close(rs);
                JdbcSqlTemplate.close(ps);
                return result;
            }
        });
    }

    public Map<String, Object> queryForMap(final String sql, final Object ... args) {
        return this.execute(new IConnectionCallback<Map<String, Object>>(){

            @Override
            public Map<String, Object> execute(Connection con) throws SQLException {
                ResultSet rs;
                PreparedStatement ps;
                LinkedCaseInsensitiveMap result;
                block16: {
                    result = null;
                    ps = null;
                    rs = null;
                    try {
                        ps = con.prepareStatement(sql);
                        ps.setQueryTimeout(JdbcSqlTemplate.this.settings.getQueryTimeout());
                        if (args != null && args.length > 0) {
                            JdbcSqlTemplate.this.setValues(ps, args);
                        }
                        long startTime = System.currentTimeMillis();
                        rs = ps.executeQuery();
                        long endTime = System.currentTimeMillis();
                        JdbcSqlTemplate.this.logSqlBuilder.logSql(log, sql, args, null, endTime - startTime);
                        if (!rs.next()) break block16;
                        ResultSetMetaData meta = rs.getMetaData();
                        int colCount = meta.getColumnCount();
                        result = new LinkedCaseInsensitiveMap(colCount);
                        for (int i = 1; i <= colCount; ++i) {
                            Class<?> clazz;
                            Class<?> superClazz;
                            String key = meta.getColumnName(i);
                            Object value = rs.getObject(i);
                            if (value instanceof Blob) {
                                Blob blob = (Blob)value;
                                try {
                                    value = IOUtils.toByteArray((InputStream)blob.getBinaryStream());
                                }
                                catch (IOException e) {
                                    throw new IoException((Exception)e);
                                }
                            }
                            if (value instanceof Clob) {
                                Clob clob = (Clob)value;
                                try {
                                    value = IOUtils.toByteArray((Reader)clob.getCharacterStream(), (Charset)Charset.defaultCharset());
                                }
                                catch (IOException e) {
                                    throw new IoException((Exception)e);
                                }
                            }
                            if (value != null && (superClazz = (clazz = value.getClass()).getSuperclass()) != null && superClazz.getName().equals("oracle.sql.Datum")) {
                                try {
                                    Method method = superClazz.getMethod("toJdbc", new Class[0]);
                                    Object jdbcValue = method.invoke(value, new Object[0]);
                                    if (jdbcValue != null) {
                                        value = jdbcValue;
                                    }
                                }
                                catch (Exception e) {
                                    throw new IllegalStateException(e);
                                }
                            }
                            result.put(key, value);
                        }
                    }
                    catch (SQLException e) {
                        try {
                            throw JdbcSqlTemplate.this.logSqlBuilder.logSqlAfterException(log, sql, args, e);
                        }
                        catch (Throwable throwable) {
                            JdbcSqlTemplate.close(rs);
                            JdbcSqlTemplate.close(ps);
                            throw throwable;
                        }
                    }
                }
                JdbcSqlTemplate.close(rs);
                JdbcSqlTemplate.close(ps);
                return result;
            }
        });
    }

    public ISqlTransaction startSqlTransaction(boolean autoCommit) {
        return new JdbcSqlTransaction(this, autoCommit);
    }

    public ISqlTransaction startSqlTransaction() {
        return new JdbcSqlTransaction(this);
    }

    protected int getUpdateCount(Statement stmt) throws SQLException {
        int updateCount;
        do {
            updateCount = stmt.getUpdateCount();
        } while (stmt.getMoreResults() || stmt.getUpdateCount() != -1);
        return updateCount;
    }

    public int update(final String sql, final Object[] args, final int[] types) {
        return this.execute(new IConnectionCallback<Integer>(){

            @Override
            public Integer execute(Connection con) throws SQLException {
                Integer n;
                if (args == null) {
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.setQueryTimeout(JdbcSqlTemplate.this.settings.getQueryTimeout());
                        long startTime = System.currentTimeMillis();
                        stmt.execute(sql);
                        long endTime = System.currentTimeMillis();
                        JdbcSqlTemplate.this.logSqlBuilder.logSql(log, sql, args, types, endTime - startTime);
                        Integer n2 = JdbcSqlTemplate.this.getUpdateCount(stmt);
                        return n2;
                    }
                    catch (SQLException e) {
                        throw JdbcSqlTemplate.this.logSqlBuilder.logSqlAfterException(log, sql, args, e);
                    }
                    finally {
                        JdbcSqlTemplate.close(stmt);
                    }
                }
                PreparedStatement ps = null;
                try {
                    ps = con.prepareStatement(sql);
                    ps.setQueryTimeout(JdbcSqlTemplate.this.settings.getQueryTimeout());
                    if (types != null) {
                        JdbcSqlTemplate.this.setValues(ps, args, types, JdbcSqlTemplate.this.getLobHandler().getDefaultHandler());
                    } else {
                        JdbcSqlTemplate.this.setValues(ps, args);
                    }
                    long startTime = System.currentTimeMillis();
                    ps.execute();
                    long endTime = System.currentTimeMillis();
                    JdbcSqlTemplate.this.logSqlBuilder.logSql(log, sql, args, types, endTime - startTime);
                    n = JdbcSqlTemplate.this.getUpdateCount(ps);
                }
                catch (SQLException e) {
                    try {
                        throw JdbcSqlTemplate.this.logSqlBuilder.logSqlAfterException(log, sql, args, e);
                    }
                    catch (Throwable throwable) {
                        JdbcSqlTemplate.close(ps);
                        throw throwable;
                    }
                }
                JdbcSqlTemplate.close(ps);
                return n;
            }
        });
    }

    public int update(boolean autoCommit, boolean failOnError, int commitRate, String ... sql) {
        return this.update(autoCommit, failOnError, commitRate, (ISqlResultsListener)null, sql);
    }

    public int update(boolean autoCommit, boolean failOnError, int commitRate, ISqlResultsListener resultsListener, String ... sql) {
        return this.update(autoCommit, failOnError, true, true, commitRate, resultsListener, (ISqlStatementSource)new ListSqlStatementSource(sql));
    }

    public int update(final boolean autoCommit, final boolean failOnError, final boolean failOnDrops, final boolean failOnSequenceCreate, final int commitRate, final ISqlResultsListener resultsListener, final ISqlStatementSource source) {
        return this.execute(new IConnectionCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer execute(Connection con) throws SQLException {
                Integer n;
                int totalUpdateCount = 0;
                boolean oldAutoCommitSetting = con.getAutoCommit();
                Statement stmt = null;
                try {
                    con.setAutoCommit(autoCommit);
                    stmt = con.createStatement();
                    int statementCount = 0;
                    String statement = source.readSqlStatement();
                    while (statement != null) {
                        block23: {
                            if (StringUtils.isNotBlank((CharSequence)statement)) {
                                try {
                                    if (resultsListener != null) {
                                        resultsListener.sqlBefore(statement, statementCount);
                                    }
                                    long startTime = System.currentTimeMillis();
                                    boolean hasResults = stmt.execute(statement);
                                    long endTime = System.currentTimeMillis();
                                    JdbcSqlTemplate.this.logSqlBuilder.logSql(log, statement, null, null, endTime - startTime);
                                    int updateCount = stmt.getUpdateCount();
                                    totalUpdateCount += updateCount;
                                    int rowsRetrieved = 0;
                                    if (hasResults) {
                                        ResultSet rs = null;
                                        try {
                                            rs = stmt.getResultSet();
                                            while (rs.next()) {
                                                ++rowsRetrieved;
                                            }
                                        }
                                        finally {
                                            JdbcSqlTemplate.close(rs);
                                        }
                                    }
                                    if (resultsListener != null) {
                                        resultsListener.sqlApplied(statement, updateCount, rowsRetrieved, statementCount);
                                    }
                                    if (++statementCount % commitRate == 0 && !autoCommit) {
                                        con.commit();
                                    }
                                }
                                catch (SQLException ex) {
                                    boolean isDrop = statement.toLowerCase().trim().startsWith("drop");
                                    boolean isSequenceCreate = statement.toLowerCase().trim().startsWith("create sequence");
                                    if (resultsListener != null) {
                                        resultsListener.sqlErrored(statement, JdbcSqlTemplate.this.translate(statement, ex), statementCount, isDrop, isSequenceCreate);
                                    }
                                    if (isDrop && !failOnDrops || isSequenceCreate && !failOnSequenceCreate) {
                                        log.debug("{}.  Failed to execute: {}", (Object)ex.getMessage(), (Object)statement);
                                    }
                                    log.warn("{}.  Failed to execute: {}", (Object)ex.getMessage(), (Object)statement);
                                    if (!failOnError) break block23;
                                    throw ex;
                                }
                            }
                        }
                        statement = source.readSqlStatement();
                    }
                    if (!autoCommit) {
                        con.commit();
                    }
                    n = totalUpdateCount;
                }
                catch (SQLException ex) {
                    try {
                        if (!autoCommit) {
                            con.rollback();
                        }
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        JdbcSqlTemplate.close(stmt);
                        if (!con.isClosed()) {
                            con.setAutoCommit(oldAutoCommitSetting);
                        }
                        throw throwable;
                    }
                }
                JdbcSqlTemplate.close(stmt);
                if (!con.isClosed()) {
                    con.setAutoCommit(oldAutoCommitSetting);
                }
                return n;
            }
        });
    }

    public void testConnection() {
        this.execute(new IConnectionCallback<Boolean>(){

            @Override
            public Boolean execute(Connection con) {
                return true;
            }
        });
    }

    public <T> T execute(IConnectionCallback<T> callback) {
        Connection c = null;
        try {
            c = this.getConnection();
            T t = callback.execute(c);
            return t;
        }
        catch (SQLException ex) {
            throw this.translate(ex);
        }
        finally {
            JdbcSqlTemplate.close(c);
        }
    }

    public static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }

    @Deprecated
    public static Object getResultSetValue(ResultSet rs, int index, boolean readStringsAsBytes) throws SQLException {
        return JdbcSqlTemplate.getResultSetValue(rs, null, index, readStringsAsBytes, false);
    }

    public static Object getResultSetValue(ResultSet rs, ResultSetMetaData metaData, int index, boolean readStringsAsBytes, boolean returnLobObjects) throws SQLException {
        Object obj;
        block40: {
            if (metaData == null) {
                metaData = rs.getMetaData();
            }
            obj = null;
            int jdbcType = metaData.getColumnType(index);
            String jdbcTypeName = metaData.getColumnTypeName(index);
            if (readStringsAsBytes && TypeMap.isTextType((int)jdbcType)) {
                byte[] bytes = rs.getBytes(index);
                if (bytes != null) {
                    obj = new String(bytes, Charset.defaultCharset());
                }
            } else {
                obj = rs.getObject(index);
            }
            String className = null;
            if (obj != null) {
                className = obj.getClass().getName();
            }
            if (obj instanceof Blob && !returnLobObjects) {
                Blob blob = (Blob)obj;
                try (InputStream is = blob.getBinaryStream();){
                    obj = IOUtils.toByteArray((InputStream)is);
                    break block40;
                }
                catch (IOException e) {
                    throw new SqlException((Throwable)e);
                }
            }
            if (obj instanceof Clob && !returnLobObjects) {
                Clob clob = (Clob)obj;
                try (Reader reader = clob.getCharacterStream();){
                    obj = IOUtils.toString((Reader)reader);
                    break block40;
                }
                catch (IOException e) {
                    throw new SqlException((Throwable)e);
                }
            }
            if (className != null && "oracle.sql.TIMESTAMP".equals(className)) {
                obj = rs.getTimestamp(index);
            } else if (className != null && "oracle.sql.TIMESTAMPTZ".equals(className)) {
                obj = rs.getString(index);
            } else if (className != null && "oracle.sql.TIMESTAMPLTZ".equals(className)) {
                obj = rs.getString(index);
            } else if (className != null && className.startsWith("oracle.sql.DATE")) {
                String metaDataClassName = metaData.getColumnClassName(index);
                obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
            } else if (obj instanceof Date) {
                String metaDataClassName = metaData.getColumnClassName(index);
                if ("java.sql.Timestamp".equals(metaDataClassName)) {
                    obj = rs.getTimestamp(index);
                }
            } else if (obj instanceof Timestamp) {
                String typeName = metaData.getColumnTypeName(index);
                if (typeName != null && typeName.equals("timestamptz")) {
                    obj = rs.getString(index);
                }
            } else if (jdbcTypeName != null && "oid".equals(jdbcTypeName)) {
                obj = PostgresLobHandler.getLoColumnAsBytes(rs, index);
            } else if (jdbcTypeName != null && (jdbcTypeName.equals("unitext") || jdbcTypeName.equals("unichar") || jdbcTypeName.equals("univarchar"))) {
                obj = rs.getBytes(index);
            }
        }
        return obj;
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void close(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void close(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void close(boolean autoCommitValue, Connection c) {
        try {
            if (c != null) {
                c.setAutoCommit(autoCommitValue);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            JdbcSqlTemplate.close(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(boolean autoCommitValue, int transactionIsolationLevel, Connection c) {
        try {
            if (c != null) {
                c.setAutoCommit(autoCommitValue);
                if (c.getTransactionIsolation() != transactionIsolationLevel) {
                    c.setTransactionIsolation(transactionIsolationLevel);
                }
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            JdbcSqlTemplate.close(c);
        }
    }

    public static void close(Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getDatabaseMajorVersion() {
        return this.execute(new IConnectionCallback<Integer>(){

            @Override
            public Integer execute(Connection con) throws SQLException {
                return con.getMetaData().getDatabaseMajorVersion();
            }
        });
    }

    public int getDatabaseMinorVersion() {
        return this.execute(new IConnectionCallback<Integer>(){

            @Override
            public Integer execute(Connection con) throws SQLException {
                return con.getMetaData().getDatabaseMinorVersion();
            }
        });
    }

    public String getDatabaseProductName() {
        return this.execute(new IConnectionCallback<String>(){

            @Override
            public String execute(Connection con) throws SQLException {
                return con.getMetaData().getDatabaseProductName();
            }
        });
    }

    public boolean isStoresMixedCaseQuotedIdentifiers() {
        return this.execute(new IConnectionCallback<Boolean>(){

            @Override
            public Boolean execute(Connection con) throws SQLException {
                return con.getMetaData().storesMixedCaseQuotedIdentifiers();
            }
        });
    }

    public boolean isStoresUpperCaseIdentifiers() {
        return this.execute(new IConnectionCallback<Boolean>(){

            @Override
            public Boolean execute(Connection con) throws SQLException {
                return con.getMetaData().storesUpperCaseIdentifiers();
            }
        });
    }

    public boolean isStoresLowerCaseIdentifiers() {
        return this.execute(new IConnectionCallback<Boolean>(){

            @Override
            public Boolean execute(Connection con) throws SQLException {
                return con.getMetaData().storesLowerCaseIdentifiers();
            }
        });
    }

    public String getDatabaseProductVersion() {
        return this.execute(new IConnectionCallback<String>(){

            @Override
            public String execute(Connection con) throws SQLException {
                return con.getMetaData().getDatabaseProductVersion();
            }
        });
    }

    public String getDriverName() {
        return this.execute(new IConnectionCallback<String>(){

            @Override
            public String execute(Connection con) throws SQLException {
                return con.getMetaData().getDriverName();
            }
        });
    }

    public String getDriverVersion() {
        return this.execute(new IConnectionCallback<String>(){

            @Override
            public String execute(Connection con) throws SQLException {
                return con.getMetaData().getDriverVersion();
            }
        });
    }

    public Set<String> getSqlKeywords() {
        return this.execute(new IConnectionCallback<Set<String>>(){

            @Override
            public Set<String> execute(Connection con) throws SQLException {
                DatabaseMetaData sqlTemplateData = con.getMetaData();
                return new HashSet<String>(Arrays.asList(sqlTemplateData.getSQLKeywords().split(",")));
            }
        });
    }

    public boolean supportsGetGeneratedKeys() {
        if (this.supportsGetGeneratedKeys == null) {
            this.supportsGetGeneratedKeys = this.execute(new IConnectionCallback<Boolean>(){

                @Override
                public Boolean execute(Connection con) throws SQLException {
                    return con.getMetaData().supportsGetGeneratedKeys();
                }
            });
        }
        return this.supportsGetGeneratedKeys;
    }

    public boolean supportsReturningKeys() {
        return false;
    }

    protected boolean allowsNullForIdentityColumn() {
        return true;
    }

    protected String getSelectLastInsertIdSql(String sequenceName) {
        throw new UnsupportedOperationException();
    }

    public long insertWithGeneratedKey(final String sql, final String column, final String sequenceName, final Object[] args, final int[] types) {
        return this.execute(new IConnectionCallback<Long>(){

            @Override
            public Long execute(Connection conn) throws SQLException {
                return JdbcSqlTemplate.this.insertWithGeneratedKey(conn, sql, column, sequenceName, args, types);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long insertWithGeneratedKey(Connection conn, String sql, String column, String sequenceName, Object[] args, int[] types) throws SQLException {
        PreparedStatement ps;
        long key;
        block18: {
            key = 0L;
            ps = null;
            try {
                boolean supportsGetGeneratedKeys = this.supportsGetGeneratedKeys();
                boolean supportsReturningKeys = this.supportsReturningKeys();
                if (this.allowsNullForIdentityColumn()) {
                    ps = supportsGetGeneratedKeys ? conn.prepareStatement(sql, new int[]{1}) : (supportsReturningKeys ? conn.prepareStatement(sql + " returning " + column) : conn.prepareStatement(sql));
                } else {
                    String replaceSql = sql.replaceFirst("\\([\"|\\w]*,", "(").replaceFirst("\\(null,", "(");
                    ps = supportsGetGeneratedKeys ? conn.prepareStatement(replaceSql, 1) : conn.prepareStatement(replaceSql);
                }
                ps.setQueryTimeout(this.settings.getQueryTimeout());
                this.setValues(ps, args, types, this.lobHandler.getDefaultHandler());
                ResultSet rs = null;
                if (supportsGetGeneratedKeys) {
                    ps.execute();
                    try {
                        rs = ps.getGeneratedKeys();
                        if (rs.next()) {
                            key = rs.getLong(1);
                        }
                        break block18;
                    }
                    finally {
                        JdbcSqlTemplate.close(rs);
                    }
                }
                if (supportsReturningKeys) {
                    try {
                        rs = ps.executeQuery();
                        if (rs.next()) {
                            key = rs.getLong(1);
                        }
                        break block18;
                    }
                    finally {
                        JdbcSqlTemplate.close(rs);
                    }
                }
                Statement st = null;
                ps.execute();
                try {
                    st = conn.createStatement();
                    rs = st.executeQuery(this.getSelectLastInsertIdSql(sequenceName));
                    if (rs.next()) {
                        key = rs.getLong(1);
                    }
                }
                finally {
                    JdbcSqlTemplate.close(rs);
                    JdbcSqlTemplate.close(st);
                }
            }
            catch (Throwable throwable) {
                JdbcSqlTemplate.close(ps);
                throw throwable;
            }
        }
        JdbcSqlTemplate.close(ps);
        return key;
    }

    public boolean isUniqueKeyViolation(Throwable ex) {
        SQLException sqlEx;
        boolean primaryKeyViolation = false;
        if ((this.primaryKeyViolationCodes != null || this.primaryKeyViolationSqlStates != null) && (sqlEx = this.findSQLException(ex)) != null) {
            String sqlMessage;
            String sqlState;
            if (this.primaryKeyViolationCodes != null) {
                int errorCode = sqlEx.getErrorCode();
                for (int primaryKeyViolationCode : this.primaryKeyViolationCodes) {
                    if (primaryKeyViolationCode != errorCode) continue;
                    primaryKeyViolation = true;
                    break;
                }
            }
            if (this.primaryKeyViolationSqlStates != null && (sqlState = sqlEx.getSQLState()) != null) {
                for (String primaryKeyViolationSqlState : this.primaryKeyViolationSqlStates) {
                    if (primaryKeyViolationSqlState == null || !primaryKeyViolationSqlState.equals(sqlState)) continue;
                    primaryKeyViolation = true;
                    break;
                }
            }
            if (this.primaryKeyViolationMessageParts != null && (sqlMessage = sqlEx.getMessage()) != null) {
                sqlMessage = sqlMessage.toLowerCase();
                for (String primaryKeyViolationMessagePart : this.primaryKeyViolationMessageParts) {
                    if (primaryKeyViolationMessagePart == null || !sqlMessage.contains(primaryKeyViolationMessagePart.toLowerCase())) continue;
                    primaryKeyViolation = true;
                    break;
                }
            }
        }
        return primaryKeyViolation;
    }

    public boolean isForeignKeyViolation(Throwable ex) {
        SQLException sqlEx;
        boolean foreignKeyViolation = false;
        if ((this.foreignKeyViolationCodes != null || this.foreignKeyViolationSqlStates != null) && (sqlEx = this.findSQLException(ex)) != null) {
            String sqlMessage;
            String sqlState;
            if (this.foreignKeyViolationCodes != null) {
                int errorCode = sqlEx.getErrorCode();
                for (int foreignKeyViolationCode : this.foreignKeyViolationCodes) {
                    if (foreignKeyViolationCode != errorCode) continue;
                    foreignKeyViolation = true;
                    break;
                }
            }
            if (this.foreignKeyViolationSqlStates != null && (sqlState = sqlEx.getSQLState()) != null) {
                for (String foreignKeyViolationSqlState : this.foreignKeyViolationSqlStates) {
                    if (foreignKeyViolationSqlState == null || !foreignKeyViolationSqlState.equals(sqlState)) continue;
                    foreignKeyViolation = true;
                    break;
                }
            }
            if (this.foreignKeyViolationMessageParts != null && (sqlMessage = sqlEx.getMessage()) != null) {
                sqlMessage = sqlMessage.toLowerCase();
                for (String foreignKeyViolationMessagePart : this.foreignKeyViolationMessageParts) {
                    if (foreignKeyViolationMessagePart == null || !sqlMessage.contains(foreignKeyViolationMessagePart.toLowerCase())) continue;
                    foreignKeyViolation = true;
                    break;
                }
            }
        }
        return foreignKeyViolation;
    }

    public boolean isForeignKeyChildExistsViolation(Throwable ex) {
        SQLException sqlEx;
        boolean foreignKeyChildExistsViolation = false;
        if ((this.foreignKeyChildExistsViolationCodes != null || this.foreignKeyChildExistsViolationSqlStates != null || this.foreignKeyChildExistsViolationMessageParts != null) && (sqlEx = this.findSQLException(ex)) != null) {
            String sqlMessage;
            String sqlState;
            if (this.foreignKeyChildExistsViolationCodes != null) {
                int errorCode = sqlEx.getErrorCode();
                for (int foreignKeyChildExistsViolationCode : this.foreignKeyChildExistsViolationCodes) {
                    if (foreignKeyChildExistsViolationCode != errorCode) continue;
                    foreignKeyChildExistsViolation = true;
                    break;
                }
            }
            if (this.foreignKeyChildExistsViolationSqlStates != null && (sqlState = sqlEx.getSQLState()) != null) {
                for (String foreignKeyChildExistsViolationSqlState : this.foreignKeyChildExistsViolationSqlStates) {
                    if (foreignKeyChildExistsViolationSqlState == null || !foreignKeyChildExistsViolationSqlState.equals(sqlState)) continue;
                    foreignKeyChildExistsViolation = true;
                    break;
                }
            }
            if (this.foreignKeyChildExistsViolationMessageParts != null && (sqlMessage = sqlEx.getMessage()) != null) {
                sqlMessage = sqlMessage.toLowerCase();
                for (String foreignKeyChildExistsViolationMessagePart : this.foreignKeyChildExistsViolationMessageParts) {
                    if (foreignKeyChildExistsViolationMessagePart == null || !sqlMessage.contains(foreignKeyChildExistsViolationMessagePart.toLowerCase()) && (!foreignKeyChildExistsViolationMessagePart.contains("*") || !sqlMessage.matches(foreignKeyChildExistsViolationMessagePart))) continue;
                    foreignKeyChildExistsViolation = true;
                    break;
                }
            }
        }
        return foreignKeyChildExistsViolation;
    }

    public boolean isDeadlock(Throwable ex) {
        SQLException sqlEx;
        boolean deadlock = false;
        if ((this.deadlockCodes != null || this.deadlockSqlStates != null) && (sqlEx = this.findSQLException(ex)) != null) {
            String sqlState;
            if (this.deadlockCodes != null) {
                int errorCode = sqlEx.getErrorCode();
                for (int deadlockCode : this.deadlockCodes) {
                    if (deadlockCode != errorCode) continue;
                    deadlock = true;
                    break;
                }
            }
            if (this.deadlockSqlStates != null && (sqlState = sqlEx.getSQLState()) != null) {
                for (String primaryKeyViolationSqlState : this.deadlockSqlStates) {
                    if (primaryKeyViolationSqlState == null || !primaryKeyViolationSqlState.equals(sqlState)) continue;
                    deadlock = true;
                    break;
                }
            }
        }
        return deadlock;
    }

    public boolean isDataTruncationViolation(Throwable ex) {
        SQLException sqlEx;
        boolean truncation = false;
        if ((this.dataTruncationCodes != null || this.dataTruncationStates != null) && (sqlEx = this.findSQLException(ex)) != null) {
            String sqlState;
            if (this.dataTruncationCodes != null) {
                int errorCode = sqlEx.getErrorCode();
                for (int dataTruncationCode : this.dataTruncationCodes) {
                    if (dataTruncationCode != errorCode) continue;
                    truncation = true;
                    break;
                }
            }
            if (this.dataTruncationStates != null && (sqlState = sqlEx.getSQLState()) != null) {
                for (String dataTruncationState : this.dataTruncationStates) {
                    if (!sqlState.equals(dataTruncationState)) continue;
                    truncation = true;
                    break;
                }
            }
        }
        return truncation;
    }

    public boolean doesObjectAlreadyExist(Throwable ex) {
        SQLException sqlEx;
        boolean alreadyExists = false;
        if ((this.objectAlreadyExistsCodes != null || this.objectAlreadyExistsStates != null) && (sqlEx = this.findSQLException(ex)) != null) {
            String sqlState;
            if (this.objectAlreadyExistsCodes != null) {
                int errorCode = sqlEx.getErrorCode();
                for (int objectAlreadyExistsCode : this.objectAlreadyExistsCodes) {
                    if (objectAlreadyExistsCode != errorCode) continue;
                    alreadyExists = true;
                    break;
                }
            }
            if (this.objectAlreadyExistsStates != null && (sqlState = sqlEx.getSQLState()) != null) {
                for (String objectAlreadyExistsState : this.objectAlreadyExistsStates) {
                    if (!sqlState.equals(objectAlreadyExistsState)) continue;
                    alreadyExists = true;
                    break;
                }
            }
        }
        return alreadyExists;
    }

    public boolean doesObjectNotExist(Throwable ex) {
        SQLException sqlEx;
        boolean doesNotExist = false;
        if ((this.objectDoesNotExistCodes != null || this.objectDoesNotExistStates != null) && (sqlEx = this.findSQLException(ex)) != null) {
            String sqlState;
            if (this.objectDoesNotExistCodes != null) {
                int errorCode = sqlEx.getErrorCode();
                for (int objectDoesNotExistCode : this.objectDoesNotExistCodes) {
                    if (objectDoesNotExistCode != errorCode) continue;
                    doesNotExist = true;
                    break;
                }
            }
            if (this.objectDoesNotExistStates != null && (sqlState = sqlEx.getSQLState()) != null) {
                for (String objectDoesNotExistState : this.objectDoesNotExistStates) {
                    if (!sqlState.equals(objectDoesNotExistState)) continue;
                    doesNotExist = true;
                    break;
                }
            }
        }
        return doesNotExist;
    }

    protected SQLException findSQLException(Throwable ex) {
        if (ex instanceof SQLException) {
            return (SQLException)ex;
        }
        Throwable cause = ex.getCause();
        if (cause != null && !cause.equals(ex)) {
            return this.findSQLException(cause);
        }
        return null;
    }

    public <T> T getObjectFromResultSet(ResultSet rs, Class<T> clazz) throws SQLException {
        Object result = java.util.Date.class.isAssignableFrom(clazz) ? rs.getTimestamp(1) : (String.class.isAssignableFrom(clazz) ? rs.getString(1) : (Long.class.isAssignableFrom(clazz) ? Long.valueOf(rs.getLong(1)) : (Integer.class.isAssignableFrom(clazz) ? Integer.valueOf(rs.getInt(1)) : (Float.class.isAssignableFrom(clazz) ? Float.valueOf(rs.getFloat(1)) : (Double.class.isAssignableFrom(clazz) ? Double.valueOf(rs.getDouble(1)) : (BigDecimal.class.isAssignableFrom(clazz) ? rs.getBigDecimal(1) : rs.getObject(1)))))));
        return (T)result;
    }

    public void setValues(PreparedStatement ps, Object[] args, int[] argTypes, LobHandler lobHandler) throws SQLException {
        for (int i = 1; i <= args.length; ++i) {
            Object arg = args[i - 1];
            int argType = argTypes != null && argTypes.length >= i ? argTypes[i - 1] : Integer.MIN_VALUE;
            try {
                if (argType == 2004 && lobHandler != null && arg instanceof byte[]) {
                    if (this.isEmptyStringNulled && ((byte[])arg).length == 0) {
                        ps.setBlob(i, ps.getConnection().createBlob());
                        continue;
                    }
                    lobHandler.getLobCreator().setBlobAsBytes(ps, i, (byte[])arg);
                    continue;
                }
                if (argType == 2004 && lobHandler != null && arg instanceof String) {
                    if (this.isEmptyStringNulled && arg.equals("")) {
                        ps.setBlob(i, ps.getConnection().createBlob());
                        continue;
                    }
                    lobHandler.getLobCreator().setBlobAsBytes(ps, i, arg.toString().getBytes(Charset.defaultCharset()));
                    continue;
                }
                if (argType == 2005 && lobHandler != null) {
                    if (this.isEmptyStringNulled && arg != null && arg.equals("")) {
                        ps.setClob(i, ps.getConnection().createClob());
                        continue;
                    }
                    lobHandler.getLobCreator().setClobAsString(ps, i, (String)arg);
                    continue;
                }
                if ((argType == 3 || argType == 2) && arg != null) {
                    this.setDecimalValue(ps, i, arg, argType);
                    continue;
                }
                if (argType == -6) {
                    this.setTinyIntValue(ps, i, arg, argType);
                    continue;
                }
                StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)i, (int)this.verifyArgType(arg, argType), (Object)arg);
                continue;
            }
            catch (SQLException ex) {
                String msg = String.format("Parameter arg '%s' type: %s caused exception: %s", arg, TypeMap.getJdbcTypeName((int)argType), ex.getMessage());
                throw new SQLException(msg, ex);
            }
        }
    }

    protected void setTinyIntValue(PreparedStatement ps, int i, Object arg, int argType) throws SQLException {
        StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)i, (int)this.verifyArgType(arg, argType), (Object)arg);
    }

    protected void setDecimalValue(PreparedStatement ps, int i, Object arg, int argType) throws SQLException {
        if ((argType == 3 || argType == 2) && arg != null && arg.equals("NaN")) {
            this.setNanOrNull(ps, i, arg, argType);
        } else {
            StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)i, (int)this.verifyArgType(arg, argType), (Object)arg);
        }
    }

    protected void setNanOrNull(PreparedStatement ps, int i, Object arg, int argType) throws SQLException {
        StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)i, (int)this.verifyArgType(arg, argType), null);
    }

    protected int verifyArgType(Object arg, int argType) {
        if (argType == -101 || argType == -102 || argType == 1111 || argType == -150) {
            return Integer.MIN_VALUE;
        }
        if (argType == 4 && arg instanceof BigInteger || argType == -5 && arg instanceof BigDecimal) {
            return 3;
        }
        return argType;
    }

    public void setValues(PreparedStatement ps, Object[] args) throws SQLException {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                try {
                    this.doSetValue(ps, i + 1, arg);
                    continue;
                }
                catch (SQLException ex) {
                    log.warn("Parameter arg '{}' caused exception: {}", arg, (Object)ex.getMessage());
                    throw ex;
                }
            }
        }
    }

    public void doSetValue(PreparedStatement ps, int parameterPosition, Object argValue) throws SQLException {
        StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)parameterPosition, (int)Integer.MIN_VALUE, (Object)argValue);
    }

    public String getUniqueKeyViolationIndexName(Throwable ex) {
        SQLException sqlEx;
        String indexName = null;
        if (this.uniqueKeyViolationNameRegex != null && (sqlEx = this.findSQLException(ex)) != null) {
            for (String regex : this.uniqueKeyViolationNameRegex) {
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(sqlEx.getMessage());
                if (!matcher.find()) continue;
                indexName = matcher.group(1);
                break;
            }
        }
        return indexName;
    }
}

