/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.voltdb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;

public class VoltDbDdlReader
extends AbstractJdbcDdlReader {
    public static final String VOLT_DB_SYSTEM_INDEX_PREFIX = "VOLTDB_AUTOGEN_IDX_";

    public VoltDbDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern(null);
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) throws SQLException {
        return true;
    }

    @Override
    protected void removeSystemIndices(Connection connection, DatabaseMetaDataWrapper metaData, Table table) throws SQLException {
        super.removeSystemIndices(connection, metaData, table);
        int indexIdx = 0;
        while (indexIdx < table.getIndexCount()) {
            IIndex index = table.getIndex(indexIdx);
            if (index.getName() != null && index.getName().startsWith(VOLT_DB_SYSTEM_INDEX_PREFIX)) {
                table.removeIndex(indexIdx);
                continue;
            }
            ++indexIdx;
        }
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        this.disableAutoIncrement(table);
        this.fixIndexKeyOrder(table);
        return table;
    }

    protected void fixIndexKeyOrder(Table table) {
    }

    protected void disableAutoIncrement(Table table) {
        for (Column column : table.getColumns()) {
            column.setAutoIncrement(false);
        }
    }

    @Override
    protected void readForeignKeyUpdateRule(Map<String, Object> values, ForeignKey fk) {
        fk.setOnUpdateAction(ForeignKey.ForeignKeyAction.NOACTION);
    }

    @Override
    protected void readForeignKeyDeleteRule(Map<String, Object> values, ForeignKey fk) {
        fk.setOnDeleteAction(ForeignKey.ForeignKeyAction.NOACTION);
    }
}

