/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.nuodb;

import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.nuodb.NuoDbDdlBuilder;
import org.jumpmind.db.platform.nuodb.NuoDbDdlReader;
import org.jumpmind.db.platform.nuodb.NuoDbJdbcSqlTemplate;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class NuoDbDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "com.nuodb.jdbc.Driver";
    public static final String JDBC_SUBPROTOCOL = "nuodb";

    public NuoDbDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
    }

    protected NuoDbDdlBuilder createDdlBuilder() {
        return new NuoDbDdlBuilder();
    }

    @Override
    protected NuoDbDdlReader createDdlReader() {
        return new NuoDbDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected NuoDbJdbcSqlTemplate createSqlTemplate() {
        return new NuoDbJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    @Override
    protected ISqlTemplate createSqlTemplateDirty() {
        return this.sqlTemplate;
    }

    public String getName() {
        return JDBC_SUBPROTOCOL;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("select current_schema from system.dual", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public String getDefaultCatalog() {
        return null;
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE TRIGGER TEST_TRIGGER FOR" + delimiter + "SYM_PERMISSION_TEST" + delimiter + " AFTER UPDATE FOR EACH ROW AS INSERT INTO " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " VALUES(NULL,NULL); END_TRIGGER";
        String dropTriggerSql = "DROP TRIGGER IF EXISTS TEST_TRIGGER";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, dropTriggerSql + "\r\n" + triggerSql + "\r\n" + dropTriggerSql);
        try {
            this.getSqlTemplate().update(dropTriggerSql, new Object[0]);
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            this.getSqlTemplate().update(dropTriggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public PermissionResult getCreateSymRoutinePermission() {
        String routineSql = "CREATE PROCEDURE TEST_PROC() AS VAR myVar = 1; END_PROCEDURE";
        String dropSql = "DROP PROCEDURE IF EXISTS TEST_PROC";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_ROUTINE, dropSql + "\r\n" + routineSql + "\r\n" + dropSql);
        try {
            this.getSqlTemplate().update(dropSql, new Object[0]);
            this.getSqlTemplate().update(routineSql, new Object[0]);
            this.getSqlTemplate().update(dropSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE ROUTINE Privilege");
        }
        return result;
    }

    protected PermissionResult getDropSymTriggerPermission() {
        String dropTriggerSql = "DROP TRIGGER IF EXISTS TEST_TRIGGER";
        PermissionResult result = new PermissionResult(PermissionType.DROP_TRIGGER, dropTriggerSql);
        try {
            this.getSqlTemplate().update(dropTriggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant DROP TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql + " limit " + limit + " offset " + offset;
    }
}

