/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mssql;

import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.JdbcSqlTransaction;

public class MsSqlJdbcSqlTransaction
extends JdbcSqlTransaction {
    private boolean allowsAutoIncrement;

    public MsSqlJdbcSqlTransaction(JdbcSqlTemplate sqltemplate) {
        super(sqltemplate);
    }

    public MsSqlJdbcSqlTransaction(JdbcSqlTemplate sqltemplate, boolean autoCommit) {
        super(sqltemplate, autoCommit);
    }

    @Override
    public void allowInsertIntoAutoIncrementColumns(boolean allow, Table table, String quote, String catalogSeparator, String schemaSeparator) {
        if (table != null && table.getAutoIncrementColumns().length > 0) {
            if (allow) {
                this.execute(String.format("SET IDENTITY_INSERT %s ON", table.getQualifiedTableName(quote, catalogSeparator, schemaSeparator)));
                this.allowsAutoIncrement = true;
            } else {
                this.execute(String.format("SET IDENTITY_INSERT %s OFF", table.getQualifiedTableName(quote, catalogSeparator, schemaSeparator)));
                this.allowsAutoIncrement = false;
            }
        }
    }

    @Override
    public boolean isAllowInsertIntoAutoIncrement() {
        return this.allowsAutoIncrement;
    }
}

