/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.interbase;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.interbase.InterbaseDdlBuilder;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;

public class InterbaseDdlReader
extends AbstractJdbcDdlReader {
    public InterbaseDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern("%");
        this.setDefaultColumnPattern("%");
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            this.determineExtraColumnInfo(connection, table);
            this.determineAutoIncrementColumns(connection, table);
            this.adjustColumns(table);
        }
        return table;
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        int size;
        Column column = super.readColumn(metaData, values);
        if (column.getMappedTypeCode() == 12 && (size = Integer.parseInt(column.getSize())) >= InterbaseDdlBuilder.SWITCH_TO_LONGVARCHAR_SIZE) {
            column.setMappedTypeCode(-1);
        }
        if (column.getJdbcTypeCode() == 93) {
            this.resetColumnSize(column, "4");
        }
        if (column.getJdbcTypeCode() == 92) {
            this.resetColumnSize(column, "4");
        }
        if (column.getJdbcTypeCode() == 91) {
            this.removeColumnSize(column);
        }
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<Column> readColumns(DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        try (ResultSet columnData = null;){
            ArrayList<Column> columns = new ArrayList<Column>();
            if (this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn()) {
                columnData = metaData.getColumns(this.getDefaultTablePattern(), this.getDefaultColumnPattern());
                while (columnData.next()) {
                    values = this.readMetaData(columnData, this.getColumnsForColumn());
                    if (!tableName.equals(values.get("TABLE_NAME"))) continue;
                    columns.add(this.readColumn(metaData, values));
                }
            } else {
                columnData = metaData.getColumns(tableName, this.getDefaultColumnPattern());
                while (columnData.next()) {
                    values = this.readMetaData(columnData, this.getColumnsForColumn());
                    columns.add(this.readColumn(metaData, values));
                }
            }
            ArrayList<Column> arrayList = columns;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void determineExtraColumnInfo(Connection connection, Table table) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT a.RDB$FIELD_NAME, a.RDB$DEFAULT_SOURCE, b.RDB$FIELD_PRECISION, b.RDB$FIELD_SCALE,");
        query.append(" b.RDB$FIELD_TYPE, b.RDB$FIELD_SUB_TYPE FROM RDB$RELATION_FIELDS a, RDB$FIELDS b");
        query.append(" WHERE a.RDB$RELATION_NAME=? AND a.RDB$FIELD_SOURCE=b.RDB$FIELD_NAME");
        try (PreparedStatement prepStmt = connection.prepareStatement(query.toString());){
            prepStmt.setString(1, this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? table.getName() : table.getName().toUpperCase());
            ResultSet rs = prepStmt.executeQuery();
            while (rs.next()) {
                boolean scaleSpecified;
                String defaultValue;
                String columnName = rs.getString(1).trim();
                Column column = table.findColumn(columnName, this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn());
                if (column == null) continue;
                byte[] defaultBytes = rs.getBytes(2);
                String string = defaultValue = defaultBytes != null ? new String(defaultBytes, Charset.defaultCharset()) : null;
                if (!rs.wasNull() && defaultValue != null) {
                    if ((defaultValue = defaultValue.trim()).toUpperCase().startsWith("DEFAULT ")) {
                        defaultValue = defaultValue.substring("DEFAULT ".length());
                    }
                    column.setDefaultValue(defaultValue);
                }
                short precision = rs.getShort(3);
                boolean precisionSpecified = !rs.wasNull();
                short scale = rs.getShort(4);
                boolean bl = scaleSpecified = !rs.wasNull();
                if (precisionSpecified) {
                    column.setSizeAndScale((int)precision, (int)(scaleSpecified ? -scale : (short)0));
                }
                short dbType = rs.getShort(5);
                short blobSubType = rs.getShort(6);
                if (rs.wasNull() || dbType != 261 || blobSubType != 1) continue;
                column.setMappedTypeCode(2005);
            }
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void determineAutoIncrementColumns(Connection connection, Table table) throws SQLException {
        InterbaseDdlBuilder builder = (InterbaseDdlBuilder)this.getPlatform().getDdlBuilder();
        Column[] columns = table.getColumns();
        HashMap<String, Column> names = new HashMap<String, Column>();
        for (int idx = 0; idx < columns.length; ++idx) {
            String name = builder.getGeneratorName(table, columns[idx]);
            if (!this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn()) {
                name = name.toUpperCase();
            }
            names.put(name, columns[idx]);
        }
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT RDB$GENERATOR_NAME FROM RDB$GENERATORS");
            while (rs.next()) {
                String generatorName = rs.getString(1).trim();
                Column column = (Column)names.get(generatorName);
                if (column == null) continue;
                column.setAutoIncrement(true);
            }
            rs.close();
        }
    }

    protected void adjustColumns(Table table) {
        Column[] columns = table.getColumns();
        for (int idx = 0; idx < columns.length; ++idx) {
            if (columns[idx].getMappedTypeCode() == 6) {
                columns[idx].setMappedTypeCode(7);
                continue;
            }
            if (columns[idx].getMappedTypeCode() == 2 || columns[idx].getMappedTypeCode() == 3) {
                if (columns[idx].getMappedTypeCode() != 2 || columns[idx].getSizeAsInt() != 18 || columns[idx].getScale() != 0) continue;
                columns[idx].setMappedTypeCode(-5);
                continue;
            }
            if (!TypeMap.isTextType((int)columns[idx].getMappedTypeCode())) continue;
            columns[idx].setDefaultValue(this.unescape(columns[idx].getDefaultValue(), "'", "''"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<String> readPrimaryKeyNames(DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        ArrayList<String> pks = new ArrayList<String>();
        try (ResultSet pkData = null;){
            if (this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn()) {
                pkData = metaData.getPrimaryKeys(this.getDefaultTablePattern());
                while (pkData.next()) {
                    Map<String, Object> values = this.readMetaData(pkData, this.getColumnsForPK());
                    if (!tableName.equals(values.get("TABLE_NAME"))) continue;
                    pks.add(this.readPrimaryKeyName(metaData, values));
                }
            } else {
                pkData = metaData.getPrimaryKeys(tableName);
                while (pkData.next()) {
                    Map<String, Object> values = this.readMetaData(pkData, this.getColumnsForPK());
                    pks.add(this.readPrimaryKeyName(metaData, values));
                }
            }
        }
        return pks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<IIndex> readIndices(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        ListOrderedMap indices = new ListOrderedMap();
        StringBuilder query = new StringBuilder();
        query.append("SELECT a.RDB$INDEX_NAME, b.RDB$RELATION_NAME, b.RDB$UNIQUE_FLAG,    ");
        query.append(" a.RDB$FIELD_POSITION, a.RDB$FIELD_NAME                             ");
        query.append(" FROM RDB$INDEX_SEGMENTS a, RDB$INDICES b                           ");
        query.append(" WHERE a.RDB$INDEX_NAME=b.RDB$INDEX_NAME AND b.RDB$RELATION_NAME = ?");
        PreparedStatement stmt = connection.prepareStatement(query.toString());
        stmt.setString(1, this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? tableName : tableName.toUpperCase());
        try (ResultSet indexData = null;){
            indexData = stmt.executeQuery();
            while (indexData.next()) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("INDEX_NAME", indexData.getString(1).trim());
                values.put("TABLE_NAME", indexData.getString(2).trim());
                values.put("NON_UNIQUE", !indexData.getBoolean(3));
                values.put("ORDINAL_POSITION", indexData.getShort(4));
                values.put("COLUMN_NAME", indexData.getString(5).trim());
                values.put("INDEX_TYPE", 3);
                this.readIndex(metaData, values, (Map<String, IIndex>)indices);
            }
        }
        return indices.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<ForeignKey> readForeignKeys(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        ListOrderedMap fks = new ListOrderedMap();
        try (ResultSet fkData = null;){
            if (this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn()) {
                fkData = metaData.getForeignKeys(this.getDefaultTablePattern());
                while (fkData.next()) {
                    Map<String, Object> values = this.readMetaData(fkData, this.getColumnsForFK());
                    if (!tableName.equals(values.get("FKTABLE_NAME"))) continue;
                    this.readForeignKey(metaData, values, (Map<String, ForeignKey>)fks);
                }
            } else {
                fkData = metaData.getForeignKeys(tableName);
                while (fkData.next()) {
                    Map<String, Object> values = this.readMetaData(fkData, this.getColumnsForFK());
                    this.readForeignKey(metaData, values, (Map<String, ForeignKey>)fks);
                }
            }
        }
        return fks.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) throws SQLException {
        InterbaseDdlBuilder builder = (InterbaseDdlBuilder)this.getPlatform().getDdlBuilder();
        String tableName = builder.getTableName(table.getName());
        String indexName = builder.getIndexName(index);
        StringBuilder query = new StringBuilder();
        query.append("SELECT RDB$CONSTRAINT_NAME FROM RDB$RELATION_CONSTRAINTS where RDB$RELATION_NAME=? AND RDB$CONSTRAINT_TYPE=? AND RDB$INDEX_NAME=?");
        try (PreparedStatement stmt = connection.prepareStatement(query.toString());){
            stmt.setString(1, this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? tableName : tableName.toUpperCase());
            stmt.setString(2, "PRIMARY KEY");
            stmt.setString(3, indexName);
            ResultSet resultSet = stmt.executeQuery();
            boolean bl = resultSet.next();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, IIndex index) throws SQLException {
        InterbaseDdlBuilder builder = (InterbaseDdlBuilder)this.getPlatform().getDdlBuilder();
        String tableName = builder.getTableName(table.getName());
        String indexName = builder.getIndexName(index);
        String fkName = builder.getForeignKeyName(table, fk);
        StringBuilder query = new StringBuilder();
        query.append("SELECT RDB$CONSTRAINT_NAME FROM RDB$RELATION_CONSTRAINTS where RDB$RELATION_NAME=? AND RDB$CONSTRAINT_TYPE=? AND RDB$CONSTRAINT_NAME=? AND RDB$INDEX_NAME=?");
        try (PreparedStatement stmt = connection.prepareStatement(query.toString());){
            stmt.setString(1, this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() ? tableName : tableName.toUpperCase());
            stmt.setString(2, "FOREIGN KEY");
            stmt.setString(3, fkName);
            stmt.setString(4, indexName);
            ResultSet resultSet = stmt.executeQuery();
            boolean bl = resultSet.next();
            return bl;
        }
    }

    @Override
    protected String getTableNamePattern(String tableName) {
        return String.format("\"%s\"", tableName);
    }

    @Override
    protected String getTableNamePatternForConstraints(String tableName) {
        return String.format("\"%s\"", tableName);
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "select TRIG.RDB$TRIGGER_NAME as TRIGGER_NAME, TRIG.RDB$RELATION_NAME as TABLE_NAME, TYPES1.RDB$TYPE_NAME as TRIGGER_TYPE, TRIG.RDB$TRIGGER_SEQUENCE as TRIGGER_SEQUENCE, TRIG.RDB$TRIGGER_BLR as TRIGGER_BLR, TRIG.RDB$DESCRIPTION as DESCRIPTION, TRIG.RDB$TRIGGER_INACTIVE as TRIGGER_INACTIVE, TYPES2.RDB$TYPE_NAME as SYSTEM_FLAG, TRIG.RDB$FLAGS as FLAGS, TRIG.RDB$VALID_BLR as VALID_BLR, TRIG.RDB$DEBUG_INFO as DEBUG_INFO,TRIG.RDB$TRIGGER_SOURCE as TRIGGER_SOURCE from RDB$TRIGGERS as TRIG inner join RDB$TYPES as TYPES1 on TYPES1.RDB$FIELD_NAME = 'RDB$TRIGGER_TYPE' and TYPES1.RDB$TYPE = TRIG.RDB$TRIGGER_TYPE inner join RDB$TYPES as TYPES2 on TYPES2.RDB$FIELD_NAME = 'RDB$SYSTEM_FLAG' and TYPES2.RDB$TYPE = TRIG.RDB$SYSTEM_FLAG where RDB$RELATION_NAME = ? ;";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("TRIGGER_NAME"));
                trigger.setTableName(row.getString("TABLE_NAME"));
                trigger.setEnabled(true);
                trigger.setSource(row.getString("TRIGGER_SOURCE"));
                row.remove((Object)"TRIGGER_SOURCE");
                String triggerType = row.getString("TRIGGER_TYPE");
                if (triggerType.contains("STORE")) {
                    trigger.setTriggerType(Trigger.TriggerType.INSERT);
                } else if (triggerType.contains("ERASE")) {
                    trigger.setTriggerType(Trigger.TriggerType.DELETE);
                } else if (triggerType.contains("MODIFY")) {
                    trigger.setTriggerType(Trigger.TriggerType.UPDATE);
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName});
        return triggers;
    }
}

