/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.ingres;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.ingres.IngresDdlBuilder;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;

public class IngresJdbcSqlTemplate
extends JdbcSqlTemplate {
    public IngresJdbcSqlTemplate(DataSource dataSource, SqlTemplateSettings settings, SymmetricLobHandler lobHandler, DatabaseInfo databaseInfo) {
        super(dataSource, settings, lobHandler, databaseInfo);
        this.requiresAutoCommitFalseToSetFetchSize = true;
        this.primaryKeyViolationSqlStates = new String[]{"23501"};
        this.primaryKeyViolationMessageParts = new String[]{"Duplicate key on INSERT detected"};
        this.uniqueKeyViolationNameRegex = new String[]{"violates unique constraint \"(.*)\""};
        this.foreignKeyViolationMessageParts = new String[]{"violates foreign key constraint"};
        this.foreignKeyViolationSqlStates = new String[]{"23503"};
        this.foreignKeyChildExistsViolationSqlStates = new String[]{"23504"};
        this.foreignKeyChildExistsViolationMessageParts = new String[]{"is still referenced from table"};
    }

    @Override
    public String getSelectLastInsertIdSql(String sequenceName) {
        if (IngresDdlBuilder.isUsePseudoSequence()) {
            return "select seq_id from " + sequenceName + "_tbl";
        }
        return "select getGeneratedKeys()";
    }

    @Override
    public boolean isDataTruncationViolation(Throwable ex) {
        String sqlState;
        boolean dataTruncationViolation = false;
        SQLException sqlEx = this.findSQLException(ex);
        if (sqlEx != null && (sqlState = sqlEx.getSQLState()) != null && sqlState.equals("22001")) {
            dataTruncationViolation = true;
        }
        return dataTruncationViolation;
    }

    @Override
    protected boolean allowsNullForIdentityColumn() {
        return false;
    }
}

