/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.informix;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;

public class InformixJdbcSqlTemplate
extends JdbcSqlTemplate {
    public InformixJdbcSqlTemplate(DataSource dataSource, SqlTemplateSettings settings, SymmetricLobHandler lobHandler, DatabaseInfo databaseInfo) {
        super(dataSource, settings, lobHandler, databaseInfo);
        this.primaryKeyViolationCodes = new int[]{-268};
        this.uniqueKeyViolationNameRegex = new String[]{"Unique Index:(.*)"};
        this.foreignKeyViolationCodes = new int[]{-691};
        this.foreignKeyChildExistsViolationCodes = new int[]{-692};
    }

    @Override
    public boolean isUniqueKeyViolation(Throwable ex) {
        SQLException sqlEx = this.findSQLException(ex);
        return sqlEx != null && sqlEx.getMessage() != null && (sqlEx.getMessage().contains("duplicate value") || sqlEx.getErrorCode() == -268);
    }

    @Override
    public boolean allowsNullForIdentityColumn() {
        return false;
    }
}

