/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.h2;

import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.h2.H2DdlBuilder;
import org.jumpmind.db.platform.h2.H2DdlReader;
import org.jumpmind.db.platform.h2.H2JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class H2DatabasePlatform
extends AbstractJdbcDatabasePlatform
implements IDatabasePlatform {
    public static final String JDBC_DRIVER = "org.h2.Driver";
    public static final String JDBC_SUBPROTOCOL = "h2";

    public H2DatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
    }

    protected H2DdlBuilder createDdlBuilder() {
        return new H2DdlBuilder();
    }

    @Override
    protected H2DdlReader createDdlReader() {
        return new H2DdlReader(this);
    }

    @Override
    protected H2JdbcSqlTemplate createSqlTemplate() {
        return new H2JdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    public String getName() {
        return JDBC_SUBPROTOCOL;
    }

    public String getDefaultSchema() {
        if (StringUtils.isBlank((CharSequence)this.defaultSchema)) {
            this.defaultSchema = (String)this.getSqlTemplate().queryForObject("select SCHEMA()", String.class, new Object[0]);
        }
        return this.defaultSchema;
    }

    public String getDefaultCatalog() {
        if (StringUtils.isBlank((CharSequence)this.defaultCatalog)) {
            this.defaultCatalog = (String)this.getSqlTemplate().queryForObject("select DATABASE()", String.class, new Object[0]);
        }
        return this.defaultCatalog;
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE TRIGGER TEST_TRIGGER AFTER UPDATE ON " + delimiter + "SYM_PERMISSION_TEST" + delimiter + "FOR EACH ROW CALL " + delimiter + "org.jumpmind.db.platform.h2.H2TestTrigger" + delimiter;
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public void shutdown() {
        this.shutdownAndCompact();
    }

    public boolean supportsMultiThreadedTransactions() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return sql + " limit " + limit + " offset " + offset + ";";
    }

    private void shutdownAndCompact() {
        try {
            this.log.info("Shutting down H2 database with COMPACT option");
            this.getSqlTemplate().update("SHUTDOWN COMPACT", new Object[0]);
        }
        catch (SqlException exception) {
            this.log.info("Caught {} during H2 shutdown and compact, with message: {}", (Object)((Object)((Object)exception)).getClass().getName(), (Object)exception.getMessage());
        }
    }
}

