/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.greenplum;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.postgresql.PostgreSqlDdlReader;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;

public class GreenplumDdlReader
extends PostgreSqlDdlReader {
    public GreenplumDdlReader(IDatabasePlatform platform) {
        super(platform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDistributionKeys(Connection connection, Table table, String schema) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select                                        ");
        query.append("   t.relname,                                 ");
        query.append("   a.attname                                  ");
        query.append("from                                          ");
        query.append("   pg_class t,                                ");
        query.append("   pg_namespace n,                            ");
        query.append("   pg_attribute a,                            ");
        query.append("   gp_distribution_policy p                   ");
        query.append("where                                         ");
        query.append("   n.oid = t.relnamespace and                 ");
        query.append("   p.localoid = t.oid and                     ");
        query.append("   a.attrelid = t.oid and                     ");
        query.append("   a.attnum = any(p.attrnums) and             ");
        query.append("   n.nspname = ? and                          ");
        query.append("   t.relname = ?                              ");
        try (PreparedStatement prepStmt = connection.prepareStatement(query.toString());){
            prepStmt.setString(1, schema);
            prepStmt.setString(2, table.getName());
            ResultSet rs = prepStmt.executeQuery();
            while (rs.next()) {
                Column column = table.findColumn(rs.getString(2).trim(), this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn());
                if (column == null) continue;
                column.setDistributionKey(true);
            }
            rs.close();
        }
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        this.setDistributionKeys(connection, table, metaData.getSchemaPattern());
        return table;
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) {
        return table.doesIndexContainOnlyPrimaryKeyColumns(index);
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) {
        ArrayList<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT trigger_name, trigger_schema, trigger_catalog, event_manipulation AS trigger_type, event_object_table AS table_name,trig.*, pgproc.prosrc FROM INFORMATION_SCHEMA.TRIGGERS AS trig INNER JOIN pg_catalog.pg_trigger AS pgtrig ON pgtrig.tgname=trig.trigger_name INNER JOIN pg_catalog.pg_proc AS pgproc ON pgproc.oid=pgtrig.tgfoid WHERE event_object_table=? AND event_object_schema=?;";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("trigger_name"));
                trigger.setCatalogName(row.getString("trigger_catalog"));
                trigger.setSchemaName(row.getString("trigger_schema"));
                trigger.setTableName(row.getString("table_name"));
                trigger.setEnabled(true);
                trigger.setSource(row.getString("prosrc"));
                row.remove((Object)"prosrc");
                String triggerType = row.getString("trigger_type");
                if (triggerType.equals("DELETE") || triggerType.equals("INSERT") || triggerType.equals("UPDATE")) {
                    trigger.setTriggerType(Trigger.TriggerType.valueOf((String)triggerType));
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName, schema});
        return triggers;
    }

    @Override
    protected void readForeignKeyUpdateRule(Map<String, Object> values, ForeignKey fk) {
        fk.setOnUpdateAction(ForeignKey.ForeignKeyAction.NOACTION);
    }

    @Override
    protected void readForeignKeyDeleteRule(Map<String, Object> values, ForeignKey fk) {
        fk.setOnDeleteAction(ForeignKey.ForeignKeyAction.NOACTION);
    }
}

