/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.firebird;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.model.Transaction;
import org.jumpmind.db.platform.AbstractJdbcDatabasePlatform;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionResult;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.platform.firebird.FirebirdDdlBuilder;
import org.jumpmind.db.platform.firebird.FirebirdDdlReader;
import org.jumpmind.db.platform.firebird.FirebirdJdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class FirebirdDatabasePlatform
extends AbstractJdbcDatabasePlatform {
    public static final String JDBC_DRIVER = "org.firebirdsql.jdbc.FBDriver";
    public static final String JDBC_SUBPROTOCOL = "firebirdsql";

    public FirebirdDatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        this.supportsTruncate = false;
    }

    protected FirebirdDdlBuilder createDdlBuilder() {
        return new FirebirdDdlBuilder();
    }

    @Override
    protected FirebirdDdlReader createDdlReader() {
        return new FirebirdDdlReader((IDatabasePlatform)this);
    }

    @Override
    protected FirebirdJdbcSqlTemplate createSqlTemplate() {
        return new FirebirdJdbcSqlTemplate(this.dataSource, this.settings, null, this.getDatabaseInfo());
    }

    public String getName() {
        return "firebird";
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getDefaultSchema() {
        return null;
    }

    public PermissionResult getCreateSymTriggerPermission() {
        String delimiter = this.getDatabaseInfo().getDelimiterToken();
        delimiter = delimiter != null ? delimiter : "";
        String triggerSql = "CREATE TRIGGER TEST_TRIGGER FOR " + delimiter + "SYM_PERMISSION_TEST" + delimiter + " AFTER UPDATE AS BEGIN END";
        PermissionResult result = new PermissionResult(PermissionType.CREATE_TRIGGER, triggerSql);
        try {
            this.getSqlTemplate().update(triggerSql, new Object[0]);
            result.setStatus(PermissionResult.Status.PASS);
        }
        catch (SqlException e) {
            result.setException((Exception)((Object)e));
            result.setSolution("Grant CREATE TRIGGER permission or TRIGGER permission");
        }
        return result;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public String massageForLimitOffset(String sql, int limit, int offset) {
        return Strings.CI.replace(sql, "select", "select first " + limit + " skip " + offset);
    }

    public List<Transaction> getTransactions() {
        int minutesOld = -5;
        String tranSql = "select t.mon$transaction_id, a.mon$user, a.mon$remote_address, t.mon$state, t.mon$timestamp, s.mon$sql_text from mon$attachments a inner join mon$transactions t on t.mon$attachment_id = a.mon$attachment_id left join mon$statements s on s.mon$attachment_id = t.mon$attachment_id and (s.mon$transaction_id = t.mon$transaction_id or s.mon$transaction_id is null)where t.mon$transaction_id is not null and ((s.mon$state = 0 and t.mon$timestamp < dateadd(? minute to current_timestamp)) or (s.mon$state = 1 and (upper(s.mon$sql_text) like 'INSERT %' or upper(s.mon$sql_text) like 'UPDATE %'or upper(s.mon$sql_text) like 'DELETE %') and s.mon$timestamp < dateadd(? minute to current_timestamp)))";
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        ArrayList<Transaction> blockedTransactions = new ArrayList<Transaction>();
        List rows = this.getSqlTemplate().query(tranSql, new Object[]{minutesOld, minutesOld}, new int[]{4, 4});
        for (Row row : rows) {
            Transaction tran = new Transaction(row.getString("mon$transaction_id"), StringUtils.trimToEmpty((String)row.getString("mon$user")), null, row.getDateTime("mon$timestamp"), row.getString("mon$sql_text"));
            tran.setRemoteIp(row.getString("mon$remote_address"));
            tran.setStatus(row.getString("mon$state"));
            transactions.add(tran);
            String text = StringUtils.trimToEmpty((String)StringUtils.upperCase((String)tran.getText()));
            if ((!"1".equals(tran.getStatus()) || !text.startsWith("INSERT")) && !text.startsWith("UPDATE") && !text.startsWith("DELETE")) continue;
            blockedTransactions.add(tran);
        }
        block1: for (Transaction blockedTran : blockedTransactions) {
            for (Transaction tran : transactions) {
                if (tran.getStartTime() == null || !tran.getStartTime().before(blockedTran.getStartTime())) continue;
                blockedTran.setBlockingId(tran.getId());
                continue block1;
            }
        }
        return transactions;
    }
}

